LOCUS       IGHA1_HUMAN              353 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig alpha-1 chain C region.
ACCESSION   P01876
VERSION     P01876.2  GI:113584
DBSOURCE    UniProtKB: locus IGHA1_HUMAN, accession P01876;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Feb 1, 1991.
            annotation updated: Sep 21, 2011.
            xrefs: J00220.1, AAC82528.1, A1HU, 1IGA_A, 1IGA_B, 1OW0_A, 1OW0_B,
            2QEJ_A, 2QEJ_B
            xrefs (non-sequence databases): IPI:IPI00449920, UniGene:Hs.699841,
            PDBsum:1IGA, PDBsum:1OW0, PDBsum:2QEJ, ProteinModelPortal:P01876,
            SMR:P01876, IntAct:P01876, STRING:P01876, PRIDE:P01876,
            Ensembl:ENST00000390547, Ensembl:ENSP00000374989,
            Ensembl:ENSG00000211895, GeneCards:GC14M086307, H-InvDB:HIX0175857,
            HGNC:5478, MIM:146900, neXtProt:NX_P01876, eggNOG:prNOG17106,
            HOVERGEN:HBG005814, InParanoid:P01876, OrthoDB:EOG4ZGPCM,
            Pathway_Interaction_DB:smad2_3nuclearpathway, ArrayExpress:P01876,
            Bgee:P01876, Genevestigator:P01876, GermOnline:ENSG00000130076,
            GO:0003823, GO:0005515, GO:0006955, GO:0018298, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07654, SMART:SM00407,
            PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Chromophore; Chromosomal rearrangement; Complete
            proteome; Direct protein sequencing; Disulfide bond; Glycoprotein;
            Immunoglobulin C region; Immunoglobulin domain; Polymorphism;
            Reference proteome; Repeat.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 353)
  AUTHORS   Flanagan,J.G., Lefranc,M.P. and Rabbitts,T.H.
  TITLE     Mechanisms of divergence and convergence of the human
            immunoglobulin alpha 1 and alpha 2 constant region gene sequences
  JOURNAL   Cell 36 (3), 681-688 (1984)
   PUBMED   6421489
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 353)
  AUTHORS   Putnam,F.W., Liu,Y.S. and Low,T.L.
  TITLE     Primary structure of a human IgA1 immunoglobulin. IV. Streptococcal
            IgA1 protease, digestion, Fab and Fc fragments, and the complete
            amino acid sequence of the alpha 1 heavy chain
  JOURNAL   J. Biol. Chem. 254 (8), 2865-2874 (1979)
   PUBMED   107164
  REMARK    PROTEIN SEQUENCE (MYELOMA PROTEIN BUR), AND DISULFIDE BONDS.
REFERENCE   3  (residues 1 to 353)
  AUTHORS   Kratzin,H., Altevogt,P., Ruban,E., Kortt,A., Staroscik,K. and
            Hilschmann,N.
  TITLE     [The primary structure of a monoclonal IgA-immunoglobulin (IgA
            Tro.), II. The amino acid sequence of the H-chain, alpha-type,
            subgroup III; structure of the complete IgA-molecule (author's
            transl)]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 356 (8), 1337-1342 (1975)
   PUBMED   809331
  REMARK    PROTEIN SEQUENCE (MYELOMA PROTEIN TRO).
REFERENCE   4  (residues 1 to 353)
  AUTHORS   Yang,C., Kratzin,H., Gotz,H. and Hilschmann,N.
  TITLE     [Rule of antibody structure. Primary structure of a human
            monoclonal IgA-immunoglobulin (myeloma protein Tro). VII.
            Purification and characterization of the disulfide bridges]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 360 (12), 1919-1940 (1979)
   PUBMED   393607
  REMARK    DISULFIDE BONDS.
REFERENCE   5  (residues 1 to 353)
  AUTHORS   Calero,M., Escribano,J., Grubb,A. and Mendez,E.
  TITLE     Location of a novel type of interpolypeptide chain linkage in the
            human protein HC-IgA complex (HC-IgA) and identification of a
            heterogeneous chromophore associated with the complex
  JOURNAL   J. Biol. Chem. 269 (1), 384-389 (1994)
   PUBMED   7506257
  REMARK    PROTEIN SEQUENCE OF 345-353, AND BINDING TO CHROMOPHORE.
REFERENCE   6  (residues 1 to 353)
  AUTHORS   Kerr,M.A.
  TITLE     The structure and function of human IgA
  JOURNAL   Biochem. J. 271 (2), 285-296 (1990)
   PUBMED   2241915
  REMARK    REVIEW.
REFERENCE   7  (residues 1 to 353)
  AUTHORS   Hatzivassiliou,G., Miller,I., Takizawa,J., Palanisamy,N., Rao,P.H.,
            Iida,S., Tagawa,S., Taniwaki,M., Russo,J., Neri,A., Cattoretti,G.,
            Clynes,R., Mendelsohn,C., Chaganti,R.S. and Dalla-Favera,R.
  TITLE     IRTA1 and IRTA2, novel immunoglobulin superfamily receptors
            expressed in B cells and involved in chromosome 1q21 abnormalities
            in B cell malignancy
  JOURNAL   Immunity 14 (3), 277-289 (2001)
   PUBMED   11290337
  REMARK    CHROMOSOMAL TRANSLOCATION WITH FCRL4.
REFERENCE   8  (residues 1 to 353)
  AUTHORS   Kristiansen,T.Z., Bunkenborg,J., Gronborg,M., Molina,H.,
            Thuluvath,P.J., Argani,P., Goggins,M.G., Maitra,A. and Pandey,A.
  TITLE     A proteomic analysis of human bile
  JOURNAL   Mol. Cell Proteomics 3 (7), 715-728 (2004)
   PUBMED   15084671
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-144, AND MASS
            SPECTROMETRY.;
            TISSUE=Bile
REFERENCE   9  (residues 1 to 353)
  AUTHORS   Nilsson,J., Ruetschi,U., Halim,A., Hesse,C., Carlsohn,E.,
            Brinkmalm,G. and Larson,G.
  TITLE     Enrichment of glycopeptides for glycan structure and attachment
            site identification
  JOURNAL   Nat. Methods 6 (11), 809-811 (2009)
   PUBMED   19838169
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-144, STRUCTURE OF
            CARBOHYDRATES, AND MASS SPECTROMETRY.;
            TISSUE=Cerebrospinal fluid
REFERENCE   10 (residues 1 to 353)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
COMMENT     On Mar 15, 2005 this sequence version replaced gi:2144705.
            [FUNCTION] Ig alpha is the major immunoglobulin class in body
            secretions. It may serve both to defend against local infection and
            to prevent access of foreign antigens to the general immunologic
            system.
            [SUBUNIT] Monomeric or polymeric.
            [PTM] 3-Hydroxykynurenine, an oxidized tryptophan metabolite that
            is common in biological fluids, reacts with alpha-1-microglobulin
            to form heterogeneous polycyclic chromophores including
            hydroxanthommatin. The chromophore reacts with accessible cysteines
            forming non-reducible thioether cross-links with Ig alpha-1 chain C
            region Cys-352.
            [DISEASE] Note=A chromosomal aberration involving IGHA1 is found in
            multiple myeloma (MM) cell lines. Translocation t(1;14)(q21;q32)
            that forms a FCRL4-IGHA1 fusion protein.
            [SIMILARITY] Contains 3 Ig-like (immunoglobulin-like) domains.
            [SEQUENCE CAUTION] Sequence=AAC82528.1; Type=Erroneous initiation;
            Note=Translation N-terminally shortened.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+IGHA1&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..353
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..353
                     /gene="IGHA1"
     Protein         <1..353
                     /gene="IGHA1"
                     /product="Ig alpha-1 chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..353
                     /gene="IGHA1"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig alpha-1 chain C region. /FTId=PRO_0000153566."
     Region          5..90
                     /gene="IGHA1"
                     /region_name="IgC_CH1"
                     /note="CH1 domain (first constant Ig domain of the heavy
                     chain) in immunoglobulin; cd04985"
                     /db_xref="CDD:143186"
     Region          6..98
                     /gene="IGHA1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 1."
     Site            order(9..10,12,29,53,55..56,66..67,69)
                     /gene="IGHA1"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Bond            14
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with light chain)."
     Bond            26..85
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            61
                     /gene="IGHA1"
                     /site_type="other"
                     /note="IgV domain interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Bond            77..101
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            105
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Site            111
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Site            113
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Site            119
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Site            121
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Bond            122
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with heavy chain)."
     Bond            123..180
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Or C-123 with C-182."
     Region          124..219
                     /gene="IGHA1"
                     /region_name="IgC_CH2"
                     /note="CH2 domain (second constant Ig domain of the heavy
                     chain) in immunoglobulin; cd04986"
                     /db_xref="CDD:143187"
     Region          125..220
                     /gene="IGHA1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 2."
     Site            order(128..131,144,146,148,150,183..186,188,190..191)
                     /gene="IGHA1"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143187"
     Region          128..130
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          134..139
                     /gene="IGHA1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            144
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...) (complex)."
     Region          146..149
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            147..204
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..164
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          163..165
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TPS -> PST (in Ref. 2; AA sequence)."
     Region          176
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> B (in Ref. 3; AA sequence)."
     Region          176
                     /gene="IGHA1"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> D (in dbSNP:rs1407). /FTId=VAR_014602."
     Bond            182
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with heavy chain) (or with C-180)."
     Region          185..188
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          190..192
                     /gene="IGHA1"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          190
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> S (in Ref. 3; AA sequence)."
     Bond            192
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Interchain (with heavy chain of another subunit)
                     (Probable)."
     Region          193..198
                     /gene="IGHA1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          201..206
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          215..220
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          227
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in Ref. 3; AA sequence)."
     Region          228..330
                     /gene="IGHA1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 3."
     Region          228..330
                     /gene="IGHA1"
                     /region_name="IgC_CH4"
                     /note="CH4 domain (fourth constant Ig domain of the heavy
                     chain) in immunoglobulin; cd05768"
                     /db_xref="CDD:143245"
     Region          229..233
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          231
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> R (in Ref. 3; AA sequence)."
     Site            order(233,249,253,295,299)
                     /gene="IGHA1"
                     /site_type="other"
                     /note="dimer interface [polypeptide binding]"
                     /db_xref="CDD:143245"
     Region          237..241
                     /gene="IGHA1"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          242..258
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            250..313
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..266
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(265,314,320..321,323..324,326)
                     /gene="IGHA1"
                     /site_type="other"
                     /note="receptor binding site"
                     /db_xref="CDD:143245"
     Region          273..275
                     /gene="IGHA1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          276..278
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          287..289
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290
                     /gene="IGHA1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> E (in Ref. 3; AA sequence)."
     Region          292..301
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          302..307
                     /gene="IGHA1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          311..316
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          323..325
                     /gene="IGHA1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            340
                     /gene="IGHA1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Bond            352
                     /gene="IGHA1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with J chain); in oligomeric form."
     Site            352
                     /gene="IGHA1"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Multimeric 3-hydroxykynurenine chromophore
                     (covalent); in form alpha-1-microglobulin complex."
ORIGIN      
        1 asptspkvfp lslcstqpdg nvviaclvqg ffpqeplsvt wsesgqgvta rnfppsqdas
       61 gdlyttssql tlpatqclag ksvtchvkhy tnpsqdvtvp cpvpstpptp spstpptpsp
      121 scchprlslh rpaledlllg seanltctlt glrdasgvtf twtpssgksa vqgpperdlc
      181 gcysvssvlp gcaepwnhgk tftctaaype sktpltatls ksgntfrpev hllpppseel
      241 alnelvtltc largfspkdv lvrwlqgsqe lprekyltwa srqepsqgtt tfavtsilrv
      301 aaedwkkgdt fscmvgheal plaftqktid rlagkpthvn vsvvmaevdg tcy
//

LOCUS       AMFR1_HUMAN              323 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Autocrine motility factor receptor, isoform 1;
            Short=AMF receptor, isoform 1; Flags: Precursor.
ACCESSION   P26442
VERSION     P26442.1  GI:113707
DBSOURCE    UniProtKB: locus AMFR1_HUMAN, accession P26442;
            class: standard.
            created: Aug 1, 1992.
            sequence updated: Aug 1, 1992.
            annotation updated: Sep 21, 2011.
            xrefs: M63175.1, AAA36671.1, L35233.1, AAA79362.1, A39877
            xrefs (non-sequence databases): IPI:IPI00435690, UniGene:Hs.295137,
            IntAct:P26442, STRING:P26442, PRIDE:P26442,
            Ensembl:ENST00000314566, Ensembl:ENSP00000313137,
            Ensembl:ENSG00000159461, GeneCards:GC16M042266, HGNC:463,
            HPA:CAB026381, MIM:603243, neXtProt:NX_P26442, eggNOG:prNOG16152,
            GeneTree:ENSGT00530000062938, ArrayExpress:P26442, Bgee:P26442,
            CleanEx:HS_AMFR, Genevestigator:P26442, GermOnline:ENSG00000159461,
            GO:0016021, GO:0004872, GO:0006928
KEYWORDS    Alternative splicing; Complete proteome; Glycoprotein; Membrane;
            Phosphoprotein; Polymorphism; Receptor; Reference proteome; Signal;
            Transmembrane; Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 323)
  AUTHORS   Watanabe,H., Carmi,P., Hogan,V., Raz,T., Silletti,S., Nabi,I.R. and
            Raz,A.
  TITLE     Purification of human tumor cell autocrine motility factor and
            molecular cloning of its receptor
  JOURNAL   J. Biol. Chem. 266 (20), 13442-13448 (1991)
   PUBMED   1649192
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   2  (residues 1 to 323)
  AUTHORS   Huang,B., Xie,Y. and Raz,A.
  TITLE     Identification of an upstream region that controls the
            transcription of the human autocrine motility factor receptor
  JOURNAL   Biochem. Biophys. Res. Commun. 212 (3), 727-742 (1995)
   PUBMED   7626106
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Placenta
COMMENT     On Apr 6, 2005 this sequence version replaced gi:105398.
            [FUNCTION] Specific receptor for the autocrine motility factor.
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=2; Name=1; IsoId=P26442-1; Sequence=Displayed; Name=2;
            IsoId=Q9UKV5-1; Sequence=External.
            [PTM] Phosphorylated in the presence of AMF.
            [PTM] O-glycosylated.
FEATURES             Location/Qualifiers
     source          1..323
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..323
                     /gene="AMFR"
     Protein         1..323
                     /gene="AMFR"
                     /product="Autocrine motility factor receptor, isoform 1"
                     /note="AMF receptor, isoform 1"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..17
                     /gene="AMFR"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Region          18..323
                     /gene="AMFR"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Autocrine motility factor receptor, isoform 1.
                     /FTId=PRO_0000020700."
     Region          18..110
                     /gene="AMFR"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Site            24
                     /gene="AMFR"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          111..137
                     /gene="AMFR"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          138..323
                     /gene="AMFR"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          181
                     /gene="AMFR"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> V (in dbSNP:rs4924). /FTId=VAR_014809."
     Site            194
                     /gene="AMFR"
                     /site_type="modified"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Phosphoserine (Potential)."
ORIGIN      
        1 mrdsacwsqr kdellqqark rflnkssedd aasesflpse gassdpvtlr rrmlaaarng
       61 gfrssrppsa plpssaasca lcptdwrrpv pilplhgkag ltalplykac glivfgqlin
      121 lillcntfyv tflfpletlq iltvgmissg vdwtawgggr sggsepvacl qqaastpasc
      181 irptnagvls ttpsgksvge ahsvsppprr gvtsviklls llwkhvdcar arptgsctpe
      241 qqgilekell vryleqrrgk sraigcdevt pfcpttsgtd fpslqskagl isvnsgapas
      301 hecapwvpsp lsislsrldl gsg
//

LOCUS       CTRB1_HUMAN              263 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Chymotrypsinogen B; Contains: RecName:
            Full=Chymotrypsin B chain A; Contains: RecName: Full=Chymotrypsin B
            chain B; Contains: RecName: Full=Chymotrypsin B chain C; Flags:
            Precursor.
ACCESSION   P17538
VERSION     P17538.1  GI:117617
DBSOURCE    UniProtKB: locus CTRB1_HUMAN, accession P17538;
            class: standard.
            created: Aug 1, 1990.
            sequence updated: Aug 1, 1990.
            annotation updated: Sep 21, 2011.
            xrefs: M24400.1, AAA52128.1, BT007356.1, AAP36020.1, BC005385.1,
            AAH05385.1, A31299
            xrefs (non-sequence databases): IPI:IPI00015133, UniGene:Hs.610926,
            ProteinModelPortal:P17538, SMR:P17538, STRING:P17538,
            PhosphoSite:P17538, PRIDE:P17538, Ensembl:ENST00000361017,
            Ensembl:ENSP00000354294, Ensembl:ENSG00000168925,
            GeneCards:GC16P061006, H-InvDB:HIX0013242, HGNC:2521, MIM:118890,
            neXtProt:NX_P17538, eggNOG:prNOG07094,
            GeneTree:ENSGT00550000074117, HOGENOM:HBG755338,
            HOVERGEN:HBG013304, InParanoid:P17538, OrthoDB:EOG4VMFG1,
            ArrayExpress:P17538, CleanEx:HS_CTRB1, Genevestigator:P17538,
            GermOnline:ENSG00000168928, GO:0005615, GO:0004252, GO:0007586,
            GO:0006508, InterPro:IPR009003, InterPro:IPR018114,
            InterPro:IPR001254, InterPro:IPR001314, Pfam:PF00089,
            PRINTS:PR00722, SMART:SM00020, SUPFAM:SSF50494, PROSITE:PS50240,
            PROSITE:PS00134, PROSITE:PS00135
KEYWORDS    Complete proteome; Digestion; Disulfide bond; Hydrolase;
            Polymorphism; Protease; Reference proteome; Secreted; Serine
            protease; Signal; Zymogen.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 263)
  AUTHORS   Tomita,N., Izumoto,Y., Horii,A., Doi,S., Yokouchi,H., Ogawa,M.,
            Mori,T. and Matsubara,K.
  TITLE     Molecular cloning and nucleotide sequence of human pancreatic
            prechymotrypsinogen cDNA
  JOURNAL   Biochem. Biophys. Res. Commun. 158 (2), 569-575 (1989)
   PUBMED   2917002
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Pancreas
REFERENCE   2  (residues 1 to 263)
  AUTHORS   Kalnine,N., Chen,X., Rolfs,A., Halleck,A., Hines,L., Eisenstein,S.,
            Koundinya,M., Raphael,J., Moreira,D., Kelley,T., LaBaer,J., Lin,Y.,
            Phelan,M. and Farmer,A.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-OCT-2004)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
REFERENCE   3  (residues 1 to 263)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Pancreas
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
COMMENT     On Mar 15, 2005 this sequence version replaced gi:105619.
            [CATALYTIC ACTIVITY] Preferential cleavage: Tyr-|-Xaa, Trp-|-Xaa,
            Phe-|-Xaa, Leu-|-Xaa.
            [SUBCELLULAR LOCATION] Secreted, extracellular space.
            [SIMILARITY] Belongs to the peptidase S1 family.
            [SIMILARITY] Contains 1 peptidase S1 domain.
            [WEB RESOURCE] Name=Wikipedia; Note=Chymotrypsin entry;
            URL='http://en.wikipedia.org/wiki/Chymotrypsin'.
FEATURES             Location/Qualifiers
     source          1..263
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..263
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
     Protein         1..263
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /product="Chymotrypsinogen B"
                     /EC_number="3.4.21.1"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..18
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          19..263
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Chymotrypsinogen B. /FTId=PRO_0000027638."
     Bond            19..140
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          19..31
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Chymotrypsin B chain A. /FTId=PRO_0000027639."
     Region          34..261
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Peptidase S1."
     Region          34..259
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Tryp_SPc"
                     /note="Trypsin-like serine protease; Many of these are
                     synthesized as inactive precursor zymogens that are
                     cleaved during limited proteolysis to generate their
                     active forms. Alignment contains also inactive enzymes
                     that have substitutions of the catalytic...; cd00190"
                     /db_xref="CDD:29152"
     Region          34..164
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Chymotrypsin B chain B. /FTId=PRO_0000027640."
     Site            34
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="cleavage"
                     /db_xref="CDD:29152"
     Bond            60..76
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(75,120,213)
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="active"
                     /db_xref="CDD:29152"
     Site            75
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Charge relay system (By similarity)."
     Site            120
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Charge relay system (By similarity)."
     Bond            154..219
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          167..263
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Chymotrypsin B chain C. /FTId=PRO_0000027641."
     Bond            186..200
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(207,232,234)
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="other"
                     /note="substrate binding sites [chemical binding]"
                     /db_xref="CDD:29152"
     Bond            209..238
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            213
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Charge relay system (By similarity)."
     Region          222
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> H (in dbSNP:rs8061550). /FTId=VAR_057158."
     Region          250
                     /gene="CTRB1"
                     /gene_synonym="CTRB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in dbSNP:rs4737). /FTId=VAR_014566."
ORIGIN      
        1 maflwllscw allgttfgcg vpaihpvlsg lsrivngeda vpgswpwqvs lqdktgfhfc
       61 ggslisedwv vtaahcgvrt sdvvvagefd qgsdeeniqv lkiakvfknp kfsiltvnnd
      121 itllklatpa rfsqtvsavc lpsadddfpa gtlcattgwg ktkynanktp dklqqaalpl
      181 lsnaeckksw grritdvmic agasgvsscm gdsggplvcq kdgawtlvgi vswgsdtcst
      241 sspgvyarvt klipwvqkil aan
//

LOCUS       IGHE_HUMAN               428 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig epsilon chain C region.
ACCESSION   P01854
VERSION     P01854.1  GI:119512
DBSOURCE    UniProtKB: locus IGHE_HUMAN, accession P01854;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: L00022.1, AAB59424.1, J00222.1, AAB59395.1, AL928742.3,
            EHHU, 1F6A_B, 1F6A_D, 1FP5_A, 1G84_A, 1IGE_A, 1IGE_B, 1O0V_A,
            1O0V_B, 2WQR_A, 2WQR_B, 2Y7Q_B, 2Y7Q_D, 3H9Y_A, 3H9Y_B, 3H9Y_E,
            3H9Z_A, 3H9Z_B, 3H9Z_C, 3H9Z_D, 3HA0_A, 3HA0_B, 3HA0_C, 3HA0_D,
            3HA0_E, 3HA0_F
            xrefs (non-sequence databases): IPI:IPI00399005, PDBsum:1F6A,
            PDBsum:1FP5, PDBsum:1G84, PDBsum:1IGE, PDBsum:1O0V, PDBsum:2WQR,
            PDBsum:2Y7Q, PDBsum:3H9Y, PDBsum:3H9Z, PDBsum:3HA0,
            ProteinModelPortal:P01854, SMR:P01854, DIP:DIP-6167N,
            STRING:P01854, PRIDE:P01854, Ensembl:ENST00000390541,
            Ensembl:ENSP00000374983, Ensembl:ENSG00000211891, UCSC:uc001yrw.1,
            GeneCards:GC14M086257, HGNC:5522, MIM:147180, neXtProt:NX_P01854,
            eggNOG:prNOG16752, GeneTree:ENSGT00530000063726,
            HOVERGEN:HBG096066, OrthoDB:EOG4RXZ0H, PhylomeDB:P01854,
            Pathway_Interaction_DB:fcer1pathway,
            Pathway_Interaction_DB:il4_2pathway, Genevestigator:P01854,
            GermOnline:ENSG00000177154, GO:0003823, GO:0006955,
            InterPro:IPR007110, InterPro:IPR013783, InterPro:IPR003006,
            InterPro:IPR003597, Gene3D:G3DSA:2.60.40.10, Pfam:PF07654,
            SMART:SM00407, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Glycoprotein; Immunoglobulin C region;
            Immunoglobulin domain; Polymorphism; Reference proteome; Repeat.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 428)
  AUTHORS   Max,E.E., Battey,J., Ney,R., Kirsch,I.R. and Leder,P.
  TITLE     Duplication and deletion in the human immunoglobulin epsilon genes
  JOURNAL   Cell 29 (2), 691-699 (1982)
   PUBMED   6288268
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE IGHE*01), AND VARIANT
            LEU-359.
REFERENCE   2  (residues 1 to 428)
  AUTHORS   Flanagan,J.G. and Rabbitts,T.H.
  TITLE     The sequence of a human immunoglobulin epsilon heavy chain constant
            region gene, and evidence for three non-allelic genes
  JOURNAL   EMBO J. 1 (5), 655-660 (1982)
   PUBMED   6234164
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE IGHE*02).
REFERENCE   3  (residues 1 to 428)
  AUTHORS   Ueda,S., Nakai,S., Nishida,Y., Hisajima,H. and Honjo,T.
  TITLE     Long terminal repeat-like elements flank a human immunoglobulin
            epsilon pseudogene that lacks introns
  JOURNAL   EMBO J. 1 (12), 1539-1544 (1982)
   PUBMED   6327276
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE IGHE*01).
REFERENCE   4  (residues 1 to 428)
  AUTHORS   Seno,M., Kurokawa,T., Ono,Y., Onda,H., Sasada,R., Igarashi,K.,
            Kikuchi,M., Sugino,Y., Nishida,Y. and Honjo,T.
  TITLE     Molecular cloning and nucleotide sequencing of human immunoglobulin
            epsilon chain cDNA
  JOURNAL   Nucleic Acids Res. 11 (3), 719-726 (1983)
   PUBMED   6300763
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE IGHE*02).
REFERENCE   5  (residues 1 to 428)
  AUTHORS   Heilig,R., Eckenberg,R., Petit,J.L., Fonknechten,N., Da Silva,C.,
            Cattolico,L., Levy,M., Barbe,V., de Berardinis,V., Ureta-Vidal,A.,
            Pelletier,E., Vico,V., Anthouard,V., Rowen,L., Madan,A., Qin,S.,
            Sun,H., Du,H., Pepin,K., Artiguenave,F., Robert,C., Cruaud,C.,
            Bruls,T., Jaillon,O., Friedlander,L., Samson,G., Brottier,P.,
            Cure,S., Segurens,B., Aniere,F., Samain,S., Crespeau,H., Abbasi,N.,
            Aiach,N., Boscus,D., Dickhoff,R., Dors,M., Dubois,I., Friedman,C.,
            Gouyvenoux,M., James,R., Madan,A., Mairey-Estrada,B., Mangenot,S.,
            Martins,N., Menard,M., Oztas,S., Ratcliffe,A., Shaffer,T.,
            Trask,B., Vacherie,B., Bellemere,C., Belser,C., Besnard-Gonnet,M.,
            Bartol-Mavel,D., Boutard,M., Briez-Silla,S., Combette,S.,
            Dufosse-Laurent,V., Ferron,C., Lechaplais,C., Louesse,C.,
            Muselet,D., Magdelenat,G., Pateau,E., Petit,E.,
            Sirvain-Trukniewicz,P., Trybou,A., Vega-Czarny,N., Bataille,E.,
            Bluet,E., Bordelais,I., Dubois,M., Dumont,C., Guerin,T.,
            Haffray,S., Hammadi,R., Muanga,J., Pellouin,V., Robert,D.,
            Wunderle,E., Gauguet,G., Roy,A., Sainte-Marthe,L., Verdier,J.,
            Verdier-Discala,C., Hillier,L., Fulton,L., McPherson,J.,
            Matsuda,F., Wilson,R., Scarpelli,C., Gyapay,G., Wincker,P.,
            Saurin,W., Quetier,F., Waterston,R., Hood,L. and Weissenbach,J.
  TITLE     The DNA sequence and analysis of human chromosome 14
  JOURNAL   Nature 421 (6923), 601-607 (2003)
   PUBMED   12508121
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   6  (residues 1 to 428)
  AUTHORS   Bennich,H.H., Johansson,S.G.O. and von Bahr-Lindstroem,H.
  JOURNAL   (in) Bach,M.K. (Ed.);
            IMMEDIATE HYPERSENSITIVITY: MODERN CONCEPTS AND DEVELOPMENTS: 1-36;
            Marcel Dekker, New York (1978)
  REMARK    PRELIMINARY PROTEIN SEQUENCE (MYELOMA PROTEIN ND).
REFERENCE   7  (residues 1 to 428)
  AUTHORS   Kenten,J.H., Molgaard,H.V., Houghton,M., Derbyshire,R.B., Viney,J.,
            Bell,L.O. and Gould,H.J.
  TITLE     Cloning and sequence determination of the gene for the human
            immunoglobulin epsilon chain expressed in a myeloma cell line
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 79 (21), 6661-6665 (1982)
   PUBMED   6815656
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 1-40; 68-114 AND 427-428.
REFERENCE   8  (residues 1 to 428)
  AUTHORS   Padlan,E.A. and Davies,D.R.
  TITLE     A model of the Fc of immunoglobulin E
  JOURNAL   Mol. Immunol. 23 (10), 1063-1075 (1986)
   PUBMED   3796618
  REMARK    3D-STRUCTURE MODELING.
COMMENT     On Mar 15, 2005 this sequence version replaced gi:70024.
            [POLYMORPHISM] The following alleles of IGHE are known: IGHE*01 and
            IGHE*02. The sequence shown is that of allele 02.
            [SIMILARITY] Contains 4 Ig-like (immunoglobulin-like) domains.
            [SEQUENCE CAUTION] Sequence=AAB59424.1; Type=Erroneous initiation.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+IGHE&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..428
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..428
                     /gene="IGHE"
     Protein         <1..428
                     /gene="IGHE"
                     /product="Ig epsilon chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..428
                     /gene="IGHE"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig epsilon chain C region. /FTId=PRO_0000153574."
     Region          5..95
                     /gene="IGHE"
                     /region_name="IgC_CH1"
                     /note="CH1 domain (first constant Ig domain of the heavy
                     chain) in immunoglobulin; cd04985"
                     /db_xref="CDD:143186"
     Region          6..103
                     /gene="IGHE"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 1."
     Site            order(9..10,12,32,56,58..59,68..69,71)
                     /gene="IGHE"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Bond            14
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a light chain)."
     Bond            15..105
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            21
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Bond            29..85
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          43
                     /gene="IGHE"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> C (in allele IGHE*01). /FTId=VAR_044229."
     Site            49
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Site            64
                     /gene="IGHE"
                     /site_type="other"
                     /note="IgV domain interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Site            99
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          112..210
                     /gene="IGHE"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 2."
     Region          113..119
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          114..207
                     /gene="IGHE"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Bond            121
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a heavy chain)."
     Region          129..140
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            135..193
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          145..151
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            146
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          158..160
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          161..168
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          171..181
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          182..186
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          191..197
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..206
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            209
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a heavy chain)."
     Region          214..318
                     /gene="IGHE"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 3."
     Region          214..216
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          218..222
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..315
                     /gene="IGHE"
                     /region_name="IgC_CH3"
                     /note="CH3 domain (third constant Ig domain of the heavy
                     chain) in immunoglobulin; cd07696"
                     /db_xref="CDD:143320"
     Site            order(220..223,236,238,240,242,278..281,283,285..286,
                     313..315)
                     /gene="IGHE"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143320"
     Site            order(223,225..227)
                     /gene="IGHE"
                     /site_type="other"
                     /note="intrachain IgC domain interface"
                     /db_xref="CDD:143320"
     Region          226..230
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          236..245
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            239..299
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          252..257
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            252
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          267..273
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          274..276
                     /gene="IGHE"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            275
                     /gene="IGHE"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          277..285
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          288..292
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          297..302
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          310..314
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          324..423
                     /gene="IGHE"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like 4."
     Region          325..330
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          326..418
                     /gene="IGHE"
                     /region_name="IgC"
                     /note="Immunoglobulin Constant domain; cd00098"
                     /db_xref="CDD:143166"
     Site            order(327..330,342,344,346,348,384..387,389,391..392)
                     /gene="IGHE"
                     /site_type="other"
                     /note="dimer interface [polypeptide binding]"
                     /db_xref="CDD:143166"
     Region          335..338
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          341..353
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            345..405
                     /gene="IGHE"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          356..361
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          359
                     /gene="IGHE"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> L (possible polymorphism). /FTId=VAR_003885."
     Region          368..370
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          371..373
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          380..382
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          384..392
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          394..397
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          398..402
                     /gene="IGHE"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          403..408
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          413..416
                     /gene="IGHE"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          417..421
                     /gene="IGHE"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
ORIGIN      
        1 astqspsvfp ltrccknips natsvtlgcl atgyfpepvm vtwdtgslng ttmtlpattl
       61 tlsghyatis lltvsgawak qmftcrvaht psstdwvdnk tfsvcsrdft pptvkilqss
      121 cdggghfppt iqllclvsgy tpgtinitwl edgqvmdvdl stasttqege lastqseltl
      181 sqkhwlsdrt ytcqvtyqgh tfedstkkca dsnprgvsay lsrpspfdlf irksptitcl
      241 vvdlapskgt vnltwsrasg kpvnhstrke ekqrngtltv tstlpvgtrd wiegetyqcr
      301 vthphlpral mrsttktsgp raapevyafa tpewpgsrdk rtlacliqnf mpedisvqwl
      361 hnevqlpdar hsttqprktk gsgffvfsrl evtraeweqk deficravhe aaspsqtvqr
      421 avsvnpgk
//

LOCUS       IGHG1_HUMAN              330 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig gamma-1 chain C region.
ACCESSION   P01857
VERSION     P01857.1  GI:121039
DBSOURCE    UniProtKB: locus IGHG1_HUMAN, accession P01857;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: J00228.1, AAC82527.1, GHHU, 1AJ7_H, 1AQK_H, 1BEY_H, 1D5B_B,
            1D5B_H, 1D5I_H, 1D6V_H, 1DFB_H, 1DN2_A, 1DN2_B, 1E4K_A, 1E4K_B,
            1FC1_A, 1FC1_B, 1FC2_D, 1FCC_A, 1FCC_B, 1GAF_H, 1H3T_A, 1H3T_B,
            1H3U_A, 1H3U_B, 1H3V_A, 1H3V_B, 1H3W_M, 1H3Y_A, 1H3Y_B, 1HKL_H,
            1HZH_H, 1HZH_K, 1I7Z_B, 1I7Z_D, 1L6X_A, 1OP3_H, 1OP3_M, 1OQO_A,
            1OQO_B, 1OQX_A, 1OQX_B, 1T83_A, 1T83_B, 1T89_A, 1T89_B, 1VGE_H,
            2DTS_A, 2DTS_B, 2GJ7_A, 2GJ7_B, 2I5Y_H, 2IWG_A, 2IWG_D, 2J6E_A,
            2J6E_B, 2JB5_H, 2JB6_B, 2JB6_H, 2O5X_H, 2O5Y_H, 2O5Z_H, 2OSL_A,
            2OSL_H, 2QAD_D, 2QAD_H, 2QL1_A, 2QQK_H, 2QQL_H, 2QQN_H, 2QR0_B,
            2QR0_F, 2QR0_H, 2QR0_L, 2QR0_N, 2QR0_R, 2QR0_T, 2QR0_X, 2R56_H,
            2R56_I, 2RCS_H, 2VXQ_H, 3AGV_A, 3AGV_B, 3AVE_A, 3AVE_B, 3B2U_C,
            3B2U_F, 3B2U_H, 3B2U_J, 3B2U_N, 3B2U_Q, 3B2U_T, 3B2U_W, 3B2V_H,
            3BDY_H, 3BE1_H, 3BKY_H, 3BN9_D, 3BN9_F, 3BQU_B, 3C08_H, 3C09_C,
            3C09_H, 3C2S_A, 3CFJ_B, 3CFJ_D, 3CFJ_F, 3CFJ_H, 3CFK_B, 3CFK_D,
            3CFK_F, 3CFK_H, 3CFK_I, 3CFK_K, 3CFK_N, 3CFK_P, 3CSY_A, 3CSY_C,
            3CSY_E, 3CSY_G, 3D0L_B, 3D0V_B, 3D6G_A, 3D6G_B, 3D85_B, 3DJ9_A,
            3DNK_A, 3DNK_B, 3DO3_A, 3DO3_B, 3DRO_B, 3DRQ_B, 3DVG_B, 3DVN_B,
            3DVN_H, 3EYF_B, 3EYF_D, 3EYO_B, 3EYO_D, 3EYQ_D
            xrefs (non-sequence databases): IPI:IPI00785084, UniGene:Hs.510635,
            PDBsum:1AJ7, PDBsum:1AQK, PDBsum:1BEY, PDBsum:1D5B, PDBsum:1D5I,
            PDBsum:1D6V, PDBsum:1DFB, PDBsum:1DN2, PDBsum:1E4K, PDBsum:1FC1,
            PDBsum:1FC2, PDBsum:1FCC, PDBsum:1GAF, PDBsum:1H3T, PDBsum:1H3U,
            PDBsum:1H3V, PDBsum:1H3W, PDBsum:1H3Y, PDBsum:1HKL, PDBsum:1HZH,
            PDBsum:1I7Z, PDBsum:1L6X, PDBsum:1OP3, PDBsum:1OQO, PDBsum:1OQX,
            PDBsum:1T83, PDBsum:1T89, PDBsum:1VGE, PDBsum:2DTS, PDBsum:2GJ7,
            PDBsum:2I5Y, PDBsum:2IWG, PDBsum:2J6E, PDBsum:2JB5, PDBsum:2JB6,
            PDBsum:2O5X, PDBsum:2O5Y, PDBsum:2O5Z, PDBsum:2OSL, PDBsum:2QAD,
            PDBsum:2QL1, PDBsum:2QQK, PDBsum:2QQL, PDBsum:2QQN, PDBsum:2QR0,
            PDBsum:2R56, PDBsum:2RCS, PDBsum:2VXQ, PDBsum:3AGV, PDBsum:3AVE,
            PDBsum:3B2U, PDBsum:3B2V, PDBsum:3BDY, PDBsum:3BE1, PDBsum:3BKY,
            PDBsum:3BN9, PDBsum:3BQU, PDBsum:3C08, PDBsum:3C09, PDBsum:3C2S,
            PDBsum:3CFJ, PDBsum:3CFK, PDBsum:3CSY, PDBsum:3D0L, PDBsum:3D0V,
            PDBsum:3D6G, PDBsum:3D85, PDBsum:3DJ9, PDBsum:3DNK, PDBsum:3DO3,
            PDBsum:3DRO, PDBsum:3DRQ, PDBsum:3DVG, PDBsum:3DVN, PDBsum:3EYF,
            PDBsum:3EYO, PDBsum:3EYQ, ProteinModelPortal:P01857, SMR:P01857,
            DIP:DIP-29187N, IntAct:P01857, MINT:MINT-120799, STRING:P01857,
            PhosphoSite:P01857, Cornea-2DPAGE:P01857, DOSAC-COBS-2DPAGE:P01857,
            REPRODUCTION-2DPAGE:P01857, UCD-2DPAGE:P01857, PRIDE:P01857,
            Ensembl:ENST00000390549, Ensembl:ENSP00000374991,
            Ensembl:ENSG00000211896, UCSC:uc001yse.2, GeneCards:GC14M086340,
            H-InvDB:HIX0175858, HGNC:5525, MIM:147100, MIM:254500,
            neXtProt:NX_P01857, Orphanet:67038, Orphanet:85443,
            eggNOG:prNOG10023, HOVERGEN:HBG005814, OrthoDB:EOG4RR6HW,
            Pathway_Interaction_DB:il4_2pathway, DrugBank:DB00051,
            DrugBank:DB00074, DrugBank:DB00111, DrugBank:DB00065,
            DrugBank:DB00043, DrugBank:DB00073, DrugBank:DB00081,
            DrugBank:DB00072, Bgee:P01857, CleanEx:HS_IGHG1,
            Genevestigator:P01857, GermOnline:ENSG00000130076, GO:0005576,
            GO:0005624, GO:0003823, GO:0005515, GO:0006955, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07654, SMART:SM00407,
            PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Chromosomal rearrangement; Complete proteome; Direct
            protein sequencing; Disulfide bond; Glycoprotein; Immunoglobulin C
            region; Immunoglobulin domain; Reference proteome; Secreted.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 330)
  AUTHORS   Ellison,J.W., Berson,B.J. and Hood,L.E.
  TITLE     The nucleotide sequence of a human immunoglobulin C gamma1 gene
  JOURNAL   Nucleic Acids Res. 10 (13), 4071-4079 (1982)
   PUBMED   6287432
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 330)
  AUTHORS   Cunningham,B.A., Rutishauser,U., Gall,W.E., Gottlieb,P.D.,
            Waxdal,M.J. and Edelman,G.M.
  TITLE     The covalent structure of a human gamma G-immunoglobulin. VII.
            Amino acid sequence of heavy-chain cyanogen bromide fragments H1-H4
  JOURNAL   Biochemistry 9 (16), 3161-3170 (1970)
   PUBMED   5489771
  REMARK    PROTEIN SEQUENCE OF 1-135 (MYELOMA PROTEIN EU).
REFERENCE   3  (residues 1 to 330)
  AUTHORS   Rutishauser,U., Cunningham,B.A., Bennett,C., Konigsberg,W.H. and
            Edelman,G.M.
  TITLE     The covalent structure of a human gamma G-immunoglobulin. 8. Amino
            acid sequence of heavy-chain cyanogen bromide fragments H5-H7
  JOURNAL   Biochemistry 9 (16), 3171-3181 (1970)
   PUBMED   5530842
  REMARK    PROTEIN SEQUENCE OF 136-329 (EU).
REFERENCE   4  (residues 1 to 330)
  AUTHORS   Ponstingl,H. and Hilschmann,N.
  TITLE     [The rule of antibody structure. The primary structure of a
            monoclonal IgG1 immunoglobulin (myeloma protein Nie). III. The
            chymotryptic peptides of the H-chain, alignment of the tryptic
            peptides and discussion of the complete structure]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 357 (11), 1571-1604 (1976)
   PUBMED   826475
  REMARK    PROTEIN SEQUENCE (MYELOMA PROTEIN NIE).
REFERENCE   5  (residues 1 to 330)
  AUTHORS   Schmidt,W.E., Jung,H.D., Palm,W. and Hilschmann,N.
  TITLE     [Three-dimensional structure determination of antibodies. Primary
            structure of crystallized monoclonal immunoglobulin IgG1 KOL, I]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 364 (6), 713-747 (1983)
   PUBMED   6884994
  REMARK    PROTEIN SEQUENCE (MYELOMA PROTEIN KOL), AND DISULFIDE BONDS.
REFERENCE   6  (residues 1 to 330)
  AUTHORS   Gall,W.E. and Edelman,G.M.
  TITLE     The covalent structure of a human gamma G-immunoglobulin. X.
            Intrachain disulfide bonds
  JOURNAL   Biochemistry 9 (16), 3188-3196 (1970)
   PUBMED   4923144
  REMARK    DISULFIDE BONDS.
REFERENCE   7  (residues 1 to 330)
  AUTHORS   Dreker,L., Schwarz,J., Reichel,W. and Hilschmann,N.
  TITLE     [Rule of antibody structure. the primary structure of a monoclonal
            IgG1 immunoglobulin (myeloma protein Nie), I: Purification and
            characterization of the protein, the L- and H-chains, the
            cyanogenbromide cleavage products, and the disulfide bridges
            (author's transl)]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 357 (11), 1515-1540 (1976)
   PUBMED   1002129
  REMARK    DISULFIDE BONDS.
REFERENCE   8  (residues 1 to 330)
  AUTHORS   Chen,R., Jiang,X., Sun,D., Han,G., Wang,F., Ye,M., Wang,L. and
            Zou,H.
  TITLE     Glycoproteomics analysis of human liver tissue by combination of
            multiple enzyme digestion and hydrazide chemistry
  JOURNAL   J. Proteome Res. 8 (2), 651-661 (2009)
   PUBMED   19159218
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-180, AND MASS
            SPECTROMETRY.;
            TISSUE=Liver
REFERENCE   9  (residues 1 to 330)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
REFERENCE   10 (residues 1 to 330)
  AUTHORS   Deisenhofer,J.
  TITLE     Crystallographic refinement and atomic models of a human Fc
            fragment and its complex with fragment B of protein A from
            Staphylococcus aureus at 2.9- and 2.8-A resolution
  JOURNAL   Biochemistry 20 (9), 2361-2370 (1981)
   PUBMED   7236608
  REMARK    X-RAY CRYSTALLOGRAPHY (2.9 ANGSTROMS).
REFERENCE   11 (residues 1 to 330)
  AUTHORS   Bergsagel,P.L., Chesi,M., Nardini,E., Brents,L.A., Kirby,S.L. and
            Kuehl,W.M.
  TITLE     Promiscuous translocations into immunoglobulin heavy chain switch
            regions in multiple myeloma
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 93 (24), 13931-13936 (1996)
   PUBMED   8943038
  REMARK    INVOLVEMENT IN MULTIPLE MYELOMA.
REFERENCE   12 (residues 1 to 330)
  AUTHORS   Harrison,C.J., Mazzullo,H., Ross,F.M., Cheung,K.L., Gerrard,G.,
            Harewood,L., Mehta,A., Lachmann,H.J., Hawkins,P.N. and Orchard,K.H.
  TITLE     Translocations of 14q32 and deletions of 13q14 are common
            chromosomal abnormalities in systemic amyloidosis
  JOURNAL   Br. J. Haematol. 117 (2), 427-435 (2002)
   PUBMED   11972529
  REMARK    INVOLVEMENT IN MULTIPLE MYELOMA.
COMMENT     On Mar 15, 2005 this sequence version replaced gi:70028.
            [INTERACTION] P31994:FCGR2B; NbExp=31; IntAct=EBI-356114,
            EBI-724784.
            [SUBCELLULAR LOCATION] Secreted.
            [DISEASE] Defects in IGHG1 are a cause of multiple myeloma (MM)
            [MIM:254500]. MM is a malignant tumor of plasma cells usually
            arising in the bone marrow and characterized by diffuse involvement
            of the skeletal system, hyperglobulinemia, Bence-Jones proteinuria
            and anemia. Complications of multiple myeloma are bone pain,
            hypercalcemia, renal failure and spinal cord compression. The
            aberrant antibodies that are produced lead to impaired humoral
            immunity and patients have a high prevalence of infection.
            Amyloidosis may develop in some patients. Multiple myeloma is part
            of a spectrum of diseases ranging from monoclonal gammopathy of
            unknown significance (MGUS) to plasma cell leukemia. Note=A
            chromosomal aberration involving IGHG1 is found in multiple
            myeloma. Translocation t(11;14)(q13;q32) with the IgH locus.
            Translocation t(11;14)(q13;q32) with CCND1; translocation
            t(4;14)(p16.3;q32.3) with FGFR3; translocation t(6;14)(p25;q32)
            with IRF4.
            [MISCELLANEOUS] Nie has the G1M(17) allotypic marker, 97-K, and the
            G1M(1) markers, 239-D and 241-L. KOL and EU sequences have the
            G1M(3) marker and the G1M (non-1) markers.
            [SEQUENCE CAUTION] Sequence=AAC82527.1; Type=Erroneous initiation.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+IGHG1&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..330
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..330
                     /gene="IGHG1"
     Protein         <1..330
                     /gene="IGHG1"
                     /product="Ig gamma-1 chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..330
                     /gene="IGHG1"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig gamma-1 chain C region. /FTId=PRO_0000153578."
     Region          1..98
                     /gene="IGHG1"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH1."
     Region          6..99
                     /gene="IGHG1"
                     /region_name="IgC_CH1"
                     /note="CH1 domain (first constant Ig domain of the heavy
                     chain) in immunoglobulin; cd04985"
                     /db_xref="CDD:143186"
     Region          7..11
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(9..10,12,30,53,55..56,64..65,67)
                     /gene="IGHG1"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Region          15..17
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          20..35
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            27..83
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          38..41
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          42..44
                     /gene="IGHG1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          50..52
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            61
                     /gene="IGHG1"
                     /site_type="other"
                     /note="IgV domain interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Region          63..73
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          74..78
                     /gene="IGHG1"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          82..87
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          88..90
                     /gene="IGHG1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          92..97
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          97
                     /gene="IGHG1"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="K -> R (in G1M(3) marker). /FTId=VAR_003886."
     Region          99..110
                     /gene="IGHG1"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Hinge."
     Bond            103
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with light chain)."
     Bond            109
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with heavy chain)."
     Region          111..223
                     /gene="IGHG1"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH2."
     Bond            112
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with heavy chain)."
     Region          122..126
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          123..220
                     /gene="IGHG1"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Region          130..134
                     /gene="IGHG1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          141..153
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            144..204
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..162
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180..190
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            180
                     /gene="IGHG1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          193..197
                     /gene="IGHG1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          202..207
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          215..219
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          224..330
                     /gene="IGHG1"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH3."
     Region          229..324
                     /gene="IGHG1"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Region          230..234
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          238..242
                     /gene="IGHG1"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          239
                     /gene="IGHG1"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> E (in G1M(non-1) marker). /FTId=VAR_003887."
     Region          241
                     /gene="IGHG1"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> M (in G1M(non-1) marker). /FTId=VAR_003888."
     Region          243..258
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            250..308
                     /gene="IGHG1"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..270
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          274..276
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          287..296
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          297..301
                     /gene="IGHG1"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          306..311
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          320..324
                     /gene="IGHG1"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
ORIGIN      
        1 astkgpsvfp lapsskstsg gtaalgclvk dyfpepvtvs wnsgaltsgv htfpavlqss
       61 glyslssvvt vpssslgtqt yicnvnhkps ntkvdkkvep kscdkthtcp pcpapellgg
      121 psvflfppkp kdtlmisrtp evtcvvvdvs hedpevkfnw yvdgvevhna ktkpreeqyn
      181 styrvvsvlt vlhqdwlngk eykckvsnka lpapiektis kakgqprepq vytlppsrde
      241 ltknqvsltc lvkgfypsdi avewesngqp ennykttppv ldsdgsffly skltvdksrw
      301 qqgnvfscsv mhealhnhyt qkslslspgk
//

LOCUS       IGHG4_HUMAN              327 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig gamma-4 chain C region.
ACCESSION   P01861
VERSION     P01861.1  GI:121047
DBSOURCE    UniProtKB: locus IGHG4_HUMAN, accession P01861;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: K01316.1, AAB59394.1, AL928742.3, G4HU, 1ADQ_A, 1BBJ_B,
            1BBJ_H, 2FL5_B, 2FL5_D, 2FL5_F, 2FL5_H
            xrefs (non-sequence databases): IPI:IPI00930442, UniGene:Hs.510635,
            PDBsum:1ADQ, PDBsum:1BBJ, PDBsum:2FL5, ProteinModelPortal:P01861,
            SMR:P01861, MINT:MINT-1179376, STRING:P01861, PRIDE:P01861,
            Ensembl:ENST00000390543, Ensembl:ENSP00000374985,
            Ensembl:ENSG00000211892, GeneCards:GC14M106090, HGNC:5528,
            MIM:147130, neXtProt:NX_P01861, eggNOG:prNOG10023,
            HOVERGEN:HBG005814, OrthoDB:EOG4RR6HW, Genevestigator:P01861,
            GermOnline:ENSG00000205402, GO:0005576, GO:0005624, GO:0003823,
            GO:0006955, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, Gene3D:G3DSA:2.60.40.10,
            Pfam:PF07654, SMART:SM00407, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Glycoprotein; Immunoglobulin C region;
            Immunoglobulin domain; Reference proteome; Secreted.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 327)
  AUTHORS   Ellison,J., Buxbaum,J. and Hood,L.
  TITLE     Nucleotide sequence of a human immunoglobulin C gamma 4 gene
  JOURNAL   DNA 1 (1), 11-18 (1981)
   PUBMED   6299662
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 327)
  AUTHORS   Heilig,R., Eckenberg,R., Petit,J.L., Fonknechten,N., Da Silva,C.,
            Cattolico,L., Levy,M., Barbe,V., de Berardinis,V., Ureta-Vidal,A.,
            Pelletier,E., Vico,V., Anthouard,V., Rowen,L., Madan,A., Qin,S.,
            Sun,H., Du,H., Pepin,K., Artiguenave,F., Robert,C., Cruaud,C.,
            Bruls,T., Jaillon,O., Friedlander,L., Samson,G., Brottier,P.,
            Cure,S., Segurens,B., Aniere,F., Samain,S., Crespeau,H., Abbasi,N.,
            Aiach,N., Boscus,D., Dickhoff,R., Dors,M., Dubois,I., Friedman,C.,
            Gouyvenoux,M., James,R., Madan,A., Mairey-Estrada,B., Mangenot,S.,
            Martins,N., Menard,M., Oztas,S., Ratcliffe,A., Shaffer,T.,
            Trask,B., Vacherie,B., Bellemere,C., Belser,C., Besnard-Gonnet,M.,
            Bartol-Mavel,D., Boutard,M., Briez-Silla,S., Combette,S.,
            Dufosse-Laurent,V., Ferron,C., Lechaplais,C., Louesse,C.,
            Muselet,D., Magdelenat,G., Pateau,E., Petit,E.,
            Sirvain-Trukniewicz,P., Trybou,A., Vega-Czarny,N., Bataille,E.,
            Bluet,E., Bordelais,I., Dubois,M., Dumont,C., Guerin,T.,
            Haffray,S., Hammadi,R., Muanga,J., Pellouin,V., Robert,D.,
            Wunderle,E., Gauguet,G., Roy,A., Sainte-Marthe,L., Verdier,J.,
            Verdier-Discala,C., Hillier,L., Fulton,L., McPherson,J.,
            Matsuda,F., Wilson,R., Scarpelli,C., Gyapay,G., Wincker,P.,
            Saurin,W., Quetier,F., Waterston,R., Hood,L. and Weissenbach,J.
  TITLE     The DNA sequence and analysis of human chromosome 14
  JOURNAL   Nature 421 (6923), 601-607 (2003)
   PUBMED   12508121
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   3  (residues 1 to 327)
  AUTHORS   Pink,J.R., Buttery,S.H., De Vries,G.M. and Milstein,C.
  TITLE     Human immunoglobulin subclasses. Partial amino acid sequence of the
            constant region of a gamma 4 chain
  JOURNAL   Biochem. J. 117 (1), 33-47 (1970)
   PUBMED   4192699
  REMARK    PROTEIN SEQUENCE OF 1-30 AND 81-326.
REFERENCE   4  (residues 1 to 327)
  AUTHORS   Chen,R., Jiang,X., Sun,D., Han,G., Wang,F., Ye,M., Wang,L. and
            Zou,H.
  TITLE     Glycoproteomics analysis of human liver tissue by combination of
            multiple enzyme digestion and hydrazide chemistry
  JOURNAL   J. Proteome Res. 8 (2), 651-661 (2009)
   PUBMED   19159218
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-177, AND MASS
            SPECTROMETRY.;
            TISSUE=Liver
COMMENT     On Mar 15, 2005 this sequence version replaced gi:70030.
            [SUBCELLULAR LOCATION] Secreted.
            [SEQUENCE CAUTION] Sequence=AAB59394.1; Type=Erroneous initiation.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+IGHG4&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..327
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..327
                     /gene="IGHG4"
     Protein         <1..327
                     /gene="IGHG4"
                     /product="Ig gamma-4 chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..327
                     /gene="IGHG4"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig gamma-4 chain C region. /FTId=PRO_0000153581."
     Region          1..98
                     /gene="IGHG4"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH1."
     Region          6..99
                     /gene="IGHG4"
                     /region_name="IgC_CH1"
                     /note="CH1 domain (first constant Ig domain of the heavy
                     chain) in immunoglobulin; cd04985"
                     /db_xref="CDD:143186"
     Site            order(9..10,12,30,53,55..56,64..65,67)
                     /gene="IGHG4"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Bond            14
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a light chain)."
     Bond            27..83
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            61
                     /gene="IGHG4"
                     /site_type="other"
                     /note="IgV domain interface [polypeptide binding]"
                     /db_xref="CDD:143186"
     Region          99..110
                     /gene="IGHG4"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Hinge."
     Bond            106
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a heavy chain)."
     Bond            109
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a heavy chain)."
     Region          111..220
                     /gene="IGHG4"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH2."
     Region          119..123
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          120..217
                     /gene="IGHG4"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Region          127..131
                     /gene="IGHG4"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          138..144
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            141..201
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          148..150
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          165..167
                     /gene="IGHG4"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            177
                     /gene="IGHG4"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          184..187
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          190..194
                     /gene="IGHG4"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          199..203
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          208..210
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          212..216
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          221..327
                     /gene="IGHG4"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CH3."
     Region          226..321
                     /gene="IGHG4"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Region          227..231
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          237..239
                     /gene="IGHG4"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          240..255
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            247..305
                     /gene="IGHG4"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          258..267
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          270..273
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          284..293
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..298
                     /gene="IGHG4"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          303..308
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          317..321
                     /gene="IGHG4"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
ORIGIN      
        1 astkgpsvfp lapcsrstse staalgclvk dyfpepvtvs wnsgaltsgv htfpavlqss
       61 glyslssvvt vpssslgtkt ytcnvdhkps ntkvdkrves kygppcpscp apeflggpsv
      121 flfppkpkdt lmisrtpevt cvvvdvsqed pevqfnwyvd gvevhnaktk preeqfnsty
      181 rvvsvltvlh qdwlngkeyk ckvsnkglps siektiskak gqprepqvyt lppsqeemtk
      241 nqvsltclvk gfypsdiave wesngqpenn ykttppvlds dgsfflysrl tvdksrwqeg
      301 nvfscsvmhe alhnhytqks lslslgk
//

LOCUS       GP1BA_HUMAN              626 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Platelet glycoprotein Ib alpha chain; Short=GP-Ib
            alpha; Short=GPIb-alpha; Short=GPIbA; Short=Glycoprotein Ibalpha;
            AltName: Full=Antigen CD42b-alpha; AltName: CD_antigen=CD42b;
            Contains: RecName: Full=Glycocalicin; Flags: Precursor.
ACCESSION   P07359
VERSION     P07359.1  GI:121531
DBSOURCE    UniProtKB: locus GP1BA_HUMAN, accession P07359;
            class: standard.
            extra accessions:Q14441,Q16469,Q8N1F3,Q8NG39,Q9HDC7,Q9UEK1,Q9UQS4
            created: Apr 1, 1988.
            sequence updated: Apr 1, 1988.
            annotation updated: Sep 21, 2011.
            xrefs: J02940.1, AAA52595.1, M22403.1, AAA52596.1, AB038516.1,
            BAB12038.1, AB086948.1, BAC10305.1, AF395009.1, AAK71325.1,
            BC027955.1, AAH27955.1, D85894.1, BAA12911.1, S34436.1, AAB22152.1,
            S34439.1, AAB22153.1, L39103.1, AAA69491.1, NBHUIA, I70082, 1GWB_A,
            1GWB_B, 1K13_A, 1M0Z_A, 1M0Z_B, 1M10_B, 1OOK_G, 1P8V_A, 1P9A_G,
            1QYY_A, 1QYY_G, 1SQ0_B, 1U0N_D, 2BP3_S, 2BP3_T, 3P72_A, 3PMH_G
            xrefs (non-sequence databases): IPI:IPI00748955, UniGene:Hs.1472,
            PDBsum:1GWB, PDBsum:1K13, PDBsum:1M0Z, PDBsum:1M10, PDBsum:1OOK,
            PDBsum:1P8V, PDBsum:1P9A, PDBsum:1QYY, PDBsum:1SQ0, PDBsum:1U0N,
            PDBsum:2BP3, PDBsum:3P72, PDBsum:3PMH, ProteinModelPortal:P07359,
            SMR:P07359, IntAct:P07359, MINT:MINT-147226, STRING:P07359,
            GlycoSuiteDB:P07359, PhosphoSite:P07359, PRIDE:P07359,
            Ensembl:ENST00000438881, Ensembl:ENSP00000396783,
            Ensembl:ENSG00000185245, GeneCards:GC17P004776, H-InvDB:HIX0013453,
            HGNC:4439, HPA:CAB002496, HPA:HPA013316, MIM:153670, MIM:177820,
            MIM:231200, MIM:258660, MIM:606672, neXtProt:NX_P07359,
            Orphanet:274, Orphanet:52530, eggNOG:prNOG18611,
            HOVERGEN:HBG051790, InParanoid:P07359, OrthoDB:EOG402WSZ,
            Pathway_Interaction_DB:amb2_neutrophils_pathway,
            Reactome:REACT_604, NextBio:11075, PMAP-CutDB:P07359,
            ArrayExpress:P07359, Bgee:P07359, CleanEx:HS_GP1BA,
            Genevestigator:P07359, GermOnline:ENSG00000185245, GO:0005887,
            GO:0005624, GO:0005515, GO:0015057, GO:0007597, GO:0007155,
            GO:0042730, GO:0030168, InterPro:IPR000483, InterPro:IPR001611,
            InterPro:IPR003591, InterPro:IPR000372, Pfam:PF00560, Pfam:PF01462,
            SMART:SM00369, SMART:SM00082, SMART:SM00013, PROSITE:PS51450
KEYWORDS    3D-structure; Bernard Soulier syndrome; Blood coagulation; Cell
            adhesion; Complete proteome; Direct protein sequencing; Disease
            mutation; Disulfide bond; Glycoprotein; Hemostasis; Leucine-rich
            repeat; Membrane; Phosphoprotein; Polymorphism; Reference proteome;
            Repeat; Signal; Sulfation; Transmembrane; Transmembrane helix; von
            Willebrand disease.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 626)
  AUTHORS   Lopez,J.A., Chung,D.W., Fujikawa,K., Hagen,F.S., Papayannopoulou,T.
            and Roth,G.J.
  TITLE     Cloning of the alpha chain of human platelet glycoprotein Ib: a
            transmembrane protein with homology to leucine-rich alpha
            2-glycoprotein
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 84 (16), 5615-5619 (1987)
   PUBMED   3303030
  REMARK    NUCLEOTIDE SEQUENCE [MRNA], AND PARTIAL PROTEIN SEQUENCE.
REFERENCE   2  (residues 1 to 626)
  AUTHORS   Wenger,R.H., Kieffer,N., Wicki,A.N. and Clemetson,K.J.
  TITLE     Structure of the human blood platelet membrane glycoprotein Ib
            alpha gene
  JOURNAL   Biochem. Biophys. Res. Commun. 156 (1), 389-395 (1988)
   PUBMED   2845978
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   3  (residues 1 to 626)
  AUTHORS   Matsubara,Y., Murata,M., Moriki,T., Yokoyama,K., Watanabe,N.,
            Nakajima,H., Handa,M., Kawano,K., Aoki,N., Yoshino,H. and Ikeda,Y.
  TITLE     A novel polymorphism, 70Leu/Phe, disrupts a consensus Leu residue
            within the leucine-rich repeat sequence of platelet glycoprotein
            Ibalpha
  JOURNAL   Thromb. Haemost. 87 (5), 867-872 (2002)
   PUBMED   12038791
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA], AND VARIANT PHE-86.
REFERENCE   4  (residues 1 to 626)
  AUTHORS   Matsubara,Y., Murata,M., Sugita,K. and Ikeda,Y.
  TITLE     Identification of a novel point mutation in platelet glycoprotein
            Ibalpha, Gly to Ser at residue 233, in a Japanese family with
            platelet-type von Willebrand disease
  JOURNAL   J. Thromb. Haemost. 1 (10), 2198-2205 (2003)
   PUBMED   14521605
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA], VARIANT PVWD SER-249,
            CHARACTERIZATION OF VARIANT PVWD VAL-255, AND MUTAGENESIS OF
            GLY-249.
REFERENCE   5  (residues 1 to 626)
  CONSRTM   SeattleSNPs variation discovery resource
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUN-2001)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA], AND VARIANT MET-161.
REFERENCE   6  (residues 1 to 626)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Lung
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   7  (residues 1 to 626)
  AUTHORS   Titani,K., Takio,K., Handa,M. and Ruggeri,Z.M.
  TITLE     Amino acid sequence of the von Willebrand factor-binding domain of
            platelet membrane glycoprotein Ib
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 84 (16), 5610-5614 (1987)
   PUBMED   3497398
  REMARK    PROTEIN SEQUENCE OF 17-315, AND STRUCTURE OF CARBOHYDRATE.
REFERENCE   8  (residues 1 to 626)
  AUTHORS   Gevaert,K., Goethals,M., Martens,L., Van Damme,J., Staes,A.,
            Thomas,G.R. and Vandekerckhove,J.
  TITLE     Exploring proteomes and analyzing protein processing by mass
            spectrometric identification of sorted N-terminal peptides
  JOURNAL   Nat. Biotechnol. 21 (5), 566-569 (2003)
   PUBMED   12665801
  REMARK    PROTEIN SEQUENCE OF 128-137.;
            TISSUE=Platelet
REFERENCE   9  (residues 1 to 626)
  AUTHORS   Suzuki,K., Hayashi,T., Akiba,J., Yahagi,A., Tajima,K., Satoh,S. and
            Sasaki,H.
  TITLE     StyI polymorphism at nucleotide 1610 in the human platelet
            glycoprotein Ib alpha gene
  JOURNAL   Jpn. J. Hum. Genet. 41 (4), 419-421 (1996)
   PUBMED   9088113
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 305-397.
REFERENCE   10 (residues 1 to 626)
  AUTHORS   Hess,D., Schaller,J., Rickli,E.E. and Clemetson,K.J.
  TITLE     Identification of the disulphide bonds in human platelet
            glycocalicin
  JOURNAL   Eur. J. Biochem. 199 (2), 389-393 (1991)
   PUBMED   2070794
  REMARK    DISULFIDE BONDS.
REFERENCE   11 (residues 1 to 626)
  AUTHORS   Takafuta,T., Wu,G., Murphy,G.F. and Shapiro,S.S.
  TITLE     Human beta-filamin is a new protein that interacts with the
            cytoplasmic tail of glycoprotein Ibalpha
  JOURNAL   J. Biol. Chem. 273 (28), 17531-17538 (1998)
   PUBMED   9651345
  REMARK    INTERACTION WITH FLNB.;
            TISSUE=Endothelial cell, and Placenta
REFERENCE   12 (residues 1 to 626)
  AUTHORS   Lewandrowski,U., Moebius,J., Walter,U. and Sickmann,A.
  TITLE     Elucidation of N-glycosylation sites on human platelet proteins: a
            glycoproteomic approach
  JOURNAL   Mol. Cell Proteomics 5 (2), 226-233 (2006)
   PUBMED   16263699
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-37, AND MASS
            SPECTROMETRY.;
            TISSUE=Platelet
REFERENCE   13 (residues 1 to 626)
  AUTHORS   Zahedi,R.P., Lewandrowski,U., Wiesner,J., Wortelkamp,S.,
            Moebius,J., Schutz,C., Walter,U., Gambaryan,S. and Sickmann,A.
  TITLE     Phosphoproteome of resting human platelets
  JOURNAL   J. Proteome Res. 7 (2), 526-534 (2008)
   PUBMED   18088087
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT TYR-292; TYR-294;
            TYR-295; SER-603 AND SER-606, AND MASS SPECTROMETRY.;
            TISSUE=Platelet
REFERENCE   14 (residues 1 to 626)
  AUTHORS   Uff,S., Clemetson,J.M., Harrison,T., Clemetson,K.J. and Emsley,J.
  TITLE     Crystal structure of the platelet glycoprotein Ib(alpha) N-terminal
            domain reveals an unmasking mechanism for receptor activation
  JOURNAL   J. Biol. Chem. 277 (38), 35657-35663 (2002)
   PUBMED   12087105
  REMARK    X-RAY CRYSTALLOGRAPHY (2.8 ANGSTROMS) OF 17-304, AND SULFATION AT
            TYR-292; TYR-294 AND TYR-295.
REFERENCE   15 (residues 1 to 626)
  AUTHORS   Huizinga,E.G., Tsuji,S., Romijn,R.A., Schiphorst,M.E., de
            Groot,P.G., Sixma,J.J. and Gros,P.
  TITLE     Structures of glycoprotein Ibalpha and its complex with von
            Willebrand factor A1 domain
  JOURNAL   Science 297 (5584), 1176-1179 (2002)
   PUBMED   12183630
  REMARK    X-RAY CRYSTALLOGRAPHY (1.85 ANGSTROMS).
REFERENCE   16 (residues 1 to 626)
  AUTHORS   Whisstock,J.C., Shen,Y., Lopez,J.A., Andrews,R.K. and Berndt,M.C.
  TITLE     Molecular modeling of the seven tandem leucine-rich repeats within
            the ligand-binding region of platelet glycoprotein Ib alpha
  JOURNAL   Thromb. Haemost. 87 (2), 329-333 (2002)
   PUBMED   11858495
  REMARK    3D-STRUCTURE MODELING OF 52-216.
REFERENCE   17 (residues 1 to 626)
  AUTHORS   Murata,M., Furihata,K., Ishida,F., Russell,S.R., Ware,J. and
            Ruggeri,Z.M.
  TITLE     Genetic and structural characterization of an amino acid dimorphism
            in glycoprotein Ib alpha involved in platelet transfusion
            refractoriness
  JOURNAL   Blood 79 (11), 3086-3090 (1992)
   PUBMED   1586750
  REMARK    VARIANT SIBA MET-161.
REFERENCE   18 (residues 1 to 626)
  AUTHORS   Miller,J.L., Lyle,V.A. and Cunningham,D.
  TITLE     Mutation of leucine-57 to phenylalanine in a platelet glycoprotein
            Ib alpha leucine tandem repeat occurring in patients with an
            autosomal dominant variant of Bernard-Soulier disease
  JOURNAL   Blood 79 (2), 439-446 (1992)
   PUBMED   1730088
  REMARK    VARIANT BSS PHE-73.
REFERENCE   19 (residues 1 to 626)
  AUTHORS   Lopez,J.A., Ludwig,E.H. and McCarthy,B.J.
  TITLE     Polymorphism of human glycoprotein Ib alpha results from a variable
            number of tandem repeats of a 13-amino acid sequence in the
            mucin-like macroglycopeptide region. Structure/function
            implications
  JOURNAL   J. Biol. Chem. 267 (14), 10055-10061 (1992)
   PUBMED   1577776
  REMARK    POLYMORPHISM OF PRO/THR-RICH DOMAIN.
REFERENCE   20 (residues 1 to 626)
  AUTHORS   Ware,J., Russell,S.R., Marchese,P., Murata,M., Mazzucato,M., De
            Marco,L. and Ruggeri,Z.M.
  TITLE     Point mutation in a leucine-rich repeat of platelet glycoprotein Ib
            alpha resulting in the Bernard-Soulier syndrome
  JOURNAL   J. Clin. Invest. 92 (3), 1213-1220 (1993)
   PUBMED   7690774
  REMARK    VARIANT BSS VAL-172.
REFERENCE   21 (residues 1 to 626)
  AUTHORS   Simsek,S., Noris,P., Lozano,M., Pico,M., von dem Borne,A.E.,
            Ribera,A. and Gallardo,D.
  TITLE     Cys209 Ser mutation in the platelet membrane glycoprotein Ib alpha
            gene is associated with Bernard-Soulier syndrome
  JOURNAL   Br. J. Haematol. 88 (4), 839-844 (1994)
   PUBMED   7819107
  REMARK    VARIANT BSS SER-225.
REFERENCE   22 (residues 1 to 626)
  AUTHORS   Miller,J.L., Cunningham,D., Lyle,V.A. and Finch,C.N.
  TITLE     Mutation in the gene encoding the alpha chain of platelet
            glycoprotein Ib in platelet-type von Willebrand disease
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 88 (11), 4761-4765 (1991)
   PUBMED   2052556
  REMARK    VARIANT PVWD VAL-249.
REFERENCE   23 (residues 1 to 626)
  AUTHORS   Murata,M., Russell,S.R., Ruggeri,Z.M. and Ware,J.
  TITLE     Expression of the phenotypic abnormality of platelet-type von
            Willebrand disease in a recombinant glycoprotein Ib alpha fragment
  JOURNAL   J. Clin. Invest. 91 (5), 2133-2137 (1993)
   PUBMED   8486780
  REMARK    VARIANT PVWD VAL-249.
REFERENCE   24 (residues 1 to 626)
  AUTHORS   Russell,S.D. and Roth,G.J.
  TITLE     Pseudo-von Willebrand disease: a mutation in the platelet
            glycoprotein Ib alpha gene associated with a hyperactive surface
            receptor
  JOURNAL   Blood 81 (7), 1787-1791 (1993)
   PUBMED   8384898
  REMARK    VARIANT PVWD VAL-255.
REFERENCE   25 (residues 1 to 626)
  AUTHORS   Ishida,F., Furihata,K., Ishida,K., Yan,J., Kitano,K., Kiyosawa,K.
            and Furuta,S.
  TITLE     The largest variant of platelet glycoprotein Ib alpha has four
            tandem repeats of 13 amino acids in the macroglycopeptide region
            and a genetic linkage with methionine145
  JOURNAL   Blood 86 (4), 1357-1360 (1995)
   PUBMED   7632942
  REMARK    VARIANT SIBA MET-161, AND POLYMORPHISM OF PRO/THR-RICH DOMAIN.
REFERENCE   26 (residues 1 to 626)
  AUTHORS   de la Salle,C., Baas,M.J., Lanza,F., Schwartz,A., Hanau,D.,
            Chevalier,J., Gachet,C., Briquel,M.E. and Cazenave,J.P.
  TITLE     A three-base deletion removing a leucine residue in a leucine-rich
            repeat of platelet glycoprotein Ib alpha associated with a variant
            of Bernard-Soulier syndrome (Nancy I)
  JOURNAL   Br. J. Haematol. 89 (2), 386-396 (1995)
   PUBMED   7873390
  REMARK    VARIANT BSS LEU-195 DEL.
REFERENCE   27 (residues 1 to 626)
  AUTHORS   Kenny,D., Jonsson,O.G., Morateck,P.A. and Montgomery,R.R.
  TITLE     Naturally occurring mutations in glycoprotein Ibalpha that result
            in defective ligand binding and synthesis of a truncated protein
  JOURNAL   Blood 92 (1), 175-183 (1998)
   PUBMED   9639514
  REMARK    VARIANT BSS ARG-81.
REFERENCE   28 (residues 1 to 626)
  AUTHORS   Cargill,M., Altshuler,D., Ireland,J., Sklar,P., Ardlie,K.,
            Patil,N., Shaw,N., Lane,C.R., Lim,E.P., Kalyanaraman,N., Nemesh,J.,
            Ziaugra,L., Friedland,L., Rolfe,A., Warrington,J., Lipshutz,R.,
            Daley,G.Q. and Lander,E.S.
  TITLE     Characterization of single-nucleotide polymorphisms in coding
            regions of human genes
  JOURNAL   Nat. Genet. 22 (3), 231-238 (1999)
   PUBMED   10391209
  REMARK    VARIANTS HIS-72 AND MET-161.
            Erratum:[Nat Genet 1999 Nov;23(3):373]
REFERENCE   29 (residues 1 to 626)
  AUTHORS   Cargill,M., Altshuler,D., Ireland,J., Sklar,P., Ardlie,K.,
            Patil,N., Shaw,N., Lane,C.R., Lim,E.P., Kalyanaraman,N., Nemesh,J.,
            Ziaugra,L., Friedland,L., Rolfe,A., Warrington,J., Lipshutz,R.,
            Daley,G.Q. and Lander,E.S.
  JOURNAL   Nat. Genet. 23, 373-373 (1999)
  REMARK    ERRATUM.
REFERENCE   30 (residues 1 to 626)
  AUTHORS   Koskela,S., Partanen,J., Salmi,T.T. and Kekomaki,R.
  TITLE     Molecular characterization of two mutations in platelet
            glycoprotein (GP) Ib alpha in two Finnish Bernard-Soulier syndrome
            families
  JOURNAL   Eur. J. Haematol. 62 (3), 160-168 (1999)
   PUBMED   10089893
  REMARK    VARIANT BSS PRO-145.
REFERENCE   31 (residues 1 to 626)
  AUTHORS   Savoia,A., Balduini,C.L., Savino,M., Noris,P., Del Vecchio,M.,
            Perrotta,S., Belletti,S., Poggi and Iolascon,A.
  TITLE     Autosomal dominant macrothrombocytopenia in Italy is most
            frequently a type of heterozygous Bernard-Soulier syndrome
  JOURNAL   Blood 97 (5), 1330-1335 (2001)
   PUBMED   11222377
  REMARK    VARIANT BMM VAL-172.
REFERENCE   32 (residues 1 to 626)
  AUTHORS   Salomon,O., Rosenberg,N., Steinberg,D.M., Huna-Baron,R.,
            Moisseiev,J., Dardik,R., Goldan,O., Kurtz,S., Ifrah,A. and
            Seligsohn,U.
  TITLE     Nonarteritic anterior ischemic optic neuropathy is associated with
            a specific platelet polymorphism located on the glycoprotein
            Ibalpha gene
  JOURNAL   Ophthalmology 111 (1), 184-188 (2004)
   PUBMED   14711733
  REMARK    INVOLVEMENT IN SUSCEPTIBILITY TO NAION.
COMMENT     On or before Mar 15, 2005 this sequence version replaced gi:72061,
            gi:2119617.
            [FUNCTION] GP-Ib, a surface membrane protein of platelets,
            participates in the formation of platelet plugs by binding to the
            A1 domain of vWF, which is already bound to the subendothelium.
            [SUBUNIT] Heterodimer composed of GP-Ib alpha and beta; disulfide
            linked. GP-IX is complexed with the GP-Ib heterodimer via a non
            covalent linkage. Interacts with FLNB.
            [INTERACTION] P04275:VWF; NbExp=2; IntAct=EBI-297082, EBI-981819.
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Glycocalicin, which is approximately coextensive with the
            extracellular part of the molecule, is cleaved off by calpain
            during platelet lysis.
            [POLYMORPHISM] Position 161 is associated with platelet-specific
            alloantigen Siba. Siba(-) has Thr-161 and Siba(+) has Met-161. Siba
            is involved in neonatal alloimmune thrombocytopenia (NATP).
            [POLYMORPHISM] Polymorphisms arise from a variable number of tandem
            13-amino acid repeats of S-E-P-A-P-S-P-T-T-P-E-P-T in the
            mucin-like macroglycopeptide (Pro/Thr-rich) domain. Allele D (shown
            here) contains one repeat starting at position 415, allele C
            contains two repeats, allele B contains three repeats and allele A
            contains four repeats. Allele B is associated with susceptibility
            to nonarteritic anterior ischemic optic neuropathy.
            [DISEASE] Genetic variations in GP1BA may be a cause of
            susceptibility to non-arteritic anterior ischemic optic neuropathy
            (NAION) [MIM:258660]. NAION is an ocular disease due to ischemic
            injury to the optic nerve. It usually affects the optic disk and
            leads to visual loss and optic disk swelling of a pallid nature.
            Visual loss is usually sudden, or over a few days at most and is
            usually permanent, with some recovery possibly occurring within the
            first weeks or months. Patients with small disks having smaller or
            non-existent cups have an anatomical predisposition for
            non-arteritic anterior ischemic optic neuropathy. As an ischemic
            episode evolves, the swelling compromises circulation, with a
            spiral of ischemia resulting in further neuronal damage.
            [DISEASE] Defects in GP1BA are a cause of Bernard-Soulier syndrome
            (BSS) [MIM:231200]; also known as giant platelet disease (GPD). BSS
            patients have unusually large platelets and have a clinical
            bleeding tendency.
            [DISEASE] Defects in GP1BA are the cause of benign mediterranean
            macrothrombocytopenia (BMM) [MIM:153670]; also known as autosomal
            dominant benign Bernard-Soulier syndrome. BMM is characterized by
            mild or no clinical symptoms, normal platelet function, and normal
            megakaryocyte count.
            [DISEASE] Defects in GP1BA are the cause of von Willebrand disease
            platelet-type (PVWD) [MIM:177820]; also known as pseudo-von
            Willebrand disease (pseudo-vWD). This autosomal dominant bleeding
            disorder is caused by an increased affinity of GP-Ib for soluble
            vWF resulting in impaired hemostatic function due to the removal of
            vWF from the circulation.
            [MISCELLANEOUS] Platelet activation apparently involves disruption
            of the macromolecular complex of GP-Ib with the platelet
            glycoprotein IX (GP-IX) and dissociation of GP-Ib from the
            actin-binding protein.
            [MISCELLANEOUS] Binding sites for vWF and thrombin (the latter site
            with unknown function) are in the N-terminal part of the molecule.
            [SIMILARITY] Contains 7 LRR (leucine-rich) repeats.
            [SIMILARITY] Contains 1 LRRCT domain.
            [SIMILARITY] Contains 1 LRRNT domain.
            [WEB RESOURCE] Name=GeneReviews;
            URL='http://www.ncbi.nlm.nih.gov/sites/GeneTests/lab/gene/GP1BA'.
            [WEB RESOURCE] Name=SeattleSNPs;
            URL='http://pga.gs.washington.edu/data/gp1ba/'.
FEATURES             Location/Qualifiers
     source          1..626
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..626
                     /gene="GP1BA"
     Protein         1..626
                     /gene="GP1BA"
                     /product="Platelet glycoprotein Ib alpha chain"
                     /note="GP-Ib alpha; GPIb-alpha; GPIbA; Glycoprotein
                     Ibalpha; Antigen CD42b-alpha"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..16
                     /gene="GP1BA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          17..626
                     /gene="GP1BA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Platelet glycoprotein Ib alpha chain.
                     /FTId=PRO_0000021343."
     Region          17..626
                     /gene="GP1BA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Glycocalicin. /FTId=PRO_0000021344."
     Region          17..505
                     /gene="GP1BA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          17..47
                     /gene="GP1BA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRRNT."
     Region          19..50
                     /gene="GP1BA"
                     /region_name="LRRNT"
                     /note="Leucine rich repeat N-terminal domain; cl02423"
                     /db_xref="CDD:198667"
     Region          19..23
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            20..33
                     /gene="GP1BA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          28..>151
                     /gene="GP1BA"
                     /region_name="COG4886"
                     /note="Leucine-rich repeat (LRR) protein [Function
                     unknown]"
                     /db_xref="CDD:34495"
     Region          30..32
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            37
                     /gene="GP1BA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          48..68
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 1."
     Region          51..53
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          60..63
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..67
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          72..93
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 2."
     Region          72
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in dbSNP:rs6068). /FTId=VAR_011909."
     Region          73
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in BSS). /FTId=VAR_014206."
     Region          75..77
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> R (in BSS). /FTId=VAR_005256."
     Region          84..87
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          86
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in dbSNP:rs13306411). /FTId=VAR_013511."
     Region          94..115
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 3."
     Region          97..99
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          112..114
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          115..138
                     /gene="GP1BA"
                     /region_name="LRR_TYP"
                     /note="Leucine-rich repeats, typical (most populated)
                     subfamily; cl15310"
                     /db_xref="CDD:199168"
     Region          117..137
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 4."
     Region          120..122
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          133..138
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          141..162
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 5."
     Region          144..146
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          145
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> P (in BSS). /FTId=VAR_014207."
     Region          157..162
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          161
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> M (in Siba(+); dbSNP:rs6065).
                     /FTId=VAR_005257."
     Region          165..186
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 6."
     Region          168..170
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          172
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> V (in BSS and BMM). /FTId=VAR_005258."
     Site            175
                     /gene="GP1BA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          181..186
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          189..210
                     /gene="GP1BA"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRR 7."
     Region          192..194
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          195
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in BSS). /FTId=VAR_005259."
     Region          205..210
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          214..217
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          221..282
                     /gene="GP1BA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LRRCT."
     Region          221..281
                     /gene="GP1BA"
                     /region_name="LRRCT"
                     /note="Leucine rich repeat C-terminal domain; smart00082"
                     /db_xref="CDD:197506"
     Bond            225..264
                     /gene="GP1BA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          225
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in BSS). /FTId=VAR_005260."
     Bond            227..280
                     /gene="GP1BA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          227..229
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          230..238
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          240..242
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> S (in PVWD). /FTId=VAR_019657."
     Region          249
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> V (in PVWD). /FTId=VAR_005261."
     Site            249
                     /gene="GP1BA"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G->A: No change."
     Site            249
                     /gene="GP1BA"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G->K,D: Decreased binding to vWF."
     Site            249
                     /gene="GP1BA"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G->S,V: Increased binding to vWF."
     Region          254
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> S (in dbSNP:rs382524). /FTId=VAR_011910."
     Region          255
                     /gene="GP1BA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> V (in PVWD; increased binding to vWF).
                     /FTId=VAR_005262."
     Region          259..261
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          262..264
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..268
                     /gene="GP1BA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          272..274
                     /gene="GP1BA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          283..287
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            292
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphotyrosine."
     Site            292
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sulfotyrosine."
     Site            294
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphotyrosine."
     Site            294
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sulfotyrosine."
     Site            295
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphotyrosine."
     Site            295
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sulfotyrosine."
     Site            308
                     /gene="GP1BA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="O-linked (GalNAc...)."
     Region          345..456
                     /gene="GP1BA"
                     /region_name="Compositionally biased region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Pro/Thr-rich."
     Region          506..526
                     /gene="GP1BA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          527..626
                     /gene="GP1BA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          579..587
                     /gene="GP1BA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          593
                     /gene="GP1BA"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in Ref. 6; AAH27955)."
     Site            603
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Site            606
                     /gene="GP1BA"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
ORIGIN      
        1 mpllllllll psplhphpic evskvashle vncdkrnlta lppdlpkdtt ilhlsenlly
       61 tfslatlmpy trltqlnldr celtklqvdg tlpvlgtldl shnqlqslpl lgqtlpaltv
      121 ldvsfnrlts lplgalrglg elqelylkgn elktlppgll tptpklekls lannnltelp
      181 agllnglenl dtlllqensl ytipkgffgs hllpfaflhg npwlcnceil yfrrwlqdna
      241 envyvwkqgv dvkamtsnva svqcdnsdkf pvykypgkgc ptlgdegdtd lydyypeedt
      301 egdkvratrt vvkfptkaht tpwglfysws tasldsqmps slhptqestk eqttfpprwt
      361 pnftlhmesi tfsktpkstt eptpspttse pvpepapnmt tleptpsptt peptsepaps
      421 pttpeptpip tiatsptilv satslitpks tfltttkpvs llestkktip eldqppklrg
      481 vlqghlessr ndpflhpdfc cllplgfyvl glfwllfasv vlilllswvg hvkpqaldsg
      541 qgaalttatq tthlelqrgr qvtvprawll flrgslptfr sslflwvrpn grvgplvagr
      601 rpsalsqgrg qdllstvsir ysghsl
//

LOCUS       1B51_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-51 alpha
            chain; AltName: Full=MHC class I antigen B*51; Flags: Precursor.
ACCESSION   P18464
VERSION     P18464.1  GI:122172
DBSOURCE    UniProtKB: locus 1B51_HUMAN, accession P18464;
            class: standard.
            extra accessions:O19675,O78173,P30489,Q29851,Q29857,Q96IT9,Q9MY43
            created: Nov 1, 1990.
            sequence updated: Nov 1, 1990.
            annotation updated: Sep 21, 2011.
            xrefs: M32319.1, AAA36232.1, M22792.1, AAA59620.1, M22786.1,
            M22787.1, M22788.1, M22789.1, M22790.1, M22791.1, L41087.1,
            AAA64513.1, L41086.1, Z15143.1, CAA78849.1, M80670.1, AAA52661.1,
            L41925.1, AAC41979.1, Y08994.1, CAA70198.1, AB056860.1, BAB64902.1,
            AB056862.1, BAB64904.1, AB056863.1, BAB64905.1, AB056864.1,
            BAB64906.1, AB056865.1, BAB64907.1, AJ278903.1, CAC05371.1,
            BC007243.1, AAH07243.1, AJ276995.1, CAB86196.1, Z46808.1,
            CAA86838.1, A30345, I37120, 1E27_A, 1E28_A
            xrefs (non-sequence databases): IPI:IPI00718924, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1E27, PDBsum:1E28,
            ProteinModelPortal:P18464, SMR:P18464, DIP:DIP-6150N,
            MINT:MINT-144207, STRING:P18464, PRIDE:P18464,
            Ensembl:ENST00000359635, Ensembl:ENSP00000352656,
            Ensembl:ENSG00000206450, GeneCards:GC06M031112,
            GeneCards:GC06Mn31311, H-InvDB:HIX0005715, HGNC:4932, MIM:142830,
            neXtProt:NX_P18464, HOVERGEN:HBG016709, InParanoid:P18464,
            Reactome:REACT_6900, CleanEx:HS_HLA-B, Genevestigator:P18464,
            GO:0016021, GO:0042612, GO:0002474, GO:0060333, GO:0044419,
            GO:0050776, GO:0060337, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Ennis,P.D., Zemmour,J., Salter,R.D. and Parham,P.
  TITLE     Rapid cloning of HLA-A,B cDNA by using the polymerase chain
            reaction: frequency and nature of errors produced in amplification
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 87 (7), 2833-2837 (1990)
   PUBMED   2320591
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*51:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Hayashi,H., Ennis,P.D., Ariga,H., Salter,R.D., Parham,P., Kano,K.
            and Takiguchi,M.
  TITLE     HLA-B51 and HLA-Bw52 differ by only two amino acids which are in
            the helical region of the alpha 1 domain
  JOURNAL   J. Immunol. 142 (1), 306-311 (1989)
   PUBMED   2909619
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*51:01).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Pohla,H., Kuon,W., Tabaczewski,P., Doerner,C. and Weiss,E.H.
  TITLE     Allelic variation in HLA-B and HLA-C sequences and the evolution of
            the HLA-B alleles
  JOURNAL   Immunogenetics 29 (5), 297-307 (1989)
   PUBMED   2714852
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*51:01).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Belich,M.P., Madrigal,J.A., Hildebrand,W.H., Zemmour,J.,
            Williams,R.C., Luz,R., Petzl-Erler,M.L. and Parham,P.
  TITLE     Unusual HLA-B alleles in two tribes of Brazilian Indians
  JOURNAL   Nature 357 (6376), 326-329 (1992)
   PUBMED   1317015
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*51:04).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Kawaguchi,G., Nakayama,S., Nagao,T. and Takiguchi,M.
  TITLE     A single amino acid substitution at residue 167 forms a novel
            HLA-B51 subtype
  JOURNAL   Tissue Antigens 42 (1), 39-41 (1993)
   PUBMED   8248893
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*51:03).;
            TISSUE=Peripheral blood
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Prilliman,K., Steiner,N., Ellexson,M., Stewart,D., Lau,M.,
            Terasaki,P., Hurley,C. and Hildebrand,W.
  TITLE     Novel alleles HLA-B*7802 and B*51022: evidence for convergency in
            the HLA-B5 family
  JOURNAL   Tissue Antigens 47 (1), 49-57 (1996)
   PUBMED   8929712
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*51:02).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Vilches,C., Bunce,M., de Pablo,R., Murray,A.K., McIntyre,C.A. and
            Kreisler,M.
  TITLE     Complete coding regions of two novel HLA-B alleles detected by
            phototyping (PCR-SSP) in the British caucasoid population: B*5108
            and B*5002
  JOURNAL   Tissue Antigens 50 (1), 38-41 (1997)
   PUBMED   9243753
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*51:08).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Sano,K., Yabuki,K., Imagawa,Y., Shiina,T., Mizuki,N., Ohno,S.,
            Kulski,J.K. and Inoko,H.
  TITLE     The absence of disease-specific polymorphisms within the HLA-B51
            gene that is the susceptible locus for Behcet's disease
  JOURNAL   Tissue Antigens 58 (2), 77-82 (2001)
   PUBMED   11696219
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*51:01).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*51:01).
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Steinle,A. and Schendel,D.J.
  TITLE     HLA class I alleles of LCL 721 and 174 x CEM.T2 (T2)
  JOURNAL   Tissue Antigens 44 (4), 268-270 (1994)
   PUBMED   7871529
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 1-206 (ALLELE B*51:01).
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] OF 3-362 (ALLELE B*51:01).;
            TISSUE=Lymph
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   12 (residues 1 to 362)
  AUTHORS   Anholts,J.D., Kemps-Mols,B., Verduijn,W., Oudshoorn,M. and
            Schreuder,G.M.
  TITLE     Three newly identified HLA-B alleles: B*5124, B*5306, B*5307 and
            confirmation of B*0809 and B*5606
  JOURNAL   Tissue Antigens 58 (1), 38-41 (2001)
   PUBMED   11580855
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*51:24).;
            TISSUE=Peripheral blood
REFERENCE   13 (residues 1 to 362)
  AUTHORS   Maenaka,K., Maenaka,T., Tomiyama,H., Takiguchi,M., Stuart,D.I. and
            Jones,E.Y.
  TITLE     Nonstandard peptide binding revealed by crystal structures of
            HLA-B*5101 complexed with HIV immunodominant epitopes
  JOURNAL   J. Immunol. 165 (6), 3260-3267 (2000)
   PUBMED   10975842
  REMARK    X-RAY CRYSTALLOGRAPHY (2.2 ANGSTROMS) OF 25-300 (B*51:01).
REFERENCE   14 (residues 1 to 362)
  AUTHORS   Arayssi,T. and Hamdan,A.
  TITLE     New insights into the pathogenesis and therapy of Behcet's disease
  JOURNAL   Curr Opin Pharmacol 4 (2), 183-188 (2004)
   PUBMED   15063364
  REMARK    INVOLVEMENT IN BEHCET DISEASE.
COMMENT     On or before Mar 15, 2005 this sequence version replaced gi:107004,
            gi:2118776, gi:231412.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-51 are known: B*51:01,
            B*51:03, B*51:04, B*51:08 and B*51:24. The sequence shown is that
            of B*51:01.
            [MISCELLANEOUS] There is evidence that HLA-B51 is associated with
            susceptibility to Behcet disease. However it is not certain whether
            HLA-B51 itself or a closely linked gene is responsible for
            susceptibility. The world distribution of HLA-B51 in healthy people
            corresponds to the global distribution of Behcet disease; in
            Southern hemisphere countries (Africa, South Pacific, etc.) and in
            some parts of Europe, the prevalence of HLA-B51 in healthy people
            is low or null, corresponding to a low prevalence of Behcet
            disease. The wide variation that exists in the relative risk of
            HLA-B51 would support other nongenetic risk factors.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-51
                     alpha chain"
                     /note="MHC class I antigen B*51"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-51 alpha
                     chain. /FTId=PRO_0000018854."
     Region          25..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          74..78
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          118..121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TWQT -> IIQR (in allele B*51:04).
                     /FTId=VAR_016478."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          155
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> R (in allele B*51:24). /FTId=VAR_017442."
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> V (in allele B*51:08). /FTId=VAR_016479."
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> D (in allele B*51:08; requires 2 nucleotide
                     substitutions). /FTId=VAR_016480."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          191
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> G (in allele B*51:03). /FTId=VAR_016481."
     Region          195
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Y (in allele B*51:02). /FTId=VAR_016482."
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..217
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          252..254
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290..292
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvtaprtvl lllwgavalt etwagshsmr yfytamsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasprte prapwieqeg peywdrntqi fktntqtyre nlrialryyn qseagshtwq
      121 tmygcdvgpd grllrghnqy aydgkdyial nedlsswtaa dtaaqitqrk weaareaeql
      181 rayleglcve wlrrhlengk etlqradppk thvthhpvsd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstipivg ivaglavlav vvigavvatv mcrrkssggk ggsysqaass dsaqgsdvsl
      361 ta
//

LOCUS       HV103_HUMAN              117 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig heavy chain V-I region V35; Flags: Precursor.
ACCESSION   P23083
VERSION     P23083.1  GI:123808
DBSOURCE    UniProtKB: locus HV103_HUMAN, accession P23083;
            class: standard.
            created: Nov 1, 1991.
            sequence updated: Nov 1, 1991.
            annotation updated: Sep 21, 2011.
            xrefs: X07448.1, HVHU35, 1WT5_A
            xrefs (non-sequence databases): IPI:IPI00009792, PDBsum:1WT5,
            ProteinModelPortal:P23083, SMR:P23083, STRING:P23083, PRIDE:P23083,
            Ensembl:ENST00000390594, Ensembl:ENSP00000375003,
            Ensembl:ENSG00000211934, UCSC:uc001yuh.2, GeneCards:GC14M106452,
            H-InvDB:HIX0176350, H-InvDB:HIX0193811,
            GeneTree:ENSGT00580000081342, HOGENOM:HBG716786,
            HOVERGEN:HBG018013, InParanoid:P23083, OrthoDB:EOG4V6ZJ5,
            Bgee:P23083, Genevestigator:P23083, GermOnline:ENSG00000130076,
            GO:0005576, GO:0003823, GO:0006955, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR013106, InterPro:IPR003596,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07686, SMART:SM00406,
            PROSITE:PS50835
KEYWORDS    3D-structure; Complete proteome; Immunoglobulin domain;
            Immunoglobulin V region; Reference proteome; Signal.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 117)
  AUTHORS   Matsuda,F., Lee,K.H., Nakai,S., Sato,T., Kodaira,M., Zong,S.Q.,
            Ohno,H., Fukuhara,S. and Honjo,T.
  TITLE     Dispersed localization of D segments in the human immunoglobulin
            heavy-chain locus
  JOURNAL   EMBO J. 7 (4), 1047-1051 (1988)
   PUBMED   2841108
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 117)
  AUTHORS   Mariette,X., Tsapis,A. and Brouet,J.C.
  TITLE     Nucleotidic sequence analysis of the variable domains of four human
            monoclonal IgM with an antibody activity to myelin-associated
            glycoprotein
  JOURNAL   Eur. J. Immunol. 23 (4), 846-851 (1993)
   PUBMED   7681398
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 20-116.
COMMENT     On Mar 15, 2005 this sequence version replaced gi:69886.
            [SIMILARITY] Contains 1 Ig-like (immunoglobulin-like) domain.
FEATURES             Location/Qualifiers
     source          1..117
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..>117
                     /product="Ig heavy chain V-I region V35"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..19
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          20..>117
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like."
     Region          20..117
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig heavy chain V-I region V35.
                     /FTId=PRO_0000015245."
     Region          23..117
                     /region_name="IgV_H"
                     /note="Immunoglobulin (Ig) heavy chain (H), variable (V)
                     domain; cd04981"
                     /db_xref="CDD:143182"
     Site            order(43..45,50..51)
                     /site_type="other"
                     /note="L1 hypervariable region"
                     /db_xref="CDD:143182"
     Site            order(52,69)
                     /site_type="other"
                     /note="antigen binding site"
                     /db_xref="CDD:143182"
     Site            order(58,62,66,114)
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143182"
     Site            92..97
                     /site_type="other"
                     /note="L2 hypervariable region"
                     /db_xref="CDD:143182"
ORIGIN      
        1 mdwtwrilfl vaaatgahsq vqlvqsgaev kkpgasvkvs ckasgytftg yymhwvrqap
       61 gqglewmgri npnsggtnya qkfqgrvtst rdtsistaym elsrlrsddt vvyycar
//

LOCUS       HV311_HUMAN              126 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig heavy chain V-III region KOL.
ACCESSION   P01772
VERSION     P01772.1  GI:123851
DBSOURCE    UniProtKB: locus HV311_HUMAN, accession P01772;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: G1HUKL, 2FB4_H, 2IG2_H, 2RCJ_A, 2RCJ_B, 2RCJ_E, 2RCJ_F,
            2RCJ_I, 2RCJ_J, 2RCJ_M, 2RCJ_N, 2RCJ_Q, 2RCJ_R
            xrefs (non-sequence databases): IPI:IPI00382489, PDBsum:2FB4,
            PDBsum:2IG2, PDBsum:2RCJ, ProteinModelPortal:P01772, SMR:P01772,
            PeptideAtlas:P01772, PRIDE:P01772, HOVERGEN:HBG018013,
            Reactome:REACT_6900, Genevestigator:P01772, GO:0005576, GO:0003823,
            GO:0006958, GO:0045087, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR013106, InterPro:IPR003596, Gene3D:G3DSA:2.60.40.10,
            Pfam:PF07686, SMART:SM00406, PROSITE:PS50835
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Immunoglobulin domain; Immunoglobulin V region;
            Pyrrolidone carboxylic acid; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 126)
  AUTHORS   Schmidt,W.E., Jung,H.D., Palm,W. and Hilschmann,N.
  TITLE     [Three-dimensional structure determination of antibodies. Primary
            structure of crystallized monoclonal immunoglobulin IgG1 KOL, I]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 364 (6), 713-747 (1983)
   PUBMED   6884994
  REMARK    PROTEIN SEQUENCE, AND DISULFIDE BONDS.
REFERENCE   2  (residues 1 to 126)
  AUTHORS   Marquart,M., Deisenhofer,J., Huber,R. and Palm,W.
  TITLE     Crystallographic refinement and atomic models of the intact
            immunoglobulin molecule Kol and its antigen-binding fragment at 3.0
            A and 1.0 A resolution
  JOURNAL   J. Mol. Biol. 141 (4), 369-391 (1980)
   PUBMED   7441755
  REMARK    X-RAY CRYSTALLOGRAPHY (1.9 ANGSTROMS).
COMMENT     On Mar 15, 2005 this sequence version replaced gi:69919.
            [SIMILARITY] Contains 1 Ig-like (immunoglobulin-like) domain.
FEATURES             Location/Qualifiers
     source          1..126
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..>126
                     /product="Ig heavy chain V-III region KOL"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..>126
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig heavy chain V-III region KOL.
                     /FTId=PRO_0000059923."
     Region          1..112
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like."
     Site            1
                     /site_type="pyrrolidone-carboxylic-acid"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          3..7
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          4..125
                     /region_name="IgV_H"
                     /note="Immunoglobulin (Ig) heavy chain (H), variable (V)
                     domain; cd04981"
                     /db_xref="CDD:143182"
     Site            order(9,11,121,123,125)
                     /site_type="other"
                     /note="intrachain domain interface"
                     /db_xref="CDD:143182"
     Region          18..27
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            22..96
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(24..26,31..32)
                     /site_type="other"
                     /note="L1 hypervariable region"
                     /db_xref="CDD:143182"
     Region          29..31
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(33,50,99)
                     /site_type="other"
                     /note="antigen binding site"
                     /db_xref="CDD:143182"
     Region          34..39
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(39,43,47,95,116..117)
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143182"
     Region          45..51
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          58..60
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          62..64
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          68..73
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            73..78
                     /site_type="other"
                     /note="L2 hypervariable region"
                     /db_xref="CDD:143182"
     Region          74..77
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          78..83
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          88..90
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          92..99
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(99,113..115)
                     /site_type="other"
                     /note="L3 hypervariable region"
                     /db_xref="CDD:143182"
     Region          101..103
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            105..110
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          113..116
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          120..124
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
ORIGIN      
        1 qvqlvesggg vvqpgrslrl scsssgfifs syamywvrqa pgkglewvai iwddgsdqhy
       61 adsvkgrfti srdnskntlf lqmdslrped tgvyfcardg ghgfcssasc fgpdywgqgt
      121 pvtvss
//

LOCUS       IGKC_HUMAN               106 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig kappa chain C region.
ACCESSION   P01834
VERSION     P01834.1  GI:125145
DBSOURCE    UniProtKB: locus IGKC_HUMAN, accession P01834;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: J00241.1, AAA58989.1, K3HU, 1A4J_A, 1A4J_L, 1A4K_A, 1A4K_L,
            1D5B_A, 1D5B_L, 1D5I_L, 1D6V_L, 1HEZ_A, 1HEZ_C, 1HKL_L, 1I7Z_A,
            1I7Z_C, 1MIM_L, 1UCB_L, 2O5X_L, 2O5Y_L, 2O5Z_L, 2QQK_L, 2QQL_L,
            2QQN_L, 2QSC_L, 2R56_L, 2R56_M, 2VXQ_L, 3B2U_D, 3B2U_G, 3B2U_K,
            3B2U_L, 3B2U_O, 3B2U_R, 3B2U_U, 3B2U_X, 3B2V_L, 3BDY_L, 3BE1_L,
            3BKY_L, 3BN9_C, 3BN9_E, 3BQU_A, 3C08_L, 3C09_B, 3C09_L, 3CFJ_A,
            3CFJ_C, 3CFJ_E, 3CFJ_L, 3CFK_A, 3CFK_C, 3CFK_E, 3CFK_G, 3CFK_J,
            3CFK_L, 3CFK_M, 3CFK_O, 3CSY_B, 3CSY_D, 3CSY_F, 3CSY_H, 3D0L_A,
            3D85_A, 3DVG_A, 3DVN_A, 3DVN_L, 3EYF_A, 3EYF_C, 3EYO_A, 3EYO_C,
            3EYQ_C
            xrefs (non-sequence databases): IPI:IPI00979250, UniGene:Hs.449621,
            PDBsum:1A4J, PDBsum:1A4K, PDBsum:1D5B, PDBsum:1D5I, PDBsum:1D6V,
            PDBsum:1HEZ, PDBsum:1HKL, PDBsum:1I7Z, PDBsum:1MIM, PDBsum:1UCB,
            PDBsum:2O5X, PDBsum:2O5Y, PDBsum:2O5Z, PDBsum:2QQK, PDBsum:2QQL,
            PDBsum:2QQN, PDBsum:2QSC, PDBsum:2R56, PDBsum:2VXQ, PDBsum:3B2U,
            PDBsum:3B2V, PDBsum:3BDY, PDBsum:3BE1, PDBsum:3BKY, PDBsum:3BN9,
            PDBsum:3BQU, PDBsum:3C08, PDBsum:3C09, PDBsum:3CFJ, PDBsum:3CFK,
            PDBsum:3CSY, PDBsum:3D0L, PDBsum:3D85, PDBsum:3DVG, PDBsum:3DVN,
            PDBsum:3EYF, PDBsum:3EYO, PDBsum:3EYQ, ProteinModelPortal:P01834,
            SMR:P01834, IntAct:P01834, MINT:MINT-159227, STRING:P01834,
            Cornea-2DPAGE:P01834, UCD-2DPAGE:P01834, PRIDE:P01834,
            Ensembl:ENST00000390237, Ensembl:ENSP00000374777,
            Ensembl:ENSG00000211592, Ensembl:ENST00000429992,
            Ensembl:ENSP00000409413, Ensembl:ENSG00000251039,
            Ensembl:ENST00000448155, Ensembl:ENSP00000406382,
            Ensembl:ENSG00000251546, GeneCards:GC02M089156, H-InvDB:HIX0021121,
            H-InvDB:HIX0161619, H-InvDB:HIX0175869, HGNC:5716, MIM:147200,
            neXtProt:NX_P01834, GeneTree:ENSGT00560000076683,
            HOVERGEN:HBG039526, InParanoid:P01834, OrthoDB:EOG408N9K,
            OrthoDB:EOG412M6X, OrthoDB:EOG4XSKRF, Reactome:REACT_6900,
            ArrayExpress:P01834, Bgee:P01834, CleanEx:HS_IGKC,
            Genevestigator:P01834, GermOnline:ENSG00000163245, GO:0005576,
            GO:0003823, GO:0005515, GO:0006958, GO:0045087, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07654, SMART:SM00407,
            PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Immunoglobulin C region; Immunoglobulin domain;
            Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 106)
  AUTHORS   Gottlieb,P.D., Cunningham,B.A., Rutishauser,U. and Edelman,G.M.
  TITLE     The covalent structure of a human gamma G-immunoglobulin. VI. Amino
            acid sequence of the light chain
  JOURNAL   Biochemistry 9 (16), 3155-3161 (1970)
   PUBMED   5489770
  REMARK    PROTEIN SEQUENCE (MYELOMA PROTEIN EU).
REFERENCE   2  (residues 1 to 106)
  AUTHORS   Gall,W.E. and Edelman,G.M.
  TITLE     The covalent structure of a human gamma G-immunoglobulin. X.
            Intrachain disulfide bonds
  JOURNAL   Biochemistry 9 (16), 3188-3196 (1970)
   PUBMED   4923144
  REMARK    DISULFIDE BONDS.
REFERENCE   3  (residues 1 to 106)
  AUTHORS   Suter,L., Barnikol,H.U., Watanabe,S. and Hilschmann,N.
  TITLE     [Rule of antibody structure. The primary structure of a monoclonal
            immunoglobulin L-chain of kappa-type, subgroup 3 (Bence-Jones
            protein Ti). IV. The complete amino acid sequence and its
            significance for the mechanism of antibody production]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 353 (2), 189-208 (1972)
   PUBMED   5027703
  REMARK    PROTEIN SEQUENCE (BENCE-JONES PROTEIN TI).
REFERENCE   4  (residues 1 to 106)
  AUTHORS   Hieter,P.A., Max,E.E., Seidman,J.G., Maizel,J.V. Jr. and Leder,P.
  TITLE     Cloned human and mouse kappa immunoglobulin constant and J region
            genes conserve homology in functional segments
  JOURNAL   Cell 22 (1 PT 1), 197-207 (1980)
   PUBMED   6775818
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   5  (residues 1 to 106)
  AUTHORS   Hilschmann,N., Barnikol,H.U., Hess,M., Langer,B., Ponstingl,H.,
            Steinmetz-Kayne,M., Suter,L. and Watanabe,S.
  JOURNAL   (in) Franek,F. and Shugar,D. (Eds.);
            GAMMA GLOBULINS: STRUCTURE AND FUNCTION: 57-74;
            Academic Press, New York (1969)
  REMARK    PROTEIN SEQUENCE (BENCE-JONES PROTEIN ROY).
REFERENCE   6  (residues 1 to 106)
  AUTHORS   Hilschmann,N.
  TITLE     [The complete amino acid sequence of Bence Jones protein Cum
            (kappa-type)]
  JOURNAL   Hoppe-Seyler's Z. Physiol. Chem. 348 (12), 1718-1722 (1967)
   PUBMED   5586923
  REMARK    PROTEIN SEQUENCE (BENCE-JONES PROTEIN CUM).
REFERENCE   7  (residues 1 to 106)
  AUTHORS   Titani,K., Shinoda,T. and Putnam,F.W.
  TITLE     The amino acid sequence of a kappa type Bence-Jones protein. 3. The
            complete sequence and the location of the disulfide bridges
  JOURNAL   J. Biol. Chem. 244 (13), 3550-3560 (1969)
   PUBMED   4893682
  REMARK    PROTEIN SEQUENCE (BENCE-JONES PROTEIN AG).
REFERENCE   8  (residues 1 to 106)
  AUTHORS   Kohler,H., Shimizu,A., Paul,C. and Putnam,F.W.
  TITLE     Macroglobulin structure: variable sequence of light and heavy
            chains
  JOURNAL   Science 169 (940), 56-59 (1970)
   PUBMED   5447531
  REMARK    PROTEIN SEQUENCE (WALDENSTROM'S MACROGLOBULIN OU).
REFERENCE   9  (residues 1 to 106)
  AUTHORS   Olsen,K.E., Sletten,K. and Westermark,P.
  TITLE     Extended analysis of AL-amyloid protein from abdominal wall
            subcutaneous fat biopsy: kappa IV immunoglobulin light chain
  JOURNAL   Biochem. Biophys. Res. Commun. 245 (3), 713-716 (1998)
   PUBMED   9588180
  REMARK    PROTEIN SEQUENCE OF 1-33; 38-41 AND 62-80.;
            TISSUE=Abdominal adipose tissue
COMMENT     On Apr 26, 2005 this sequence version replaced gi:69996.
            [MISCELLANEOUS] The EU sequence has the INV (3) allotypic marker,
            Ala-45 and Val-83. The ROY sequence has the INV (1,2) allotypic
            marker, Ala-45 and Leu-83.
            [SIMILARITY] Contains 1 Ig-like (immunoglobulin-like) domain.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+IGKC&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..106
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..106
                     /gene="IGKC"
     Protein         <1..106
                     /gene="IGKC"
                     /product="Ig kappa chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..106
                     /gene="IGKC"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig kappa chain C region. /FTId=PRO_0000153596."
     Region          4..103
                     /gene="IGKC"
                     /region_name="IgC_L"
                     /note="Immunoglobulin Constant domain; cd07699"
                     /db_xref="CDD:143323"
     Region          5..102
                     /gene="IGKC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like."
     Region          6..10
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(8..10,23,25,27,29..30,52..55,66..68,99..100)
                     /gene="IGKC"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143323"
     Region          14..19
                     /gene="IGKC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          14
                     /gene="IGKC"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in Ref. 7; AA sequence and 8; AA
                     sequence)."
     Region          21..34
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            26..86
                     /gene="IGKC"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(32,57..58,63)
                     /gene="IGKC"
                     /site_type="other"
                     /note="intrachain IgV interface"
                     /db_xref="CDD:143323"
     Region          37..42
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          49..55
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          57
                     /gene="IGKC"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> Q (in Ref. 5; AA sequence and 6; AA
                     sequence)."
     Region          60..62
                     /gene="IGKC"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          65..74
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          75..80
                     /gene="IGKC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          83..89
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          83
                     /gene="IGKC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in INV(1,2) marker). /FTId=VAR_003897."
     Region          97..102
                     /gene="IGKC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            106
                     /gene="IGKC"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Interchain (with a heavy chain)."
ORIGIN      
        1 tvaapsvfif ppsdeqlksg tasvvcllnn fypreakvqw kvdnalqsgn sqesvteqds
       61 kdstyslsst ltlskadyek hkvyacevth qglsspvtks fnrgec
//

LOCUS       KV203_HUMAN              112 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig kappa chain V-II region MIL.
ACCESSION   P01616
VERSION     P01616.1  GI:125786
DBSOURCE    UniProtKB: locus KV203_HUMAN, accession P01616;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: K2HUML
            xrefs (non-sequence databases): IPI:IPI00387110,
            ProteinModelPortal:P01616, IntAct:P01616, PeptideAtlas:P01616,
            PRIDE:P01616, HOVERGEN:HBG018013, Reactome:REACT_6900,
            Genevestigator:P01616, GO:0005576, GO:0003823, GO:0005515,
            GO:0006958, GO:0045087, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR013106, InterPro:IPR003596, Gene3D:G3DSA:2.60.40.10,
            Pfam:PF07686, SMART:SM00406, PROSITE:PS50835
KEYWORDS    Bence-Jones protein; Complete proteome; Direct protein sequencing;
            Disulfide bond; Immunoglobulin domain; Immunoglobulin V region;
            Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 112)
  AUTHORS   Dreyer,W.J., Gray,W.R. and Hood,L.E.
  TITLE     The genetic, molecular, and cellular basis of antibody formation:
            some facts and a unifying hypothesis
  JOURNAL   Cold Spring Harb. Symp. Quant. Biol. 32, 353-367 (1967)
  REMARK    PROTEIN SEQUENCE.
COMMENT     On Mar 15, 2005 this sequence version replaced gi:69745.
            [INTERACTION] P22392:NME2; NbExp=1; IntAct=EBI-1053880, EBI-713693.
            [MISCELLANEOUS] The C region of this chain has the INV (3) marker.
            [MISCELLANEOUS] This is a Bence-Jones protein.
FEATURES             Location/Qualifiers
     source          1..112
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..>112
                     /product="Ig kappa chain V-II region MIL"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..>112
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig kappa chain V-II region MIL.
                     /FTId=PRO_0000059760."
     Region          1..110
                     /region_name="V-set"
                     /note="Immunoglobulin V-set domain; pfam07686"
                     /db_xref="CDD:191812"
     Region          1..23
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-1."
     Region          2..110
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Bond            23..92
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          24..38
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-1."
     Region          39..53
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-2."
     Region          54..60
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-2."
     Region          61..92
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-3."
     Region          93..101
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-3."
     Region          102..111
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-4."
ORIGIN      
        1 divltqspls lpvtpgepas iscrssqnll zsbgbyldwy lzkpgzspzl liylgsnras
       61 gvpnrfsgsg sgtbftlkis rvzazbvgvy ycmqalqtpl tfgggtnvei kr
//

LOCUS       KV312_HUMAN              129 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig kappa chain V-III region HAH; Flags: Precursor.
ACCESSION   P18135
VERSION     P18135.1  GI:125817
DBSOURCE    UniProtKB: locus KV312_HUMAN, accession P18135;
            class: standard.
            created: Nov 1, 1990.
            sequence updated: Nov 1, 1990.
            annotation updated: Sep 21, 2011.
            xrefs: C27594, E30607, K3HUHA, 1DH5_L
            xrefs (non-sequence databases): IPI:IPI00030205, UniGene:Hs.449621,
            UniGene:Hs.719895, PDBsum:1DH5, ProteinModelPortal:P18135,
            SMR:P18135, IntAct:P18135, MINT:MINT-202307, STRING:P18135,
            PRIDE:P18135, Ensembl:ENST00000492167, Ensembl:ENSP00000418649,
            Ensembl:ENSG00000239951, HOGENOM:HBG716786, HOVERGEN:HBG018013,
            InParanoid:P18135, Reactome:REACT_6900, Bgee:P18135,
            Genevestigator:P18135, GermOnline:ENSG00000169769, GO:0005576,
            GO:0003823, GO:0006958, GO:0045087, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR013106, InterPro:IPR003596,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07686, SMART:SM00406,
            PROSITE:PS50835
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Immunoglobulin
            domain; Immunoglobulin V region; Reference proteome; Signal.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 129)
  AUTHORS   Kipps,T.J., Tomhave,E., Chen,P.P. and Carson,D.A.
  TITLE     Autoantibody-associated kappa light chain variable region gene
            expressed in chronic lymphocytic leukemia with little or no somatic
            mutation. Implications for etiology and immunotherapy
  JOURNAL   J. Exp. Med. 167 (3), 840-852 (1988)
   PUBMED   3127527
  REMARK    NUCLEOTIDE SEQUENCE [MRNA], AND INVOLVEMENT IN LYMPHOCYTIC
            LEUKEMIA.
COMMENT     On or before Jul 17, 2007 this sequence version replaced gi:87873,
            gi:69750.
            [MISCELLANEOUS] One of the surface immunoglobulin M autoantibodies
            expressed in patients with chronic lymphocytic leukemia.
FEATURES             Location/Qualifiers
     source          1..129
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..>129
                     /product="Ig kappa chain V-III region HAH"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..20
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          21..129
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig kappa chain V-III region HAH.
                     /FTId=PRO_0000015179."
     Region          21..43
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-1."
     Region          22..127
                     /region_name="IgV_L_kappa"
                     /note="Immunoglobulin (Ig) light chain, kappa type,
                     variable (V) domain; cd04980"
                     /db_xref="CDD:143181"
     Region          22..127
                     /region_name="V-set"
                     /note="Immunoglobulin V-set domain; pfam07686"
                     /db_xref="CDD:191812"
     Site            order(32,124,126..127)
                     /site_type="other"
                     /note="intrachain domain interface"
                     /db_xref="CDD:143181"
     Bond            43..109
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          44..55
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-1."
     Site            order(45..47,52)
                     /site_type="other"
                     /note="L1 hypervariable region"
                     /db_xref="CDD:143181"
     Site            order(52..53,70,113)
                     /site_type="other"
                     /note="antigen binding site"
                     /db_xref="CDD:143181"
     Site            order(55,57,59,64,67,71,108)
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143181"
     Region          56..70
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-2."
     Region          71..77
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-2."
     Region          78..109
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Framework-3."
     Site            87..91
                     /site_type="other"
                     /note="L2 hypervariable region"
                     /db_xref="CDD:143181"
     Region          110..118
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Complementarity-determining-3."
     Site            order(112..114,116..118)
                     /site_type="other"
                     /note="L3 hypervariable region"
                     /db_xref="CDD:143181"
     Region          119..129
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="JK1 segment."
ORIGIN      
        1 metpaqllfl lllwlpdttg eivltqspgt lslspgerat lscrasqsvs ssylawyqqk
       61 pgqaprlliy gassratgip drfsgsgsgt dftltisrle pedfavyycq qygtsprtfg
      121 qgtkveikr
//

LOCUS       LV206_HUMAN              111 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Ig lambda chain V-II region MGC.
ACCESSION   P01709
VERSION     P01709.1  GI:126559
DBSOURCE    UniProtKB: locus LV206_HUMAN, accession P01709;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: L2HUMC, 1A8J_H, 1A8J_L, 1DCL_A, 1DCL_B, 2MCG_1, 2MCG_2
            xrefs (non-sequence databases): IPI:IPI00382427, PDBsum:1A8J,
            PDBsum:1DCL, PDBsum:2MCG, ProteinModelPortal:P01709, SMR:P01709,
            STRING:P01709, PRIDE:P01709, HOVERGEN:HBG018013,
            Reactome:REACT_6900, Genevestigator:P01709,
            GermOnline:ENSG00000100208, GO:0005576, GO:0003823, GO:0006958,
            GO:0045087, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR013106, InterPro:IPR003596, Gene3D:G3DSA:2.60.40.10,
            Pfam:PF07686, SMART:SM00406, PROSITE:PS50835
KEYWORDS    3D-structure; Bence-Jones protein; Complete proteome; Direct
            protein sequencing; Disulfide bond; Immunoglobulin domain;
            Immunoglobulin V region; Pyrrolidone carboxylic acid; Reference
            proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 111)
  AUTHORS   Fett,J.W. and Deutsch,H.F.
  TITLE     Primary structure of the Mcg lambda chain
  JOURNAL   Biochemistry 13 (20), 4102-4114 (1974)
   PUBMED   4415202
  REMARK    PROTEIN SEQUENCE.
REFERENCE   2  (residues 1 to 111)
  AUTHORS   Fett,F.W. and Deutsch,H.F.
  TITLE     A new lambda-chain gene
  JOURNAL   Immunochemistry 12 (8), 643-652 (1975)
   PUBMED   812801
  REMARK    LAMBDA CHAIN GENES.
REFERENCE   3  (residues 1 to 111)
  AUTHORS   Edmundson,A.B., Ely,K.R., Abola,E.E., Schiffer,M. and
            Panagiotopoulos,N.
  TITLE     Rotational allomerism and divergent evolution of domains in
            immunoglobulin light chains
  JOURNAL   Biochemistry 14, 3953-3961 (1975)
  REMARK    X-RAY CRYSTALLOGRAPHY (2.3 ANGSTROMS).
REFERENCE   4  (residues 1 to 111)
  AUTHORS   Ely,K.R., Herron,J.N., Harker,M. and Edmundson,A.B.
  TITLE     Three-dimensional structure of a light chain dimer crystallized in
            water. Conformational flexibility of a molecule in two crystal
            forms
  JOURNAL   J. Mol. Biol. 210 (3), 601-615 (1989)
   PUBMED   2515285
  REMARK    X-RAY CRYSTALLOGRAPHY (2.7 ANGSTROMS).
COMMENT     On Mar 15, 2005 this sequence version replaced gi:69835.
            [MISCELLANEOUS] This is a Bence-Jones protein.
            [MISCELLANEOUS] The MCG-type C region appears to be correlated with
            a very unusual V-region substitution, 103-Thr above for Gly,
            suggesting that the V-C joining mechanism is not always random.
            [MISCELLANEOUS] The C region of this chain has the Kern+ and Mcg+
            markers.
            [SIMILARITY] Contains 1 Ig-like (immunoglobulin-like) domain.
FEATURES             Location/Qualifiers
     source          1..111
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..>111
                     /product="Ig lambda chain V-II region MGC"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..>111
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig lambda chain V-II region MGC.
                     /FTId=PRO_0000059835."
     Region          1..109
                     /region_name="V-set"
                     /note="Immunoglobulin V-set domain; pfam07686"
                     /db_xref="CDD:191812"
     Region          1..108
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like."
     Site            1
                     /site_type="pyrrolidone-carboxylic-acid"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          8..12
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          10..109
                     /region_name="IgV_L_lambda"
                     /note="Immunoglobulin (Ig) lambda light chain variable (V)
                     domain; cd04984"
                     /db_xref="CDD:143185"
     Region          18..33
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            22..90
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(24..25,31..32)
                     /site_type="other"
                     /note="L1 hypervariable region"
                     /db_xref="CDD:143185"
     Site            order(31..32,34,36,93..94)
                     /site_type="other"
                     /note="antigen binding site"
                     /db_xref="CDD:143185"
     Region          35..40
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(38,40,87,101)
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143185"
     Region          47..51
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          52..54
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          62..68
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(68..69,72)
                     /site_type="other"
                     /note="L2 hypervariable region"
                     /db_xref="CDD:143185"
     Region          70..79
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          82..84
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          86..92
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(93..94,98..100)
                     /site_type="other"
                     /note="L3 hypervariable region"
                     /db_xref="CDD:143185"
     Region          95..97
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          100..102
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          105..109
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
ORIGIN      
        1 qsaltqppsa sgslgqsvti sctgtssdvg gynyvswyqq hagkapkvii yevnkrpsgv
       61 pdrfsgsksg ntasltvsgl qaedeadyyc ssyegsdnfv fgtgtkvtvl g
//

LOCUS       MGMT_HUMAN               207 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Methylated-DNA--protein-cysteine methyltransferase;
            AltName: Full=6-O-methylguanine-DNA methyltransferase; Short=MGMT;
            AltName: Full=O-6-methylguanine-DNA-alkyltransferase.
ACCESSION   P16455
VERSION     P16455.1  GI:127069
DBSOURCE    UniProtKB: locus MGMT_HUMAN, accession P16455;
            class: standard.
            extra accessions:Q5VY78
            created: Aug 1, 1990.
            sequence updated: Aug 1, 1990.
            annotation updated: Sep 21, 2011.
            xrefs: X54228.1, CAA38137.1, M29971.1, AAA59596.1, M31767.1,
            AAA52317.1, M60761.1, AAA59594.1, BT006714.1, AAP35360.1,
            AL157832.14, CAH70060.1, AL355531.16, CAH72190.1, CH471066.2,
            EAW49166.1, BC000824.1, AAH00824.1, XUHUMC, 1EH6_A, 1EH7_A, 1EH8_A,
            1QNT_A, 1T38_A, 1T39_A, 1T39_B, 1YFH_A, 1YFH_B, 1YFH_C
            xrefs (non-sequence databases): IPI:IPI00028618, UniGene:Hs.501522,
            PDBsum:1EH6, PDBsum:1EH7, PDBsum:1EH8, PDBsum:1QNT, PDBsum:1T38,
            PDBsum:1T39, PDBsum:1YFH, ProteinModelPortal:P16455, SMR:P16455,
            IntAct:P16455, STRING:P16455, PhosphoSite:P16455,
            PeptideAtlas:P16455, PRIDE:P16455, Ensembl:ENST00000306010,
            Ensembl:ENSP00000302111, Ensembl:ENSG00000170430,
            Ensembl:ENST00000440826, Ensembl:ENSP00000404598, UCSC:uc001lkh.1,
            GeneCards:GC10P124842, H-InvDB:HIX0009309, HGNC:7059,
            HPA:CAB002786, MIM:156569, neXtProt:NX_P16455, eggNOG:prNOG10571,
            HOVERGEN:HBG001146, InParanoid:P16455, OrthoDB:EOG4SJ5G1,
            PhylomeDB:P16455, BRENDA:2.1.1.63, Reactome:REACT_216,
            DrugBank:DB00151, NextBio:16779, ArrayExpress:P16455, Bgee:P16455,
            CleanEx:HS_MGMT, Genevestigator:P16455, GermOnline:ENSG00000170430,
            GO:0005654, GO:0003677, GO:0009008, GO:0003908, GO:0006266,
            InterPro:IPR001497, InterPro:IPR014048, InterPro:IPR008332,
            InterPro:IPR011991, Gene3D:G3DSA:1.10.10.10, Pfam:PF01035,
            Pfam:PF02870, SUPFAM:SSF46767, TIGRFAMs:TIGR00589, PROSITE:PS00374
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing; DNA
            damage; DNA repair; DNA-binding; Metal-binding; Methyltransferase;
            Nucleus; Phosphoprotein; Polymorphism; Reference proteome;
            Transferase; Zinc.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 207)
  AUTHORS   Tano,K., Shiota,S., Collier,J., Foote,R.S. and Mitra,S.
  TITLE     Isolation and structural characterization of a cDNA clone encoding
            the human DNA repair protein for O6-alkylguanine
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 87 (2), 686-690 (1990)
   PUBMED   2405387
  REMARK    NUCLEOTIDE SEQUENCE [MRNA], AND PROTEIN SEQUENCE OF 1-8.
            Erratum:[Proc Natl Acad Sci U S A 1990 Apr;87(8):3253]
REFERENCE   2  (residues 1 to 207)
  AUTHORS   Rydberg,B., Spurr,N. and Karran,P.
  TITLE     cDNA cloning and chromosomal assignment of the human
            O6-methylguanine-DNA methyltransferase. cDNA expression in
            Escherichia coli and gene expression in human cells
  JOURNAL   J. Biol. Chem. 265 (16), 9563-9569 (1990)
   PUBMED   2188979
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   3  (residues 1 to 207)
  AUTHORS   Koike,G., Maki,H., Takeya,H., Hayakawa,H. and Sekiguchi,M.
  TITLE     Purification, structure, and biochemical properties of human
            O6-methylguanine-DNA methyltransferase
  JOURNAL   J. Biol. Chem. 265 (25), 14754-14762 (1990)
   PUBMED   2394694
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   4  (residues 1 to 207)
  AUTHORS   Hayakawa,H., Koike,G. and Sekiguchi,M.
  TITLE     Expression and cloning of complementary DNA for a human enzyme that
            repairs O6-methylguanine in DNA
  JOURNAL   J. Mol. Biol. 213 (4), 739-747 (1990)
   PUBMED   2359121
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   5  (residues 1 to 207)
  AUTHORS   Kalnine,N., Chen,X., Rolfs,A., Halleck,A., Hines,L., Eisenstein,S.,
            Koundinya,M., Raphael,J., Moreira,D., Kelley,T., LaBaer,J., Lin,Y.,
            Phelan,M. and Farmer,A.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAY-2003)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
REFERENCE   6  (residues 1 to 207)
  AUTHORS   Deloukas,P., Earthrowl,M.E., Grafham,D.V., Rubenfield,M.,
            French,L., Steward,C.A., Sims,S.K., Jones,M.C., Searle,S.,
            Scott,C., Howe,K., Hunt,S.E., Andrews,T.D., Gilbert,J.G.,
            Swarbreck,D., Ashurst,J.L., Taylor,A., Battles,J., Bird,C.P.,
            Ainscough,R., Almeida,J.P., Ashwell,R.I., Ambrose,K.D.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Bates,K.,
            Beasley,H., Bray-Allen,S., Brown,A.J., Brown,J.Y., Burford,D.C.,
            Burrill,W., Burton,J., Cahill,P., Camire,D., Carter,N.P.,
            Chapman,J.C., Clark,S.Y., Clarke,G., Clee,C.M., Clegg,S., Corby,N.,
            Coulson,A., Dhami,P., Dutta,I., Dunn,M., Faulkner,L., Frankish,A.,
            Frankland,J.A., Garner,P., Garnett,J., Gribble,S., Griffiths,C.,
            Grocock,R., Gustafson,E., Hammond,S., Harley,J.L., Hart,E.,
            Heath,P.D., Ho,T.P., Hopkins,B., Horne,J., Howden,P.J., Huckle,E.,
            Hynds,C., Johnson,C., Johnson,D., Kana,A., Kay,M., Kimberley,A.M.,
            Kershaw,J.K., Kokkinaki,M., Laird,G.K., Lawlor,S., Lee,H.M.,
            Leongamornlert,D.A., Laird,G., Lloyd,C., Lloyd,D.M., Loveland,J.,
            Lovell,J., McLaren,S., McLay,K.E., McMurray,A.,
            Mashreghi-Mohammadi,M., Matthews,L., Milne,S., Nickerson,T.,
            Nguyen,M., Overton-Larty,E., Palmer,S.A., Pearce,A.V., Peck,A.I.,
            Pelan,S., Phillimore,B., Porter,K., Rice,C.M., Rogosin,A.,
            Ross,M.T., Sarafidou,T., Sehra,H.K., Shownkeen,R., Skuce,C.D.,
            Smith,M., Standring,L., Sycamore,N., Tester,J., Thorpe,A.,
            Torcasso,W., Tracey,A., Tromans,A., Tsolas,J., Wall,M., Walsh,J.,
            Wang,H., Weinstock,K., West,A.P., Willey,D.L., Whitehead,S.L.,
            Wilming,L., Wray,P.W., Young,L., Chen,Y., Lovering,R.C.,
            Moschonas,N.K., Siebert,R., Fechtel,K., Bentley,D., Durbin,R.,
            Hubbard,T., Doucette-Stamm,L., Beck,S., Smith,D.R. and Rogers,J.
  TITLE     The DNA sequence and comparative analysis of human chromosome 10
  JOURNAL   Nature 429 (6990), 375-381 (2004)
   PUBMED   15164054
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   7  (residues 1 to 207)
  AUTHORS   Mural,R.J., Istrail,S., Sutton,G.G., Florea,L., Halpern,A.L.,
            Mobarry,C.M., Lippert,R., Walenz,B., Shatkay,H., Dew,I.,
            Miller,J.R., Flanigan,M.J., Edwards,N.J., Bolanos,R., Fasulo,D.,
            Halldorsson,B.V., Hannenhalli,S., Turner,R., Yooseph,S., Lu,F.,
            Nusskern,D.R., Shue,B.C., Zheng,X.H., Zhong,F., Delcher,A.L.,
            Huson,D.H., Kravitz,S.A., Mouchard,L., Reinert,K., Remington,K.A.,
            Clark,A.G., Waterman,M.S., Eichler,E.E., Adams,M.D.,
            Hunkapiller,M.W., Myers,E.W. and Venter,J.C.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-SEP-2005)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   8  (residues 1 to 207)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Placenta
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   9  (residues 1 to 207)
  AUTHORS   von Wronski,M.A., Shiota,S., Tano,K., Mitra,S., Bigner,D.D. and
            Brent,T.P.
  TITLE     Structural and immunological comparison of indigenous human
            O6-methylguanine-DNA methyltransferase with that encoded by a
            cloned cDNA
  JOURNAL   J. Biol. Chem. 266 (2), 1064-1070 (1991)
   PUBMED   1985934
  REMARK    PARTIAL PROTEIN SEQUENCE, AND ALKYL GROUP ACCEPTOR.
REFERENCE   10 (residues 1 to 207)
  AUTHORS   Liem,L.K., Lim,A. and Li,B.F.
  TITLE     Specificities of human, rat and E. coli O6-methylguanine-DNA
            methyltransferases towards the repair of O6-methyl and
            O6-ethylguanine in DNA
  JOURNAL   Nucleic Acids Res. 22 (9), 1613-1619 (1994)
   PUBMED   8202360
  REMARK    CHARACTERIZATION.
REFERENCE   11 (residues 1 to 207)
  AUTHORS   Crone,T.M., Goodtzova,K., Edara,S. and Pegg,A.E.
  TITLE     Mutations in human O6-alkylguanine-DNA alkyltransferase imparting
            resistance to O6-benzylguanine
  JOURNAL   Cancer Res. 54 (23), 6221-6227 (1994)
   PUBMED   7954470
  REMARK    MUTAGENESIS OF PRO-138; PRO-140 AND GLY-156.
REFERENCE   12 (residues 1 to 207)
  AUTHORS   Kanugula,S., Goodtzova,K., Edara,S. and Pegg,A.E.
  TITLE     Alteration of arginine-128 to alanine abolishes the ability of
            human O6-alkylguanine-DNA alkyltransferase to repair methylated DNA
            but has no effect on its reaction with O6-benzylguanine
  JOURNAL   Biochemistry 34 (21), 7113-7119 (1995)
   PUBMED   7766621
  REMARK    MUTAGENESIS OF TYR-114; ARG-128 AND CYS-145.
REFERENCE   13 (residues 1 to 207)
  AUTHORS   Edara,S., Goodtzova,K. and Pegg,A.E.
  TITLE     The role of tyrosine-158 in O6-alkylguanine-DNA alkyltransferase
            activity
  JOURNAL   Carcinogenesis 16 (7), 1637-1642 (1995)
   PUBMED   7614699
  REMARK    MUTAGENESIS OF TYR-158.
REFERENCE   14 (residues 1 to 207)
  AUTHORS   Beausoleil,S.A., Jedrychowski,M., Schwartz,D., Elias,J.E.,
            Villen,J., Li,J., Cohn,M.A., Cantley,L.C. and Gygi,S.P.
  TITLE     Large-scale characterization of HeLa cell nuclear phosphoproteins
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 101 (33), 12130-12135 (2004)
   PUBMED   15302935
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-201, AND MASS
            SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   15 (residues 1 to 207)
  AUTHORS   Imami,K., Sugiyama,N., Kyono,Y., Tomita,M. and Ishihama,Y.
  TITLE     Automated phosphoproteome analysis for cultured cancer cells by
            two-dimensional nanoLC-MS using a calcined titania/C18 biphasic
            column
  JOURNAL   Anal Sci 24 (1), 161-166 (2008)
   PUBMED   18187866
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT THR-10 AND THR-11, AND
            MASS SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   16 (residues 1 to 207)
  AUTHORS   Daniels,D.S., Mol,C.D., Arvai,A.S., Kanugula,S., Pegg,A.E. and
            Tainer,J.A.
  TITLE     Active and alkylated human AGT structures: a novel zinc site,
            inhibitor and extrahelical base binding
  JOURNAL   EMBO J. 19 (7), 1719-1730 (2000)
   PUBMED   10747039
  REMARK    X-RAY CRYSTALLOGRAPHY (2.0 ANGSTROMS) IN COMPLEX WITH DNA AND ZINC
            IONS, AND MUTAGENESIS OF ARG-128 AND CYS-145.
REFERENCE   17 (residues 1 to 207)
  AUTHORS   Wibley,J.E., Pegg,A.E. and Moody,P.C.
  TITLE     Crystal structure of the human O(6)-alkylguanine-DNA
            alkyltransferase
  JOURNAL   Nucleic Acids Res. 28 (2), 393-401 (2000)
   PUBMED   10606635
  REMARK    X-RAY CRYSTALLOGRAPHY (1.9 ANGSTROMS) OF 1-176.
REFERENCE   18 (residues 1 to 207)
  AUTHORS   Duguid,E.M., Rice,P.A. and He,C.
  TITLE     The structure of the human AGT protein bound to DNA and its
            implications for damage detection
  JOURNAL   J. Mol. Biol. 350 (4), 657-666 (2005)
   PUBMED   15964013
  REMARK    X-RAY CRYSTALLOGRAPHY (3.0 ANGSTROMS) OF 1-179 IN COMPLEX WITH DNA
            AND ZINC IONS.
COMMENT     On or before Sep 26, 2008 this sequence version replaced
            gi:74757042, gi:279472.
            [FUNCTION] Involved in the cellular defense against the biological
            effects of O6-methylguanine (O6-MeG) in DNA. Repairs alkylated
            guanine in DNA by stoichiometrically transferring the alkyl group
            at the O-6 position to a cysteine residue in the enzyme. This is a
            suicide reaction: the enzyme is irreversibly inactivated.
            [CATALYTIC ACTIVITY] DNA (containing 6-O-methylguanine) + protein
            L-cysteine = DNA (without 6-O-methylguanine) + protein
            S-methyl-L-cysteine.
            [COFACTOR] Binds 1 zinc ion.
            [SUBCELLULAR LOCATION] Nucleus.
            [MISCELLANEOUS] This enzyme catalyzes only one turnover and
            therefore is not strictly catalytic. According to one definition,
            an enzyme is a biocytalyst that acts repeatedly and over many
            reaction cycles.
            [SIMILARITY] Belongs to the MGMT family.
FEATURES             Location/Qualifiers
     source          1..207
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..207
                     /gene="MGMT"
     Protein         1..207
                     /gene="MGMT"
                     /product="Methylated-DNA--protein-cysteine
                     methyltransferase"
                     /EC_number="2.1.1.63"
                     /note="6-O-methylguanine-DNA methyltransferase;
                     O-6-methylguanine-DNA-alkyltransferase"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..207
                     /gene="MGMT"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Methylated-DNA--protein-cysteine methyltransferase.
                     /FTId=PRO_0000139359."
     Site            5
                     /gene="MGMT"
                     /site_type="metal-binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc."
     Region          6..90
                     /gene="MGMT"
                     /region_name="Methyltransf_1N"
                     /note="6-O-methylguanine DNA methyltransferase,
                     ribonuclease-like domain; pfam02870"
                     /db_xref="CDD:145821"
     Region          8..12
                     /gene="MGMT"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            10
                     /gene="MGMT"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphothreonine."
     Site            11
                     /gene="MGMT"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphothreonine."
     Region          19..24
                     /gene="MGMT"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            24
                     /gene="MGMT"
                     /site_type="metal-binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc."
     Region          27..33
                     /gene="MGMT"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            29
                     /gene="MGMT"
                     /site_type="metal-binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc."
     Region          30
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in dbSNP:rs2020893). /FTId=VAR_014750."
     Region          50..52
                     /gene="MGMT"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          53
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in dbSNP:rs12917). /FTId=VAR_056129."
     Region          57..71
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          58
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> S (in dbSNP:rs2308322). /FTId=VAR_029112."
     Region          65
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> C (in dbSNP:rs2282164). /FTId=VAR_020354."
     Region          73..78
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          84
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in dbSNP:rs12917). /FTId=VAR_014751."
     Site            85
                     /gene="MGMT"
                     /site_type="metal-binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc."
     Region          87..90
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          94..173
                     /gene="MGMT"
                     /region_name="ATase"
                     /note="The DNA repair protein O6-alkylguanine-DNA
                     alkyltransferase (ATase; also known as AGT, AGAT and MGMT)
                     reverses O6-alkylation DNA damage by transferring O6-alkyl
                     adducts to an active site cysteine irreversibly, without
                     inducing DNA strand breaks. ATases...; cd06445"
                     /db_xref="CDD:119438"
     Site            order(94..95,114..115,123,126,128..129,131,134..135,137,
                     145,150,157)
                     /gene="MGMT"
                     /site_type="DNA binding"
                     /note="DNA binding site [nucleotide binding]"
                     /db_xref="CDD:119438"
     Region          94..105
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            95
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA; via amide nitrogen."
     Region          112
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> V (in dbSNP:rs2308321). /FTId=VAR_056130."
     Site            order(114,145..146,148,172)
                     /gene="MGMT"
                     /site_type="active"
                     /db_xref="CDD:119438"
     Region          114..120
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            114
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA."
     Site            114
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y->A: Decreases activity towards methylated DNA
                     over 1000-fold. Slightly reduced reactivity with
                     O6-benzylguanine."
     Site            114
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y->E: Loss of DNA repair activity. Slightly reduced
                     reactivity with O6-benzylguanine."
     Site            115
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA; via amide nitrogen."
     Site            123
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA."
     Region          127..133
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          127
                     /gene="MGMT"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in Ref. 2; AAA52317)."
     Site            128
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA."
     Site            128
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R->A,D: Decreases activity towards methylated DNA
                     over 1000-fold. No effect on reactivity with
                     O6-benzylguanine."
     Site            128
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R->G: Loss of DNA repair activity."
     Site            128
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R->K,L: Slightly reduced DNA repair activity."
     Region          138..140
                     /gene="MGMT"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            138
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P->K: Decreased reactivity with O6-benzylguanine."
     Site            140
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P->A: Decreased reactivity with O6-benzylguanine."
     Region          143
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> V (in dbSNP:rs2308321). /FTId=VAR_014752."
     Region          145..147
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            145
                     /gene="MGMT"
                     /site_type="active"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Nucleophile; methyl group acceptor."
     Site            145
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C->A: Loss of DNA repair activity."
     Site            151
                     /gene="MGMT"
                     /site_type="binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DNA; via amide nitrogen."
     Site            156
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G->A: Decreased reactivity with O6-benzylguanine."
     Site            158
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y->A: Reduced DNA repair activity. Decreased
                     reactivity with O6-benzylguanine."
     Site            158
                     /gene="MGMT"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y->F: Slightly reduced DNA repair activity."
     Region          160
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> R (in dbSNP:rs2308318). /FTId=VAR_014753."
     Region          162..171
                     /gene="MGMT"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          166
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> D (in dbSNP:rs2308320). /FTId=VAR_014754."
     Region          178
                     /gene="MGMT"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="K -> R (in dbSNP:rs2308327). /FTId=VAR_014755."
     Site            201
                     /gene="MGMT"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
ORIGIN      
        1 mdkdcemkrt tldsplgkle lsgceqglhe ikllgkgtsa adavevpapa avlggpeplm
       61 qctawlnayf hqpeaieefp vpalhhpvfq qesftrqvlw kllkvvkfge visyqqlaal
      121 agnpkaarav ggamrgnpvp ilipchrvvc ssgavgnysg glavkewlla heghrlgkpg
      181 lggssglaga wlkgagatsg sppagrn
//

LOCUS       MYCL2_HUMAN              357 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Protein L-Myc-2.
ACCESSION   P12525
VERSION     P12525.1  GI:127602
DBSOURCE    UniProtKB: locus MYCL2_HUMAN, accession P12525;
            class: standard.
            created: Oct 1, 1989.
            sequence updated: Oct 1, 1989.
            annotation updated: Sep 21, 2011.
            xrefs: J03069.1, AAA59883.1, TVHUL2
            xrefs (non-sequence databases): IPI:IPI00409756,
            ProteinModelPortal:P12525, SMR:P12525, PRIDE:P12525,
            GeneCards:GC0XP106515, HGNC:7556, MIM:310310, neXtProt:NX_P12525,
            HOVERGEN:HBG000472, InParanoid:P12525, Genevestigator:P12525,
            GermOnline:ENSG00000204053, GO:0005634, GO:0003677, GO:0003700,
            InterPro:IPR011598, InterPro:IPR001092, InterPro:IPR002418,
            InterPro:IPR012682, Gene3D:G3DSA:4.10.280.10, Pfam:PF00010,
            Pfam:PF01056, PIRSF:PIRSF001705, PRINTS:PR00044, SMART:SM00353,
            SUPFAM:SSF47459, PROSITE:PS50888
KEYWORDS    Complete proteome; DNA-binding; Nucleus; Phosphoprotein; Reference
            proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 357)
  AUTHORS   Morton,C.C., Nussenzweig,M.C., Sousa,R., Sorenson,G.D.,
            Pettengill,O.S. and Shows,T.B.
  TITLE     Mapping and characterization of an X-linked processed gene related
            to MYCL1
  JOURNAL   Genomics 4 (3), 367-375 (1989)
   PUBMED   2541066
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 357)
  AUTHORS   Robertson,N.G., Pomponio,R.J., Mutter,G.L. and Morton,C.C.
  TITLE     Testis-specific expression of the human MYCL2 gene
  JOURNAL   Nucleic Acids Res. 19 (11), 3129-3137 (1991)
   PUBMED   1711681
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 273-354, AND TISSUE
            SPECIFICITY.
COMMENT     On Mar 15, 2005 this sequence version replaced gi:68920.
            [SUBUNIT] Efficient DNA binding requires dimerization with another
            bHLH protein. Binds DNA as an heterodimer with MAX.
            [SUBCELLULAR LOCATION] Nucleus (Potential).
            [TISSUE SPECIFICITY] Detected in adult testis.
            [SIMILARITY] Contains 1 basic helix-loop-helix (bHLH) domain.
FEATURES             Location/Qualifiers
     source          1..357
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..357
                     /gene="MYCL2"
     Protein         1..357
                     /gene="MYCL2"
                     /product="Protein L-Myc-2"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..357
                     /gene="MYCL2"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Protein L-Myc-2. /FTId=PRO_0000127335."
     Region          25..210
                     /gene="MYCL2"
                     /region_name="Myc_N"
                     /note="Myc amino-terminal region; pfam01056"
                     /db_xref="CDD:110083"
     Region          275..331
                     /gene="MYCL2"
                     /region_name="HLH"
                     /note="Helix-loop-helix domain, found in specific DNA-
                     binding proteins that act as transcription factors; 60-100
                     amino acids long. A DNA-binding basic region is followed
                     by two alpha-helices separated by a variable loop region;
                     HLH forms homo- and...; cd00083"
                     /db_xref="CDD:28964"
     Site            order(275..276,282..284,286,309,312)
                     /gene="MYCL2"
                     /site_type="DNA binding"
                     /note="DNA binding region [nucleotide binding]"
                     /db_xref="CDD:28964"
     Site            275..287
                     /gene="MYCL2"
                     /site_type="DNA binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Basic motif."
     Site            283
                     /gene="MYCL2"
                     /site_type="other"
                     /note="E-box/N-box specificity site"
                     /db_xref="CDD:28964"
     Region          288..327
                     /gene="MYCL2"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Helix-loop-helix motif."
     Site            order(289..290,293..294,296..297,313,316,320,322..323,327,
                     329..330)
                     /gene="MYCL2"
                     /site_type="other"
                     /note="dimerization interface [polypeptide binding]"
                     /db_xref="CDD:28964"
     Site            306
                     /gene="MYCL2"
                     /site_type="modified"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Phosphoserine (By similarity)."
ORIGIN      
        1 mdrdsyhhyf ydydggedfy rsttpsediw kkfelvpppw twvrsrepsp qlwspgtwpv
       61 gcagdetesq dywkawdany aslirrdcmw sgfstqeple ravsdllavg apsgyspkef
      121 atpdytpele agnlapifpc llgepkiqac srsespsdse geeidvtvkk rqslstrkpv
      181 iiavradlld prmnlfhisi hqqqhnyaap fppescfqeg apkrmppkea lereapggkd
      241 dkedeeivsl ppveseaaqs cqpkpihydt enwtkkkyhs ylerkrrndq rsrflalrde
      301 vpalascsrv skvmilvkat eylhelaeae ermatekrql ecqrrqlqkr ieylssy
//

LOCUS       PGCA_HUMAN              2415 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Aggrecan core protein; AltName:
            Full=Cartilage-specific proteoglycan core protein; Short=CSPCP;
            AltName: Full=Chondroitin sulfate proteoglycan core protein 1;
            Short=Chondroitin sulfate proteoglycan 1; Contains: RecName:
            Full=Aggrecan core protein 2; Flags: Precursor.
ACCESSION   P16112
VERSION     P16112.2  GI:129886
DBSOURCE    UniProtKB: locus PGCA_HUMAN, accession P16112;
            class: standard.
            extra accessions:Q13650,Q9UCD3,Q9UCP4,Q9UCP5,Q9UDE0
            created: Apr 1, 1990.
            sequence updated: Aug 1, 1992.
            annotation updated: Sep 21, 2011.
            xrefs: M55172.1, AAA62824.1, X80278.1, S74659.1, AAC60643.2,
            X17406.1, CAA35463.1, J05062.1, AAA35726.1, A39086
            xrefs (non-sequence databases): IPI:IPI00793748, IPI:IPI00923424,
            IPI:IPI00923437, UniGene:Hs.2159, UniGene:Hs.616395,
            ProteinModelPortal:P16112, SMR:P16112, STRING:P16112,
            PhosphoSite:P16112, PRIDE:P16112, Ensembl:ENST00000268134,
            Ensembl:ENSP00000268134, Ensembl:ENSG00000157766,
            GeneCards:GC15P065458, HGNC:319, HPA:CAB016377, MIM:155760,
            MIM:165800, MIM:608361, MIM:612813, neXtProt:NX_P16112,
            Orphanet:251262, Orphanet:171866, Orphanet:93283, PharmGKB:PA24616,
            eggNOG:prNOG12958, HOVERGEN:HBG007982, InParanoid:P16112,
            PMAP-CutDB:P16112, ArrayExpress:P16112, Bgee:P16112,
            CleanEx:HS_ACAN, Genevestigator:P16112, GermOnline:ENSG00000157766,
            GO:0005578, GO:0005201, GO:0005540, GO:0005515, GO:0005529,
            GO:0007155, GO:0006508, GO:0001501, InterPro:IPR001304,
            InterPro:IPR016186, InterPro:IPR018378, InterPro:IPR016187,
            InterPro:IPR016060, InterPro:IPR006209, InterPro:IPR006210,
            InterPro:IPR013032, InterPro:IPR000742, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003599,
            InterPro:IPR013106, InterPro:IPR000538, InterPro:IPR000436,
            Gene3D:G3DSA:3.10.100.10, Gene3D:G3DSA:2.10.70.10,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF00008, Pfam:PF00059, Pfam:PF00084,
            Pfam:PF07686, Pfam:PF00193, PRINTS:PR01265, SMART:SM00032,
            SMART:SM00034, SMART:SM00181, SMART:SM00409, SMART:SM00445,
            SUPFAM:SSF56436, SUPFAM:SSF57535, PROSITE:PS00615, PROSITE:PS50041,
            PROSITE:PS00022, PROSITE:PS01186, PROSITE:PS50026, PROSITE:PS50835,
            PROSITE:PS00290, PROSITE:PS01241, PROSITE:PS50963, PROSITE:PS50923
KEYWORDS    Alternative splicing; Complete proteome; Direct protein sequencing;
            Disease mutation; Disulfide bond; Dwarfism; EGF-like domain;
            Extracellular matrix; Glycoprotein; Immunoglobulin domain; Lectin;
            Polymorphism; Proteoglycan; Reference proteome; Repeat; Secreted;
            Signal; Sushi.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 2415)
  AUTHORS   Doege,K.J., Sasaki,M., Kimura,T. and Yamada,Y.
  TITLE     Complete coding sequence and deduced primary structure of the human
            cartilage large aggregating proteoglycan, aggrecan. Human-specific
            repeats, and additional alternatively spliced forms
  JOURNAL   J. Biol. Chem. 266 (2), 894-902 (1991)
   PUBMED   1985970
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORM 3).;
            TISSUE=Chondrocyte
REFERENCE   2  (residues 1 to 2415)
  AUTHORS   Ilic,M.Z., Mok,M.T., Williamson,O.D., Campbell,M.A., Hughes,C.E.
            and Handley,C.J.
  TITLE     Catabolism of aggrecan by explant cultures of human articular
            cartilage in the presence of retinoic acid
  JOURNAL   Arch. Biochem. Biophys. 322 (1), 22-30 (1995)
   PUBMED   7574678
  REMARK    PROTEIN SEQUENCE OF 17-27 AND 393-403, AND PROTEOLYTIC PROCESSING
            BY AGGRECANASE.
REFERENCE   3  (residues 1 to 2415)
  AUTHORS   Sandy,J.D., Flannery,C.R., Neame,P.J. and Lohmander,L.S.
  TITLE     The structure of aggrecan fragments in human synovial fluid.
            Evidence for the involvement in osteoarthritis of a novel
            proteinase which cleaves the Glu 373-Ala 374 bond of the
            interglobular domain
  JOURNAL   J. Clin. Invest. 89 (5), 1512-1516 (1992)
   PUBMED   1569188
  REMARK    PROTEIN SEQUENCE OF 361-373 AND 393-409, PROTEOLYTIC PROCESSING,
            AND GLYCOSYLATION AT THR-371 AND THR-376.
REFERENCE   4  (residues 1 to 2415)
  AUTHORS   Glumoff,V., Savontaus,M., Vehanen,J. and Vuorio,E.
  TITLE     Analysis of aggrecan and tenascin gene expression in mouse skeletal
            tissues by northern and in situ hybridization using species
            specific cDNA probes
  JOURNAL   Biochim. Biophys. Acta 1219 (3), 613-622 (1994)
   PUBMED   7524681
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 380-497, AND TISSUE SPECIFICITY.
REFERENCE   5  (residues 1 to 2415)
  AUTHORS   Lohmander,L.S., Neame,P.J. and Sandy,J.D.
  TITLE     The structure of aggrecan fragments in human synovial fluid.
            Evidence that aggrecanase mediates cartilage degradation in
            inflammatory joint disease, joint injury, and osteoarthritis
  JOURNAL   Arthritis Rheum. 36 (9), 1214-1222 (1993)
   PUBMED   8216415
  REMARK    PROTEIN SEQUENCE OF 393-409.;
            TISSUE=Synovial fluid
REFERENCE   6  (residues 1 to 2415)
  AUTHORS   Barry,F.P., Neame,P.J., Sasse,J. and Pearson,D.
  TITLE     Length variation in the keratan sulfate domain of mammalian
            aggrecan
  JOURNAL   Matrix Biol. 14 (4), 323-328 (1994)
   PUBMED   7827755
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 764-864.;
            TISSUE=Blood
REFERENCE   7  (residues 1 to 2415)
  AUTHORS   Dudhia,J., Davidson,C.M., Wells,T.M., Vynios,D.H., Hardingham,T.E.
            and Bayliss,M.T.
  TITLE     Age-related changes in the content of the C-terminal region of
            aggrecan in human articular cartilage
  JOURNAL   Biochem. J. 313 (PT 3), 933-940 (1996)
   PUBMED   8611178
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 1778-2415 (ISOFORM 2).;
            TISSUE=Chondrocyte
REFERENCE   8  (residues 1 to 2415)
  AUTHORS   Baldwin,C.T., Reginato,A.M. and Prockop,D.J.
  TITLE     A new epidermal growth factor-like domain in the human core protein
            for the large cartilage-specific proteoglycan. Evidence for
            alternative splicing of the domain
  JOURNAL   J. Biol. Chem. 264 (27), 15747-15750 (1989)
   PUBMED   2789216
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 1936-2415 (ISOFORM 1).
REFERENCE   9  (residues 1 to 2415)
  AUTHORS   Gleghorn,L., Ramesar,R., Beighton,P. and Wallis,G.
  TITLE     A mutation in the variable repeat region of the aggrecan gene
            (AGC1) causes a form of spondyloepiphyseal dysplasia associated
            with severe, premature osteoarthritis
  JOURNAL   Am. J. Hum. Genet. 77 (3), 484-490 (2005)
   PUBMED   16080123
  REMARK    INVOLVEMENT IN SEDK.
REFERENCE   10 (residues 1 to 2415)
  AUTHORS   Liu,T., Qian,W.J., Gritsenko,M.A., Camp,D.G. II, Monroe,M.E.,
            Moore,R.J. and Smith,R.D.
  TITLE     Human plasma N-glycoproteome analysis by immunoaffinity
            subtraction, hydrazide chemistry, and mass spectrometry
  JOURNAL   J. Proteome Res. 4 (6), 2070-2080 (2005)
   PUBMED   16335952
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-657, AND MASS
            SPECTROMETRY.;
            TISSUE=Plasma
REFERENCE   11 (residues 1 to 2415)
  AUTHORS   Chen,F.H., Herndon,M.E., Patel,N., Hecht,J.T., Tuan,R.S. and
            Lawler,J.
  TITLE     Interaction of cartilage oligomeric matrix protein/thrombospondin 5
            with aggrecan
  JOURNAL   J. Biol. Chem. 282 (34), 24591-24598 (2007)
   PUBMED   17588949
  REMARK    INTERACTION WITH COMP.
REFERENCE   12 (residues 1 to 2415)
  AUTHORS   Tompson,S.W., Merriman,B., Funari,V.A., Fresquet,M., Lachman,R.S.,
            Rimoin,D.L., Nelson,S.F., Briggs,M.D., Cohn,D.H. and Krakow,D.
  TITLE     A recessive skeletal dysplasia, SEMD aggrecan type, results from a
            missense mutation affecting the C-type lectin domain of aggrecan
  JOURNAL   Am. J. Hum. Genet. 84 (1), 72-79 (2009)
   PUBMED   19110214
  REMARK    VARIANT SEMD-ACAN ASN-2266, AND CHARACTERIZATION OF VARIANT
            SEMD-ACAN ASN-2266.
REFERENCE   13 (residues 1 to 2415)
  AUTHORS   Stattin,E.L., Wiklund,F., Lindblom,K., Onnerfjord,P., Jonsson,B.A.,
            Tegner,Y., Sasaki,T., Struglics,A., Lohmander,S., Dahl,N.,
            Heinegard,D. and Aspberg,A.
  TITLE     A missense mutation in the aggrecan C-type lectin domain disrupts
            extracellular matrix interactions and causes dominant familial
            osteochondritis dissecans
  JOURNAL   Am. J. Hum. Genet. 86 (2), 126-137 (2010)
   PUBMED   20137779
  REMARK    VARIANT OD MET-2303, AND DETECTION OF VARIANT OD MET-2303 BY MASS
            SPECTROMETRY.
COMMENT     On or before Jan 23, 2009 this sequence version replaced
            gi:74720177, gi:74734940, gi:74734941, gi:74734956, gi:25756916.
            [FUNCTION] This proteoglycan is a major component of extracellular
            matrix of cartilagenous tissues. A major function of this protein
            is to resist compression in cartilage. It binds avidly to
            hyaluronic acid via an N-terminal globular region.
            [SUBUNIT] Interacts with FBLN1 (By similarity). Interacts with
            COMP.
            [SUBCELLULAR LOCATION] Secreted, extracellular space, extracellular
            matrix (By similarity).
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=3; Comment=Additional isoforms seem to exist; Name=1;
            IsoId=P16112-1; Sequence=Displayed; Name=2; IsoId=P16112-2;
            Sequence=VSP_003074; Name=3; IsoId=P16112-3; Sequence=VSP_003074,
            VSP_003075.
            [TISSUE SPECIFICITY] Restricted to cartilages.
            [DEVELOPMENTAL STAGE] Expression was detected in chondrocytes
            throughout the developing skeleton.
            [DOMAIN] Two globular domains, G1 and G2, comprise the N-terminus
            of the proteoglycan, while another globular region, G3, makes up
            the C-terminus. G1 contains Link domains and thus consists of three
            disulfide-bonded loop structures designated as the A, B, B' motifs.
            G2 is similar to G1. The keratan sulfate (KS) and the chondroitin
            sulfate (CS) attachment domains lie between G2 and G3.
            [PTM] Contains mostly chondroitin sulfate, but also keratan sulfate
            chains, N-linked and O-linked oligosaccharides. The release of
            aggrecan fragments from articular cartilage into the synovial fluid
            at all stages of human osteoarthritis is the result of cleavage by
            aggrecanase.
            [DISEASE] Defects in ACAN are the cause of spondyloepiphyseal
            dysplasia type Kimberley (SEDK) [MIM:608361]. Spondyloepiphyseal
            dysplasias are a heterogeneous group of congenital
            chondrodysplasias that specifically affect epiphyses and vertebrae.
            The autosomal dominant SEDK is associated with premature
            degenerative arthropathy.
            [DISEASE] Defects in ACAN are the cause of spondyloepimetaphyseal
            dysplasia aggrecan type (SEMD-ACAN) [MIM:612813]. A bone disease
            characterized by severe short stature, macrocephaly, severe midface
            hypoplasia, short neck, barrel chest and brachydactyly. The
            radiological findings comprise long bones with generalized
            irregular epiphyses with widened metaphyses, especially at the
            knees, platyspondyly, and multiple cervical-vertebral clefts.
            [DISEASE] Defects in ACAN are the cause of osteochondritis
            dissecans short stature and early-onset osteoarthritis (OD)
            [MIM:165800]. It is a type of osteochondritis defined as a
            separation of cartilage and subchondral bone from the surrounding
            tissue, primarily affecting the knee, ankle and elbow joints. It is
            clinically characterized by multiple osteochondritic lesions in
            knees and/or hips and/or elbows, disproportionate short stature and
            early-onset osteoarthritis.
            [SIMILARITY] Belongs to the aggrecan/versican proteoglycan family.
            [SIMILARITY] Contains 1 C-type lectin domain.
            [SIMILARITY] Contains 1 EGF-like domain.
            [SIMILARITY] Contains 1 Ig-like V-type (immunoglobulin-like)
            domain.
            [SIMILARITY] Contains 4 Link domains.
            [SIMILARITY] Contains 1 Sushi (CCP/SCR) domain.
            [WEB RESOURCE] Name=Functional Glycomics Gateway - Glycan Binding;
            Note=Aggrecan;
            URL='http://www.functionalglycomics.org/glycomics/GBPServlet?&opera
            tionType=view&cbpId=cbp_hum_Ctlect_351'.
FEATURES             Location/Qualifiers
     source          1..2415
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..2415
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
     Protein         1..2415
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /product="Aggrecan core protein"
                     /note="Cartilage-specific proteoglycan core protein;
                     Chondroitin sulfate proteoglycan core protein 1; CSPCP;
                     Chondroitin sulfate proteoglycan 1"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..16
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          17..2415
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Aggrecan core protein. /FTId=PRO_0000017505."
     Region          30..148
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="V-set"
                     /note="Immunoglobulin V-set domain; pfam07686"
                     /db_xref="CDD:191812"
     Region          34..147
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like V-type."
     Region          43..154
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Ig_Aggrecan"
                     /note="Immunoglobulin (Ig)-like domain of the chondroitin
                     sulfate proteoglycan core protein (CSPG), aggrecan;
                     cd05900"
                     /db_xref="CDD:143308"
     Region          48..141
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G1-A."
     Bond            51..133
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          102
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> E (in dbSNP:rs16942318). /FTId=VAR_056152."
     Site            126
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          152..247
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G1-B."
     Region          153..248
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Link 1."
     Region          153..247
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Link_domain_CSPGs_modules_1_3"
                     /note="Link_domain_CSPGs_modules_1_3; this extracellular
                     link domain is found in the first and third link modules
                     of the chondroitin sulfate proteoglycan core protein
                     (CSPG) aggrecan. In addition, it is found in the first
                     link module of three other CSPGs:...; cd03517"
                     /db_xref="CDD:88305"
     Site            163..164
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="putative hyaluronan binding site [chemical
                     binding]"
                     /db_xref="CDD:88305"
     Bond            175..246
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            199..220
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            239
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          253..349
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G1-B'."
     Region          254..350
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Link 2."
     Region          254..349
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Link_domain_CSPGs_modules_2_4"
                     /note="Link_domain_CSPGs_modules_2_4; this link domain is
                     found in the second and fourth link modules of the
                     chondroitin sulfate proteoglycan core protein (CSPG)
                     aggrecan and, in the second link module of three other
                     CSPGs: versican, neurocan, and brevican...; cd03520"
                     /db_xref="CDD:88308"
     Site            261..262
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="putative hyaluronan binding site [chemical
                     binding]"
                     /db_xref="CDD:88308"
     Bond            273..348
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          275
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> Q (in dbSNP:rs34949187). /FTId=VAR_056153."
     Bond            297..318
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            333
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Site            371
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="O-linked (Xyl...) (keratan sulfate) (Probable)."
     Site            376
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="O-linked (Xyl...) (keratan sulfate) (Probable)."
     Site            387
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Site            392..393
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="cleavage"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Cleavage; by aggrecanase."
     Region          393..2415
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Aggrecan core protein 2. /FTId=PRO_0000017506."
     Site            434
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          477..571
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G2-B."
     Region          478..573
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Link 3."
     Region          478..572
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Link_domain_CSPGs_modules_1_3"
                     /note="Link_domain_CSPGs_modules_1_3; this extracellular
                     link domain is found in the first and third link modules
                     of the chondroitin sulfate proteoglycan core protein
                     (CSPG) aggrecan. In addition, it is found in the first
                     link module of three other CSPGs:...; cd03517"
                     /db_xref="CDD:88305"
     Site            488..489
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="putative hyaluronan binding site [chemical
                     binding]"
                     /db_xref="CDD:88305"
     Bond            500..571
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            524..545
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          578..672
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G2-B'."
     Region          579..674
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Link 4."
     Region          579..673
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Link_domain_CSPGs_modules_2_4"
                     /note="Link_domain_CSPGs_modules_2_4; this link domain is
                     found in the second and fourth link modules of the
                     chondroitin sulfate proteoglycan core protein (CSPG)
                     aggrecan and, in the second link module of three other
                     CSPGs: versican, neurocan, and brevican...; cd03520"
                     /db_xref="CDD:88308"
     Site            586..587
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="putative hyaluronan binding site [chemical
                     binding]"
                     /db_xref="CDD:88308"
     Bond            598..672
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            602
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            621..642
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            657
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          676..848
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="KS."
     Site            737
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          766
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> A (in Ref. 6; AAC60643)."
     Region          772..843
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="12 X 6 AA approximate tandem repeats of
                     E-[GVE]-P-[SFY]-[APT]-[TSP]."
     Region          772..777
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-1."
     Region          778..783
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-2."
     Region          784..789
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-3."
     Region          790..795
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-4."
     Region          796..801
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-5."
     Region          802..807
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-6."
     Region          808..813
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-7; approximate."
     Region          814..819
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-8; approximate."
     Region          820..825
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-9."
     Region          826..831
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-10; approximate."
     Region          832..837
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-11."
     Region          838..843
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="1-12."
     Region          847
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> V (in Ref. 6; AAC60643)."
     Region          851..1497
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CS-1."
     Region          941..1497
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="29 X 19 AA approximate tandem repeats of
                     E-[IVDG]-[LV]-[EV]-[GTI]-[STA]-[ATV]-[SP]-[GA]-[VIFAD]-
                     [GEDL]-[DE]-[LVI]-[SG]-[GERK]-[LV]-P-S-G."
     Region          941..959
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-1."
     Region          960..978
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-2."
     Region          979..997
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-3."
     Region          998..1016
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-4."
     Region          1017..1035
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-5."
     Region          1036..1054
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-6."
     Region          1055..1073
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-7."
     Region          1074..1092
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-8."
     Region          1093..1111
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-9."
     Region          1112..1130
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-10."
     Region          1131..1149
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-11."
     Region          1150..1168
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-12."
     Region          1169..1187
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-13."
     Region          1188..1206
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-14."
     Region          1207..1225
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-15."
     Region          1226..1244
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-16."
     Region          1245..1263
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-17."
     Region          1264..1282
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-18."
     Region          1283..1301
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-19."
     Region          1302..1320
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-20."
     Region          <1318..>1499
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="PRK15387"
                     /note="E3 ubiquitin-protein ligase SspH2; Provisional"
                     /db_xref="CDD:185285"
     Region          1321..1339
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-21."
     Region          1340..1358
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-22."
     Region          1360..1378
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-23."
     Region          1379..1397
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-24."
     Region          1398..1416
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-25."
     Region          1418..1436
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-26."
     Region          1439..1457
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-27; approximate."
     Region          1459..1477
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-28."
     Region          1479..1497
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="2-29."
     Region          1498..2162
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CS-2."
     Site            1898
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          1928
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> A (in Ref. 7; CAA35463)."
     Region          1943
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> L (in dbSNP:rs35061438). /FTId=VAR_056154."
     Region          1964
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> V (in Ref. 7; CAA35463 and 8; AAA35726)."
     Region          2005
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> R (in dbSNP:rs34153007). /FTId=VAR_056155."
     Region          2070
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> A (in Ref. 8; AAA35726)."
     Region          2163..2415
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G3."
     Region          2163..2200
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in isoform 2 and isoform 3).
                     /FTId=VSP_003074."
     Region          2164..2199
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="EGF-like."
     Region          2168..2198
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="EGF_CA"
                     /note="Calcium-binding EGF-like domain, present in a large
                     number of membrane-bound and extracellular (mostly animal)
                     proteins. Many of these proteins require calcium for their
                     biological function and calcium-binding sites have been
                     found to be located at the...; cl09941"
                     /db_xref="CDD:198973"
     Bond            2168..2178
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            2173..2187
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            2189..2198
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          2201..2327
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C-type lectin."
     Region          2205..2328
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="CLECT_CSPGs"
                     /note="C-type lectin-like domain (CTLD) of the type found
                     in chondroitin sulfate proteoglycan core proteins;
                     cd03588"
                     /db_xref="CDD:153058"
     Bond            2205..2216
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(2223,2255..2258,2287,2297,2305,2307,2313,2316,
                     2318..2320)
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="fibronectin type III repeats 3-5 binding site"
                     /db_xref="CDD:153058"
     Bond            2233..2325
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(2266,2270,2293,2299..2300)
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="calcium binding site 1 [ion binding]"
                     /db_xref="CDD:153058"
     Region          2266
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in SEMD-ACAN; creates a functional
                     N-glycosylation site; does not adversely affect protein
                     trafficking and secretion). /FTId=VAR_063053."
     Site            order(2270,2300)
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="calcium binding site 3 [ion binding]"
                     /db_xref="CDD:153058"
     Site            order(2290,2292,2299,2313..2314)
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="carbohydrate binding site"
                     /db_xref="CDD:153058"
     Bond            2301..2317
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          2303
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in OD). /FTId=VAR_063765."
     Region          2330..2390
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in isoform 3). /FTId=VSP_003075."
     Region          2330..2390
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sushi."
     Region          2332..2388
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="CCP"
                     /note="Complement control protein (CCP) modules (aka short
                     consensus repeats SCRs or SUSHI repeats) have been
                     identified in several proteins of the complement system;
                     cd00033"
                     /db_xref="CDD:153056"
     Bond            2332..2375
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(2342,2362)
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /site_type="other"
                     /note="receptor-ligand interactions"
                     /db_xref="CDD:153056"
     Bond            2361..2388
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          2391
                     /gene="ACAN"
                     /gene_synonym="AGC1"
                     /gene_synonym="CSPG1"
                     /gene_synonym="MSK16"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> P (in Ref. 7; CAA35463 and 8; AAA35726)."
ORIGIN      
        1 mttllwvfvt lrvitaavtv etsdhdnsls vsipqpsplr vllgtsltip cyfidpmhpv
       61 ttapstapla prikwsrvsk ekevvllvat egrvrvnsay qdkvslpnyp aipsdatlev
      121 qslrsndsgv yrcevmhgie dseatlevvv kgivfhyrai strytldfdr aqraclqnsa
      181 iiatpeqlqa ayedgfhqcd agwladqtvr ypihtpregc ygdkdefpgv rtygirdtne
      241 tydvycfaee megevfyats pekftfqeaa necrrlgarl attghvylaw qagmdmcsag
      301 wladrsvryp iskarpncgg nllgvrtvyv hanqtgypdp ssrydaicyt gedfvdipen
      361 ffgvggeedi tvqtvtwpdm elplprnite geargsvilt vkpifevsps plepeepftf
      421 apeigatafa evenetgeat rpwgfptpgl gpataftsed lvvqvtavpg qphlpggvvf
      481 hyrpgptrys ltfeeaqqac pgtgaviasp eqlqaayeag yeqcdagwlr dqtvrypivs
      541 prtpcvgdkd sspgvrtygv rpstetydvy cfvdrlegev ffatrleqft fqealefces
      601 hnatattgql yaawsrgldk cyagwladgs lrypivtprp acggdkpgvr tvylypnqtg
      661 lpdplsrhha fcfrgisavp spgeeeggtp tspsgveewi vtqvvpgvaa vpveeettav
      721 psgettaile fttepenqte wepaytpvgt splpgilptw pptgaetees tegpsatevp
      781 saseepspse vpfpseepsp seepfpsvrp fpsvelfpse epfpskepsp seepsaseep
      841 ytpsppepsw telpssgees gapdvsgdft gsgdvsghld fsgqlsgdra sglpsgdlds
      901 sgltstvgsg ltvesglpsg deeriewpst ptvgelpsga eilegsasgv gdlsglpsge
      961 vletsasgvg dlsglpsgev lettapgved isglpsgevl ettapgvedi sglpsgevle
     1021 ttapgvedis glpsgevlet tapgvedisg lpsgevlett apgvedisgl psgevletaa
     1081 pgvedisglp sgevletaap gvedisglps gevletaapg vedisglpsg evletaapgv
     1141 edisglpsge vletaapgve disglpsgev letaapgved isglpsgevl etaapgvedi
     1201 sglpsgevle taapgvedis glpsgevlet aapgvedisg lpsgevleta apgvedisgl
     1261 psgevletaa pgvedisglp sgevlettap gveeisglps gevlettapg vdeisglpsg
     1321 evlettapgv eeisglpsge vletstsavg dlsglpsgge vleisvsgve disglpsgev
     1381 vetsasgied vselpsgegl etsasgvedl srlpsgeevl eisasgfgdl sgvpsggegl
     1441 etsasevgtd lsglpsgreg letsasgaed lsglpsgked lvgsasgdld lgklpsgtlg
     1501 sgqapetsgl psgfsgeysg vdlgsgppsg lpdfsglpsg fptvslvdst lvevvtasta
     1561 selegrgtig isgageisgl psseldisgr asglpsgtel sgqasgspdv sgeipglfgv
     1621 sgqpsgfpdt sgetsgvtel sglssgqpgv sgeasgvlyg tsqpfgitdl sgetsgvpdl
     1681 sgqpsglpgf sgatsgvpdl vsgttsgsge ssgitfvdts lvevapttfk eeeglgsvel
     1741 sglpsgeadl sgksgmvdvs gqfsgtvdss gftsqtpefs glpsgiaevs gessraeigs
     1801 slpsgayygs gtpssfptvs lvdrtlvesv tqaptaqeag egpsgilels gahsgapdms
     1861 gehsgfldls glqsglieps geppgtpyfs gdfasttnvs gessvamgts geasglpevt
     1921 litsefvegv teptisqelg qrppvthtpq lfessgkvst agdisgatpv lpgsgvevss
     1981 vpesssetsa ypeagfgasa apeasredsg spdlsettsa fheanlerss glgvsgstlt
     2041 fqegeasaap evsgesttts dvgteapglp satptasgdr teisgdlsgh tsqlgvvist
     2101 sipesewtqq tqrpaethle iesssllysg eethtvetat sptdasipas pewkresest
     2161 aaaparscae epcgagtcke teghviclcp pgytgehcni dqevceegwn kyqghcyrhf
     2221 pdretwvdae rrcreqqshl ssivtpeeqe fvnnnaqdyq wiglndrtie gdfrwsdghp
     2281 mqfenwrpnq pdnffaaged cvvmiwhekg ewndvpcnyh lpftckkgtv acgeppvveh
     2341 artfgqkkdr yeinslvryq ctegfvqrhm ptircqpsgh weepritctd attykrrlqk
     2401 rssrhprrsr pstah
//

LOCUS       DMA_HUMAN                261 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class II histocompatibility antigen, DM alpha
            chain; AltName: Full=MHC class II antigen DMA; AltName: Full=Really
            interesting new gene 6 protein; Flags: Precursor.
ACCESSION   P28067
VERSION     P28067.1  GI:133158
DBSOURCE    UniProtKB: locus DMA_HUMAN, accession P28067;
            class: standard.
            extra accessions:Q29639,Q29640
            created: Aug 1, 1992.
            sequence updated: Aug 1, 1992.
            annotation updated: Sep 21, 2011.
            xrefs: X62744.1, CAA44606.1, AL935042.6, Z24753.1, U04878.1,
            AAA56994.1, U04877.1, AAA56993.1, I38490, S17886, 1HDM_A, 2BC4_A,
            2BC4_C
            xrefs (non-sequence databases): IPI:IPI00291924, UniGene:Hs.728759,
            PDBsum:1HDM, PDBsum:2BC4, ProteinModelPortal:P28067, SMR:P28067,
            DIP:DIP-6184N, IntAct:P28067, STRING:P28067, PRIDE:P28067,
            Ensembl:ENST00000374843, Ensembl:ENSP00000363976,
            Ensembl:ENSG00000204257, Ensembl:ENST00000383230,
            Ensembl:ENSP00000372717, Ensembl:ENSG00000243215,
            Ensembl:ENST00000434337, Ensembl:ENSP00000407198,
            Ensembl:ENSG00000242361, Ensembl:ENST00000441375,
            Ensembl:ENSP00000410591, Ensembl:ENSG00000239463,
            Ensembl:ENST00000450601, Ensembl:ENSP00000392842,
            Ensembl:ENSG00000242685, Ensembl:ENST00000452615,
            Ensembl:ENSP00000395349, Ensembl:ENSG00000243189,
            Ensembl:ENST00000453490, Ensembl:ENSP00000404018,
            Ensembl:ENSG00000243719, GeneCards:GC06M032658, HGNC:4934,
            HPA:HPA012750, MIM:142855, neXtProt:NX_P28067, HOVERGEN:HBG001688,
            InParanoid:P28067, OrthoDB:EOG49ZXQ0, Reactome:REACT_6900,
            NextBio:12333, CleanEx:HS_HLA-DMA, Genevestigator:P28067,
            GermOnline:ENSG00000204257, GO:0016021, GO:0031902, GO:0005765,
            GO:0042613, GO:0060333, GO:0031295, GO:0050852, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011162, InterPro:IPR014745, InterPro:IPR001003,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.10.320.10, Pfam:PF07654,
            Pfam:PF00993, SMART:SM00407, SMART:SM00920, SUPFAM:SSF54452,
            PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Endosome;
            Glycoprotein; Immunity; Lysosome; Membrane; MHC II; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 261)
  AUTHORS   Kelly,A.P., Monaco,J.J., Cho,S.G. and Trowsdale,J.
  TITLE     A new human HLA class II-related locus, DM
  JOURNAL   Nature 353 (6344), 571-573 (1991)
   PUBMED   1922365
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE DMA*01:01).
REFERENCE   2  (residues 1 to 261)
  AUTHORS   Mungall,A.J., Palmer,S.A., Sims,S.K., Edwards,C.A., Ashurst,J.L.,
            Wilming,L., Jones,M.C., Horton,R., Hunt,S.E., Scott,C.E.,
            Gilbert,J.G., Clamp,M.E., Bethel,G., Milne,S., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Andrews,T.D., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Barker,D.J.,
            Barlow,K.F., Bates,K., Beare,D.M., Beasley,H., Beasley,O.,
            Bird,C.P., Blakey,S., Bray-Allen,S., Brook,J., Brown,A.J.,
            Brown,J.Y., Burford,D.C., Burrill,W., Burton,J., Carder,C.,
            Carter,N.P., Chapman,J.C., Clark,S.Y., Clark,G., Clee,C.M.,
            Clegg,S., Cobley,V., Collier,R.E., Collins,J.E., Colman,L.K.,
            Corby,N.R., Coville,G.J., Culley,K.M., Dhami,P., Davies,J.,
            Dunn,M., Earthrowl,M.E., Ellington,A.E., Evans,K.A., Faulkner,L.,
            Francis,M.D., Frankish,A., Frankland,J., French,L., Garner,P.,
            Garnett,J., Ghori,M.J., Gilby,L.M., Gillson,C.J., Glithero,R.J.,
            Grafham,D.V., Grant,M., Gribble,S., Griffiths,C., Griffiths,M.,
            Hall,R., Halls,K.S., Hammond,S., Harley,J.L., Hart,E.A.,
            Heath,P.D., Heathcott,R., Holmes,S.J., Howden,P.J., Howe,K.L.,
            Howell,G.R., Huckle,E., Humphray,S.J., Humphries,M.D., Hunt,A.R.,
            Johnson,C.M., Joy,A.A., Kay,M., Keenan,S.J., Kimberley,A.M.,
            King,A., Laird,G.K., Langford,C., Lawlor,S., Leongamornlert,D.A.,
            Leversha,M., Lloyd,C.R., Lloyd,D.M., Loveland,J.E., Lovell,J.,
            Martin,S., Mashreghi-Mohammadi,M., Maslen,G.L., Matthews,L.,
            McCann,O.T., McLaren,S.J., McLay,K., McMurray,A., Moore,M.J.,
            Mullikin,J.C., Niblett,D., Nickerson,T., Novik,K.L., Oliver,K.,
            Overton-Larty,E.K., Parker,A., Patel,R., Pearce,A.V., Peck,A.I.,
            Phillimore,B., Phillips,S., Plumb,R.W., Porter,K.M., Ramsey,Y.,
            Ranby,S.A., Rice,C.M., Ross,M.T., Searle,S.M., Sehra,H.K.,
            Sheridan,E., Skuce,C.D., Smith,S., Smith,M., Spraggon,L.,
            Squares,S.L., Steward,C.A., Sycamore,N., Tamlyn-Hall,G., Tester,J.,
            Theaker,A.J., Thomas,D.W., Thorpe,A., Tracey,A., Tromans,A.,
            Tubby,B., Wall,M., Wallis,J.M., West,A.P., White,S.S.,
            Whitehead,S.L., Whittaker,H., Wild,A., Willey,D.J., Wilmer,T.E.,
            Wood,J.M., Wray,P.W., Wyatt,J.C., Young,L., Younger,R.M.,
            Bentley,D.R., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E.,
            Dunham,I., Rogers,J. and Beck,S.
  TITLE     The DNA sequence and analysis of human chromosome 6
  JOURNAL   Nature 425 (6960), 805-811 (2003)
   PUBMED   14574404
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   3  (residues 1 to 261)
  AUTHORS   Sanderson,F., Powis,S.H., Kelly,A.P. and Trowsdale,J.
  TITLE     Limited polymorphism in HLA-DM does not involve the peptide binding
            groove
  JOURNAL   Immunogenetics 39 (1), 56-58 (1994)
   PUBMED   8225438
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 31-218 (ALLELE DMA*01:02).
REFERENCE   4  (residues 1 to 261)
  AUTHORS   Carrington,M. and Harding,A.
  TITLE     Sequence analysis of two novel HLA-DMA alleles
  JOURNAL   Immunogenetics 40 (2), 165 (1994)
   PUBMED   8026867
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 125-217 (ALLELES DMA*01:03 AND
            DMA*01:04).
REFERENCE   5  (residues 1 to 261)
  AUTHORS   Weber,D.A., Evavold,B.D. and Jensen,P.E.
  TITLE     Enhanced dissociation of HLA-DR-bound peptides in the presence of
            HLA-DM
  JOURNAL   Science 274 (5287), 618-620 (1996)
   PUBMED   8849454
  REMARK    FUNCTION.
REFERENCE   6  (residues 1 to 261)
  AUTHORS   Mosyak,L., Zaller,D.M. and Wiley,D.C.
  TITLE     The structure of HLA-DM, the peptide exchange catalyst that loads
            antigen onto class II MHC molecules during antigen presentation
  JOURNAL   Immunity 9 (3), 377-383 (1998)
   PUBMED   9768757
  REMARK    X-RAY CRYSTALLOGRAPHY (2.5 ANGSTROMS) OF 27-230 IN COMPLEX WITH
            DMB, FUNCTION, SUBUNIT, AND DISULFIDE BONDS.
REFERENCE   7  (residues 1 to 261)
  AUTHORS   Nicholson,M.J., Moradi,B., Seth,N.P., Xing,X., Cuny,G.D.,
            Stein,R.L. and Wucherpfennig,K.W.
  TITLE     Small molecules that enhance the catalytic efficiency of HLA-DM
  JOURNAL   J. Immunol. 176 (7), 4208-4220 (2006)
   PUBMED   16547258
  REMARK    X-RAY CRYSTALLOGRAPHY (2.27 ANGSTROMS) OF 27-229 IN COMPLEX WITH
            DMB, FUNCTION, SUBUNIT, AND DISULFIDE BONDS.
COMMENT     On or before Jun 21, 2005 this sequence version replaced
            gi:2135359, gi:107621.
            [FUNCTION] Plays a critical role in catalyzing the release of class
            II-associated invariant chain peptide (CLIP) from newly synthesized
            MHC class II molecules and freeing the peptide binding site for
            acquisition of antigenic peptides. In B cells, the interaction
            between HLA-DM and MHC class II molecules is regulated by HLA-DO.
            [SUBUNIT] Heterodimer of an alpha chain (DMA) and a beta chain
            (DMB).
            [SUBCELLULAR LOCATION] Late endosome membrane; Single-pass type I
            membrane protein. Lysosome membrane; Single-pass type I membrane
            protein. Note=Localizes to late endocytic compartment. Associates
            with lysosome membranes.
            [POLYMORPHISM] The following alleles of DMA are known: DMA*01:01,
            DMA*01:02, DMA*01:03 (DMA3.2) and DMA*01:04 (DMA3.4). The sequence
            shown is that of DMA*01:01.
            [SIMILARITY] Belongs to the MHC class II family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..261
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..261
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
     Protein         1..261
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /product="HLA class II histocompatibility antigen, DM
                     alpha chain"
                     /note="MHC class II antigen DMA; Really interesting new
                     gene 6 protein"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..26
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Region          27..261
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class II histocompatibility antigen, DM alpha
                     chain. /FTId=PRO_0000018958."
     Region          27..233
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Lumenal (Potential)."
     Region          27..124
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          41..123
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="MHC_II_alpha"
                     /note="Class II histocompatibility antigen, alpha domain;
                     cl03058"
                     /db_xref="CDD:198802"
     Region          41..63
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            41
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            50..105
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          66..72
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          73..76
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          77..82
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          83..88
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          98..111
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          117..119
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          121..215
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          125..217
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          126..218
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="IgC_MHC_II_alpha"
                     /note="Class II major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd05767"
                     /db_xref="CDD:143244"
     Region          128..135
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(130,132..134,136,187,189)
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143244"
     Region          143..155
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            147..202
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(154..156,175..178,183..184,189)
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143244"
     Region          157..163
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Q (in allele DMA*01:03 and allele DMA*01:04).
                     /FTId=VAR_016746."
     Region          163
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> H (in allele DMA*01:03 and allele DMA*01:04).
                     /FTId=VAR_016747."
     Region          166
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in allele DMA*01:02 and allele DMA*01:04;
                     dbSNP:rs1063478). /FTId=VAR_016748."
     Region          174..179
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180..182
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          181
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> A (in allele DMA*01:03; dbSNP:rs6926628).
                     /FTId=VAR_016749."
     Region          183..192
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..206
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..210
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          210
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> C (in allele DMA*01:04; dbSNP:rs17214044).
                     /FTId=VAR_016750."
     Region          210
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in allele DMA*01:03; dbSNP:rs41555121).
                     /FTId=VAR_016751."
     Region          211..217
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          218..233
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Region of interest in the sequence"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Connecting peptide (Potential)."
     Region          234..254
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          235
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs9469319). /FTId=VAR_056544."
     Region          255..261
                     /gene="HLA-DMA"
                     /gene_synonym="DMA"
                     /gene_synonym="RING6"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mgheqnqgaa llqmlpllwl lphswavpea ptpmwpddlq nhtflhtvyc qdgspsvgls
       61 eaydedqlff fdfsqntrvp rlpefadwaq eqgdapailf dkefcewmiq qigpkldgki
      121 pvsrgfpiae vftlkplefg kpntlvcfvs nlfppmltvn whdhsvpveg fgptfvsavd
      181 glsfqafsyl nftpepsdif scivtheidr ytaiaywvpr nalpsdllen vlcgvafglg
      241 vlgiivgivl iiyfrkpcsg d
//

LOCUS       TCA_HUMAN                142 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=T-cell receptor alpha chain C region.
ACCESSION   P01848
VERSION     P01848.1  GI:135511
DBSOURCE    UniProtKB: locus TCA_HUMAN, accession P01848;
            class: standard.
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: X02592.1, CAA26435.1, RWHUAC, 1J8H_D, 1KGC_D, 1MI5_D,
            1OGA_D, 1QRN_D, 1YMM_D, 1ZGL_M, 1ZGL_Q, 1ZGL_S, 1ZGL_U, 2AK4_D,
            2AK4_I, 2AK4_N, 2AK4_T, 2BNQ_D, 2BNR_D, 2BNU_A, 2ESV_D, 2EYR_A,
            2EYS_A, 2EYT_A, 2EYT_C, 2F53_D, 2F54_D, 2F54_K, 2GJ6_D, 2IAL_A,
            2IAL_C, 2IAM_C, 2IAN_D, 2IAN_I, 2IAN_N, 2IAN_S, 2NX5_D, 2NX5_I,
            2NX5_N, 2NX5_T, 2P5E_D, 2P5W_D, 2PO6_C, 2PO6_G, 2PYE_D, 2PYF_A,
            2VLJ_D, 2VLK_D, 2VLM_D, 2VLR_D, 2VLR_I, 2XN9_A, 2XNA_A, 3DX9_A,
            3DX9_C, 3DXA_D, 3DXA_I, 3DXA_N, 3FFC_D, 3FFC_I, 3GSN_A, 3HG1_D,
            3KPR_D, 3KPR_I, 3KPS_D, 3KXF_D, 3KXF_G, 3KXF_M, 3KXF_N, 3O6F_C,
            3O6F_G, 3O8X_C, 3O9W_C
            xrefs (non-sequence databases): IPI:IPI00450949, UniGene:Hs.74647,
            PDBsum:1J8H, PDBsum:1KGC, PDBsum:1MI5, PDBsum:1OGA, PDBsum:1QRN,
            PDBsum:1YMM, PDBsum:1ZGL, PDBsum:2AK4, PDBsum:2BNQ, PDBsum:2BNR,
            PDBsum:2BNU, PDBsum:2ESV, PDBsum:2EYR, PDBsum:2EYS, PDBsum:2EYT,
            PDBsum:2F53, PDBsum:2F54, PDBsum:2GJ6, PDBsum:2IAL, PDBsum:2IAM,
            PDBsum:2IAN, PDBsum:2NX5, PDBsum:2P5E, PDBsum:2P5W, PDBsum:2PO6,
            PDBsum:2PYE, PDBsum:2PYF, PDBsum:2VLJ, PDBsum:2VLK, PDBsum:2VLM,
            PDBsum:2VLR, PDBsum:2XN9, PDBsum:2XNA, PDBsum:3DX9, PDBsum:3DXA,
            PDBsum:3FFC, PDBsum:3GSN, PDBsum:3HG1, PDBsum:3KPR, PDBsum:3KPS,
            PDBsum:3KXF, PDBsum:3O6F, PDBsum:3O8X, PDBsum:3O9W,
            ProteinModelPortal:P01848, SMR:P01848, DisProt:DP00093,
            IntAct:P01848, MINT:MINT-249869, STRING:P01848, PRIDE:P01848,
            UCSC:uc001weg.2, GeneCards:GC14P003134, H-InvDB:HIX0018085,
            HGNC:12029, neXtProt:NX_P01848, HOVERGEN:HBG017898,
            InParanoid:P01848, Reactome:REACT_6900, ArrayExpress:P01848,
            Genevestigator:P01848, GermOnline:ENSG00000129563, GO:0005887,
            GO:0042287, GO:0042605, GO:0004872, GO:0006968, GO:0031295,
            GO:0050852, InterPro:IPR015370, InterPro:IPR013783,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF09291
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Membrane; Receptor; Reference proteome; Transmembrane;
            Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 142)
  AUTHORS   Rabbitts,T.H., Lefranc,M.P., Stinson,M.A., Sims,J.E., Schroder,J.,
            Steinmetz,M., Spurr,N.L., Solomon,E. and Goodfellow,P.N.
  TITLE     The chromosomal location of T-cell receptor genes and a T cell
            rearranging gene: possible correlation with specific translocations
            in human T cell leukaemia
  JOURNAL   EMBO J. 4 (6), 1461-1465 (1985)
   PUBMED   3875483
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   2  (residues 1 to 142)
  AUTHORS   Yanagi,Y., Chan,A., Chin,B., Minden,M. and Mak,T.W.
  TITLE     Analysis of cDNA clones specific for human T cells and the alpha
            and beta chains of the T-cell receptor heterodimer from a human
            T-cell line
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 82 (10), 3430-3434 (1985)
   PUBMED   3873654
  REMARK    NUCLEOTIDE SEQUENCE (CLONE PY14).
REFERENCE   3  (residues 1 to 142)
  AUTHORS   Wollscheid,B., Bausch-Fluck,D., Henderson,C., O'Brien,R., Bibel,M.,
            Schiess,R., Aebersold,R. and Watts,J.D.
  TITLE     Mass-spectrometric identification and relative quantification of
            N-linked cell surface glycoproteins
  JOURNAL   Nat. Biotechnol. 27 (4), 378-386 (2009)
   PUBMED   19349973
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-34; ASN-61 AND ASN-68,
            AND MASS SPECTROMETRY.;
            TISSUE=Leukemic T-cell
            Erratum:[Nat Biotechnol. 2009 Sep;27(9):864]
REFERENCE   4  (residues 1 to 142)
  AUTHORS   Kjer-Nielsen,L., Clements,C.S., Brooks,A.G., Purcell,A.W.,
            McCluskey,J. and Rossjohn,J.
  TITLE     The 1.5 A crystal structure of a highly selected antiviral T cell
            receptor provides evidence for a structural basis of
            immunodominance
  JOURNAL   Structure 10 (11), 1521-1532 (2002)
   PUBMED   12429093
  REMARK    X-RAY CRYSTALLOGRAPHY (1.5 ANGSTROMS) OF 1-95.
REFERENCE   5  (residues 1 to 142)
  AUTHORS   Stewart-Jones,G.B., McMichael,A.J., Bell,J.I., Stuart,D.I. and
            Jones,E.Y.
  TITLE     A structural basis for immunodominant human T cell receptor
            recognition
  JOURNAL   Nat. Immunol. 4 (7), 657-663 (2003)
   PUBMED   12796775
  REMARK    X-RAY CRYSTALLOGRAPHY (1.4 ANGSTROMS) OF 1-93 IN COMPLEX WITH
            HLA-A/B2M HETERODIMER AND TRBC1, AND DISULFIDE BOND.
REFERENCE   6  (residues 1 to 142)
  AUTHORS   Li,Y., Huang,Y., Lue,J., Quandt,J.A., Martin,R. and Mariuzza,R.A.
  TITLE     Structure of a human autoimmune TCR bound to a myelin basic protein
            self-peptide and a multiple sclerosis-associated MHC class II
            molecule
  JOURNAL   EMBO J. 24 (17), 2968-2979 (2005)
   PUBMED   16079912
  REMARK    X-RAY CRYSTALLOGRAPHY (2.8 ANGSTROMS) OF 3-96 IN COMPLEX WITH
            HLA-DRA/HLA-DRB5 HETERODIMER AND MBP PEPTIDE.
COMMENT     On Apr 26, 2005 this sequence version replaced gi:2144704.
            [INTERACTION] P01850:TRBC1; NbExp=1; IntAct=EBI-1034847,
            EBI-1034839.
            [SUBCELLULAR LOCATION] Membrane; Single-pass membrane protein
            (Potential).
            [MISCELLANEOUS] This clone was isolated from a human leukemic
            T-cell line, Jurkat.
            [MISCELLANEOUS] This alpha chain C region shows sequence homology
            to its beta chain counterpart.
            [MISCELLANEOUS] The gene corresponding to this mRNA is rearranged
            specifically in T-cells; its organization is similar to an Ig gene,
            with V, D, J, and C regions.
            [SEQUENCE CAUTION] Sequence=CAA26435.1; Type=Erroneous initiation;
            Note=Translation N-terminally shortened.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-
            DB/GENElect?query=2+TRAC&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..142
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..142
                     /gene="TRAC"
                     /gene_synonym="TCRA"
     Protein         <1..142
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /product="T-cell receptor alpha chain C region"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          <1..142
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T-cell receptor alpha chain C region.
                     /FTId=PRO_0000184524."
     Region          1..117
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C region."
     Region          7..82
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="IgC_TCR_alpha"
                     /note="T cell receptor (TCR) alpha chain immunoglobulin
                     domain; cd07688"
                     /db_xref="CDD:143312"
     Site            order(7,11..14,21,23,25,44..46,49..51,60,62,64,66)
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="other"
                     /note="IgC heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143312"
     Region          9..20
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          22..28
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            24..74
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(31,50,59,61)
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="other"
                     /note="intrachain IgV domain interface"
                     /db_xref="CDD:143312"
     Site            34
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          43..45
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          49..53
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          54..56
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          58..68
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            61
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Site            68
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          74..80
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            115
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          118..137
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          138..142
                     /gene="TRAC"
                     /gene_synonym="TCRA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 pniqnpdpav yqlrdskssd ksvclftdfd sqtnvsqskd sdvyitdktv ldmrsmdfks
       61 nsavawsnks dfacanafnn siipedtffp spesscdvkl veksfetdtn lnfqnlsvig
      121 frilllkvag fnllmtlrlw ss
//

LOCUS       TVB1_HUMAN               135 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=T-cell receptor beta chain V region YT35; Flags:
            Precursor.
ACCESSION   P01733
VERSION     P01733.1  GI:136492
DBSOURCE    UniProtKB: locus TVB1_HUMAN, accession P01733;
            class: standard.
            extra accessions:A0A5A7
            created: Jul 21, 1986.
            sequence updated: Jul 21, 1986.
            annotation updated: Sep 21, 2011.
            xrefs: L36092.2, AAC13336.1, U66061.1, M14158.1, AAA60669.1,
            RWHUVY, S03488, S03510
            xrefs (non-sequence databases): IPI:IPI00003986,
            ProteinModelPortal:P01733, SMR:P01733, MINT:MINT-4328927,
            PRIDE:P01733, GeneCards:GC07P141712, H-InvDB:HIX0007159,
            HGNC:12185, eggNOG:maNOG23302, HOVERGEN:HBG100543,
            InParanoid:P01733, Reactome:REACT_6900, Genevestigator:P01733,
            GermOnline:ENSG00000198446, GO:0005886, GO:0042287, GO:0042605,
            GO:0004872, GO:0006955, GO:0031295, GO:0050852, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003599, InterPro:IPR013106,
            Gene3D:G3DSA:2.60.40.10, Pfam:PF07686, SMART:SM00409,
            PROSITE:PS50835
KEYWORDS    Complete proteome; Glycoprotein; Immunoglobulin domain; Receptor;
            Reference proteome; Signal.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 135)
  AUTHORS   Yanagi,Y., Yoshikai,Y., Leggett,K., Clark,S.P., Aleksander,I. and
            Mak,T.W.
  TITLE     A human T cell-specific cDNA clone encodes a protein having
            extensive homology to immunoglobulin chains
  JOURNAL   Nature 308 (5955), 145-149 (1984)
   PUBMED   6336315
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 135)
  AUTHORS   Hillier,L.W., Fulton,R.S., Fulton,L.A., Graves,T.A., Pepin,K.H.,
            Wagner-McPherson,C., Layman,D., Maas,J., Jaeger,S., Walker,R.,
            Wylie,K., Sekhon,M., Becker,M.C., O'Laughlin,M.D., Schaller,M.E.,
            Fewell,G.A., Delehaunty,K.D., Miner,T.L., Nash,W.E., Cordes,M.,
            Du,H., Sun,H., Edwards,J., Bradshaw-Cordum,H., Ali,J., Andrews,S.,
            Isak,A., Vanbrunt,A., Nguyen,C., Du,F., Lamar,B., Courtney,L.,
            Kalicki,J., Ozersky,P., Bielicki,L., Scott,K., Holmes,A.,
            Harkins,R., Harris,A., Strong,C.M., Hou,S., Tomlinson,C.,
            Dauphin-Kohlberg,S., Kozlowicz-Reilly,A., Leonard,S., Rohlfing,T.,
            Rock,S.M., Tin-Wollam,A.M., Abbott,A., Minx,P., Maupin,R.,
            Strowmatt,C., Latreille,P., Miller,N., Johnson,D., Murray,J.,
            Woessner,J.P., Wendl,M.C., Yang,S.P., Schultz,B.R., Wallis,J.W.,
            Spieth,J., Bieri,T.A., Nelson,J.O., Berkowicz,N., Wohldmann,P.E.,
            Cook,L.L., Hickenbotham,M.T., Eldred,J., Williams,D., Bedell,J.A.,
            Mardis,E.R., Clifton,S.W., Chissoe,S.L., Marra,M.A., Raymond,C.,
            Haugen,E., Gillett,W., Zhou,Y., James,R., Phelps,K., Iadanoto,S.,
            Bubb,K., Simms,E., Levy,R., Clendenning,J., Kaul,R., Kent,W.J.,
            Furey,T.S., Baertsch,R.A., Brent,M.R., Keibler,E., Flicek,P.,
            Bork,P., Suyama,M., Bailey,J.A., Portnoy,M.E., Torrents,D.,
            Chinwalla,A.T., Gish,W.R., Eddy,S.R., McPherson,J.D., Olson,M.V.,
            Eichler,E.E., Green,E.D., Waterston,R.H. and Wilson,R.K.
  TITLE     The DNA sequence of human chromosome 7
  JOURNAL   Nature 424 (6945), 157-164 (2003)
   PUBMED   12853948
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   3  (residues 1 to 135)
  AUTHORS   Toyonaga,B., Yoshikai,Y., Vadasz,V., Chin,B. and Mak,T.W.
  TITLE     Organization and sequences of the diversity, joining, and constant
            region genes of the human T-cell receptor beta chain
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 82 (24), 8624-8628 (1985)
   PUBMED   3866244
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 121-135.
REFERENCE   4  (residues 1 to 135)
  AUTHORS   Wollscheid,B., Bausch-Fluck,D., Henderson,C., O'Brien,R., Bibel,M.,
            Schiess,R., Aebersold,R. and Watts,J.D.
  TITLE     Mass-spectrometric identification and relative quantification of
            N-linked cell surface glycoproteins
  JOURNAL   Nat. Biotechnol. 27 (4), 378-386 (2009)
   PUBMED   19349973
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-90, AND MASS
            SPECTROMETRY.;
            TISSUE=Leukemic T-cell
            Erratum:[Nat Biotechnol. 2009 Sep;27(9):864]
COMMENT     On or before Dec 19, 2008 this sequence version replaced
            gi:121949322, gi:88715, gi:88710, gi:69861.
            [WEB RESOURCE] Name=IMGT/GENE-DB;
            URL='http://www.imgt.org/IMGT_GENE-DB/GENElect?query=2+TRBV12-
            3&species=Homo+sapiens'.
FEATURES             Location/Qualifiers
     source          1..135
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..135
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
     Protein         1..>135
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /product="T-cell receptor beta chain V region YT35"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..21
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Region          22..135
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T-cell receptor beta chain V region YT35.
                     /FTId=PRO_0000033597."
     Region          23..134
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /region_name="IgV_TCR_beta"
                     /note="Immunoglobulin (Ig) variable (V) domain of T-cell
                     receptor (TCR) bet a chain; cd05899"
                     /db_xref="CDD:143307"
     Region          23..134
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /region_name="V-set"
                     /note="Immunoglobulin V-set domain; pfam07686"
                     /db_xref="CDD:191812"
     Site            order(30..34,131,133..134)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="intrachain IgC domain interface"
                     /db_xref="CDD:143307"
     Site            order(44..45,48..49)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="L1 hypervariable region"
                     /db_xref="CDD:143307"
     Site            order(54,56,64,67,109,111,126..128)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="IgV heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143307"
     Site            order(69..70,118)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="antigen/MHC binding site"
                     /db_xref="CDD:143307"
     Site            order(88..89,93)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="L2 hypervariable region"
                     /db_xref="CDD:143307"
     Site            90
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          115..119
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="FSTCS -> LATAL (in Ref. 2; AAC13336)."
     Site            order(117..118,123..124)
                     /gene="TRBV12-3"
                     /gene_synonym="TCRBV8S1"
                     /site_type="other"
                     /note="L3 hypervariable region"
                     /db_xref="CDD:143307"
ORIGIN      
        1 mdswtfccvs lcilvakhtd agviqsprhe vtemgqevtl rckpisghns lfwyrqtmmr
       61 glelliyfnn nvpiddsgmp edrfsakmpn asfstlkiqp seprdsavyf cassfstcsa
      121 nygytfgsgt rltvv
//

LOCUS       1A23_HUMAN               365 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, A-23 alpha
            chain; AltName: Full=HLA class I histocompatibility antigen, A-9
            alpha chain; AltName: Full=MHC class I antigen A*23; Flags:
            Precursor.
ACCESSION   P30447
VERSION     P30447.1  GI:231359
DBSOURCE    UniProtKB: locus 1A23_HUMAN, accession P30447;
            class: standard.
            extra accessions:Q9TQF1,Q9TQF8,Q9TQG5,Q9TQM6
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M64742.1, AAA03662.1, AF137080.1, AAD33736.1, AF137079.1,
            AF102572.1, AAD28171.1, AF102571.1, AF135549.1, AAD22272.1,
            AF135548.1, AF140860.1, AAD31878.1, AF140859.1
            xrefs (non-sequence databases): IPI:IPI00472151, UniGene:Hs.181244,
            UniGene:Hs.713441, ProteinModelPortal:P30447, SMR:P30447,
            STRING:P30447, PRIDE:P30447, Ensembl:ENST00000442068,
            Ensembl:ENSP00000404428, Ensembl:ENSG00000223980,
            Ensembl:ENST00000454091, Ensembl:ENSP00000410645,
            GeneCards:GC06P029921, GeneCards:GC06Po29897, HGNC:4931,
            MIM:142800, neXtProt:NX_P30447, HOVERGEN:HBG016709,
            OrthoDB:EOG4T783X, CleanEx:HS_HLA-A, Genevestigator:P30447,
            GermOnline:ENSG00000204632, GO:0016021, GO:0042612, GO:0002474,
            GO:0006955, GO:0044419, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 365)
  AUTHORS   Little,A.M., Madrigal,J.A. and Parham,P.
  TITLE     Molecular definition of an elusive third HLA-A9 molecule: HLA-A9.3
  JOURNAL   Immunogenetics 35 (1), 41-45 (1992)
   PUBMED   1729171
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*23:01).
REFERENCE   2  (residues 1 to 365)
  AUTHORS   Ellis,J., Steiner,N., Kosman,C., Henson,V., Mitton,W., Koester,R.,
            Ng,J., Hartzman,R.J. and Hurley,C.K.
  TITLE     Seventeen more novel HLA-A locus alleles
  JOURNAL   Tissue Antigens 55 (4), 369-373 (2000)
   PUBMED   10852390
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES A*23:02 AND A*23:03).
REFERENCE   3  (residues 1 to 365)
  AUTHORS   Steiner,N.K., Edson,S.M., Mitton,W., Ng,J., Hartzman,R.J. and
            Hurley,C.K.
  TITLE     Seven novel HLA-A alleles carry previously observed polymorphisms
  JOURNAL   Tissue Antigens 56 (6), 551-552 (2000)
   PUBMED   11169246
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES A*23:04 AND A*23:05).
REFERENCE   4  (residues 1 to 365)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
COMMENT     [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of A-23 are known: A*23:01,
            A*23:02, A*23:03, A*23:04 and A*23:05. The sequence shown is that
            of A*23:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..365
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
     Protein         1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /product="HLA class I histocompatibility antigen, A-23
                     alpha chain"
                     /note="HLA class I histocompatibility antigen, A-9 alpha
                     chain; MHC class I antigen A*23"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, A-23 alpha
                     chain. /FTId=PRO_0000018817."
     Region          25..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          31
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> C (in allele A*23:05). /FTId=VAR_016606."
     Site            110
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Bond            125..188
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          151
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="K -> N (in allele A*23:03). /FTId=VAR_016607."
     Region          180
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> W (in allele A*23:02). /FTId=VAR_016608."
     Region          190..191
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DG -> EW (in allele A*23:04). /FTId=VAR_016609."
     Region          205
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in dbSNP:rs17185861). /FTId=VAR_056262."
     Region          207..299
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mavmaprtlv lllsgalalt qtwagshsmr yfstsvsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasqrme prapwieqeg peywdeetgk vkahsqtdre nlrialryyn qseagshtlq
      121 mmfgcdvgsd grflrgyhqy aydgkdyial kedlrswtaa dmaaqitqrk weaarvaeql
      181 raylegtcvd glrrylengk etlqrtdppk thmthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqptvhivg iiaglvllga vitgavvaav mwrrnssdrk ggsysqaass dsaqgsdvsl
      361 tackv
//

LOCUS       1A36_HUMAN               365 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, A-36 alpha
            chain; AltName: Full=Aw-36; AltName: Full=MHC class I antigen A*36;
            Flags: Precursor.
ACCESSION   P30455
VERSION     P30455.1  GI:231370
DBSOURCE    UniProtKB: locus 1A36_HUMAN, accession P30455;
            class: standard.
            extra accessions:Q9MY89
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: X61700.1, CAA43869.1, AF274505.1, AAF78082.1, AF274504.1,
            I37478
            xrefs (non-sequence databases): IPI:IPI00644748, UniGene:Hs.181244,
            UniGene:Hs.713441, ProteinModelPortal:P30455, SMR:P30455,
            IntAct:P30455, STRING:P30455, PRIDE:P30455,
            Ensembl:ENST00000431795, Ensembl:ENSP00000396220,
            Ensembl:ENSG00000229215, Ensembl:ENST00000431930,
            Ensembl:ENSP00000406366, Ensembl:ENST00000443552,
            Ensembl:ENSP00000404678, Ensembl:ENSG00000224320,
            Ensembl:ENST00000448357, Ensembl:ENSP00000402461,
            GeneCards:GC06P029921, GeneCards:GC06Pi29846,
            GeneCards:GC06Pj29898, HGNC:4931, MIM:142800, neXtProt:NX_P30455,
            HOVERGEN:HBG016709, CleanEx:HS_HLA-A, Genevestigator:P30455,
            GO:0005887, GO:0042612, GO:0032393, GO:0005515, GO:0002474,
            GO:0006955, GO:0044419, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 365)
  AUTHORS   Madrigal,J.A., Belich,M.P., Hildebrand,W.H., Benjamin,R.J.,
            Little,A.-M., Zemmour,J., Ennis,P.D., Ward,F.E., Petzl-Erler,M.L.,
            Martell,R.W., du Toit,E.D. and Parham,P.
  TITLE     Distinctive HLA-A,B antigens of black populations formed by
            interallelic conversion
  JOURNAL   J. Immunol. 149 (10), 3411-3415 (1992)
   PUBMED   1431115
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE A*36:01).
REFERENCE   2  (residues 1 to 365)
  AUTHORS   Rizzuto,G.A. and Hurley,C.K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUN-2000)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*36:02).
COMMENT     On Jun 21, 2005 this sequence version replaced gi:2118704.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of A-36 are known: A*36:01 and
            A*36:02. The sequence shown is that of A*36:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..365
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
     Protein         1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /product="HLA class I histocompatibility antigen, A-36
                     alpha chain"
                     /note="Aw-36; MHC class I antigen A*36"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..24
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, A-36 alpha
                     chain. /FTId=PRO_0000018827."
     Region          25..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          89
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> G (in dbSNP:rs1059459). /FTId=VAR_056291."
     Site            110
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Bond            125..188
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          131
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> W (in dbSNP:rs1136702). /FTId=VAR_056292."
     Region          133
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="F -> L (in dbSNP:rs1059488). /FTId=VAR_056293."
     Region          151
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in dbSNP:rs1059509). /FTId=VAR_056294."
     Region          166
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> T (in dbSNP:rs1059516). /FTId=VAR_056295."
     Region          169
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in dbSNP:rs1059520). /FTId=VAR_056296."
     Region          182
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> A (in allele A*36:02). /FTId=VAR_016610."
     Region          185
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> D (in allele A*36:02). /FTId=VAR_016611."
     Region          205
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in dbSNP:rs17185861). /FTId=VAR_056297."
     Region          207..299
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mavmaprtll lllsgalalt qtwagshsmr yfftsvsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasqkme prapwieqeg peywdqetrn mkahsqtdra nlgtlrgyyn qsedgshtiq
      121 imygcdvgpd grflrgyrqd aydgkdyial nedlrswtaa dmaaqitkrk weavhaaeqr
      181 rvylegtcve wlrrylengk etlqrtdppk thmthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwel
      301 ssqptipivg iiaglvllga vitgavvaav mwrrkssdrk ggsytqaass dsaqgsdvsl
      361 tackv
//

LOCUS       1A66_HUMAN               365 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, A-66 alpha
            chain; AltName: Full=Aw-66; AltName: Full=HLA class I
            histocompatibility antigen, A-10 alpha chain; AltName: Full=MHC
            class I antigen A*66; Flags: Precursor.
ACCESSION   P30457
VERSION     P30457.1  GI:231372
DBSOURCE    UniProtKB: locus 1A66_HUMAN, accession P30457;
            class: standard.
            extra accessions:P30458
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: X61711.1, CAA43880.1, X61712.1, CAA43881.1, X51745.1,
            CAA36034.1, U17571.1, AAA56781.1, JL0135
            xrefs (non-sequence databases): IPI:IPI00785070, UniGene:Hs.181244,
            UniGene:Hs.713441, ProteinModelPortal:P30457, SMR:P30457,
            IntAct:P30457, STRING:P30457, PRIDE:P30457,
            Ensembl:ENST00000383605, Ensembl:ENSP00000373100,
            Ensembl:ENSG00000206505, Ensembl:ENST00000383617,
            Ensembl:ENSP00000373112, GeneCards:GC06P029921,
            GeneCards:GC06Pn29898, HGNC:4931, MIM:142800, neXtProt:NX_P30457,
            HOVERGEN:HBG016709, CleanEx:HS_HLA-A, Genevestigator:P30457,
            GermOnline:ENSG00000204632, GO:0016021, GO:0042612, GO:0005515,
            GO:0002474, GO:0006955, GO:0044419, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011161, InterPro:IPR011162, InterPro:IPR001039,
            InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 365)
  AUTHORS   Madrigal,J.A., Belich,M.P., Benjamin,R.J., Little,A.M.,
            Hildebrand,W.H., Mann,D.L. and Parham,P.
  TITLE     Molecular definition of a polymorphic antigen (LA45) of free HLA-A
            and -B heavy chains found on the surfaces of activated B and T
            cells
  JOURNAL   J. Exp. Med. 174 (5), 1085-1095 (1991)
   PUBMED   1940790
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES A*66:01 AND A*66:02).
REFERENCE   2  (residues 1 to 365)
  AUTHORS   Schnabl,E., Stockinger,H., Majdic,O., Gaugitsch,H., Lindley,I.J.,
            Maurer,D., Hajek-Rosenmayr,A. and Knapp,W.
  TITLE     Activated human T lymphocytes express MHC class I heavy chains not
            associated with beta 2-microglobulin
  JOURNAL   J. Exp. Med. 171 (5), 1431-1442 (1990)
   PUBMED   2139695
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE A*66:02).
REFERENCE   3  (residues 1 to 365)
  AUTHORS   Hurley,C.K. and Bei,M.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-NOV-1994)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 1-322 (ALLELE A*66:01).
COMMENT     On or before Jun 21, 2005 this sequence version replaced
            gi:1071961, gi:231373.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of A-66 are known: A*66:01 and
            A*66:02 (Aw67). The sequence shown is that of A*66:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..365
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
     Protein         1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /product="HLA class I histocompatibility antigen, A-66
                     alpha chain"
                     /note="Aw-66; HLA class I histocompatibility antigen, A-10
                     alpha chain; MHC class I antigen A*66"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..24
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, A-66 alpha
                     chain. /FTId=PRO_0000018829."
     Region          25..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          28
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> W (in allele A*66:02). /FTId=VAR_004386."
     Region          89
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> G (in dbSNP:rs1059459). /FTId=VAR_056300."
     Region          101
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in dbSNP:rs1136688). /FTId=VAR_056301."
     Site            110
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> A (in allele A*66:02). /FTId=VAR_004387."
     Region          115..206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Bond            125..188
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          151
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in dbSNP:rs1059509). /FTId=VAR_056302."
     Region          166
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> T (in dbSNP:rs1059516). /FTId=VAR_056303."
     Region          187
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> E (in allele A*66:02; requires 2 nucleotide
                     substitutions). /FTId=VAR_004388."
     Region          207..299
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mavmaprtlv lllsgalalt qtwagshsmr yfytsvsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasqrme prapwieqeg peywdrntrn vkaqsqtdrv dlgtlrgyyn qsedgshtiq
      121 rmygcdvgpd grflrgyqqd aydgkdyial nedlrswtaa dmaaqitqrk wetaheaeqw
      181 raylegrcve wlrrylengk etlqrtdapk thmthhavsd heatlrcwal sfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwas vvvpsgqeqr ytchvqhegl pkpltlrwep
      301 ssqptipivg iiaglvlfga viagavvaav mwrrkssdrk ggsysqaass dsaqgsdmsl
      361 tackv
//

LOCUS       1B08_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-8 alpha
            chain; AltName: Full=MHC class I antigen B*8; Flags: Precursor.
ACCESSION   P30460
VERSION     P30460.1  GI:231381
DBSOURCE    UniProtKB: locus 1B08_HUMAN, accession P30460;
            class: standard.
            extra
            accessions:O62901,O95730,O98140,P79542,Q95369,Q95J00,Q9GJ20,Q9MY78,
            Q9MYF4,Q9TQH6,Q9TQM2,Q9UQT0
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M24036.1, AAA52662.1, AJ295294.2, CAC18876.1, BA000025.2,
            BAB63309.1, U67331.1, AAB07726.1, U67330.1, U74386.1, AAB41720.1,
            AF056483.2, AAC14124.2, AF105226.1, AAD05244.1, AF127248.1,
            AAD31431.1, AF127247.1, AJ131853.1, CAA10522.1, AF102560.1,
            AAD28165.1, AF102559.1, AF226151.1, AAF36681.1, AF226150.1,
            AF279675.1, AAF81604.1, AF279674.1, AF310145.1, AAG27470.1,
            AF310144.1, AY016212.1, AAK38401.1, AY016211.1, AJ133101.1,
            CAB38945.1, AJ133102.1, I84431, 1AGB_A, 1AGC_A, 1AGD_A, 1AGE_A,
            1AGF_A, 1M05_A, 1M05_C, 1MI5_A, 3FFC_A, 3FFC_F
            xrefs (non-sequence databases): IPI:IPI00479242, UniGene:Hs.130838,
            UniGene:Hs.654404, UniGene:Hs.703277, UniGene:Hs.728757,
            UniGene:Hs.77961, PDBsum:1AGB, PDBsum:1AGC, PDBsum:1AGD,
            PDBsum:1AGE, PDBsum:1AGF, PDBsum:1M05, PDBsum:1MI5, PDBsum:3FFC,
            ProteinModelPortal:P30460, SMR:P30460, STRING:P30460, PRIDE:P30460,
            Ensembl:ENST00000425848, Ensembl:ENSP00000400842,
            Ensembl:ENSG00000223532, GeneCards:GC06M031112,
            GeneCards:GC06Mj31312, H-InvDB:HIX0078437, HGNC:4932, MIM:142830,
            neXtProt:NX_P30460, HOVERGEN:HBG016709, InParanoid:P30460,
            OrthoDB:EOG4F4SBG, Reactome:REACT_6900, CleanEx:HS_HLA-B,
            Genevestigator:P30460, GO:0005887, GO:0042612, GO:0032393,
            GO:0002474, GO:0060333, GO:0044419, GO:0050776, GO:0060337,
            InterPro:IPR007110, InterPro:IPR013783, InterPro:IPR003006,
            InterPro:IPR003597, InterPro:IPR011161, InterPro:IPR011162,
            InterPro:IPR001039, InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Parham,P., Lawlor,D.A., Lomen,C.E. and Ennis,P.D.
  TITLE     Diversity and diversification of HLA-A,B,C alleles
  JOURNAL   J. Immunol. 142 (11), 3937-3950 (1989)
   PUBMED   2715640
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*08:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*08:01).;
            TISSUE=Blood
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Shiina,S., Tamiya,G., Oka,A. and Inoko,H.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-SEP-1999)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA] (ALLELE B*08:01).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Hoyer,R.J., Bratlie,A., Schreuder,G.M. and Hurley,C.K.
  TITLE     Characterization of a novel HLA-B allele, B*0804, in a Norwegian
            family
  JOURNAL   Tissue Antigens 50 (3), 308-310 (1997)
   PUBMED   9331954
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*08:04).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Eberle,M., Lorentzen,D., Iwanaga,K.K. and Watkins,D.I.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-OCT-1996)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 33-257 (ALLELE B*08:04).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Marcos,C.Y., Lazaro,A.M., Noreen,H. and Stastny,P.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAY-2010)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*08:07).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Kennedy,C.T., Dodd,R., Le,T., Wallace,R., Ng,G., Greville,W.D.,
            Kennedy,A., Taverniti,A., Moses,J.H., Clow,N., Watson,N. and
            Dunckley,H.
  TITLE     Routine HLA-B genotyping with PCR-sequence-specific
            oligonucleotides (PCR-SSO) detects eight new alleles: B*0807,
            B*0809, B*1551, B*3529, B*3532, B*4025, B*5304 and B*5508
  JOURNAL   Tissue Antigens 55 (3), 266-270 (2000)
   PUBMED   10777103
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELES B*08:07 AND
            B*08:09).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Elsner,H.A. and Blasczyk,R.
  TITLE     Identification of the novel allele HLA-B*0809 in a Caucasian
            individual: estimation of allogeneic potential between B*08
            variants
  JOURNAL   Tissue Antigens 55 (1), 74-77 (2000)
   PUBMED   10703615
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 116-206 (ALLELE B*08:09).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Steiner,N.K., Gans,C.P., Kosman,C., Baldassarre,L.A., Edson,S.,
            Jones,P.F., Rizzuto,G., Pimtanothai,N., Koester,R., Mitton,W.,
            Ng,J., Hartzman,R.J. and Hurley,C.K.
  TITLE     Novel HLA-B alleles associated with antigens in the 8C CREG
  JOURNAL   Tissue Antigens 57 (4), 373-375 (2001)
   PUBMED   11380951
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELES B*08:09;
            B*08:12; B*08:13 AND B*08:14).
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Day,S.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAR-1999)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*08:10).
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Reid,S.W., McAdam,S., Smith,K.J., Klenerman,P., O'Callaghan,C.A.,
            Harlos,K., Jakobsen,B.K., McMichael,A.J., Bell,J.I., Stuart,D.I.
            and Jones,E.Y.
  TITLE     Antagonist HIV-1 Gag peptides induce structural changes in HLA B8
  JOURNAL   J. Exp. Med. 184 (6), 2279-2286 (1996)
   PUBMED   8976183
  REMARK    X-RAY CRYSTALLOGRAPHY (2.2 ANGSTROMS) OF 25-300.
COMMENT     On Apr 12, 2005 this sequence version replaced gi:2118715.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-8 are known: B*08:01,
            B*08:04, B*08:06, B*08:07 (B*NV), B*08:09 (B*HM; B*08HO), B*08:10,
            B*08:12, B*08:13 and B*08:14. The sequence shown is B*08:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-8
                     alpha chain"
                     /note="MHC class I antigen B*8"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          4
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> T (in dbSNP:rs1050458). /FTId=VAR_056321."
     Region          9
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in dbSNP:rs1050462). /FTId=VAR_056322."
     Region          17
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> V (in dbSNP:rs1131165). /FTId=VAR_056323."
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-8 alpha
                     chain. /FTId=PRO_0000018834."
     Region          25..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> A (in dbSNP:rs713031). /FTId=VAR_061392."
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> P (in dbSNP:rs713031). /FTId=VAR_061393."
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> T (in dbSNP:rs713031). /FTId=VAR_061394."
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          65
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1050529). /FTId=VAR_056324."
     Region          70..73
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          74..76
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> D (in allele B*08:10; dbSNP:rs1050570).
                     /FTId=VAR_016502."
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in dbSNP:rs1065386). /FTId=VAR_059474."
     Region          91
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="F -> S (in allele B*08:04). /FTId=VAR_016503."
     Region          97
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in dbSNP:rs1050393). /FTId=VAR_056325."
     Region          98
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> Y (in dbSNP:rs1131215). /FTId=VAR_059475."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> N (in allele B*08:06; dbSNP:rs1050388).
                     /FTId=VAR_016504."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          119
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> W (in allele B*08:09). /FTId=VAR_016505."
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> R (in allele B*08:12). /FTId=VAR_016506."
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> T (in allele B*08:09). /FTId=VAR_016507."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          137..138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HN -> YH (in allele B*08:14). /FTId=VAR_016519."
     Region          137
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Y (in dbSNP:rs1050379). /FTId=VAR_056326."
     Region          138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> D (in allele B*08:07). /FTId=VAR_016508."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> D (in allele B*08:14). /FTId=VAR_016520."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          155
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> S (in dbSNP:rs1050654). /FTId=VAR_056327."
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..174
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> E (in allele B*08:06). /FTId=VAR_016509."
     Region          177..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> L (in allele B*08:13; requires 2 nucleotide
                     substitutions). /FTId=VAR_016510."
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> R (in allele B*08:06; requires 2 nucleotide
                     substitutions). /FTId=VAR_016511."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..217
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          306
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs1131500). /FTId=VAR_056328."
     Region          310..333
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          329
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1051488). /FTId=VAR_056329."
     Region          334..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in dbSNP:rs2308655). /FTId=VAR_061395."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> Y (in dbSNP:rs2308655). /FTId=VAR_061396."
ORIGIN      
        1 mlvmaprtvl lllsaalalt etwagshsmr yfdtamsrpg rgeprfisvg yvddtqfvrf
       61 dsdaaspree prapwieqeg peywdrntqi fktntqtdre slrnlrgyyn qseagshtlq
      121 smygcdvgpd grllrghnqy aydgkdyial nedlrswtaa dtaaqitqrk weaarvaeqd
      181 raylegtcve wlrrylengk dtleradppk thvthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstvpivg ivaglavlav vvigavvaav mcrrkssggk ggsysqaacs dsaqgsdvsl
      361 ta
//

LOCUS       1B13_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-13 alpha
            chain; AltName: Full=MHC class I antigen B*13; Flags: Precursor.
ACCESSION   P30461
VERSION     P30461.1  GI:231382
DBSOURCE    UniProtKB: locus 1B13_HUMAN, accession P30461;
            class: standard.
            extra accessions:O02956,O78180,Q29661,Q29933,Q9GIY5
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M24041.1, AAA59660.1, M19757.1, AAA52657.1, M24075.1,
            AAA59627.1, D50290.1, BAA08821.1, D50291.1, BAA08822.1, U14943.1,
            AAB06829.1, U75533.1, AAC31793.1, AJ295279.1, CAC17137.1, A45850,
            I54442
            xrefs (non-sequence databases): IPI:IPI00472458, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, ProteinModelPortal:P30461,
            SMR:P30461, MINT:MINT-1195012, STRING:P30461, PRIDE:P30461,
            Ensembl:ENST00000435618, Ensembl:ENSP00000405178,
            Ensembl:ENSG00000224608, GeneCards:GC06M031112,
            GeneCards:GC06Ml31364, HGNC:4932, MIM:142830, neXtProt:NX_P30461,
            HOVERGEN:HBG016709, InParanoid:P30461, OrthoDB:EOG4F4SBG,
            Reactome:REACT_6900, CleanEx:HS_HLA-B, Genevestigator:P30461,
            GO:0016021, GO:0042612, GO:0002474, GO:0060333, GO:0044419,
            GO:0050776, GO:0060337, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Parham,P., Lawlor,D.A., Lomen,C.E. and Ennis,P.D.
  TITLE     Diversity and diversification of HLA-A,B,C alleles
  JOURNAL   J. Immunol. 142 (11), 3937-3950 (1989)
   PUBMED   2715640
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*13:02).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Zemmour,J., Ennis,P.D., Parham,P. and Dupont,B.
  TITLE     Comparison of the structure of HLA-Bw47 to HLA-B13 and its
            relationship to 21-hydroxylase deficiency
  JOURNAL   Immunogenetics 27 (4), 281-287 (1988)
   PUBMED   3257938
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*13:02).
            Erratum:[Immunogenetics 1989;29(3):224]
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Kato,K., Dupont,B. and Yang,S.Y.
  TITLE     Localization of nucleotide sequence which determines Mongoloid
            subtype of HLA-B13
  JOURNAL   Immunogenetics 29 (2), 117-120 (1989)
   PUBMED   2914710
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*13:01).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Lin,L., Tokunaga,K., Nakajima,F., Ishikawa,Y., Kashiwase,K.,
            Tanaka,H., Kuwata,S., Sideltseva,E., Akaza,T., Tadokoro,K.,
            Shibata,Y., Chandanayingyong,D. and Juji,T.
  TITLE     Both HLA-B*1301 and B*1302 exist in Asian populations and are
            associated with different haplotypes
  JOURNAL   Hum. Immunol. 43 (1), 51-56 (1995)
   PUBMED   7558929
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES B*13:01 AND B*13:02).;
            TISSUE=Blood
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Balas,A., Garcia-Sanchez,F. and Vicario,J.L.
  TITLE     HLA-B*1303: a new example of poor correlation between serology and
            structure
  JOURNAL   Hum. Immunol. 45 (1), 32-36 (1996)
   PUBMED   8655357
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*13:03).;
            TISSUE=Blood
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Ellexson,M., Lai-Kwan,P., Lau,M., Muto,K., Terasaki,P., Cole,J.,
            Thompson,C. and Hildebrand,W.
  TITLE     Polymorphism at codons 114, 116, 145, and 163 muddle the typing of
            HLA-B*1304
  JOURNAL   Hum. Immunol. 55 (1), 66-73 (1997)
   PUBMED   9328792
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*13:04).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Carter,V. and Dunn,P.P.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-NOV-2000)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*13:08).
COMMENT     On or before Jun 21, 2005 this sequence version replaced gi:321162,
            gi:2118811.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-13 are known: B*13:01
            (B13.1), B*13:02 (B13.2), B*13:04 and B*13:08. The sequence shown
            is that of B*13:02.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-13
                     alpha chain"
                     /note="MHC class I antigen B*13"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-13 alpha
                     chain. /FTId=PRO_0000018835."
     Region          25..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..119
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TW -> II (in allele B*13:01). /FTId=VAR_016357."
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> R (in allele B*13:01). /FTId=VAR_016358."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> D (in allele B*13:04). /FTId=VAR_016360."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> S (in allele B*13:04). /FTId=VAR_016361."
     Region          169
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> R (in allele B*13:03 and allele B*13:04;
                     requires 2 nucleotide substitutions). /FTId=VAR_016362."
     Region          183
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> C (in allele B*13:08). /FTId=VAR_016359."
     Region          187
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> L (in allele B*13:03 and allele B*13:04).
                     /FTId=VAR_016363."
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          306
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs1131500). /FTId=VAR_056330."
     Region          310..333
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          329
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1051488). /FTId=VAR_056331."
     Region          334..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in dbSNP:rs2308655). /FTId=VAR_061397."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> Y (in dbSNP:rs2308655). /FTId=VAR_061398."
ORIGIN      
        1 mrvtaprtll lllwgavalt etwagshsmr yfytamsrpg rgeprfitvg yvddtqfvrf
       61 dsdatsprma prapwieqeg peywdretqi sktntqtyre nlrtalryyn qseagshtwq
      121 tmygcdlgpd grllrghnql aydgkdyial nedlsswtaa dtaaqitqlk weaarvaeql
      181 raylegecve wlrrylengk etlqradppk thvthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstvpivg ivaglavlav vvigavvaav mcrrkssggk ggsysqaacs dsaqgsdvsl
      361 ta
//

LOCUS       1B35_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-35 alpha
            chain; AltName: Full=MHC class I antigen B*35; Flags: Precursor.
ACCESSION   P30685
VERSION     P30685.1  GI:231390
DBSOURCE    UniProtKB: locus 1B35_HUMAN, accession P30685;
            class: standard.
            extra
            accessions:O62919,P30468,P30469,P30470,P30471,P30472,P30473,P30474,
            Q9GJM7,Q9TPV2,Q9TQH3,Q9TQH9,Q9TQN4,Q9TQN6
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M28115.1, AAA59617.1, M28109.1, M28110.1, M28111.1,
            M28112.1, M28113.1, M28114.1, M63454.1, AAA59682.1, M81798.1,
            AAA59684.1, D50299.1, BAA08828.1, M84385.1, AAA59635.1, M84381.1,
            AAA59631.1, L04695.1, AAA59694.1, L04696.1, AAA52674.1, Z22651.1,
            CAA80366.1, M86403.1, AF117771.1, AAD23460.1, AF117770.1,
            AF134867.1, AAD30277.1, AF134866.1, AF061864.1, AAC32570.1,
            AF061863.1, AF108429.1, AAD27538.1, AF108428.1, AF176078.1,
            AAD51745.1, AF176077.1, AF110505.1, AAD26151.1, AF110504.1,
            AF282766.1, AAG01819.1, AF282765.1, A45880, I54298, I56133, I61904,
            I61907, I81233, 1A1N_A, 1A9B_A, 1A9B_D, 1A9E_A, 1CG9_A, 1XH3_A,
            1ZHK_A, 1ZHL_A, 1ZSD_A, 2AK4_A, 2AK4_F, 2AK4_K, 2AK4_Q, 2AXF_A,
            2AXG_A, 2CIK_A, 2FYY_A, 2FZ3_A, 2H6P_A, 2NW3_A, 2NX5_A, 2NX5_F,
            2NX5_K, 2NX5_Q, 3BW9_A, 3BWA_A, 3KWW_A, 3KXF_A, 3KXF_C, 3KXF_I,
            3KXF_K, 3LKN_A, 3LKO_A, 3LKP_A, 3LKQ_A, 3LKR_A, 3LKS_A, 3MV7_A,
            3MV8_A, 3MV9_A
            xrefs (non-sequence databases): IPI:IPI00646083, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1A1N, PDBsum:1A9B,
            PDBsum:1A9E, PDBsum:1CG9, PDBsum:1XH3, PDBsum:1ZHK, PDBsum:1ZHL,
            PDBsum:1ZSD, PDBsum:2AK4, PDBsum:2AXF, PDBsum:2AXG, PDBsum:2CIK,
            PDBsum:2FYY, PDBsum:2FZ3, PDBsum:2H6P, PDBsum:2NW3, PDBsum:2NX5,
            PDBsum:3BW9, PDBsum:3BWA, PDBsum:3KWW, PDBsum:3KXF, PDBsum:3LKN,
            PDBsum:3LKO, PDBsum:3LKP, PDBsum:3LKQ, PDBsum:3LKR, PDBsum:3LKS,
            PDBsum:3MV7, PDBsum:3MV8, PDBsum:3MV9, ProteinModelPortal:P30685,
            SMR:P30685, STRING:P30685, PRIDE:P30685, Ensembl:ENST00000359635,
            Ensembl:ENSP00000352656, Ensembl:ENSG00000206450,
            GeneCards:GC06M031112, GeneCards:GC06Mn31311, H-InvDB:HIX0167180,
            HGNC:4932, MIM:142830, neXtProt:NX_P30685, HOVERGEN:HBG016709,
            InParanoid:P30685, Reactome:REACT_6900, CleanEx:HS_HLA-B,
            Genevestigator:P30685, GO:0016021, GO:0042612, GO:0002474,
            GO:0060333, GO:0044419, GO:0050776, GO:0060337, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011161, InterPro:IPR011162, InterPro:IPR001039,
            InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Ooba,T., Hayashi,H., Karaki,S., Tanabe,M., Kano,K. and Takiguchi,M.
  TITLE     The structure of HLA-B35 suggests that it is derived from HLA-Bw58
            by two genetic mechanisms
  JOURNAL   Immunogenetics 30 (2), 76-80 (1989)
   PUBMED   2788131
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*35:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Chertkoff,L.P., Herrera,M., Fainboim,L. and Satz,M.L.
  TITLE     Complete nucleotide sequence of a genomic clone encoding HLA-B35
            isolated from a Caucasian individual of Hispanic origin.
            Identification of a new variant of HLA-B35
  JOURNAL   Hum. Immunol. 31 (3), 153-158 (1991)
   PUBMED   1890016
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*35:02).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Zemmour,J., Little,A.M., Schendel,D.J. and Parham,P.
  TITLE     The HLA-A,B 'negative' mutant cell line C1R expresses a novel
            HLA-B35 allele, which also has a point mutation in the translation
            initiation codon
  JOURNAL   J. Immunol. 148 (6), 1941-1948 (1992)
   PUBMED   1541831
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*35:03).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Beck,Y., Satz,L., Takamiya,Y., Nakayama,S., Ling,L., Ishikawa,Y.,
            Nagao,T., Uchida,H., Tokunaga,K., Mueller,C., Juji,T. and
            Takiguchi,M.
  TITLE     Polymorphism of human minor histocompatibility antigens: T cell
            recognition of human minor histocompatibility peptides presented by
            HLA-B35 subtype molecules
  JOURNAL   J. Exp. Med. 181 (6), 2037-2048 (1995)
   PUBMED   7759996
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*35:03).;
            TISSUE=Blood
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Belich,M.P., Madrigal,J.A., Hildebrand,W.H., Zemmour,J.,
            Williams,R.C., Luz,R., Petzl-Erler,M.L. and Parham,P.
  TITLE     Unusual HLA-B alleles in two tribes of Brazilian Indians
  JOURNAL   Nature 357 (6376), 326-329 (1992)
   PUBMED   1317015
  REMARK    NUCLEOTIDE SEQUENCE (ALLELES B*35:05 AND B*35:06).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Theiler,G., Pando,M., Delfino,J.M., Takiguchi,M. and Satz,M.L.
  TITLE     Isolation and characterization of two new functional subtypes of
            HLA-B35
  JOURNAL   Tissue Antigens 41 (3), 143-147 (1993)
   PUBMED   8316945
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES B*35:07 AND B*35:08).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Steinle,A., Reinhardt,C., Nossner,E., Uchanska-Ziegler,B.,
            Ziegler,A. and Schendel,D.J.
  TITLE     Microheterogeneity in HLA-B35 alleles influences peptide-dependent
            allorecognition by cytotoxic T cells but not binding of a
            peptide-restricted monoclonal antibody
  JOURNAL   Hum. Immunol. 38 (4), 261-269 (1993)
   PUBMED   8138421
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*35:08).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Watkins,D.I., McAdam,S.N., Liu,X., Stang,C.R., Milford,E.L.,
            Levine,C.G., Garber,T.L., Dogon,A.L., Lord,C.I., Ghim,S.H.,
            Troup,G.M., Hughes,A.L. and Letvin,N.L.
  TITLE     New recombinant HLA-B alleles in a tribe of South American
            Amerindians indicate rapid evolution of MHC class I loci
  JOURNAL   Nature 357 (6376), 329-333 (1992)
   PUBMED   1589035
  REMARK    NUCLEOTIDE SEQUENCE OF 9-362 (ALLELE B*35:04).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Kennedy,C.T., Dodd,R., Le,T., Wallace,R., Ng,G., Greville,W.D.,
            Kennedy,A., Taverniti,A., Moses,J.H., Clow,N., Watson,N. and
            Dunckley,H.
  TITLE     Routine HLA-B genotyping with PCR-sequence-specific
            oligonucleotides (PCR-SSO) detects eight new alleles: B*0807,
            B*0809, B*1551, B*3529, B*3532, B*4025, B*5304 and B*5508
  JOURNAL   Tissue Antigens 55 (3), 266-270 (2000)
   PUBMED   10777103
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELES B*35:29 AND
            B*35:32).
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Steiner,N.K., Kosman,C., Jones,P.F., Gans,C.P.,
            Rodriguez-Marino,S.G., Rizzuto,G., Baldassarre,L.A., Edson,S.,
            Koester,R., Sese,D., Mitton,W., Ng,J., Hartzman,R.J. and
            Hurley,C.K.
  TITLE     Twenty-nine new HLA-B alleles associated with antigens in the 5C
            CREG
  JOURNAL   Tissue Antigens 57 (5), 481-485 (2001)
   PUBMED   11556976
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES B*35:25; B*35:28; B*35:29;
            B*35:30 AND B*35:36).
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Smith,K.J., Reid,S.W., Stuart,D.I., McMichael,A.J., Jones,E.Y. and
            Bell,J.I.
  TITLE     An altered position of the alpha 2 helix of MHC class I is revealed
            by the crystal structure of HLA-B*3501
  JOURNAL   Immunity 4 (3), 203-213 (1996)
   PUBMED   8624811
  REMARK    X-RAY CRYSTALLOGRAPHY (2.0 ANGSTROMS) OF 25-300.
REFERENCE   12 (residues 1 to 362)
  AUTHORS   Menssen,R., Orth,P., Ziegler,A. and Saenger,W.
  TITLE     Decamer-like conformation of a nona-peptide bound to HLA-B*3501 due
            to non-standard positioning of the C terminus
  JOURNAL   J. Mol. Biol. 285 (2), 645-653 (1999)
   PUBMED   9878435
  REMARK    X-RAY CRYSTALLOGRAPHY (2.5 ANGSTROMS).
COMMENT     On or before Apr 26, 2005 this sequence version replaced gi:321163,
            gi:2118848, gi:2118827, gi:2118853, gi:2118852, gi:2118836,
            gi:231391, gi:231392, gi:231393, gi:231394, gi:231395, gi:231396,
            gi:231397.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-35 are known: B*35:01,
            B*35:02, B*35:03, B*35:04, B*35:05 (B35-G), B*35:06 (B35-K),
            B*35:07, B*35:08, B*35:25, B*35:28, B*35:29 (B*KG), B*35:30,
            B*35:32 (B*TMUL) and B*35:36. The sequence shown is that of
            B*35:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-35
                     alpha chain"
                     /note="MHC class I antigen B*35"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-35 alpha
                     chain. /FTId=PRO_0000018840."
     Region          25..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          40
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> V (in allele B*35:07). /FTId=VAR_016393."
     Region          41..43
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> S (in allele B*35:25). /FTId=VAR_016394."
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          69
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> E (in allele B*35:25; requires 2 nucleotide
                     substitutions). /FTId=VAR_016395."
     Region          74..76
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> E (in allele B*35:28; requires 2 nucleotide
                     substitutions). /FTId=VAR_016396."
     Region          91
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="F -> S (in allele B*35:28). /FTId=VAR_016397."
     Region          98
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> D (in allele B*35:29). /FTId=VAR_016398."
     Region          107
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> D (in allele B*35:36). /FTId=VAR_016399."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          118..119
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="II -> TL (in allele B*35:05 and allele B*35:32).
                     /FTId=VAR_016400."
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> S (in allele B*35:05 and allele B*35:30).
                     /FTId=VAR_016401."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> V (in allele B*35:32). /FTId=VAR_016402."
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          133
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in allele B*35:02). /FTId=VAR_016403."
     Region          138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in allele B*35:02, allele B*35:04 and
                     allele B*35:06). /FTId=VAR_016404."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> F (in allele B*35:06 and allele B*35:36).
                     /FTId=VAR_016405."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> Y (in allele B*35:02, allele B*35:03 and
                     allele B*35:04). /FTId=VAR_016406."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> R (in allele B*35:08). /FTId=VAR_016407."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..217
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvtaprtvl lllwgavalt etwagshsmr yfytamsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasprte prapwieqeg peywdrntqi fktntqtyre slrnlrgyyn qseagshiiq
      121 rmygcdlgpd grllrghdqs aydgkdyial nedlsswtaa dtaaqitqrk weaarvaeql
      181 rayleglcve wlrrylengk etlqradppk thvthhpvsd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstipivg ivaglavlav vvigavvatv mcrrkssggk ggsysqaass dsaqgsdvsl
      361 ta
//

LOCUS       1B42_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-42 alpha
            chain; AltName: Full=MHC class I antigen B*42; Flags: Precursor.
ACCESSION   P30480
VERSION     P30480.1  GI:231403
DBSOURCE    UniProtKB: locus 1B42_HUMAN, accession P30480;
            class: standard.
            extra accessions:P79555
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M24034.1, AAA59667.1, U88407.1, AAC16437.1, AJ309194.1,
            CAC38393.1, I61865
            xrefs (non-sequence databases): IPI:IPI00472676, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, ProteinModelPortal:P30480,
            SMR:P30480, IntAct:P30480, STRING:P30480, PRIDE:P30480,
            Ensembl:ENST00000412585, Ensembl:ENSP00000399168,
            Ensembl:ENSG00000234745, GeneCards:GC06M031112, HGNC:4932,
            HPA:CAB015418, MIM:142830, neXtProt:NX_P30480, HOVERGEN:HBG016709,
            Reactome:REACT_6900, CleanEx:HS_HLA-B, Genevestigator:P30480,
            GermOnline:ENSG00000204523, GO:0016021, GO:0042612, GO:0005515,
            GO:0002474, GO:0060333, GO:0044419, GO:0050776, GO:0060337,
            InterPro:IPR007110, InterPro:IPR013783, InterPro:IPR003006,
            InterPro:IPR003597, InterPro:IPR011161, InterPro:IPR011162,
            InterPro:IPR001039, InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Parham,P., Lawlor,D.A., Lomen,C.E. and Ennis,P.D.
  TITLE     Diversity and diversification of HLA-A,B,C alleles
  JOURNAL   J. Immunol. 142 (11), 3937-3950 (1989)
   PUBMED   2715640
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*42:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Lardy,N.M., Otting,N., van de Weerd,M.J., van de Horst,A.R.,
            Waal,L.P. and Bontrop,R.E.
  TITLE     Full-length cDNA nucleotide sequence of the HLA-B*4202 allele
  JOURNAL   Tissue Antigens 50 (1), 83-84 (1997)
   PUBMED   9243763
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*42:02).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*42:01).;
            TISSUE=Blood
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
COMMENT     On Jun 21, 2005 this sequence version replaced gi:2118822.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-42 are known: B*42:01
            (Bw-42) and B*42:02. The sequence shown is that of B*42:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-42
                     alpha chain"
                     /note="MHC class I antigen B*42"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          4
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> T (in dbSNP:rs1050458). /FTId=VAR_056372."
     Region          9
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in dbSNP:rs1050462). /FTId=VAR_056373."
     Region          17
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> V (in dbSNP:rs1131165). /FTId=VAR_056374."
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-42 alpha
                     chain. /FTId=PRO_0000018846."
     Region          25..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          33
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> H (in allele B*42:02). /FTId=VAR_016460."
     Region          35
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> A (in dbSNP:rs1131170). /FTId=VAR_056375."
     Region          36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs1050486). /FTId=VAR_056376."
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> A (in dbSNP:rs713031). /FTId=VAR_061417."
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> P (in dbSNP:rs713031). /FTId=VAR_061418."
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> T (in dbSNP:rs713031). /FTId=VAR_061419."
     Region          65
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1050529). /FTId=VAR_056377."
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> D (in dbSNP:rs1050570). /FTId=VAR_056378."
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in dbSNP:rs1065386). /FTId=VAR_059480."
     Region          97
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in dbSNP:rs1050393). /FTId=VAR_056379."
     Region          98
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> Y (in dbSNP:rs1131215). /FTId=VAR_059481."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> N (in dbSNP:rs1050388). /FTId=VAR_056380."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          137
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Y (in dbSNP:rs1050379). /FTId=VAR_056381."
     Region          155
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> S (in dbSNP:rs1050654). /FTId=VAR_056382."
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          306
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs1131500). /FTId=VAR_056383."
     Region          310..333
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          329
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1051488). /FTId=VAR_056384."
     Region          334..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in dbSNP:rs2308655). /FTId=VAR_061420."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> Y (in dbSNP:rs2308655). /FTId=VAR_061421."
ORIGIN      
        1 mlvmaprtvl lllsaalalt etwagshsmr yfytsvsrpg rgeprfisvg yvddtqfvrf
       61 dsdaaspree prapwieqeg peywdrntqi ykaqaqtdre slrnlrgyyn qseagshtlq
      121 smygcdvgpd grllrghnqy aydgkdyial nedlrswtaa dtaaqitqrk weaarvaeqd
      181 raylegtcve wlrrylengk dtleradppk thvthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstvpivg ivaglavlav vvigavvaav mcrrkssggk ggsysqaacs dsaqgsdvsl
      361 ta
//

LOCUS       1B44_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-44 alpha
            chain; AltName: Full=Bw-44; AltName: Full=MHC class I antigen B*44;
            Flags: Precursor.
ACCESSION   P30481
VERSION     P30481.1  GI:231404
DBSOURCE    UniProtKB: locus 1B44_HUMAN, accession P30481;
            class: standard.
            extra
            accessions:P10320,P30482,P79524,Q29850,Q5RIP1,Q860I4,Q861B5,Q9BCM7,
            Q9MYC3,Q9UQS8
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M24038.1, AAA59663.1, X64366.1, CAA45718.1, L42282.1,
            AAB51454.1, L42283.1, AAB51455.1, X90391.1, CAA62036.1, U64801.1,
            AAB40632.1, AJ133267.2, CAB38071.2, AJ131118.1, CAB37868.1,
            AJ309936.1, CAC33891.1, AJ309937.1, CAC33892.1, AJ535113.1,
            CAD59381.1, AJ550735.1, CAD79566.1, BX248310.3, CAI18717.1,
            M15470.1, AAA59619.1, HLHUB4, I61861, S25415, 1M6O_A, 1SYS_A,
            1SYV_A, 3DX6_A, 3DX7_A, 3DX8_A, 3DXA_A, 3DXA_F, 3DXA_K, 3KPL_A,
            3KPM_A, 3KPN_A, 3KPO_A, 3KPP_A, 3KPQ_A, 3KPR_A, 3KPR_F, 3KPS_A,
            3L3D_A, 3L3G_A, 3L3I_A, 3L3J_A, 3L3K_A
            xrefs (non-sequence databases): IPI:IPI00743117, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1M6O, PDBsum:1SYS,
            PDBsum:1SYV, PDBsum:3DX6, PDBsum:3DX7, PDBsum:3DX8, PDBsum:3DXA,
            PDBsum:3KPL, PDBsum:3KPM, PDBsum:3KPN, PDBsum:3KPO, PDBsum:3KPP,
            PDBsum:3KPQ, PDBsum:3KPR, PDBsum:3KPS, PDBsum:3L3D, PDBsum:3L3G,
            PDBsum:3L3I, PDBsum:3L3J, PDBsum:3L3K, ProteinModelPortal:P30481,
            SMR:P30481, STRING:P30481, PRIDE:P30481, Ensembl:ENST00000421349,
            Ensembl:ENSP00000405365, Ensembl:ENSG00000228964,
            GeneCards:GC06M031112, H-InvDB:HIX0167415, HGNC:4932, MIM:142830,
            neXtProt:NX_P30481, HOVERGEN:HBG016709, InParanoid:P30481,
            OrthoDB:EOG4F4SBG, Reactome:REACT_6900, CleanEx:HS_HLA-B,
            Genevestigator:P30481, GO:0016021, GO:0042612, GO:0002474,
            GO:0060333, GO:0044419, GO:0050776, GO:0060337, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011161, InterPro:IPR011162, InterPro:IPR001039,
            InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Parham,P., Lawlor,D.A., Lomen,C.E. and Ennis,P.D.
  TITLE     Diversity and diversification of HLA-A,B,C alleles
  JOURNAL   J. Immunol. 142 (11), 3937-3950 (1989)
   PUBMED   2715640
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*44:02).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Fleischhauer,K., Kernan,N.A., Dupont,B. and Yang,S.Y.
  TITLE     The two major subtypes of HLA-B44 differ for a single amino acid in
            codon 156
  JOURNAL   Tissue Antigens 37 (3), 133-137 (1991)
   PUBMED   1871765
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*44:03).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Adams,E.J., Little,A.M., Arnett,K.L., McAuley,J.E., Williams,R.C.
            and Parham,P.
  TITLE     Three new HLA-B alleles found in Mexican-Americans
  JOURNAL   Tissue Antigens 46 (5), 414-416 (1995)
   PUBMED   8838356
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*44:03).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Vilches,C., Sanz,L., de Pablo,R., Moreno,M.E., Puente,S. and
            Kreisler,M.
  TITLE     Molecular characterization of the new alleles HLA-B*8101 and B*4407
  JOURNAL   Tissue Antigens 47 (2), 139-142 (1996)
   PUBMED   8851728
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*44:07).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Darke,C., Street,J., Fussell,H., Thomas,M., Guttridge,M.,
            Goldberg,T.E., Arnett,K.L. and Parham,P.
  TITLE     A new HLA-B44 variant (B44BO [B*4408]) identified by serology
  JOURNAL   Tissue Antigens 50 (1), 32-37 (1997)
   PUBMED   9243752
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*44:08).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Prokupek,B., Madrigal,A. and Little,A.-M.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-FEB-2000)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*44:12).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A., Prokupek,B., Madrigal,J.A. and Little,A.M.
  TITLE     HLA-B*4413 identified in a UK Caucasoid potential bone marrow donor
  JOURNAL   Tissue Antigens 55 (2), 185-187 (2000)
   PUBMED   10746795
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*44:13).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Dunn,P.P.J.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAR-2001)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELES B*44:02 AND B*44:09).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Vilches,C. and Sepulveda,S.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-DEC-2002)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*44:05).
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Cox,S.T.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAR-2003)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*44:04).;
            TISSUE=Blood
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Mungall,A.J., Palmer,S.A., Sims,S.K., Edwards,C.A., Ashurst,J.L.,
            Wilming,L., Jones,M.C., Horton,R., Hunt,S.E., Scott,C.E.,
            Gilbert,J.G., Clamp,M.E., Bethel,G., Milne,S., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Andrews,T.D., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Barker,D.J.,
            Barlow,K.F., Bates,K., Beare,D.M., Beasley,H., Beasley,O.,
            Bird,C.P., Blakey,S., Bray-Allen,S., Brook,J., Brown,A.J.,
            Brown,J.Y., Burford,D.C., Burrill,W., Burton,J., Carder,C.,
            Carter,N.P., Chapman,J.C., Clark,S.Y., Clark,G., Clee,C.M.,
            Clegg,S., Cobley,V., Collier,R.E., Collins,J.E., Colman,L.K.,
            Corby,N.R., Coville,G.J., Culley,K.M., Dhami,P., Davies,J.,
            Dunn,M., Earthrowl,M.E., Ellington,A.E., Evans,K.A., Faulkner,L.,
            Francis,M.D., Frankish,A., Frankland,J., French,L., Garner,P.,
            Garnett,J., Ghori,M.J., Gilby,L.M., Gillson,C.J., Glithero,R.J.,
            Grafham,D.V., Grant,M., Gribble,S., Griffiths,C., Griffiths,M.,
            Hall,R., Halls,K.S., Hammond,S., Harley,J.L., Hart,E.A.,
            Heath,P.D., Heathcott,R., Holmes,S.J., Howden,P.J., Howe,K.L.,
            Howell,G.R., Huckle,E., Humphray,S.J., Humphries,M.D., Hunt,A.R.,
            Johnson,C.M., Joy,A.A., Kay,M., Keenan,S.J., Kimberley,A.M.,
            King,A., Laird,G.K., Langford,C., Lawlor,S., Leongamornlert,D.A.,
            Leversha,M., Lloyd,C.R., Lloyd,D.M., Loveland,J.E., Lovell,J.,
            Martin,S., Mashreghi-Mohammadi,M., Maslen,G.L., Matthews,L.,
            McCann,O.T., McLaren,S.J., McLay,K., McMurray,A., Moore,M.J.,
            Mullikin,J.C., Niblett,D., Nickerson,T., Novik,K.L., Oliver,K.,
            Overton-Larty,E.K., Parker,A., Patel,R., Pearce,A.V., Peck,A.I.,
            Phillimore,B., Phillips,S., Plumb,R.W., Porter,K.M., Ramsey,Y.,
            Ranby,S.A., Rice,C.M., Ross,M.T., Searle,S.M., Sehra,H.K.,
            Sheridan,E., Skuce,C.D., Smith,S., Smith,M., Spraggon,L.,
            Squares,S.L., Steward,C.A., Sycamore,N., Tamlyn-Hall,G., Tester,J.,
            Theaker,A.J., Thomas,D.W., Thorpe,A., Tracey,A., Tromans,A.,
            Tubby,B., Wall,M., Wallis,J.M., West,A.P., White,S.S.,
            Whitehead,S.L., Whittaker,H., Wild,A., Willey,D.J., Wilmer,T.E.,
            Wood,J.M., Wray,P.W., Wyatt,J.C., Young,L., Younger,R.M.,
            Bentley,D.R., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E.,
            Dunham,I., Rogers,J. and Beck,S.
  TITLE     The DNA sequence and analysis of human chromosome 6
  JOURNAL   Nature 425 (6960), 805-811 (2003)
   PUBMED   14574404
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   12 (residues 1 to 362)
  AUTHORS   Kottmann,A.H., Seemann,G.H., Guessow,H.D. and Roos,M.H.
  TITLE     DNA sequence of the coding region of the HLA-B44 gene
  JOURNAL   Immunogenetics 23 (6), 396-400 (1986)
   PUBMED   3459708
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 4-362 (ALLELE B*44:02).
COMMENT     On or before Dec 19, 2008 this sequence version replaced
            gi:74755923, gi:70084, gi:2118755, gi:284044, gi:122171, gi:231405.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-44 are known: B*44:02
            (B-12; B44.2), B*44:04, B*44:05, B*44:07, B*44:08 (B44BO), B*44:09,
            B*44:12 and B*44:13. The sequence shown is that of B*44:02.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-44
                     alpha chain"
                     /note="Bw-44; MHC class I antigen B*44"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-44 alpha
                     chain. /FTId=PRO_0000018847."
     Region          25..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          41..43
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          65
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in allele B*44:07 and allele B*44:08).
                     /FTId=VAR_016461."
     Region          69..70
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="KE -> MA (in allele B*44:08). /FTId=VAR_016462."
     Region          74..76
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          85
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> E (in allele B*44:13). /FTId=VAR_016463."
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> N (in allele B*44:12; requires 2 nucleotide
                     substitutions). /FTId=VAR_016464."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> S (in allele B*44:09). /FTId=VAR_016465."
     Region          104..107
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TALR -> NLRG (in allele B*44:09).
                     /FTId=VAR_016466."
     Region          106
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> A (in Ref. 12; AAA59619)."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> Y (in allele B*44:05). /FTId=VAR_016467."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> L (in allele B*44:03, allele B*44:07 and
                     allele B*44:13; requires 2 nucleotide substitutions).
                     /FTId=VAR_016468."
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> R (in allele B*44:04; requires 2 nucleotide
                     substitutions). /FTId=VAR_016469."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          187
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> T (in allele B*44:04; requires 2 nucleotide
                     substitutions). /FTId=VAR_016470."
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..219
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          222..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          223
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> A (in Ref. 12; AAA59619)."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          229
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> S (in Ref. 12; AAA59619)."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290..292
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          306
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs1131500). /FTId=VAR_056385."
     Region          310..333
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          329
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1051488). /FTId=VAR_056386."
     Region          334..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in dbSNP:rs2308655). /FTId=VAR_061422."
ORIGIN      
        1 mrvtaprtll lllwgavalt etwagshsmr yfytamsrpg rgeprfitvg yvddtlfvrf
       61 dsdatsprke prapwieqeg peywdretqi sktntqtyre nlrtalryyn qseagshiiq
      121 rmygcdvgpd grllrgydqd aydgkdyial nedlsswtaa dtaaqitqrk weaarvaeqd
      181 rayleglcve slrrylengk etlqradppk thvthhpisd hevtlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstvpivg ivaglavlav vvigavvaav mcrrkssggk ggsysqaacs dsaqgsdvsl
      361 ta
//

LOCUS       1B53_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-53 alpha
            chain; AltName: Full=Bw-53; AltName: Full=MHC class I antigen B*53;
            Flags: Precursor.
ACCESSION   P30491
VERSION     P30491.1  GI:231414
DBSOURCE    UniProtKB: locus 1B53_HUMAN, accession P30491;
            class: standard.
            extra
            accessions:O78053,O78138,Q30198,Q5TK76,Q9BD43,Q9GJF0,Q9MY42,Q9TP36,
            Q9TQH8
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M58636.1, AAA36228.1, U90566.1, AAB96793.1, AJ311599.3,
            CAC35317.1, U63562.1, AAB05926.1, U63561.1, AF071770.1, AAC35939.1,
            AF071769.1, AF198653.1, AAF20814.1, AF198652.1, AF117773.1,
            AAD23461.1, AF117772.1, AF304003.1, AAG53942.1, AF304002.1,
            AJ276996.1, CAB86197.1, AJ293856.1, CAC05305.1, AJ293857.1, A45834,
            1A1M_A, 1A1O_A
            xrefs (non-sequence databases): IPI:IPI00655604, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1A1M, PDBsum:1A1O,
            ProteinModelPortal:P30491, SMR:P30491, DIP:DIP-6054N,
            STRING:P30491, PRIDE:P30491, Ensembl:ENST00000359635,
            Ensembl:ENSP00000352656, Ensembl:ENSG00000206450,
            GeneCards:GC06M031112, GeneCards:GC06Mn31311, HGNC:4932,
            MIM:142830, neXtProt:NX_P30491, HOVERGEN:HBG016709,
            InParanoid:P30491, Reactome:REACT_6900, CleanEx:HS_HLA-B,
            Genevestigator:P30491, GO:0016021, GO:0042612, GO:0002474,
            GO:0060333, GO:0044419, GO:0050776, GO:0060337, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011161, InterPro:IPR011162, InterPro:IPR001039,
            InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Hayashi,H., Ooba,T., Nakayama,S., Sekimata,M., Kano,K. and
            Takiguchi,M.
  TITLE     Allospecificities between HLA-Bw53 and HLA-B35 are generated by
            substitution of the residues associated with HLA-Bw4/Bw6 public
            epitopes
  JOURNAL   Immunogenetics 32 (3), 195-199 (1990)
   PUBMED   1699887
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*53:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Gomez-Casado,E., Vargas-Alarcon,G., Martinez-Laso,J.,
            Perez-Blas,M., Granados,J., Layrisse,Z., Montoya,F., Varela,P. and
            Arnaiz-Villena,A.
  TITLE     Generation of the HLA-B35, -B5, -B16, and B15 groups of alleles
            studied by intron 1 and 2 sequence analysis
  JOURNAL   Immunogenetics 46 (6), 469-476 (1997)
   PUBMED   9321426
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 5-206 (ALLELE B*53:01).;
            TISSUE=Blood
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Cox,S.T.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-APR-2007)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].;
            TISSUE=Blood
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Hurley,C.K. and Hoyer,R.J.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-1996)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*53:02).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Steiner,N.K., Kosman,C., Jones,P.F., Gans,C.P.,
            Rodriguez-Marino,S.G., Rizzuto,G., Baldassarre,L.A., Edson,S.,
            Koester,R., Sese,D., Mitton,W., Ng,J., Hartzman,R.J. and
            Hurley,C.K.
  TITLE     Twenty-nine new HLA-B alleles associated with antigens in the 5C
            CREG
  JOURNAL   Tissue Antigens 57 (5), 481-485 (2001)
   PUBMED   11556976
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELES B*53:03 AND
            B*53:05).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Kennedy,C.T., Dodd,R., Le,T., Wallace,R., Ng,G., Greville,W.D.,
            Kennedy,A., Taverniti,A., Moses,J.H., Clow,N., Watson,N. and
            Dunckley,H.
  TITLE     Routine HLA-B genotyping with PCR-sequence-specific
            oligonucleotides (PCR-SSO) detects eight new alleles: B*0807,
            B*0809, B*1551, B*3529, B*3532, B*4025, B*5304 and B*5508
  JOURNAL   Tissue Antigens 55 (3), 266-270 (2000)
   PUBMED   10777103
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*53:04).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Tait,B., Holdsworth,R., Cantwell,L., Boyle,A. and Diviney,M.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-SEP-2000)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE B*53:05).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Anholts,J.D., Kemps-Mols,B., Verduijn,W., Oudshoorn,M. and
            Schreuder,G.M.
  TITLE     Three newly identified HLA-B alleles: B*5124, B*5306, B*5307 and
            confirmation of B*0809 and B*5606
  JOURNAL   Tissue Antigens 58 (1), 38-41 (2001)
   PUBMED   11580855
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELES B*53:06 AND
            B*53:07).;
            TISSUE=Peripheral blood
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Smith,K.J., Reid,S.W., Harlos,K., McMichael,A.J., Stuart,D.I.,
            Bell,J.I. and Jones,E.Y.
  TITLE     Bound water structure and polymorphic amino acids act together to
            allow the binding of different peptides to MHC class I HLA-B53
  JOURNAL   Immunity 4 (3), 215-228 (1996)
   PUBMED   8624812
  REMARK    X-RAY CRYSTALLOGRAPHY (2.3 ANGSTROMS) OF 25-302.
COMMENT     On or before Dec 19, 2008 this sequence version replaced
            gi:74756660, gi:321167.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-53 are known: B*53:01,
            B*53:02, B*53:03, B*53:04, B*53:05, B*53:06 and B*53:07. The
            sequence shown is that of B*53:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-53
                     alpha chain"
                     /note="Bw-53; MHC class I antigen B*53"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-53 alpha
                     chain. /FTId=PRO_0000018856."
     Region          25..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          41..43
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          74..76
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> D (in allele B*53:03). /FTId=VAR_016524."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> S (in allele B*53:05). /FTId=VAR_016525."
     Region          104..105
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="IA -> TL (in allele B*53:03). /FTId=VAR_016526."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          118
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> T (in allele B*53:07). /FTId=VAR_016527."
     Region          123
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> S (in allele B*53:07). /FTId=VAR_016528."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> V (in allele B*53:07). /FTId=VAR_016529."
     Region          131..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          137..138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HD -> YN (in allele B*53:07). /FTId=VAR_016530."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> F (in allele B*53:04 and allele B*53:07).
                     /FTId=VAR_016531."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..172
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          173..175
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> E (in allele B*53:06). /FTId=VAR_016532."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          195
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> H (in allele B*53:02 and allele B*53:06).
                     /FTId=VAR_016533."
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..217
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290..292
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvtaprtvl lllwgavalt etwagshsmr yfytamsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasprte prapwieqeg peywdrntqi fktntqtyre nlrialryyn qseagshiiq
      121 rmygcdlgpd grllrghdqs aydgkdyial nedlsswtaa dtaaqitqrk weaarvaeql
      181 rayleglcve wlrrylengk etlqradppk thvthhpvsd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstipivg ivaglavlav vvigavvatv mcrrkssggk ggsysqaass dsaqgsdvsl
      361 ta
//

LOCUS       1C04_HUMAN               366 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, Cw-4 alpha
            chain; AltName: Full=MHC class I antigen Cw*4; Flags: Precursor.
ACCESSION   P30504
VERSION     P30504.1  GI:231433
DBSOURCE    UniProtKB: locus 1C04_HUMAN, accession P30504;
            class: standard.
            extra accessions:O78067,O78072,O78090,O78149,Q29921,Q9UM42
            created: Apr 1, 1993.
            sequence updated: Apr 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: M84386.1, AAA59705.1, X58536.1, CAA41427.1, AJ278494.1,
            CAB95011.1, AJ238694.2, CAB41889.2, L54059.1, AAB04639.1, U96787.1,
            AAC17719.1, U96786.1, AF036557.1, AAC17720.1, AF036556.1,
            AF076476.1, AAC27626.1, AF062588.1, AAC16245.1, AF062587.1, A59028,
            JH0526, 1IM9_A, 1IM9_E, 1QQD_A
            xrefs (non-sequence databases): IPI:IPI00795906, UniGene:Hs.654404,
            UniGene:Hs.656020, PDBsum:1IM9, PDBsum:1QQD,
            ProteinModelPortal:P30504, SMR:P30504, IntAct:P30504,
            MINT:MINT-101019, STRING:P30504, PRIDE:P30504,
            Ensembl:ENST00000400341, Ensembl:ENSP00000383195,
            Ensembl:ENSG00000206435, Ensembl:ENST00000400394,
            Ensembl:ENSP00000383244, Ensembl:ENSG00000206452,
            GeneCards:GC06M031007, GeneCards:GC06Mn31226,
            GeneCards:GC06Mo31229, H-InvDB:HIX0186567, HGNC:4933, MIM:142840,
            neXtProt:NX_P30504, HOVERGEN:HBG016709, OrthoDB:EOG4F4SBG,
            Reactome:REACT_6900, CleanEx:HS_HLA-C, Genevestigator:P30504,
            GO:0016021, GO:0042612, GO:0002474, GO:0060333, GO:0044419,
            GO:0050776, GO:0060337, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 366)
  AUTHORS   Belich,M.P., Madrigal,J.A., Hildebrand,W.H., Zemmour,J.,
            Williams,R.C., Luz,R., Petzl-Erler,M.L. and Parham,P.
  TITLE     Unusual HLA-B alleles in two tribes of Brazilian Indians
  JOURNAL   Nature 357 (6376), 326-329 (1992)
   PUBMED   1317015
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE CW*04:01).
REFERENCE   2  (residues 1 to 366)
  AUTHORS   Grassi,F., Meneveri,R., Gullberg,M., Lopalco,L., Rossi,G.B.,
            Lanza,P., de Santis,C., Brattsand,G., Butto,S., Ginelli,E.,
            Beretta,A. and Siccardi,A.G.
  TITLE     Human immunodeficiency virus type 1 gp120 mimics a hidden
            monomorphic epitope borne by class I major histocompatibility
            complex heavy chains
  JOURNAL   J. Exp. Med. 174 (1), 53-62 (1991)
   PUBMED   1711567
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*04:01).
REFERENCE   3  (residues 1 to 366)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE CW*04:01).;
            TISSUE=Blood
REFERENCE   4  (residues 1 to 366)
  AUTHORS   Dunn,P.P., van Dam,M., Crosby,I. and Carter,V.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-1999)
  REMARK    NUCLEOTIDE SEQUENCE OF 1-365 (ALLELE CW*04:01).
REFERENCE   5  (residues 1 to 366)
  AUTHORS   Little,A.M., Mason,A., Marsh,S.G. and Parham,P.
  TITLE     HLA-C typing of eleven Papua New Guineans: identification of an
            HLA-Cw4/Cw2 hybrid allele
  JOURNAL   Tissue Antigens 48 (2), 113-117 (1996)
   PUBMED   8883300
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE CW*04:03).;
            TISSUE=B-cell
REFERENCE   6  (residues 1 to 366)
  AUTHORS   Turner,S., Ellexson,M.E., Hickman,H.D., Sidebottom,D.A.,
            Fernandez-Vina,M., Confer,D.L. and Hildebrand,W.H.
  TITLE     Sequence-based typing provides a new look at HLA-C diversity
  JOURNAL   J. Immunol. 161 (3), 1406-1413 (1998)
   PUBMED   9686604
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES CW*04:04 AND CW*04:05).
REFERENCE   7  (residues 1 to 366)
  AUTHORS   Ren,E.C., Haniff,F., Loh,M.T., Chan,S.H., Petersdorf,E. and
            Hansen,J.
  TITLE     Identification of a novel HLA-C allele, Cw*0406, in a Singapore
            Malay
  JOURNAL   Tissue Antigens 53 (2), 198-200 (1999)
   PUBMED   10090622
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE CW*04:06).
REFERENCE   8  (residues 1 to 366)
  AUTHORS   Carbonnelle,E., Poirier,J.C., Fortier,C., Marzais,F., Visser,C.J.,
            Borie,C., Toubert,A., Raffoux,C., Charron,D. and Tamouza,R.
  TITLE     Characterization of a novel HLA-Cw*04 variant in a Laotian family:
            HLA-Cw*0406
  JOURNAL   Tissue Antigens 53 (6), 601-603 (1999)
   PUBMED   10395115
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE CW*04:06).
REFERENCE   9  (residues 1 to 366)
  AUTHORS   Johnson,J.M., Nicot,C., Fullen,J., Ciminale,V., Casareto,L.,
            Mulloy,J.C., Jacobson,S. and Franchini,G.
  TITLE     Free major histocompatibility complex class I heavy chain is
            preferentially targeted for degradation by human T-cell
            leukemia/lymphotropic virus type 1 p12(I) protein
  JOURNAL   J. Virol. 75 (13), 6086-6094 (2001)
   PUBMED   11390610
  REMARK    INTERACTION WITH HTLV-1 ACCESSORY PROTEIN P12I.
COMMENT     On or before Apr 26, 2005 this sequence version replaced
            gi:25518280, gi:345797.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity). Interacts with HTLV-1 p12I accessory
            protein.
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of Cw-4 are known: Cw*04:01
            Cw*04:03, Cw*04:04, Cw*04:05 and Cw*04:06. The sequence shown is
            that of Cw*04:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..366
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
     Protein         1..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /product="HLA class I histocompatibility antigen, Cw-4
                     alpha chain"
                     /note="MHC class I antigen Cw*4"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, Cw-4 alpha
                     chain. /FTId=PRO_0000018871."
     Region          25..308
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          33
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> Y (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016571."
     Region          35
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> A (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016572."
     Region          38
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> R (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016573."
     Region          40
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> S (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016574."
     Region          45..52
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016575."
     Region          52
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in allele Cw*04:05). /FTId=VAR_016576."
     Region          55..61
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          70..73
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          73
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> A (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016577."
     Region          74..76
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          76
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs1065382). /FTId=VAR_056464."
     Region          81..108
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          90
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="K -> N (in dbSNP:rs28626310). /FTId=VAR_056465."
     Region          97
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs41543814). /FTId=VAR_056466."
     Site            110
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Bond            125..188
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          131..142
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          145..150
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> L (in allele Cw*04:04 and allele Cw*04:06).
                     /FTId=VAR_016578."
     Region          182
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> V (in dbSNP:rs1059539). /FTId=VAR_056467."
     Region          187..198
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..203
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          201
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in dbSNP:rs1131103). /FTId=VAR_056468."
     Region          207..298
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..297
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..217
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          219..235
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          252..254
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          272
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs1050276). /FTId=VAR_056469."
     Region          278..280
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290..292
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..333
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          327
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> V (in allele Cw*04:03 and allele Cw*04:06).
                     /FTId=VAR_016579."
     Region          334..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvmaprtli lllsgalalt etwagshsmr yfstsvswpg rgeprfiavg yvddtqfvrf
       61 dsdaasprge prepwveqeg peywdretqk ykrqaqadrv nlrklrgyyn qsedgshtlq
      121 rmfgcdlgpd grllrgynqf aydgkdyial nedlrswtaa dtaaqitqrk weaareaeqr
      181 raylegtcve wlrrylengk etlqraehpk thvthhpvsd heatlrcwal gfypaeitlt
      241 wqwdgedqtq dtelvetrpa gdgtfqkwaa vvvpsgeeqr ytchvqhegl pepltlrwkp
      301 ssqptipivg ivaglavlav lavlgamvav vmcrrkssgg kggscsqaas snsaqgsdes
      361 liacka
//

LOCUS       FCG2C_HUMAN              323 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Low affinity immunoglobulin gamma Fc region receptor
            II-c; Short=IgG Fc receptor II-c; AltName: Full=CDw32; AltName:
            Full=Fc-gamma RII-c; Short=Fc-gamma-RIIc; Short=FcRII-c; AltName:
            CD_antigen=CD32; Flags: Precursor.
ACCESSION   P31995
VERSION     P31995.1  GI:399478
DBSOURCE    UniProtKB: locus FCG2C_HUMAN, accession P31995;
            class: standard.
            extra accessions:O00523,O00524,O00525
            created: Jul 1, 1993.
            sequence updated: Jul 1, 1993.
            annotation updated: Sep 21, 2011.
            xrefs: X17652.1, CAA35642.1, CAA35643.1, U90938.1, AAC12807.1,
            U90939.1, AAC12808.1, U90940.1, AAC12809.1, U90941.1, AAC12810.1,
            S06946
            xrefs (non-sequence databases): IPI:IPI00013971, IPI:IPI00215903,
            IPI:IPI00215904, IPI:IPI00215905, UniGene:Hs.352642,
            UniGene:Hs.713617, ProteinModelPortal:P31995, SMR:P31995,
            IntAct:P31995, MINT:MINT-7241761, STRING:P31995,
            PhosphoSite:P31995, PRIDE:P31995, UCSC:uc009wum.1,
            GeneCards:GC01P161551, H-InvDB:HIX0056771, HGNC:15626,
            neXtProt:NX_P31995, eggNOG:prNOG18864, HOVERGEN:HBG051602,
            DrugBank:DB00054, DrugBank:DB00051, DrugBank:DB00092,
            DrugBank:DB00087, DrugBank:DB00074, DrugBank:DB00112,
            DrugBank:DB00002, DrugBank:DB00111, DrugBank:DB00095,
            DrugBank:DB00005, DrugBank:DB00056, DrugBank:DB00078,
            DrugBank:DB00028, DrugBank:DB00075, DrugBank:DB00108,
            DrugBank:DB00110, DrugBank:DB00073, DrugBank:DB00081,
            DrugBank:DB00072, NextBio:34121, CleanEx:HS_FCGR2C,
            Genevestigator:P31995, GermOnline:ENSG00000203746, GO:0005737,
            GO:0016021, GO:0005886, GO:0019864, GO:0004888, GO:0006955,
            InterPro:IPR007110, InterPro:IPR013783, InterPro:IPR003599,
            Gene3D:G3DSA:2.60.40.10, SMART:SM00409, PROSITE:PS50835
KEYWORDS    Alternative splicing; Cell membrane; Complete proteome; Cytoplasm;
            Disulfide bond; Glycoprotein; IgG-binding protein; Immunoglobulin
            domain; Membrane; Phosphoprotein; Receptor; Reference proteome;
            Repeat; Signal; Transmembrane; Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 323)
  AUTHORS   Stuart,S.G., Simister,N.E., Clarkson,S.B., Kacinski,B.M.,
            Shapiro,M. and Mellman,I.
  TITLE     Human IgG Fc receptor (hFcRII; CD32) exists as multiple isoforms in
            macrophages, lymphocytes and IgG-transporting placental epithelium
  JOURNAL   EMBO J. 8 (12), 3657-3666 (1989)
   PUBMED   2531080
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORM IIC1).;
            TISSUE=Placenta
REFERENCE   2  (residues 1 to 323)
  AUTHORS   Metes,D., Ernst,L.K., Chambers,W.H., Sulica,A., Herberman,R.B. and
            Morel,P.A.
  TITLE     Expression of functional CD32 molecules on human NK cells is
            determined by an allelic polymorphism of the FcgammaRIIC gene
  JOURNAL   Blood 91 (7), 2369-2380 (1998)
   PUBMED   9516136
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORMS IIC1; IIC2; IIC3 AND IIC4).;
            TISSUE=Natural killer cell
REFERENCE   3  (residues 1 to 323)
  AUTHORS   Rikova,K., Guo,A., Zeng,Q., Possemato,A., Yu,J., Haack,H.,
            Nardone,J., Lee,K., Reeves,C., Li,Y., Hu,Y., Tan,Z., Stokes,M.,
            Sullivan,L., Mitchell,J., Wetzel,R., Macneill,J., Ren,J.M.,
            Yuan,J., Bakalarski,C.E., Villen,J., Kornhauser,J.M., Smith,B.,
            Li,D., Zhou,X., Gygi,S.P., Gu,T.L., Polakiewicz,R.D., Rush,J. and
            Comb,M.J.
  TITLE     Global survey of phosphotyrosine signaling identifies oncogenic
            kinases in lung cancer
  JOURNAL   Cell 131 (6), 1190-1203 (2007)
   PUBMED   18083107
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT TYR-310, AND MASS
            SPECTROMETRY.;
            TISSUE=Lung carcinoma
COMMENT     On Mar 15, 2005 this sequence version replaced gi:106694.
            [FUNCTION] Receptor for the Fc region of complexed immunoglobulins
            gamma. Low affinity receptor. Involved in a variety of effector and
            regulatory functions such as phagocytosis of immune complexes and
            modulation of antibody production by B-cells.
            [INTERACTION] P02741:CRP; NbExp=2; IntAct=EBI-1396036, EBI-1395983;
            P16333:NCK1; NbExp=2; IntAct=EBI-1396036, EBI-389883.
            [SUBCELLULAR LOCATION] Isoform IIC4: Cytoplasm (Probable).
            [SUBCELLULAR LOCATION] Isoform IIC3: Cell membrane; Single-pass
            type I membrane protein.
            [SUBCELLULAR LOCATION] Isoform IIC2: Cell membrane; Single-pass
            type I membrane protein.
            [SUBCELLULAR LOCATION] Isoform IIC1: Cell membrane; Single-pass
            type I membrane protein.
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=4; Name=IIC1; Synonyms=C1; IsoId=P31995-1;
            Sequence=Displayed; Name=IIC2; IsoId=P31995-2; Sequence=VSP_002646;
            Name=IIC3; IsoId=P31995-3; Sequence=VSP_002645; Name=IIC4;
            IsoId=P31995-4; Sequence=VSP_002644.
            [TISSUE SPECIFICITY] Isoform IIC1 is detected in monocytes,
            macrophages, polymorphonuclear cells and natural killer cells.
            [DOMAIN] Contains an intracytoplasmic twice repeated motif referred
            as immunoreceptor tyrosine-based activator motif (ITAM). These
            motifs are involved in triggering cell activation upon receptors
            aggregation.
            [SIMILARITY] Contains 2 Ig-like C2-type (immunoglobulin-like)
            domains.
            [CAUTION] Has sometimes been attributed to correspond to FcR-IIB.
            [SEQUENCE CAUTION] Sequence=CAA35643.1; Type=Erroneous initiation.
FEATURES             Location/Qualifiers
     source          1..323
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
     Protein         1..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /product="Low affinity immunoglobulin gamma Fc region
                     receptor II-c"
                     /note="IgG Fc receptor II-c; CDw32; Fc-gamma RII-c;
                     Fc-gamma-RIIc; FcRII-c"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..42
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Region          43..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Low affinity immunoglobulin gamma Fc region
                     receptor II-c. /FTId=PRO_0000015148."
     Region          43..223
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          48..127
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type 1."
     Region          50..128
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Ig1_FcgammaR_like"
                     /note="Frst immunoglobulin (Ig)-like domain of
                     Fcgamma-receptors (FcgammaRs) and similar proteins;
                     cd05752"
                     /db_xref="CDD:143229"
     Site            order(53..54,72,80..83)
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="other"
                     /note="pentraxin binding site"
                     /db_xref="CDD:143229"
     Bond            71..113
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            106
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          131..213
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type 2."
     Region          132..214
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Ig2_FcgammaR_like"
                     /note="Second immunoglobulin (Ig)-like domain of
                     Fcgamma-receptors (FcgammaRs) and similar proteins;
                     cd05753"
                     /db_xref="CDD:143230"
     Site            order(132,155,161..162,176..177)
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="other"
                     /note="Fc binding site [polypeptide binding]"
                     /db_xref="CDD:143230"
     Site            order(145..147,156,161,177,200..201)
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="other"
                     /note="pentraxin binding site"
                     /db_xref="CDD:143230"
     Region          151
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> K (in Ref. 2; AAC12810)."
     Bond            152..196
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          164
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> I (in Ref. 2; AAC12809)."
     Site            180
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Site            187
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          216..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="APSSSPMGIIVAVVTGIAVAAIVAAVVALIYCRKKRISANSTDPVKAAQFE
                     PPGRQMIAIRKRQPEETNNDYETADGGYMTLNPRAPTDDDKNIYLTLPPNDHVNSNN
                     -> GPRLRTAAKQSSLVGAEVP (in isoform IIC4).
                     /FTId=VSP_002644."
     Region          224..246
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          247..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          255..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="NSTDPVKAAQFEPPGRQMIAIRKRQPEETNNDYETADGGYMTLNPRAPTDD
                     DKNIYLTLPPNDHVNSNN -> TWTSNDCHQKETT (in isoform IIC3).
                     /FTId=VSP_002645."
     Region          267..323
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="PPGRQMIAIRKRQPEETNNDYETADGGYMTLNPRAPTDDDKNIYLTLPPND
                     HVNSNN -> MLSCSHLDVK (in isoform IIC2). /FTId=VSP_002646."
     Site            310
                     /gene="FCGR2C"
                     /gene_synonym="CD32"
                     /gene_synonym="FCG2"
                     /gene_synonym="IGFR2"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphotyrosine."
ORIGIN      
        1 mgilsflpvl atesdwadck spqpwghmll wtavlflapv agtpaappka vlklepqwin
       61 vlqedsvtlt crgthspesd siqwfhngnl ipthtqpsyr fkannndsge ytcqtgqtsl
      121 sdpvhltvls ewlvlqtphl efqegetivl rchswkdkpl vkvtffqngk skkfsrsdpn
      181 fsipqanhsh sgdyhctgni gytlysskpv titvqapsss pmgiivavvt giavaaivaa
      241 vvaliycrkk risanstdpv kaaqfeppgr qmiairkrqp eetnndyeta dggymtlnpr
      301 aptdddkniy ltlppndhvn snn
//

LOCUS       1C15_HUMAN               366 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, Cw-15 alpha
            chain; AltName: Full=MHC class I antigen Cw*15; Flags: Precursor.
ACCESSION   Q07000
VERSION     Q07000.1  GI:543713
DBSOURCE    UniProtKB: locus 1C15_HUMAN, accession Q07000;
            class: standard.
            extra accessions:O78165,Q29864,Q29991,Q31605,Q9BD28,Q9GJ33,Q9MY49
            created: Jun 1, 1994.
            sequence updated: Jun 1, 1994.
            annotation updated: Sep 21, 2011.
            xrefs: X67818.1, CAA48029.1, D83031.1, BAA32614.1, AJ420250.2,
            CAD12435.1, AJ272049.1, CAB75584.1, M99388.1, AAA88087.1, X73518.1,
            CAA51917.1, X78343.1, CAA55138.1, X87841.1, CAA61110.1, AF302134.1,
            AAG33823.1, AF302133.1, AF335317.1, AAK07656.1, AF335316.1, I37523,
            I37527, I37544
            xrefs (non-sequence databases): IPI:IPI00471951,
            ProteinModelPortal:Q07000, SMR:Q07000, STRING:Q07000, PRIDE:Q07000,
            Ensembl:ENST00000400341, Ensembl:ENSP00000383195,
            Ensembl:ENSG00000206435, Ensembl:ENST00000400394,
            Ensembl:ENSP00000383244, Ensembl:ENSG00000206452,
            GeneCards:GC06M031007, GeneCards:GC06Mn31226,
            GeneCards:GC06Mo31229, H-InvDB:HIX0167430, HGNC:4933, MIM:142840,
            neXtProt:NX_Q07000, HOVERGEN:HBG016709, CleanEx:HS_HLA-C,
            Genevestigator:Q07000, GO:0016021, GO:0042612, GO:0002474,
            GO:0006955, GO:0044419, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 366)
  AUTHORS   Vilches,C., de Pablo,R., Herrero,M.J., Moreno,M.E. and Kreisler,M.
  TITLE     Molecular cloning and polymerase chain reaction-sequence-specific
            oligonucleotide detection of the allele encoding the novel
            allospecificity HLA-Cw6.2 (Cw*1502) in Spanish gypsies
  JOURNAL   Hum. Immunol. 37 (4), 259-263 (1993)
   PUBMED   7905471
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*15:02).
REFERENCE   2  (residues 1 to 366)
  AUTHORS   Wang,H. and Tokunaga,K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JAN-1996)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*15:02).;
            TISSUE=Peripheral blood
REFERENCE   3  (residues 1 to 366)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE CW*15:02).
REFERENCE   4  (residues 1 to 366)
  AUTHORS   Witter,K., Zahn,R., Scholz,S. and Albert,E.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-FEB-2000)
  REMARK    NUCLEOTIDE SEQUENCE OF 1-275 (ALLELE CW*15:02).
REFERENCE   5  (residues 1 to 366)
  AUTHORS   Domena,J.D.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAY-1994)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE CW*15:03).
REFERENCE   6  (residues 1 to 366)
  AUTHORS   de Pablo,M.R., Vilches,C., Moreno,M.E. and Kreisler,M.
  TITLE     A novel HLA-C allele (Cw*1504) related to the Cw6.2 phenotype
  JOURNAL   Immunogenetics 39 (1), 79 (1994)
   PUBMED   8225443
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*15:04).
REFERENCE   7  (residues 1 to 366)
  AUTHORS   Vilches,C., de Pablo,R., Herrero,M.J., Moreno,M.E. and Kreisler,M.
  TITLE     Cw*1505: a novel HLA-C allele isolated from a B*7301 haplotype
  JOURNAL   Immunogenetics 40 (4), 313 (1994)
   PUBMED   8082899
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*15:05).
REFERENCE   8  (residues 1 to 366)
  AUTHORS   Sanz,L., Vilches,C., de Pablo,R., Bunce,M., Moreno,M.E. and
            Kreisler,M.
  TITLE     Haplotypic association of two new HLA class I alleles: Cw*15052 and
            B*0706: evolutionary relationships of HLA-Cw*15 alleles
  JOURNAL   Tissue Antigens 47 (4), 329-332 (1996)
   PUBMED   8773323
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE CW*15:05).
REFERENCE   9  (residues 1 to 366)
  AUTHORS   Tamouza,R., Schaeffer,V., Marzais,F., Poirier,J.C., Fortier,C. and
            Charron,D.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-SEP-2000)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE CW*15:10).
REFERENCE   10 (residues 1 to 366)
  AUTHORS   Greville,W.D., Chapman,G., Le,T., Dodd,R., Taverniti,A. and
            Dunckley,H.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JAN-2001)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE CW*15:11).
REFERENCE   11 (residues 1 to 366)
  AUTHORS   Wollscheid,B., Bausch-Fluck,D., Henderson,C., O'Brien,R., Bibel,M.,
            Schiess,R., Aebersold,R. and Watts,J.D.
  TITLE     Mass-spectrometric identification and relative quantification of
            N-linked cell surface glycoproteins
  JOURNAL   Nat. Biotechnol. 27 (4), 378-386 (2009)
   PUBMED   19349973
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-110, AND MASS
            SPECTROMETRY.;
            TISSUE=Leukemic T-cell
            Erratum:[Nat Biotechnol. 2009 Sep;27(9):864]
COMMENT     On or before Jun 21, 2005 this sequence version replaced
            gi:2118709, gi:2118710, gi:2118840.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of Cw-15 are known: Cw*15:02,
            Cw*15:03, Cw*15:04, Cw*15:05, Cw*15:10 and Cw*15:11. The sequence
            shown is that of Cw*15:02.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..366
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
     Protein         1..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /product="HLA class I histocompatibility antigen, Cw-15
                     alpha chain"
                     /note="MHC class I antigen Cw*15"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          5
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in Ref. 2; BAA32614)."
     Region          25..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, Cw-15 alpha
                     chain. /FTId=PRO_0000018878."
     Region          25..308
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          40
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> S (in allele Cw*15:11). /FTId=VAR_016639."
     Region          45
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> R (in allele Cw*15:10). /FTId=VAR_016640."
     Region          73
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> E (in dbSNP:rs1050409). /FTId=VAR_056500."
     Region          76
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs1065382). /FTId=VAR_056501."
     Region          90
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in allele Cw*15:11). /FTId=VAR_016641."
     Region          97
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in allele Cw*15:03). /FTId=VAR_016642."
     Site            110
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          115..206
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Bond            125..188
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          137
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Y (in allele Cw*15:04). /FTId=VAR_016643."
     Region          140
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> F (in allele Cw*15:05). /FTId=VAR_016644."
     Region          140
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> S (in allele Cw*15:04). /FTId=VAR_016645."
     Region          182
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> V (in dbSNP:rs1059539). /FTId=VAR_056502."
     Region          201
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in dbSNP:rs1131103). /FTId=VAR_056503."
     Region          207..299
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..297
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          272
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in dbSNP:rs1050276). /FTId=VAR_056504."
     Region          299..308
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..333
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          334..366
                     /gene="HLA-C"
                     /gene_synonym="HLAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvmaprtll lllsgalalt etwacshsmr yfytavsrpg rgephfiavg yvddtqfvrf
       61 dsdaasprge prapwveqeg peywdretqn ykrqaqtdrv nlrklrgyyn qseagshiiq
      121 rmygcdlgpd grllrghdql aydgkdyial nedlrswtaa dtaaqitqrk weaareaeql
      181 raylegtcve wlrrylengk etlqraehpk thvthhpvsd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwaa vvvpsgeeqr ytchvqhegl pepltlrwep
      301 ssqptipivg ivaglavlav lavlgavmav vmcrrkssgg kggscsqaas snsaqgsdes
      361 liacka
//

LOCUS       1A30_HUMAN               365 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, A-30 alpha
            chain; AltName: Full=MHC class I antigen A*30; Flags: Precursor.
ACCESSION   P16188
VERSION     P16188.2  GI:1345596
DBSOURCE    UniProtKB: locus 1A30_HUMAN, accession P16188;
            class: standard.
            extra accessions:O19598,O62921,P30452,Q9UIP7
            created: Apr 1, 1990.
            sequence updated: Feb 1, 1996.
            annotation updated: Sep 21, 2011.
            xrefs: M30576.1, AAA59612.1, U07234.1, AAA70162.1, X61702.1,
            CAA43871.1, M93657.1, AAA58650.1, Z34921.1, CAA84401.1, U19734.1,
            AAB53658.1, U18988.1, U24261.1, AAB50434.1, X83770.1, CAA58723.1,
            X83771.1, CAA58724.1, AF028714.1, AAC14191.1, AF028713.1,
            AF065643.1, AAC18600.1, AF065642.1, AJ249308.1, CAB57306.1,
            AJ249309.1, AJ249310.1, AJ249311.1, AJ249312.1, AJ249313.1,
            AJ249314.1, AJ249315.1, I38519, I54307, I56039
            xrefs (non-sequence databases): IPI:IPI00472855,
            ProteinModelPortal:P16188, SMR:P16188, IntAct:P16188,
            STRING:P16188, PRIDE:P16188, Ensembl:ENST00000376809,
            Ensembl:ENSP00000366005, Ensembl:ENSG00000206503,
            Ensembl:ENST00000396634, Ensembl:ENSP00000379873,
            GeneCards:GC06P029921, HGNC:4931, MIM:142800, neXtProt:NX_P16188,
            HOVERGEN:HBG016709, CleanEx:HS_HLA-A, Genevestigator:P16188,
            GermOnline:ENSG00000204632, GO:0005887, GO:0042612, GO:0032393,
            GO:0005515, GO:0002474, GO:0006955, GO:0044419, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011161, InterPro:IPR011162, InterPro:IPR001039,
            InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    Complete proteome; Disulfide bond; Glycoprotein; Host-virus
            interaction; Immunity; Membrane; MHC I; Polymorphism; Reference
            proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 365)
  AUTHORS   Kato,K., Trapani,J.A., Allopenna,J., Dupont,B. and Yang,S.Y.
  TITLE     Molecular analysis of the serologically defined HLA-Aw19 antigens.
            A genetically distinct family of HLA-A antigens comprising A29,
            A31, A32, and Aw33, but probably not A30
  JOURNAL   J. Immunol. 143 (10), 3371-3378 (1989)
   PUBMED   2478623
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*30:01).
REFERENCE   2  (residues 1 to 365)
  AUTHORS   Olerup,O., Daniels,T. and Baxter-Lowe,L.A.
  TITLE     Correct sequence of the A*3001 allele obtained by PCR-SSP typing
            and automated nucleotide sequencing
  JOURNAL   Tissue Antigens 44 (4), 265-267 (1994)
   PUBMED   7871528
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE A*30:01).
REFERENCE   3  (residues 1 to 365)
  AUTHORS   Madrigal,J.A., Belich,M.P., Hildebrand,W.H., Benjamin,R.J.,
            Little,A.-M., Zemmour,J., Ennis,P.D., Ward,F.E., Petzl-Erler,M.L.,
            Martell,R.W., du Toit,E.D. and Parham,P.
  TITLE     Distinctive HLA-A,B antigens of black populations formed by
            interallelic conversion
  JOURNAL   J. Immunol. 149 (10), 3411-3415 (1992)
   PUBMED   1431115
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*30:02).
REFERENCE   4  (residues 1 to 365)
  AUTHORS   Choo,S.Y., Starling,G.C., Anasetti,C. and Hansen,J.A.
  TITLE     Selection of an unrelated donor for marrow transplantation
            facilitated by the molecular characterization of a novel HLA-A
            allele
  JOURNAL   Hum. Immunol. 36 (1), 20-26 (1993)
   PUBMED   8458735
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 25-279 (ALLELE A*30:03).
REFERENCE   5  (residues 1 to 365)
  AUTHORS   Krausa,P., Carcassi,C., Orru,S., Bodmer,J.G., Browning,M.J. and
            Contu,L.
  TITLE     Defining the allelic variants of HLA-A30 in the Sardinian
            population using amplification refractory mutation
            system--polymerase chain reaction
  JOURNAL   Hum. Immunol. 44 (1), 35-42 (1995)
   PUBMED   8522453
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE A*30:04).
REFERENCE   6  (residues 1 to 365)
  AUTHORS   Lienert,K., Russ,G., Bennett,G., Gao,X. and McCluskey,J.
  TITLE     HLA-A*3004: a new A30 allele identified in an Australian Caucasoid
            population
  JOURNAL   Tissue Antigens 46 (5), 394-397 (1995)
   PUBMED   8838350
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA / MRNA] OF 26-206 (ALLELE
            A*30:04).
REFERENCE   7  (residues 1 to 365)
  AUTHORS   Blasczyk,R., Wehling,J., Passler,M., Hahn,U., Huhn,D. and Salama,A.
  TITLE     A novel HLA-A30 allele (A*3004) identified by single-strand
            conformation polymorphism analysis and confirmed by solid-phase
            sequencing
  JOURNAL   Tissue Antigens 46 (4), 322-326 (1995)
   PUBMED   8560452
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 28-205 (ALLELE A*30:04).
REFERENCE   8  (residues 1 to 365)
  AUTHORS   Ellis,J.M., Mack,S.J., Leke,R.F., Quakyi,I., Johnson,A.H. and
            Hurley,C.K.
  TITLE     Diversity is demonstrated in class I HLA-A and HLA-B alleles in
            Cameroon, Africa: description of HLA-A*03012, *2612, *3006 and
            HLA-B*1403, *4016, *4703
  JOURNAL   Tissue Antigens 56 (4), 291-302 (2000)
   PUBMED   11098929
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*30:06).
REFERENCE   9  (residues 1 to 365)
  AUTHORS   Ellis,J., Steiner,N., Kosman,C., Henson,V., Mitton,W., Koester,R.,
            Ng,J., Hartzman,R.J. and Hurley,C.K.
  TITLE     Seventeen more novel HLA-A locus alleles
  JOURNAL   Tissue Antigens 55 (4), 369-373 (2000)
   PUBMED   10852390
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*30:07).
REFERENCE   10 (residues 1 to 365)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Koester,R.P., Heine,U., Holman,R.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Further diversity at HLA-A and -B loci identified in Afro-Caribbean
            potential bone marrow donors
  JOURNAL   Tissue Antigens 57 (1), 70-72 (2001)
   PUBMED   11169261
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*30:08).
REFERENCE   11 (residues 1 to 365)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
COMMENT     On or before Jul 18, 2007 this sequence version replaced
            gi:2135711, gi:2118806, gi:2118807, gi:122119.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of A-30 are known: A*30:01
            (A30.3), A*30:02, A*30:03, A*30:04 (A30W7), A*30:06, A*30:07 and
            A*30:08. The sequence shown is that of A*30:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..365
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
     Protein         1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /product="HLA class I histocompatibility antigen, A-30
                     alpha chain"
                     /note="MHC class I antigen A*30"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          21
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Q (in allele A*30:02, allele A*30:04 and
                     allele A*30:08). /FTId=VAR_004366."
     Region          25..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, A-30 alpha
                     chain. /FTId=PRO_0000018822."
     Region          25..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          33
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> F (in Ref. 1; AAA59612)."
     Region          33
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> Y (in allele A*30:08). /FTId=VAR_010284."
     Region          55
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in allele A*30:06). /FTId=VAR_016653."
     Region          80
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> G (in allele A*30:03). /FTId=VAR_004367."
     Region          86
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Q -> E (in allele A*30:07). /FTId=VAR_016738."
     Region          89..90
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="RN -> GK (in allele A*30:07). /FTId=VAR_016739."
     Region          89
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> G (in dbSNP:rs1059459). /FTId=VAR_056271."
     Region          94
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Q -> H (in allele A*30:02, allele A*30:03, allele
                     A*30:04, allele A*30:06 and allele A*30:07;
                     dbSNP:rs1059463). /FTId=VAR_004368."
     Region          100..101
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="VD -> EN (in allele A*30:02, allele A*30:03, allele
                     A*30:04, allele A*30:06 and allele A*30:07).
                     /FTId=VAR_004369."
     Region          101
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in dbSNP:rs1136688). /FTId=VAR_056272."
     Site            110
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          121
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> M (in dbSNP:rs1136695). /FTId=VAR_056273."
     Bond            125..188
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          129
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> P (in dbSNP:rs1136700). /FTId=VAR_056274."
     Region          131
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> W (in dbSNP:rs1136702). /FTId=VAR_056275."
     Region          133
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="F -> L (in dbSNP:rs1059488). /FTId=VAR_056276."
     Region          151
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> K (in dbSNP:rs1059509). /FTId=VAR_056277."
     Region          166
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> T (in dbSNP:rs1059516). /FTId=VAR_056278."
     Region          175..176
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="RW -> HV (in allele A*30:04 and allele A*30:06).
                     /FTId=VAR_004370."
     Region          176
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> R (in allele A*30:02, allele A*30:03 and
                     allele A*30:07). /FTId=VAR_004371."
     Region          180
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> W (in allele A*30:04 and allele A*30:06).
                     /FTId=VAR_004372."
     Region          205
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in dbSNP:rs17185861). /FTId=VAR_056279."
     Region          207..299
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          299..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mavmaprtll lllsgalalt htwagshsmr yfstsvsrpg sgeprfiavg yvddtqfvrf
       61 dsdaasqrme prapwieqer peywdqetrn vkaqsqtdrv dlgtlrgyyn qseagshtiq
      121 imygcdvgsd grflrgyeqh aydgkdyial nedlrswtaa dmaaqitqrk weaarwaeql
      181 raylegtcve wlrrylengk etlqrtdppk thmthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwel
      301 ssqptipivg iiaglvllga vitgavvaav mwrrkssdrk ggsytqaass dsaqgsdvsl
      361 tackv
//

LOCUS       DVL1L_HUMAN              670 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Segment polarity protein dishevelled homolog
            DVL-1-like; Short=Dishevelled-1-like; AltName: Full=DSH homolog
            1-like.
ACCESSION   P54792
VERSION     P54792.1  GI:1706528
DBSOURCE    UniProtKB: locus DVL1L_HUMAN, accession P54792;
            class: standard.
            created: Oct 1, 1996.
            sequence updated: Oct 1, 1996.
            annotation updated: Sep 21, 2011.
            xrefs: U46461.1, AAC50682.1
            xrefs (non-sequence databases): IPI:IPI00008404, IPI:IPI00217316,
            UniGene:Hs.74375, ProteinModelPortal:P54792, SMR:P54792,
            STRING:P54792, PRIDE:P54792, Ensembl:ENST00000378891,
            Ensembl:ENSP00000368169, Ensembl:ENSG00000107404,
            GeneCards:GC22M002861, H-InvDB:HIX0000023, HGNC:3085,
            HPA:CAB011538, MIM:601225, neXtProt:NX_P54792, HOVERGEN:HBG005542,
            OrthoDB:EOG4640BS, ArrayExpress:P54792, Bgee:P54792,
            CleanEx:HS_DVL1, Genevestigator:P54792, GermOnline:ENSG00000107404,
            GO:0004871, GO:0007507, GO:0035556, InterPro:IPR000591,
            InterPro:IPR008339, InterPro:IPR008340, InterPro:IPR003351,
            InterPro:IPR001158, InterPro:IPR015506, InterPro:IPR001478,
            InterPro:IPR011991, Gene3D:G3DSA:1.10.10.10, PANTHER:PTHR10878:SF5,
            PANTHER:PTHR10878, Pfam:PF00610, Pfam:PF02377, Pfam:PF00778,
            Pfam:PF00595, PRINTS:PR01760, PRINTS:PR01761, SMART:SM00021,
            SMART:SM00049, SMART:SM00228, SUPFAM:SSF50156, PROSITE:PS50186,
            PROSITE:PS50841, PROSITE:PS50106
KEYWORDS    Alternative splicing; Complete proteome; Cytoplasm; Developmental
            protein; Reference proteome; Wnt signaling pathway.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 670)
  AUTHORS   Pizzuti,A., Novelli,G., Mari,A., Ratti,A., Colosimo,A., Amati,F.,
            Penso,D., Sangiuolo,F., Calabrese,G., Palka,G., Silani,V.,
            Gennarelli,M., Mingarelli,R., Scarlato,G., Scambler,P. and
            Dallapiccola,B.
  TITLE     Human homologue sequences to the Drosophila dishevelled
            segment-polarity gene are deleted in the DiGeorge syndrome
  JOURNAL   Am. J. Hum. Genet. 58 (4), 722-729 (1996)
   PUBMED   8644734
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORMS LONG AND SHORT), INVOLVEMENT
            IN DIGEORGE SYNDROME, AND TISSUE SPECIFICITY.;
            TISSUE=Brain, and Sympathetic ganglion
COMMENT     [FUNCTION] May play a role in the signal transduction pathway
            mediated by multiple Wnt genes.
            [SUBCELLULAR LOCATION] Cytoplasm (Potential).
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=2; Name=Long; IsoId=P54792-1; Sequence=Displayed;
            Name=Short; IsoId=P54792-2; Sequence=VSP_001320.
            [TISSUE SPECIFICITY] Expressed in thymus, heart, liver, kidney,
            brain, skeletal muscle, and pancreas.
            [MISCELLANEOUS] May be involved in the pathogenesis of DiGeorge
            syndrome (DGS).
            [SIMILARITY] Belongs to the DSH family.
            [SIMILARITY] Contains 1 DEP domain.
            [SIMILARITY] Contains 1 DIX domain.
            [SIMILARITY] Contains 1 PDZ (DHR) domain.
FEATURES             Location/Qualifiers
     source          1..670
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..670
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
     Protein         1..670
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /product="Segment polarity protein dishevelled homolog
                     DVL-1-like"
                     /note="Dishevelled-1-like; DSH homolog 1-like"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..670
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Segment polarity protein dishevelled homolog
                     DVL-1-like. /FTId=PRO_0000145741."
     Region          1..85
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="DIX"
                     /note="DIX domain; cl02426"
                     /db_xref="CDD:198670"
     Region          1..85
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DIX."
     Region          221..224
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Compositionally biased region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Poly-Arg."
     Region          249..336
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="PDZ_signaling"
                     /note="PDZ domain found in a variety of Eumetazoan
                     signaling molecules, often in tandem arrangements. May be
                     responsible for specific protein-protein interactions, as
                     most PDZ domains bind C-terminal polypeptides, and binding
                     to internal (non-C-terminal)...; cd00992"
                     /db_xref="CDD:29049"
     Region          251..323
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="PDZ."
     Site            order(261..264,266,317..318,321..322)
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /site_type="other"
                     /note="protein binding site [polypeptide binding]"
                     /db_xref="CDD:29049"
     Region          391..474
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="DEP_dishevelled"
                     /note="DEP (Dishevelled, Egl-10, and Pleckstrin) domain
                     found in dishevelled-like proteins.  Dishevelled-like
                     proteins play a key role in the transduction of the Wnt
                     signal from the cell surface to the nucleus, which in turn
                     is an important regulatory pathway...; cd04438"
                     /db_xref="CDD:80321"
     Region          400..474
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="DEP."
     Region          478..660
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Dsh_C"
                     /note="Segment polarity protein dishevelled (Dsh) C
                     terminal; pfam12316"
                     /db_xref="CDD:152751"
     Region          479..486
                     /gene="DVL1L1"
                     /gene_synonym="DVL"
                     /gene_synonym="DVL1"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in isoform Short). /FTId=VSP_001320."
ORIGIN      
        1 maetkiiyhm deeetpylvk lpvapervtl adfknvlsnr pvhaykfffk smdqdfgvvk
       61 eeifddnakl pcfngrvvsw lvlvegahsd agsqgtdsht dlppplertg gigdsrspsf
      121 qpdvassrdg mdnetgtesm vshrrdrarr rnreeaartn ghprgdrrrd vglppdsast
      181 alsselesss fvdsdeddst srlsssteqs tssrlirkhk rrrrkqrlrq adrassfssm
      241 tdstmslnii tvtlnmerhh flgicivgqs ndrgdggiyi gsimkggava adgriepgdm
      301 llqvndvnfe nmsnddavrv lreivsqtgp isltvakcwd ptprsyftvp rpdpvrpidp
      361 aawlshtaal tgalprpqle eapltvesdm ntvvrvmqlp dsgleirdrm wlkitianav
      421 igadvvdwly thvegfkerr earkyassll khgflrhtvn kitfseqcyy vfgdlcsnla
      481 tlnlnsgssg tsdqdtlapl phpaapwplg qgypyqypgp ppcfppayqd pgfsygsgst
      541 gsqqsegsks sgstrntlrp pacekerraa gsgdsdsesd htapsgvgss wrerpadqls
      601 rgssprsqas syapglppph pttkaytvvg gppggppvre laavppeltg srqsfqkamg
      661 npceffvdim
//

LOCUS       ADAM8_HUMAN              824 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Disintegrin and metalloproteinase domain-containing
            protein 8; Short=ADAM 8; AltName: Full=Cell surface antigen MS2;
            AltName: CD_antigen=CD156a; Flags: Precursor.
ACCESSION   P78325
VERSION     P78325.1  GI:2499914
DBSOURCE    UniProtKB: locus ADAM8_HUMAN, accession P78325;
            class: standard.
            created: Nov 1, 1997.
            sequence updated: May 1, 1997.
            annotation updated: Sep 21, 2011.
            xrefs: D26579.1, BAA05626.1
            xrefs (non-sequence databases): IPI:IPI00019158, UniGene:Hs.501574,
            ProteinModelPortal:P78325, SMR:P78325, IntAct:P78325,
            STRING:P78325, MEROPS:M12.208, PhosphoSite:P78325, PRIDE:P78325,
            GeneCards:GC10M128622, H-InvDB:HIX0035404, HGNC:215, MIM:602267,
            neXtProt:NX_P78325, eggNOG:prNOG15149, HOVERGEN:HBG006978,
            InParanoid:P78325, NextBio:381, ArrayExpress:P78325,
            CleanEx:HS_ADAM8, Genevestigator:P78325,
            GermOnline:ENSG00000151651, GO:0071133, GO:0009986, GO:0032127,
            GO:0005887, GO:0032010, GO:0002102, GO:0042581, GO:0070820,
            GO:0005509, GO:0050839, GO:0004222, GO:0043621, GO:0008270,
            GO:0035419, GO:0001525, GO:0000902, GO:0071456, GO:0002523,
            GO:0048247, GO:0043524, GO:0002675, GO:0045780, GO:0045785,
            GO:0002693, GO:0051044, GO:0051092, GO:0051897, GO:0010954,
            GO:0033089, GO:0070245, GO:2000309, GO:0006508, GO:0022407,
            InterPro:IPR006586, InterPro:IPR001762, InterPro:IPR018358,
            InterPro:IPR006210, InterPro:IPR013032, InterPro:IPR000742,
            InterPro:IPR024079, InterPro:IPR001590, InterPro:IPR002870,
            Gene3D:G3DSA:4.10.70.10, Gene3D:G3DSA:3.40.390.10, Pfam:PF08516,
            Pfam:PF00200, Pfam:PF01562, Pfam:PF01421, PRINTS:PR00289,
            SMART:SM00608, SMART:SM00050, SMART:SM00181, SUPFAM:SSF57552,
            PROSITE:PS50215, PROSITE:PS00427, PROSITE:PS50214, PROSITE:PS00022,
            PROSITE:PS01186, PROSITE:PS50026, PROSITE:PS00142
KEYWORDS    Complete proteome; Disulfide bond; EGF-like domain; Glycoprotein;
            Hydrolase; Membrane; Metal-binding; Metalloprotease; Polymorphism;
            Protease; Reference proteome; Signal; Transmembrane; Transmembrane
            helix; Zinc.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 824)
  AUTHORS   Yoshiyama,K., Higuchi,Y., Kataoka,M., Matsuura,K. and Yamamoto,S.
  TITLE     CD156 (human ADAM8): expression, primary amino acid sequence, and
            gene location
  JOURNAL   Genomics 41 (1), 56-62 (1997)
   PUBMED   9126482
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Blood
REFERENCE   2  (residues 1 to 824)
  AUTHORS   Bartholin,L., Destaing,O., Forissier,S., Martel,S.,
            Maguer-Satta,V., Jurdic,P. and Rimokh,R.
  TITLE     FLRG, a new ADAM12-associated protein, modulates osteoclast
            differentiation
  JOURNAL   Biol. Cell 97 (7), 577-588 (2005)
   PUBMED   15574124
  REMARK    INTERACTION WITH FST3.
COMMENT     [FUNCTION] Possible involvement in extravasation of leukocytes.
            [COFACTOR] Binds 1 zinc ion per subunit (Probable).
            [SUBUNIT] Interacts with FST3.
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [TISSUE SPECIFICITY] Expressed on neutrophils and monocytes.
            [SIMILARITY] Contains 1 disintegrin domain.
            [SIMILARITY] Contains 1 EGF-like domain.
            [SIMILARITY] Contains 1 peptidase M12B domain.
FEATURES             Location/Qualifiers
     source          1..824
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..824
                     /gene="ADAM8"
                     /gene_synonym="MS2"
     Protein         1..824
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /product="Disintegrin and metalloproteinase
                     domain-containing protein 8"
                     /EC_number="3.4.24.-"
                     /note="ADAM 8; Cell surface antigen MS2"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..16
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Region          17..824
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Disintegrin and metalloproteinase domain-containing
                     protein 8. /FTId=PRO_0000029060."
     Region          17..655
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          53..155
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Pep_M12B_propep"
                     /note="Reprolysin family propeptide; pfam01562"
                     /db_xref="CDD:190038"
     Site            67
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Site            91
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          101
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> R (in dbSNP:rs11101675). /FTId=VAR_059760."
     Region          189
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> W (in dbSNP:rs45451297). /FTId=VAR_061735."
     Region          200..400
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Peptidase M12B."
     Region          200..398
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="ZnMc_adamalysin_II_like"
                     /note="Zinc-dependent metalloprotease; adamalysin_II_like
                     subfamily. Adamalysin II is a snake venom zinc
                     endopeptidase. This subfamily contains other snake venom
                     metalloproteinases, as well as membrane-anchored
                     metalloproteases belonging to the ADAM family...; cd04269"
                     /db_xref="CDD:58570"
     Bond            310..395
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(334..335,338,344)
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="active"
                     /db_xref="CDD:58570"
     Site            334
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="metal-binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Zinc; catalytic (Probable)."
     Site            335
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            338
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="metal-binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Zinc; catalytic (Probable)."
     Site            344
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="metal-binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Zinc; catalytic (Probable)."
     Bond            351..379
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            353..362
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          408..494
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Disintegrin."
     Region          417..491
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Disintegrin"
                     /note="Disintegrin; cl10507"
                     /db_xref="CDD:198991"
     Region          433
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> C (in dbSNP:rs12257830). /FTId=VAR_061736."
     Site            436
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            466..486
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          494..605
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="TSP_1"
                     /note="Thrombospondin type 1 domain; cl15278"
                     /db_xref="CDD:199136"
     Site            612
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            613..623
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            617..629
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            631..640
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          656..676
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          677..824
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          775
                     /gene="ADAM8"
                     /gene_synonym="MS2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> T (in dbSNP:rs3008319). /FTId=VAR_061737."
ORIGIN      
        1 mrglglwllg ammlpaiaps rpwalmeqye vvlprrlpgp rvrralpshl glhpervsyv
       61 lgatghnftl hlrknrdllg sgytetytaa ngsevteqpr gqdhclyqgh vegypdsaas
      121 lstcaglrgf fqvgsdlhli epldeggegg rhavyqaehl lqtagtcgvs ddslgsllgp
      181 rtaavfrprp gdslpsretr yvelyvvvdn aefqmlgsea avrhrvlevv nhvdklyqkl
      241 nfrvvlvgle iwnsqdrfhv spdpsvtlen lltwqarqrt rrhlhdnvql itgvdftgtt
      301 vgfarvsamc shssgavnqd hsknpvgvac tmahemghnl gmdhdenvqg crcqerfeag
      361 rcimagsigs sfprmfsdcs qaylesfler pqsvclanap dlshlvggpv cgnlfverge
      421 qcdcgppedc rnrccnsttc qlaegaqcah gtccqeckvk pagelcrpkk dmcdleefcd
      481 grhpecpeda fqengtpcsg gycyngacpt laqqcqafwg pggqaaeesc fsydilpgck
      541 asryradmcg vlqckggqqp lgraicivdv chalttedgt ayepvpegtr cgpekvcwkg
      601 rcqdlhvyrs sncsaqchnh gvcnhkqech chagwapphc aklltevhaa sgslpvlvvv
      661 vlvllavvlv tlagiivyrk arsrilsrnv apkttmgrsn plfhqaasrv pakggapaps
      721 rgpqelvptt hpgqparhpa ssvalkrppp appvtvsspp fpvpvytrqa pkqvikptfa
      781 ppvppvkpga gaanpgpaeg avgpkvalkp piqrkqgaga ptap
//

LOCUS       KI3S1_HUMAN              387 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Killer cell immunoglobulin-like receptor 3DS1;
            AltName: Full=MHC class I NK cell receptor; AltName: Full=Natural
            killer-associated transcript 10; Short=NKAT-10; Flags: Precursor.
ACCESSION   Q14943
VERSION     Q14943.1  GI:2833258
DBSOURCE    UniProtKB: locus KI3S1_HUMAN, accession Q14943;
            class: standard.
            created: Nov 1, 1997.
            sequence updated: Nov 1, 1996.
            annotation updated: Sep 21, 2011.
            xrefs: L76661.1, AAB36589.1
            xrefs (non-sequence databases): IPI:IPI00745311, UniGene:Hs.683173,
            ProteinModelPortal:Q14943, SMR:Q14943, STRING:Q14943, PRIDE:Q14943,
            Ensembl:ENST00000400848, Ensembl:ENSP00000383646,
            Ensembl:ENSG00000215764, GeneCards:GC19P9I0074, H-InvDB:HIX0040485,
            HGNC:6340, MIM:604946, neXtProt:NX_Q14943, HOVERGEN:HBG074353,
            InParanoid:Q14943, ArrayExpress:Q14943, Bgee:Q14943,
            CleanEx:HS_KIR3DS1, Genevestigator:Q14943,
            GermOnline:ENSG00000167633, GO:0005887, GO:0032393, GO:0006955,
            GO:0030101, InterPro:IPR013783, InterPro:IPR003599,
            InterPro:IPR013151, Gene3D:G3DSA:2.60.40.10, Pfam:PF00047,
            SMART:SM00409, PROSITE:PS50835
KEYWORDS    Cell membrane; Complete proteome; Disulfide bond; Glycoprotein;
            Immunoglobulin domain; Membrane; Polymorphism; Receptor; Reference
            proteome; Repeat; Signal; Transmembrane; Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 387)
  AUTHORS   Dohring,C., Samaridis,J. and Colonna,M.
  TITLE     Alternatively spliced forms of human killer inhibitory receptors
  JOURNAL   Immunogenetics 44 (3), 227-230 (1996)
   PUBMED   8662091
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   2  (residues 1 to 387)
  AUTHORS   Uhrberg,M., Valiante,N.M., Shum,B.P., Shilling,H.G.,
            Lienert-Weidenbach,K., Corliss,B., Tyan,D., Lanier,L.L. and
            Parham,P.
  TITLE     Human diversity in killer cell inhibitory receptor genes
  JOURNAL   Immunity 7 (6), 753-763 (1997)
   PUBMED   9430221
  REMARK    VARIANT HIS-166.
COMMENT     [FUNCTION] Receptor on natural killer (NK) cells for HLA-C alleles.
            Does not inhibit the activity of NK cells.
            [SUBCELLULAR LOCATION] Cell membrane; Single-pass type I membrane
            protein.
            [TISSUE SPECIFICITY] Expressed in NK and T-cell lines but not in
            B-lymphoblastoid cell lines or in a colon carcinoma cell line.
            [POLYMORPHISM] The KIR genes are located in a segment of DNA on
            19q13.4 in the leukocyte receptor complex that has undergone
            expansion and contraction over time, probably through unequal
            crossing-over. Thus, KIR haplotypes vary in the number and types of
            genes, although a few framework loci, such as the gene KIR3DL1, are
            present on all or nearly all haplotypes. KIR3DL1 and KIR3DS1
            segregate as alleles of the locus KIR3DL1/3DS1.
            [SIMILARITY] Belongs to the immunoglobulin superfamily.
            [SIMILARITY] Contains 3 Ig-like C2-type (immunoglobulin-like)
            domains.
FEATURES             Location/Qualifiers
     source          1..387
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..387
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
     Protein         1..387
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /product="Killer cell immunoglobulin-like receptor 3DS1"
                     /note="MHC class I NK cell receptor; Natural
                     killer-associated transcript 10; NKAT-10"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..21
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Signal"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          2
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> L (in dbSNP:rs605219). /FTId=VAR_056093."
     Region          22..387
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Killer cell immunoglobulin-like receptor 3DS1.
                     /FTId=PRO_0000015092."
     Region          22..340
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          28..117
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Ig_FcalphaRI"
                     /note="Immunoglobulin (IG)-like domain of of FcalphaRI;
                     cd05711"
                     /db_xref="CDD:143188"
     Site            order(30,33,111,117)
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="other"
                     /note="homodimer interface [polypeptide binding]"
                     /db_xref="CDD:143188"
     Region          42..102
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type 1."
     Bond            49..95
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(56,67,69,98)
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="other"
                     /note="IgA interface [polypeptide binding]"
                     /db_xref="CDD:143188"
     Region          68
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs45556431). /FTId=VAR_056094."
     Site            92
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          123..217
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Ig_FcalphaRI"
                     /note="Immunoglobulin (IG)-like domain of of FcalphaRI;
                     cd05711"
                     /db_xref="CDD:143188"
     Site            order(125,128,211,217)
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="other"
                     /note="homodimer interface [polypeptide binding]"
                     /db_xref="CDD:143188"
     Region          137..202
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type 2."
     Bond            144..195
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(151,166,168,198)
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="other"
                     /note="IgA interface [polypeptide binding]"
                     /db_xref="CDD:143188"
     Region          166
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H. /FTId=VAR_010377."
     Site            179
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          203
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> S (in dbSNP:rs2273731). /FTId=VAR_056095."
     Region          220
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> P (in dbSNP:rs680891). /FTId=VAR_056096."
     Region          223..311
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Ig"
                     /note="Immunoglobulin domain; cl11960"
                     /db_xref="CDD:199062"
     Region          237..300
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type 3."
     Bond            244..293
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          259
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="G -> R (in dbSNP:rs1049215). /FTId=VAR_056097."
     Site            273
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          341..360
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          361..387
                     /gene="KIR3DS1"
                     /gene_synonym="NKAT10"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mslmvvsmac vglflvqrag phmggqdkpf lsawpsavvp rgghvtlrch yrhrfnnfml
       61 ykedrihvpi fhgrifqegf nmspvttaha gnytcrgshp hsptgwsaps npmvimvtgn
      121 hrkpsllahp gplvksgerv ilqcwsdimf ehfflhkewi skdpsrlvgq ihdgvskanf
      181 sigsmmrala gtyrcygsvt htpyqlsaps dpldivvtgl yekpslsaqp gpkvqagesv
      241 tlscssrssy dmyhlsregg aherrlpavr kvnrtfqadf plgpathggt yrcfgsfrhs
      301 pyewsdpsdp llvsvtgnps sswpspteps sksgnlrhlh iligtsvvki pftillffll
      361 hrwcsnkkna avmdqepagn rseqrgf
//

LOCUS       K0087_HUMAN              138 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Uncharacterized protein KIAA0087.
ACCESSION   Q14695
VERSION     Q14695.1  GI:3183214
DBSOURCE    UniProtKB: locus K0087_HUMAN, accession Q14695;
            class: standard.
            extra accessions:A1A524,Q75MW1
            created: Jul 15, 1998.
            sequence updated: Nov 1, 1996.
            annotation updated: Sep 21, 2011.
            xrefs: D42038.1, BAA07639.2, AC004947.2, AAQ96877.1, CH236948.1,
            EAL24233.1, CH471073.1, EAW93856.1
            xrefs (non-sequence databases): IPI:IPI00032390, UniGene:Hs.69749,
            IntAct:Q14695, MINT:MINT-1375938, PhosphoSite:Q14695, PRIDE:Q14695,
            Ensembl:ENST00000242109, Ensembl:ENSP00000242109,
            Ensembl:ENSG00000122548, GeneCards:GC07M026541, HGNC:22191,
            HPA:HPA019750, neXtProt:NX_Q14695, eggNOG:prNOG21557,
            GeneTree:ENSGT00390000009854, InParanoid:Q14695, OrthoDB:EOG47M20K,
            Bgee:Q14695, CleanEx:HS_KIAA0087, Genevestigator:Q14695,
            GermOnline:ENSG00000122548
KEYWORDS    Complete proteome; Phosphoprotein; Polymorphism; Reference
            proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 138)
  AUTHORS   Nagase,T., Miyajima,N., Tanaka,A., Sazuka,T., Seki,N., Sato,S.,
            Tabata,S., Ishikawa,K., Kawarabayasi,Y., Kotani,H. and Nomura,N.
  TITLE     Prediction of the coding sequences of unidentified human genes.
            III. The coding sequences of 40 new genes (KIAA0081-KIAA0120)
            deduced by analysis of cDNA clones from human cell line KG-1
  JOURNAL   DNA Res. 2 (1), 37-43 (1995)
   PUBMED   7788527
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Bone marrow
REFERENCE   2  (residues 1 to 138)
  AUTHORS   Hillier,L.W., Fulton,R.S., Fulton,L.A., Graves,T.A., Pepin,K.H.,
            Wagner-McPherson,C., Layman,D., Maas,J., Jaeger,S., Walker,R.,
            Wylie,K., Sekhon,M., Becker,M.C., O'Laughlin,M.D., Schaller,M.E.,
            Fewell,G.A., Delehaunty,K.D., Miner,T.L., Nash,W.E., Cordes,M.,
            Du,H., Sun,H., Edwards,J., Bradshaw-Cordum,H., Ali,J., Andrews,S.,
            Isak,A., Vanbrunt,A., Nguyen,C., Du,F., Lamar,B., Courtney,L.,
            Kalicki,J., Ozersky,P., Bielicki,L., Scott,K., Holmes,A.,
            Harkins,R., Harris,A., Strong,C.M., Hou,S., Tomlinson,C.,
            Dauphin-Kohlberg,S., Kozlowicz-Reilly,A., Leonard,S., Rohlfing,T.,
            Rock,S.M., Tin-Wollam,A.M., Abbott,A., Minx,P., Maupin,R.,
            Strowmatt,C., Latreille,P., Miller,N., Johnson,D., Murray,J.,
            Woessner,J.P., Wendl,M.C., Yang,S.P., Schultz,B.R., Wallis,J.W.,
            Spieth,J., Bieri,T.A., Nelson,J.O., Berkowicz,N., Wohldmann,P.E.,
            Cook,L.L., Hickenbotham,M.T., Eldred,J., Williams,D., Bedell,J.A.,
            Mardis,E.R., Clifton,S.W., Chissoe,S.L., Marra,M.A., Raymond,C.,
            Haugen,E., Gillett,W., Zhou,Y., James,R., Phelps,K., Iadanoto,S.,
            Bubb,K., Simms,E., Levy,R., Clendenning,J., Kaul,R., Kent,W.J.,
            Furey,T.S., Baertsch,R.A., Brent,M.R., Keibler,E., Flicek,P.,
            Bork,P., Suyama,M., Bailey,J.A., Portnoy,M.E., Torrents,D.,
            Chinwalla,A.T., Gish,W.R., Eddy,S.R., McPherson,J.D., Olson,M.V.,
            Eichler,E.E., Green,E.D., Waterston,R.H. and Wilson,R.K.
  TITLE     The DNA sequence of human chromosome 7
  JOURNAL   Nature 424 (6945), 157-164 (2003)
   PUBMED   12853948
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA], AND VARIANT ASN-85.
REFERENCE   3  (residues 1 to 138)
  AUTHORS   Scherer,S.W., Cheung,J., MacDonald,J.R., Osborne,L.R.,
            Nakabayashi,K., Herbrick,J.A., Carson,A.R., Parker-Katiraee,L.,
            Skaug,J., Khaja,R., Zhang,J., Hudek,A.K., Li,M., Haddad,M.,
            Duggan,G.E., Fernandez,B.A., Kanematsu,E., Gentles,S.,
            Christopoulos,C.C., Choufani,S., Kwasnicka,D., Zheng,X.H., Lai,Z.,
            Nusskern,D., Zhang,Q., Gu,Z., Lu,F., Zeesman,S., Nowaczyk,M.J.,
            Teshima,I., Chitayat,D., Shuman,C., Weksberg,R., Zackai,E.H.,
            Grebe,T.A., Cox,S.R., Kirkpatrick,S.J., Rahman,N., Friedman,J.M.,
            Heng,H.H., Pelicci,P.G., Lo-Coco,F., Belloni,E., Shaffer,L.G.,
            Pober,B., Morton,C.C., Gusella,J.F., Bruns,G.A., Korf,B.R.,
            Quade,B.J., Ligon,A.H., Ferguson,H., Higgins,A.W., Leach,N.T.,
            Herrick,S.R., Lemyre,E., Farra,C.G., Kim,H.G., Summers,A.M.,
            Gripp,K.W., Roberts,W., Szatmari,P., Winsor,E.J., Grzeschik,K.H.,
            Teebi,A., Minassian,B.A., Kere,J., Armengol,L., Pujana,M.A.,
            Estivill,X., Wilson,M.D., Koop,B.F., Tosi,S., Moore,G.E.,
            Boright,A.P., Zlotorynski,E., Kerem,B., Kroisel,P.M., Petek,E.,
            Oscier,D.G., Mould,S.J., Dohner,H., Dohner,K., Rommens,J.M.,
            Vincent,J.B., Venter,J.C., Li,P.W., Mural,R.J., Adams,M.D. and
            Tsui,L.C.
  TITLE     Human chromosome 7: DNA sequence and biology
  JOURNAL   Science 300 (5620), 767-772 (2003)
   PUBMED   12690205
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   4  (residues 1 to 138)
  AUTHORS   Mural,R.J., Istrail,S., Sutton,G.G., Florea,L., Halpern,A.L.,
            Mobarry,C.M., Lippert,R., Walenz,B., Shatkay,H., Dew,I.,
            Miller,J.R., Flanigan,M.J., Edwards,N.J., Bolanos,R., Fasulo,D.,
            Halldorsson,B.V., Hannenhalli,S., Turner,R., Yooseph,S., Lu,F.,
            Nusskern,D.R., Shue,B.C., Zheng,X.H., Zhong,F., Delcher,A.L.,
            Huson,D.H., Kravitz,S.A., Mouchard,L., Reinert,K., Remington,K.A.,
            Clark,A.G., Waterman,M.S., Eichler,E.E., Adams,M.D.,
            Hunkapiller,M.W., Myers,E.W. and Venter,J.C.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-2005)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   5  (residues 1 to 138)
  AUTHORS   Matsuoka,S., Ballif,B.A., Smogorzewska,A., McDonald,E.R. III,
            Hurov,K.E., Luo,J., Bakalarski,C.E., Zhao,Z., Solimini,N.,
            Lerenthal,Y., Shiloh,Y., Gygi,S.P. and Elledge,S.J.
  TITLE     ATM and ATR substrate analysis reveals extensive protein networks
            responsive to DNA damage
  JOURNAL   Science 316 (5828), 1160-1166 (2007)
   PUBMED   17525332
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-6 AND SER-7, AND MASS
            SPECTROMETRY.;
            TISSUE=Embryonic kidney
COMMENT     On Sep 23, 2008 this sequence version replaced gi:74712879.
            [PTM] Phosphorylated upon DNA damage, probably by ATM or ATR.
            [SEQUENCE CAUTION] Sequence=BAA07639.2; Type=Erroneous initiation.
FEATURES             Location/Qualifiers
     source          1..138
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..138
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
     Protein         1..138
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
                     /product="Uncharacterized protein KIAA0087"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..138
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Uncharacterized protein KIAA0087.
                     /FTId=PRO_0000050719."
     Site            6
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Site            7
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Region          85
                     /gene="KIAA0087"
                     /locus_tag="HA1002"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> N (in dbSNP:rs740182). /FTId=VAR_044539."
ORIGIN      
        1 meawessqpl lrceipcplp gtdrdgsvsl pgeaascdld tlepehgnrr vsgnpisvcw
       61 aykvtkvkcw svrerggrhi ggprstlkhp ahhgmgknla tslptaaslg lgkgqllvsi
      121 rfmdttkkrg qsetfnic
//

LOCUS       PGRC2_HUMAN              223 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Membrane-associated progesterone receptor component
            2; AltName: Full=Progesterone membrane-binding protein; AltName:
            Full=Steroid receptor protein DG6.
ACCESSION   O15173
VERSION     O15173.1  GI:6647832
DBSOURCE    UniProtKB: locus PGRC2_HUMAN, accession O15173;
            class: standard.
            extra accessions:Q569H1
            created: May 30, 2000.
            sequence updated: Jan 1, 1998.
            annotation updated: Sep 21, 2011.
            xrefs: AJ002030.1, CAA05152.1, DQ496105.1, ABF47094.1, BC016692.1,
            AAH16692.1, BC092478.1, AAH92478.1
            xrefs (non-sequence databases): IPI:IPI01015100, UniGene:Hs.507910,
            ProteinModelPortal:O15173, SMR:O15173, STRING:O15173,
            PhosphoSite:O15173, PRIDE:O15173, Ensembl:ENST00000296425,
            Ensembl:ENSP00000296425, Ensembl:ENSG00000164040, UCSC:uc003igg.1,
            GeneCards:GC04M124921, H-InvDB:HIX0004497, HGNC:16089, MIM:607735,
            neXtProt:NX_O15173, eggNOG:prNOG14486,
            GeneTree:ENSGT00530000063049, HOGENOM:HBG715794,
            HOVERGEN:HBG059971, InParanoid:O15173, OrthoDB:EOG4SXNDQ,
            PhylomeDB:O15173, NextBio:39508, ArrayExpress:O15173, Bgee:O15173,
            CleanEx:HS_PGRMC2, Genevestigator:O15173,
            GermOnline:ENSG00000164040, GO:0016021, GO:0020037, GO:0005496,
            GO:0003707, InterPro:IPR001199, Gene3D:G3DSA:3.10.120.10,
            Pfam:PF00173, SUPFAM:SSF55856, PROSITE:PS00191, PROSITE:PS50255
KEYWORDS    Complete proteome; Lipid-binding; Membrane; Phosphoprotein;
            Receptor; Reference proteome; Steroid-binding; Transmembrane;
            Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 223)
  AUTHORS   Gerdes,D., Wehling,M., Leube,B. and Falkenstein,E.
  TITLE     Cloning and tissue expression of two putative steroid membrane
            receptors
  JOURNAL   Biol. Chem. 379 (7), 907-911 (1998)
   PUBMED   9705155
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Liver
REFERENCE   2  (residues 1 to 223)
  CONSRTM   NIEHS SNPs program
  TITLE     Direct Submission
  JOURNAL   Submitted (??-APR-2006)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   3  (residues 1 to 223)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Kidney, and Testis
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   4  (residues 1 to 223)
  AUTHORS   Olsen,J.V., Blagoev,B., Gnad,F., Macek,B., Kumar,C., Mortensen,P.
            and Mann,M.
  TITLE     Global, in vivo, and site-specific phosphorylation dynamics in
            signaling networks
  JOURNAL   Cell 127 (3), 635-648 (2006)
   PUBMED   17081983
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-90, AND MASS
            SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   5  (residues 1 to 223)
  AUTHORS   Daub,H., Olsen,J.V., Bairlein,M., Gnad,F., Oppermann,F.S.,
            Korner,R., Greff,Z., Keri,G., Stemmann,O. and Mann,M.
  TITLE     Kinase-selective enrichment enables quantitative phosphoproteomics
            of the kinome across the cell cycle
  JOURNAL   Mol. Cell 31 (3), 438-448 (2008)
   PUBMED   18691976
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-90 AND THR-211, AND
            MASS SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   6  (residues 1 to 223)
  AUTHORS   Dephoure,N., Zhou,C., Villen,J., Beausoleil,S.A., Bakalarski,C.E.,
            Elledge,S.J. and Gygi,S.P.
  TITLE     A quantitative atlas of mitotic phosphorylation
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 105 (31), 10762-10767 (2008)
   PUBMED   18669648
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT TYR-210 AND THR-211, AND
            MASS SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   7  (residues 1 to 223)
  AUTHORS   Han,G., Ye,M., Zhou,H., Jiang,X., Feng,S., Jiang,X., Tian,R.,
            Wan,D., Zou,H. and Gu,J.
  TITLE     Large-scale phosphoproteome analysis of human liver tissue by
            enrichment and fractionation of phosphopeptides with strong anion
            exchange chromatography
  JOURNAL   Proteomics 8 (7), 1346-1361 (2008)
   PUBMED   18318008
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-208 AND THR-211, AND
            MASS SPECTROMETRY.;
            TISSUE=Liver
REFERENCE   8  (residues 1 to 223)
  AUTHORS   Gauci,S., Helbig,A.O., Slijper,M., Krijgsveld,J., Heck,A.J. and
            Mohammed,S.
  TITLE     Lys-N and trypsin cover complementary parts of the phosphoproteome
            in a refined SCX-based approach
  JOURNAL   Anal. Chem. 81 (11), 4493-4501 (2009)
   PUBMED   19413330
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT THR-211, AND MASS
            SPECTROMETRY.;
            TISSUE=Embryonic kidney
REFERENCE   9  (residues 1 to 223)
  AUTHORS   Oppermann,F.S., Gnad,F., Olsen,J.V., Hornberger,R., Greff,Z.,
            Keri,G., Mann,M. and Daub,H.
  TITLE     Large-scale proteomics analysis of the human kinome
  JOURNAL   Mol. Cell Proteomics 8 (7), 1751-1764 (2009)
   PUBMED   19369195
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-90; SER-208 AND
            TYR-210, AND MASS SPECTROMETRY.
REFERENCE   10 (residues 1 to 223)
  AUTHORS   Mayya,V., Lundgren,D.H., Hwang,S.I., Rezaul,K., Wu,L., Eng,J.K.,
            Rodionov,V. and Han,D.K.
  TITLE     Quantitative phosphoproteomic analysis of T cell receptor signaling
            reveals system-wide modulation of protein-protein interactions
  JOURNAL   Sci Signal 2 (84), RA46 (2009)
   PUBMED   19690332
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-90, AND MASS
            SPECTROMETRY.;
            TISSUE=Leukemic T-cell
            Publication Status: Online-Only
REFERENCE   11 (residues 1 to 223)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
COMMENT     On Jun 13, 2006 this sequence version replaced gi:74755074.
            [FUNCTION] Receptor for steroids (Potential).
            [SUBCELLULAR LOCATION] Membrane; Single-pass membrane protein
            (Potential).
            [DOMAIN] The cytochrome b5 heme-binding domain lacks the conserved
            iron-binding His residues at positions 137 and 161 (By similarity).
            [SIMILARITY] Belongs to the cytochrome b5 family. MAPR subfamily.
            [SIMILARITY] Contains 1 cytochrome b5 heme-binding domain.
FEATURES             Location/Qualifiers
     source          1..223
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..223
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
     Protein         1..223
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /product="Membrane-associated progesterone receptor
                     component 2"
                     /note="Progesterone membrane-binding protein; Steroid
                     receptor protein DG6"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..223
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Membrane-associated progesterone receptor component
                     2. /FTId=PRO_0000121743."
     Region          42..66
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Site            90
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Region          102..201
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Cytochrome b5 heme-binding."
     Region          103..200
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /region_name="Cyt-b5"
                     /note="Cytochrome b5-like Heme/Steroid binding domain;
                     cl02041"
                     /db_xref="CDD:154719"
     Site            104
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /site_type="modified"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Phosphoserine (By similarity)."
     Site            208
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Site            210
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphotyrosine."
     Site            211
                     /gene="PGRMC2"
                     /gene_synonym="DG6"
                     /gene_synonym="PMBP"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphothreonine."
ORIGIN      
        1 maagdgdvkl gtlgsgsess ndggsespgd agaaaegggw aaaalalltg ggemllnval
       61 valvllgayr lwvrwgrrgl gagagagees patslprmkk rdfsleqlrq ydgsrnpril
      121 lavngkvfdv tkgskfygpa gpygifagrd asrglatfcl dkdalrdeyd dlsdlnavqm
      181 esvrewemqf kekydyvgrl lkpgeepsey tdeedtkdhn kqd
//

LOCUS       TCL6_HUMAN               141 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Putative T-cell leukemia/lymphoma protein 6; AltName:
            Full=TCL1 neighboring gene 1 protein.
ACCESSION   P56846
VERSION     P56846.1  GI:6831703
DBSOURCE    UniProtKB: locus TCL6_HUMAN, accession P56846;
            class: standard.
            extra accessions:Q7LG61
            created: May 30, 2000.
            sequence updated: May 30, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AF195820.1, AAF07203.1, AB035332.1, BAA96371.1, AB035333.1,
            BAA96372.1, AB035334.1, BAA96373.1, AB035340.1, BAA96377.1,
            AB035341.1, BAA96379.1, CH471061.1, EAW81610.1, BC041075.1,
            AAH41075.1
            xrefs (non-sequence databases): IPI:IPI00011583, UniGene:Hs.510368,
            ProteinModelPortal:P56846, STRING:P56846, PhosphoSite:P56846,
            PRIDE:P56846, UCSC:uc001yes.1, GeneCards:GC14P076303, HGNC:13463,
            MIM:604412, neXtProt:NX_P56846, NextBio:49492, ArrayExpress:P56846,
            CleanEx:HS_TCL6, Genevestigator:P56846, GermOnline:ENSG00000187621
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 141)
  AUTHORS   Hallas,C., Pekarsky,Y., Itoyama,T., Varnum,J., Bichi,R.,
            Rothstein,J.L. and Croce,C.M.
  TITLE     Genomic analysis of human and mouse TCL1 loci reveals a complex of
            tightly clustered genes
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 96 (25), 14418-14423 (1999)
   PUBMED   10588720
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   2  (residues 1 to 141)
  AUTHORS   Saitou,M., Sugimoto,J., Hatakeyama,T., Russo,G. and Isobe,M.
  TITLE     Identification of the TCL6 genes within the breakpoint cluster
            region on chromosome 14q32 in T-cell leukemia
  JOURNAL   Oncogene 19 (23), 2796-2802 (2000)
   PUBMED   10851082
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Placenta
REFERENCE   3  (residues 1 to 141)
  AUTHORS   Mural,R.J., Istrail,S., Sutton,G.G., Florea,L., Halpern,A.L.,
            Mobarry,C.M., Lippert,R., Walenz,B., Shatkay,H., Dew,I.,
            Miller,J.R., Flanigan,M.J., Edwards,N.J., Bolanos,R., Fasulo,D.,
            Halldorsson,B.V., Hannenhalli,S., Turner,R., Yooseph,S., Lu,F.,
            Nusskern,D.R., Shue,B.C., Zheng,X.H., Zhong,F., Delcher,A.L.,
            Huson,D.H., Kravitz,S.A., Mouchard,L., Reinert,K., Remington,K.A.,
            Clark,A.G., Waterman,M.S., Eichler,E.E., Adams,M.D.,
            Hunkapiller,M.W., Myers,E.W. and Venter,J.C.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-2005)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   4  (residues 1 to 141)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Lymph
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
COMMENT     On May 6, 2009 this sequence version replaced gi:74738919.
            [TISSUE SPECIFICITY] Expressed in many tissues.
            [MISCELLANEOUS] Activated in T-cell leukemias (T-CLL) with
            rearrangements at 14q32.1.
            [CAUTION] Product of a dubious CDS prediction. Probable non-coding
            RNA.
FEATURES             Location/Qualifiers
     source          1..141
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..141
                     /gene="TCL6"
                     /gene_synonym="TNG1"
                     /gene_synonym="TNG2"
     Protein         1..141
                     /gene="TCL6"
                     /gene_synonym="TNG1"
                     /gene_synonym="TNG2"
                     /product="Putative T-cell leukemia/lymphoma protein 6"
                     /note="TCL1 neighboring gene 1 protein"
                     /UniProtKB_evidence="Uncertain"
     Region          1..141
                     /gene="TCL6"
                     /gene_synonym="TNG1"
                     /gene_synonym="TNG2"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Putative T-cell leukemia/lymphoma protein 6.
                     /FTId=PRO_0000072451."
ORIGIN      
        1 meprvtqrkr pldgcmgkit gitsdilkyd hkcfklslpa kfpevcgsde vfpdpdllhv
       61 lpvagslqqs idqcclqles lcrpgllcah ptllfklhss mknrpffsli ytyvkktqqv
      121 rkrdrkprgq vaagpnptsv m
//

LOCUS       L3R2A_HUMAN               94 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Putative uncharacterized protein encoded by
            NCRNA00312; AltName: Full=Loss of heterozygosity 3 chromosomal
            region 2 gene A protein.
ACCESSION   Q9Y6C7
VERSION     Q9Y6C7.1  GI:7531163
DBSOURCE    UniProtKB: locus L3R2A_HUMAN, accession Q9Y6C7;
            class: standard.
            created: May 30, 2000.
            sequence updated: Nov 1, 1999.
            annotation updated: Sep 21, 2011.
            xrefs: AF086709.2, AAD45398.1
            xrefs (non-sequence databases): IPI:IPI00002162, UniGene:Hs.591661,
            MINT:MINT-1206479, PRIDE:Q9Y6C7, GeneCards:GC03P008588, HGNC:6662,
            MIM:610485, neXtProt:NX_Q9Y6C7, CleanEx:HS_LOH3CR2A,
            Genevestigator:Q9Y6C7
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 94)
  AUTHORS   Xie,Y., Deng,L.-W., Jiang,N., Zhan,F.-H. and Li,G.-Y.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-1999)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Nasopharyngeal epithelium
COMMENT     [CAUTION] Product of a dubious CDS prediction. May be a non-coding
            RNA.
FEATURES             Location/Qualifiers
     source          1..94
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..94
                     /gene="NCRNA00312"
                     /locus_tag="NAG7"
                     /gene_synonym="LOH3CR2A"
     Protein         1..94
                     /gene="NCRNA00312"
                     /locus_tag="NAG7"
                     /gene_synonym="LOH3CR2A"
                     /product="Putative uncharacterized protein encoded by
                     NCRNA00312"
                     /note="Loss of heterozygosity 3 chromosomal region 2 gene
                     A protein"
                     /UniProtKB_evidence="Uncertain"
     Region          1..94
                     /gene="NCRNA00312"
                     /locus_tag="NAG7"
                     /gene_synonym="LOH3CR2A"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Putative uncharacterized protein encoded by
                     NCRNA00312. /FTId=PRO_0000096693."
ORIGIN      
        1 mahhslntfy iwhnnvlhth lvfflphlln qpfsrgsfli wlllcwnswy hlrtlrrqan
       61 qanklsmmll rvkqspgtkl chgdseltsg llat
//

LOCUS       PINL_HUMAN               100 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Putative PIN1-like protein; AltName:
            Full=Peptidylprolyl cis-trans isomerase NIMA-interacting 1
            pseudogene 1.
ACCESSION   O15428
VERSION     O15428.1  GI:7531173
DBSOURCE    UniProtKB: locus PINL_HUMAN, accession O15428;
            class: standard.
            extra accessions:B2RBW1,Q5VW75
            created: May 30, 2000.
            sequence updated: Jan 1, 1998.
            annotation updated: Sep 21, 2011.
            xrefs: U82382.1, AAB81333.1, AK314840.1, BAG37358.1, AL391728.19
            xrefs (non-sequence databases): IPI:IPI00006667, UniGene:Hs.654711,
            ProteinModelPortal:O15428, SMR:O15428, MINT:MINT-1668373,
            STRING:O15428, PRIDE:O15428, UCSC:uc009wbh.1, HGNC:8989,
            MIM:602051, neXtProt:NX_O15428, eggNOG:prNOG20165,
            Genevestigator:O15428, GermOnline:ENSG00000203959,
            InterPro:IPR001202, Gene3D:G3DSA:2.20.70.10, Pfam:PF00397,
            SMART:SM00456, SUPFAM:SSF51045, PROSITE:PS01159, PROSITE:PS50020
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 100)
  AUTHORS   Campbell,H.D., Webb,G.C., Fountain,S. and Young,I.G.
  TITLE     The human PIN1 peptidyl-prolyl cis/trans isomerase gene maps to
            human chromosome 19p13 and the closely related PIN1L gene to 1p31
  JOURNAL   Genomics 44 (2), 157-162 (1997)
   PUBMED   9299231
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   2  (residues 1 to 100)
  AUTHORS   Ota,T., Suzuki,Y., Nishikawa,T., Otsuki,T., Sugiyama,T., Irie,R.,
            Wakamatsu,A., Hayashi,K., Sato,H., Nagai,K., Kimura,K., Makita,H.,
            Sekine,M., Obayashi,M., Nishi,T., Shibahara,T., Tanaka,T.,
            Ishii,S., Yamamoto,J., Saito,K., Kawai,Y., Isono,Y., Nakamura,Y.,
            Nagahari,K., Murakami,K., Yasuda,T., Iwayanagi,T., Wagatsuma,M.,
            Shiratori,A., Sudo,H., Hosoiri,T., Kaku,Y., Kodaira,H., Kondo,H.,
            Sugawara,M., Takahashi,M., Kanda,K., Yokoi,T., Furuya,T.,
            Kikkawa,E., Omura,Y., Abe,K., Kamihara,K., Katsuta,N., Sato,K.,
            Tanikawa,M., Yamazaki,M., Ninomiya,K., Ishibashi,T., Yamashita,H.,
            Murakawa,K., Fujimori,K., Tanai,H., Kimata,M., Watanabe,M.,
            Hiraoka,S., Chiba,Y., Ishida,S., Ono,Y., Takiguchi,S., Watanabe,S.,
            Yosida,M., Hotuta,T., Kusano,J., Kanehori,K., Takahashi-Fujii,A.,
            Hara,H., Tanase,T.O., Nomura,Y., Togiya,S., Komai,F., Hara,R.,
            Takeuchi,K., Arita,M., Imose,N., Musashino,K., Yuuki,H., Oshima,A.,
            Sasaki,N., Aotsuka,S., Yoshikawa,Y., Matsunawa,H., Ichihara,T.,
            Shiohata,N., Sano,S., Moriya,S., Momiyama,H., Satoh,N., Takami,S.,
            Terashima,Y., Suzuki,O., Nakagawa,S., Senoh,A., Mizoguchi,H.,
            Goto,Y., Shimizu,F., Wakebe,H., Hishigaki,H., Watanabe,T.,
            Sugiyama,A., Takemoto,M., Kawakami,B., Yamazaki,M., Watanabe,K.,
            Kumagai,A., Itakura,S., Fukuzumi,Y., Fujimori,Y., Komiyama,M.,
            Tashiro,H., Tanigami,A., Fujiwara,T., Ono,T., Yamada,K., Fujii,Y.,
            Ozaki,K., Hirao,M., Ohmori,Y., Kawabata,A., Hikiji,T., Kobatake,N.,
            Inagaki,H., Ikema,Y., Okamoto,S., Okitani,R., Kawakami,T.,
            Noguchi,S., Itoh,T., Shigeta,K., Senba,T., Matsumura,K.,
            Nakajima,Y., Mizuno,T., Morinaga,M., Sasaki,M., Togashi,T.,
            Oyama,M., Hata,H., Watanabe,M., Komatsu,T., Mizushima-Sugano,J.,
            Satoh,T., Shirai,Y., Takahashi,Y., Nakagawa,K., Okumura,K.,
            Nagase,T., Nomura,N., Kikuchi,H., Masuho,Y., Yamashita,R.,
            Nakai,K., Yada,T., Nakamura,Y., Ohara,O., Isogai,T. and Sugano,S.
  TITLE     Complete sequencing and characterization of 21,243 full-length
            human cDNAs
  JOURNAL   Nat. Genet. 36 (1), 40-45 (2004)
   PUBMED   14702039
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Testis
REFERENCE   3  (residues 1 to 100)
  AUTHORS   Gregory,S.G., Barlow,K.F., McLay,K.E., Kaul,R., Swarbreck,D.,
            Dunham,A., Scott,C.E., Howe,K.L., Woodfine,K., Spencer,C.C.,
            Jones,M.C., Gillson,C., Searle,S., Zhou,Y., Kokocinski,F.,
            McDonald,L., Evans,R., Phillips,K., Atkinson,A., Cooper,R.,
            Jones,C., Hall,R.E., Andrews,T.D., Lloyd,C., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Anderson,F., Andrew,R.W., Ashwell,R.I.,
            Aubin,K., Babbage,A.K., Bagguley,C.L., Bailey,J., Beasley,H.,
            Bethel,G., Bird,C.P., Bray-Allen,S., Brown,J.Y., Brown,A.J.,
            Buckley,D., Burton,J., Bye,J., Carder,C., Chapman,J.C., Clark,S.Y.,
            Clarke,G., Clee,C., Cobley,V., Collier,R.E., Corby,N.,
            Coville,G.J., Davies,J., Deadman,R., Dunn,M., Earthrowl,M.,
            Ellington,A.G., Errington,H., Frankish,A., Frankland,J., French,L.,
            Garner,P., Garnett,J., Gay,L., Ghori,M.R., Gibson,R., Gilby,L.M.,
            Gillett,W., Glithero,R.J., Grafham,D.V., Griffiths,C.,
            Griffiths-Jones,S., Grocock,R., Hammond,S., Harrison,E.S., Hart,E.,
            Haugen,E., Heath,P.D., Holmes,S., Holt,K., Howden,P.J., Hunt,A.R.,
            Hunt,S.E., Hunter,G., Isherwood,J., James,R., Johnson,C.,
            Johnson,D., Joy,A., Kay,M., Kershaw,J.K., Kibukawa,M.,
            Kimberley,A.M., King,A., Knights,A.J., Lad,H., Laird,G., Lawlor,S.,
            Leongamornlert,D.A., Lloyd,D.M., Loveland,J., Lovell,J., Lush,M.J.,
            Lyne,R., Martin,S., Mashreghi-Mohammadi,M., Matthews,L.,
            Matthews,N.S., McLaren,S., Milne,S., Mistry,S., Moore,M.J.,
            Nickerson,T., O'Dell,C.N., Oliver,K., Palmeiri,A., Palmer,S.A.,
            Parker,A., Patel,D., Pearce,A.V., Peck,A.I., Pelan,S., Phelps,K.,
            Phillimore,B.J., Plumb,R., Rajan,J., Raymond,C., Rouse,G.,
            Saenphimmachak,C., Sehra,H.K., Sheridan,E., Shownkeen,R., Sims,S.,
            Skuce,C.D., Smith,M., Steward,C., Subramanian,S., Sycamore,N.,
            Tracey,A., Tromans,A., Van Helmond,Z., Wall,M., Wallis,J.M.,
            White,S., Whitehead,S.L., Wilkinson,J.E., Willey,D.L., Williams,H.,
            Wilming,L., Wray,P.W., Wu,Z., Coulson,A., Vaudin,M., Sulston,J.E.,
            Durbin,R., Hubbard,T., Wooster,R., Dunham,I., Carter,N.P.,
            McVean,G., Ross,M.T., Harrow,J., Olson,M.V., Beck,S., Rogers,J.,
            Bentley,D.R., Banerjee,R., Bryant,S.P., Burford,D.C., Burrill,W.D.,
            Clegg,S.M., Dhami,P., Dovey,O., Faulkner,L.M., Gribble,S.M.,
            Langford,C.F., Pandian,R.D., Porter,K.M. and Prigmore,E.
  TITLE     The DNA sequence and biological annotation of human chromosome 1
  JOURNAL   Nature 441 (7091), 315-321 (2006)
   PUBMED   16710414
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
            Erratum:[Nature. 2006 Oct 26;443(7114):1013. Banerjee, R [added];
            Bryant, SP [added]; Burford, DC [added]; Burrill, WDH [added];
            Clegg, SM [added]; Dhami, P [added]; Dovey, O [added]; Faulkner, LM
            [added]; Gribble, SM [added]; Langford, CF [added]; Pandian, RD
            [added]; Porter, KM [added]; Prigmore, E [added]]
COMMENT     On Feb 28, 2007 this sequence version replaced gi:74747353.
            [SIMILARITY] Contains 1 WW domain.
            [CAUTION] Could be the product of a pseudogene.
FEATURES             Location/Qualifiers
     source          1..100
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..100
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
     Protein         1..100
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
                     /product="Putative PIN1-like protein"
                     /note="Peptidylprolyl cis-trans isomerase NIMA-interacting
                     1 pseudogene 1"
                     /UniProtKB_evidence="Uncertain"
     Region          1..100
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Putative PIN1-like protein. /FTId=PRO_0000193437."
     Region          5..38
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="WW."
     Region          8..39
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
                     /region_name="WW"
                     /note="Two conserved tryptophans domain; also known as the
                     WWP or rsp5 domain; around 40 amino acids; functions as an
                     interaction module in a diverse set of signalling
                     proteins; binds specific proline-rich sequences but at low
                     affinities compared to other...; cd00201"
                     /db_xref="CDD:29258"
     Site            order(23,34)
                     /gene="PIN1P1"
                     /gene_synonym="PIN1L"
                     /site_type="binding"
                     /note="binding pocket"
                     /db_xref="CDD:29258"
ORIGIN      
        1 madeeklppg wekrmsrpsg rgyyfnhitn psqwerpsgn sssggkiwqg eparvrrshl
       61 lvkpvkaald laagnhpdqg ggpgadqrlh pedqgrregl
//

LOCUS       CXX1_HUMAN               209 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=CAAX box protein 1; AltName: Full=Cerebral protein 5;
            Flags: Precursor.
ACCESSION   O15255
VERSION     O15255.1  GI:9087144
DBSOURCE    UniProtKB: locus CXX1_HUMAN, accession O15255;
            class: standard.
            extra accessions:Q6IBF1
            created: Dec 1, 2000.
            sequence updated: Jan 1, 1998.
            annotation updated: Sep 21, 2011.
            xrefs: Y13374.1, CAA73804.1, D88756.1, BAB46920.1, AF038168.1,
            AAB97361.1, AF052096.1, AAC28618.1, CR456853.1, CAG33134.1,
            AL136169.6, BC002385.2, BC002410.2
            xrefs (non-sequence databases): IPI:IPI00005727, UniGene:Hs.522789,
            IntAct:O15255, MINT:MINT-2865579, PRIDE:O15255,
            GeneCards:GC0XP123560, H-InvDB:HIX0017070, HGNC:2569, MIM:300213,
            neXtProt:NX_O15255, eggNOG:prNOG19955, HOVERGEN:HBG001853,
            InParanoid:O15255, OrthoDB:EOG4GB77P, PhylomeDB:O15255,
            NextBio:33588, CleanEx:HS_FAM127A, Genevestigator:O15255,
            GermOnline:ENSG00000134590, GO:0005886, GO:0005515
KEYWORDS    Cell membrane; Complete proteome; Lipoprotein; Membrane;
            Methylation; Phosphoprotein; Polymorphism; Prenylation; Reference
            proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 209)
  AUTHORS   Frattini,A., Faranda,S., Zucchi,I. and Vezzoni,P.
  TITLE     A low-copy repeat in Xq26 represents a novel putatively prenylated
            protein gene (CXX1) and its pseudogenes (DXS9914, DXS9915, and
            DXS9916)
  JOURNAL   Genomics 46 (1), 167-169 (1997)
   PUBMED   9403077
  REMARK    NUCLEOTIDE SEQUENCE [MRNA], AND TISSUE SPECIFICITY.;
            TISSUE=Brain
REFERENCE   2  (residues 1 to 209)
  AUTHORS   Yoshimoto,M., Yazaki,M., Takayama,K. and Matsumoto,K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-NOV-1996)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Brain
REFERENCE   3  (residues 1 to 209)
  AUTHORS   Yu,W., Sarginson,J. and Gibbs,R.A.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-DEC-1997)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Brain
REFERENCE   4  (residues 1 to 209)
  AUTHORS   Ebert,L., Schick,M., Neubert,P., Schatten,R., Henze,S. and Korn,B.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUN-2004)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].
REFERENCE   5  (residues 1 to 209)
  AUTHORS   Ross,M.T., Grafham,D.V., Coffey,A.J., Scherer,S., McLay,K.,
            Muzny,D., Platzer,M., Howell,G.R., Burrows,C., Bird,C.P.,
            Frankish,A., Lovell,F.L., Howe,K.L., Ashurst,J.L., Fulton,R.S.,
            Sudbrak,R., Wen,G., Jones,M.C., Hurles,M.E., Andrews,T.D.,
            Scott,C.E., Searle,S., Ramser,J., Whittaker,A., Deadman,R.,
            Carter,N.P., Hunt,S.E., Chen,R., Cree,A., Gunaratne,P., Havlak,P.,
            Hodgson,A., Metzker,M.L., Richards,S., Scott,G., Steffen,D.,
            Sodergren,E., Wheeler,D.A., Worley,K.C., Ainscough,R.,
            Ambrose,K.D., Ansari-Lari,M.A., Aradhya,S., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Ballabio,A., Banerjee,R., Barker,G.E.,
            Barlow,K.F., Barrett,I.P., Bates,K.N., Beare,D.M., Beasley,H.,
            Beasley,O., Beck,A., Bethel,G., Blechschmidt,K., Brady,N.,
            Bray-Allen,S., Bridgeman,A.M., Brown,A.J., Brown,M.J., Bonnin,D.,
            Bruford,E.A., Buhay,C., Burch,P., Burford,D., Burgess,J.,
            Burrill,W., Burton,J., Bye,J.M., Carder,C., Carrel,L., Chako,J.,
            Chapman,J.C., Chavez,D., Chen,E., Chen,G., Chen,Y., Chen,Z.,
            Chinault,C., Ciccodicola,A., Clark,S.Y., Clarke,G., Clee,C.M.,
            Clegg,S., Clerc-Blankenburg,K., Clifford,K., Cobley,V., Cole,C.G.,
            Conquer,J.S., Corby,N., Connor,R.E., David,R., Davies,J., Davis,C.,
            Davis,J., Delgado,O., Deshazo,D., Dhami,P., Ding,Y., Dinh,H.,
            Dodsworth,S., Draper,H., Dugan-Rocha,S., Dunham,A., Dunn,M.,
            Durbin,K.J., Dutta,I., Eades,T., Ellwood,M., Emery-Cohen,A.,
            Errington,H., Evans,K.L., Faulkner,L., Francis,F., Frankland,J.,
            Fraser,A.E., Galgoczy,P., Gilbert,J., Gill,R., Glockner,G.,
            Gregory,S.G., Gribble,S., Griffiths,C., Grocock,R., Gu,Y.,
            Gwilliam,R., Hamilton,C., Hart,E.A., Hawes,A., Heath,P.D.,
            Heitmann,K., Hennig,S., Hernandez,J., Hinzmann,B., Ho,S., Hoffs,M.,
            Howden,P.J., Huckle,E.J., Hume,J., Hunt,P.J., Hunt,A.R.,
            Isherwood,J., Jacob,L., Johnson,D., Jones,S., de Jong,P.J.,
            Joseph,S.S., Keenan,S., Kelly,S., Kershaw,J.K., Khan,Z.,
            Kioschis,P., Klages,S., Knights,A.J., Kosiura,A., Kovar-Smith,C.,
            Laird,G.K., Langford,C., Lawlor,S., Leversha,M., Lewis,L., Liu,W.,
            Lloyd,C., Lloyd,D.M., Loulseged,H., Loveland,J.E., Lovell,J.D.,
            Lozado,R., Lu,J., Lyne,R., Ma,J., Maheshwari,M., Matthews,L.H.,
            McDowall,J., McLaren,S., McMurray,A., Meidl,P., Meitinger,T.,
            Milne,S., Miner,G., Mistry,S.L., Morgan,M., Morris,S., Muller,I.,
            Mullikin,J.C., Nguyen,N., Nordsiek,G., Nyakatura,G., O'Dell,C.N.,
            Okwuonu,G., Palmer,S., Pandian,R., Parker,D., Parrish,J.,
            Pasternak,S., Patel,D., Pearce,A.V., Pearson,D.M., Pelan,S.E.,
            Perez,L., Porter,K.M., Ramsey,Y., Reichwald,K., Rhodes,S.,
            Ridler,K.A., Schlessinger,D., Schueler,M.G., Sehra,H.K.,
            Shaw-Smith,C., Shen,H., Sheridan,E.M., Shownkeen,R., Skuce,C.D.,
            Smith,M.L., Sotheran,E.C., Steingruber,H.E., Steward,C.A.,
            Storey,R., Swann,R.M., Swarbreck,D., Tabor,P.E., Taudien,S.,
            Taylor,T., Teague,B., Thomas,K., Thorpe,A., Timms,K., Tracey,A.,
            Trevanion,S., Tromans,A.C., d'Urso,M., Verduzco,D., Villasana,D.,
            Waldron,L., Wall,M., Wang,Q., Warren,J., Warry,G.L., Wei,X.,
            West,A., Whitehead,S.L., Whiteley,M.N., Wilkinson,J.E.,
            Willey,D.L., Williams,G., Williams,L., Williamson,A.,
            Williamson,H., Wilming,L., Woodmansey,R.L., Wray,P.W., Yen,J.,
            Zhang,J., Zhou,J., Zoghbi,H., Zorilla,S., Buck,D., Reinhardt,R.,
            Poustka,A., Rosenthal,A., Lehrach,H., Meindl,A., Minx,P.J.,
            Hillier,L.W., Willard,H.F., Wilson,R.K., Waterston,R.H., Rice,C.M.,
            Vaudin,M., Coulson,A., Nelson,D.L., Weinstock,G., Sulston,J.E.,
            Durbin,R., Hubbard,T., Gibbs,R.A., Beck,S., Rogers,J. and
            Bentley,D.R.
  TITLE     The DNA sequence of the human X chromosome
  JOURNAL   Nature 434 (7031), 325-337 (2005)
   PUBMED   15772651
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   6  (residues 1 to 209)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Muscle
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   7  (residues 1 to 209)
  AUTHORS   Yu,L.R., Zhu,Z., Chan,K.C., Issaq,H.J., Dimitrov,D.S. and
            Veenstra,T.D.
  TITLE     Improved titanium dioxide enrichment of phosphopeptides from HeLa
            cells and high confident phosphopeptide identification by
            cross-validation of MS/MS and MS/MS/MS spectra
  JOURNAL   J. Proteome Res. 6 (11), 4150-4162 (2007)
   PUBMED   17924679
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-56, AND MASS
            SPECTROMETRY.;
            TISSUE=Cervix carcinoma
COMMENT     On Jul 17, 2007 this sequence version replaced gi:74721961.
            [INTERACTION] P00519:ABL1; NbExp=1; IntAct=EBI-954396, EBI-375543.
            [SUBCELLULAR LOCATION] Cell membrane; Lipid-anchor (Potential).
            [TISSUE SPECIFICITY] Ubiquitous.
            [CAUTION] There seems to be two proteins encoded by the FAM127A
            gene, one with a C-terminal CAAX box (the sequence shown here) and
            a smaller protein (AC A6ZKI3).
FEATURES             Location/Qualifiers
     source          1..209
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..209
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
     Protein         1..209
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /product="CAAX box protein 1"
                     /note="Cerebral protein 5"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..206
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="CAAX box protein 1. /FTId=PRO_0000079745."
     Site            56
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Region          152
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> W (in dbSNP:rs5930670). /FTId=VAR_037283."
     Site            206
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /site_type="lipid-binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="S-farnesyl cysteine (Potential)."
     Site            206
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /site_type="modified"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cysteine methyl ester (Potential)."
     Region          207..209
                     /gene="FAM127A"
                     /locus_tag="hucep-5"
                     /gene_synonym="CXX1"
                     /gene_synonym="MAR8"
                     /gene_synonym="MAR8C"
                     /gene_synonym="MART8"
                     /region_name="Propeptide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Removed in mature form (Potential).
                     /FTId=PRO_0000396750."
ORIGIN      
        1 mgggrgllgr etlgpgggcs gegplcywpp pgsppapslr aslplepprc plrscslprs
       61 aclcsrnsap gsccrpwasl wsepppspss qpappmyiwt lscapaaswa pvthwtdhpl
      121 pplpspllpt rlpddyiilp tdlrchshrh pshptdrlll lviwthlggi waghspwtvi
      181 qtagrpprdl spsarpissp ppetscvla
//

LOCUS       MALAT_HUMAN               57 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Metastasis-associated lung adenocarcinoma transcript
            1.
ACCESSION   Q9UHZ2
VERSION     Q9UHZ2.1  GI:9910794
DBSOURCE    UniProtKB: locus MALAT_HUMAN, accession Q9UHZ2;
            class: standard.
            created: Dec 1, 2000.
            sequence updated: May 1, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AF113016.1, AAF20277.1, AF119905.1, AAF69659.1, AF203815.1
            xrefs (non-sequence databases): IPI:IPI00006107, IntAct:Q9UHZ2,
            GeneCards:GC11P061592, H-InvDB:HIX0026124, H-InvDB:HIX0035841,
            HGNC:29665, MIM:607924, neXtProt:NX_Q9UHZ2, OMA:RISELCF,
            ArrayExpress:Q9UHZ2, Bgee:Q9UHZ2, CleanEx:HS_MALAT1,
            Genevestigator:Q9UHZ2, GermOnline:ENSG00000184027
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 57)
  AUTHORS   Zhang,C., Yu,Y., Zhang,S., Ouyang,S., Luo,L., Wei,H., Zhou,G.,
            Liu,M. and He,F.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-DEC-1998)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Fetal liver
REFERENCE   2  (residues 1 to 57)
  AUTHORS   Zhang,C., Yu,Y., Zhang,S., Wei,H., Zhang,Y., Zhou,G., Bi,J., Liu,M.
            and He,F.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JAN-1999)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Fetal liver
REFERENCE   3  (residues 1 to 57)
  AUTHORS   van Asseldonk,M., Schepens,M., de Bruijn,D., Janssen,B., Merkx,G.
            and Geurts van Kessel,A.
  TITLE     Construction of a 350-kb sequence-ready 11q13 cosmid contig
            encompassing the markers D11S4933 and D11S546: mapping of 11 genes
            and 3 tumor-associated translocation breakpoints
  JOURNAL   Genomics 66 (1), 35-42 (2000)
   PUBMED   10843802
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
FEATURES             Location/Qualifiers
     source          1..57
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..57
                     /gene="MALAT1"
                     /locus_tag="PRO1073"
                     /gene_synonym="PRO2853"
     Protein         1..57
                     /gene="MALAT1"
                     /locus_tag="PRO1073"
                     /gene_synonym="PRO2853"
                     /product="Metastasis-associated lung adenocarcinoma
                     transcript 1"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..57
                     /gene="MALAT1"
                     /locus_tag="PRO1073"
                     /gene_synonym="PRO2853"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Metastasis-associated lung adenocarcinoma
                     transcript 1. /FTId=PRO_0000084557."
ORIGIN      
        1 mqimfssvvr isglclfpng gmtynlfcly lsihqgavfs asrpsycqag ydsedvi
//

LOCUS       RIPK4_HUMAN              832 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Receptor-interacting serine/threonine-protein kinase
            4; AltName: Full=Ankyrin repeat domain-containing protein 3;
            AltName: Full=PKC-delta-interacting protein kinase.
ACCESSION   P57078
VERSION     P57078.1  GI:10719883
DBSOURCE    UniProtKB: locus RIPK4_HUMAN, accession P57078;
            class: standard.
            extra accessions:Q96KH0
            created: Dec 1, 2000.
            sequence updated: Dec 1, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AB047783.1, BAB56136.1, AP001743.1, BAA95526.1
            xrefs (non-sequence databases): IPI:IPI00025714, IPI:IPI00215935,
            UniGene:Hs.517310, ProteinModelPortal:P57078, SMR:P57078,
            STRING:P57078, PhosphoSite:P57078, PRIDE:P57078,
            Ensembl:ENST00000352483, Ensembl:ENSP00000330161,
            Ensembl:ENSG00000183421, UCSC:uc002yzn.1, GeneCards:GC21M028579,
            HGNC:496, HPA:HPA021158, MIM:605706, neXtProt:NX_P57078,
            eggNOG:prNOG05962, HOGENOM:HBG444289, HOVERGEN:HBG061582,
            InParanoid:P57078, OMA:ARNGHLA, PhylomeDB:P57078,
            ArrayExpress:P57078, Bgee:P57078, CleanEx:HS_RIPK4,
            Genevestigator:P57078, GermOnline:ENSG00000183421, GO:0005737,
            GO:0016020, GO:0005524, GO:0004674, GO:0004872, InterPro:IPR002110,
            InterPro:IPR020683, InterPro:IPR011009, InterPro:IPR000719,
            InterPro:IPR017441, InterPro:IPR017442, InterPro:IPR008271,
            Gene3D:G3DSA:1.25.40.20, Pfam:PF00023, Pfam:PF00069, SMART:SM00248,
            SUPFAM:SSF48403, SUPFAM:SSF56112, PROSITE:PS50297, PROSITE:PS50088,
            PROSITE:PS00107, PROSITE:PS50011, PROSITE:PS00108
KEYWORDS    Alternative splicing; ANK repeat; ATP-binding; Complete proteome;
            Cytoplasm; Kinase; Membrane; Nucleotide-binding; Phosphoprotein;
            Polymorphism; Receptor; Reference proteome; Repeat;
            Serine/threonine-protein kinase; Transferase.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 832)
  AUTHORS   Shimizu,N., Kudoh,J. and Shibuya,K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-AUG-2000)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORM 2).;
            TISSUE=Fetal kidney, and Fetal lung
REFERENCE   2  (residues 1 to 832)
  AUTHORS   Hattori,M., Fujiyama,A., Taylor,T.D., Watanabe,H., Yada,T.,
            Park,H.S., Toyoda,A., Ishii,K., Totoki,Y., Choi,D.K., Groner,Y.,
            Soeda,E., Ohki,M., Takagi,T., Sakaki,Y., Taudien,S.,
            Blechschmidt,K., Polley,A., Menzel,U., Delabar,J., Kumpf,K.,
            Lehmann,R., Patterson,D., Reichwald,K., Rump,A., Schillhabel,M.,
            Schudy,A., Zimmermann,W., Rosenthal,A., Kudoh,J., Schibuya,K.,
            Kawasaki,K., Asakawa,S., Shintani,A., Sasaki,T., Nagamine,K.,
            Mitsuyama,S., Antonarakis,S.E., Minoshima,S., Shimizu,N.,
            Nordsiek,G., Hornischer,K., Brant,P., Scharfe,M., Schon,O.,
            Desario,A., Reichelt,J., Kauer,G., Blocker,H., Ramser,J., Beck,A.,
            Klages,S., Hennig,S., Riesselmann,L., Dagand,E., Haaf,T.,
            Wehrmeyer,S., Borzym,K., Gardiner,K., Nizetic,D., Francis,F.,
            Lehrach,H., Reinhardt,R. and Yaspo,M.L.
  CONSRTM   Chromosome 21 mapping and sequencing consortium
  TITLE     The DNA sequence of human chromosome 21
  JOURNAL   Nature 405 (6784), 311-319 (2000)
   PUBMED   10830953
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
            Erratum:[Nature 2000 Sep 7;407(6800):110]
REFERENCE   3  (residues 1 to 832)
  AUTHORS   Meylan,E., Martinon,F., Thome,M., Gschwendt,M. and Tschopp,J.
  TITLE     RIP4 (DIK/PKK), a novel member of the RIP kinase family, activates
            NF-kappa B and is processed during apoptosis
  JOURNAL   EMBO Rep. 3 (12), 1201-1208 (2002)
   PUBMED   12446564
  REMARK    CLEAVAGE AT ASP-388 AND ASP-426, INTERACTION WITH TRAF1; TRAF2;
            TRAF3 AND TRAF5, AND FUNCTION.
REFERENCE   4  (residues 1 to 832)
  AUTHORS   Greenman,C., Stephens,P., Smith,R., Dalgliesh,G.L., Hunter,C.,
            Bignell,G., Davies,H., Teague,J., Butler,A., Stevens,C., Edkins,S.,
            O'Meara,S., Vastrik,I., Schmidt,E.E., Avis,T., Barthorpe,S.,
            Bhamra,G., Buck,G., Choudhury,B., Clements,J., Cole,J., Dicks,E.,
            Forbes,S., Gray,K., Halliday,K., Harrison,R., Hills,K., Hinton,J.,
            Jenkinson,A., Jones,D., Menzies,A., Mironenko,T., Perry,J.,
            Raine,K., Richardson,D., Shepherd,R., Small,A., Tofts,C.,
            Varian,J., Webb,T., West,S., Widaa,S., Yates,A., Cahill,D.P.,
            Louis,D.N., Goldstraw,P., Nicholson,A.G., Brasseur,F.,
            Looijenga,L., Weber,B.L., Chiew,Y.E., DeFazio,A., Greaves,M.F.,
            Green,A.R., Campbell,P., Birney,E., Easton,D.F.,
            Chenevix-Trench,G., Tan,M.H., Khoo,S.K., Teh,B.T., Yuen,S.T.,
            Leung,S.Y., Wooster,R., Futreal,P.A. and Stratton,M.R.
  TITLE     Patterns of somatic mutation in human cancer genomes
  JOURNAL   Nature 446 (7132), 153-158 (2007)
   PUBMED   17344846
  REMARK    VARIANTS [LARGE SCALE ANALYSIS] ASN-462; MET-463; TYR-562; HIS-669
            AND SER-749.
COMMENT     [FUNCTION] Plays a role in NF-kappa B activation.
            [CATALYTIC ACTIVITY] ATP + a protein = ADP + a phosphoprotein.
            [SUBUNIT] Interacts with PRKCB (By similarity). Interacts with
            TRAF1, TRAF2, TRAF3 and TRAF5.
            [SUBCELLULAR LOCATION] Cytoplasm. Membrane; Peripheral membrane
            protein (By similarity).
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=2; Name=1; IsoId=P57078-1; Sequence=Displayed; Name=2;
            IsoId=P57078-2; Sequence=VSP_004862.
            [PTM] May be phosphorylated by MAP3K2 and MAP3K3 (By similarity).
            [PTM] Proteolytically cleaved by during Fas-induced apoptosis.
            Cleavage at Asp-388 and Asp-426.
            [SIMILARITY] Belongs to the protein kinase superfamily. TKL Ser/Thr
            protein kinase family.
            [SIMILARITY] Contains 10 ANK repeats.
            [SIMILARITY] Contains 1 protein kinase domain.
FEATURES             Location/Qualifiers
     source          1..832
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..832
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
     Protein         1..832
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /product="Receptor-interacting serine/threonine-protein
                     kinase 4"
                     /EC_number="2.7.11.1"
                     /note="Ankyrin repeat domain-containing protein 3;
                     PKC-delta-interacting protein kinase"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..832
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Receptor-interacting serine/threonine-protein
                     kinase 4. /FTId=PRO_0000086613."
     Region          12
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> G (in dbSNP:rs6586239). /FTId=VAR_030160."
     Region          22..286
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Protein kinase."
     Region          26..277
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="S_TKc"
                     /note="Serine/Threonine protein kinases, catalytic domain;
                     smart00220"
                     /db_xref="CDD:197582"
     Region          28..277
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="PKc"
                     /note="Catalytic domain of Protein Kinases; cd00180"
                     /db_xref="CDD:173623"
     Site            order(28..32,36,49,51,82,96..99,103,105,143,145,147..148,
                     150,161,164,183..186)
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="active"
                     /db_xref="CDD:173623"
     Site            order(28..32,36,49,51,82,96..99,103,143,145,147..148,150,
                     161)
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="other"
                     /note="ATP binding site [chemical binding]"
                     /db_xref="CDD:173623"
     Site            28..36
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="np-binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="ATP (By similarity)."
     Site            order(32,103,105,143,145,147,164,183..186)
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="other"
                     /note="substrate binding site [chemical binding]"
                     /db_xref="CDD:173623"
     Site            51
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="ATP (By similarity)."
     Site            143
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Proton acceptor (By similarity)."
     Site            order(160..166,183..186)
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="other"
                     /note="activation loop (A-loop)"
                     /db_xref="CDD:173623"
     Region          177
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> N (in dbSNP:rs12482626). /FTId=VAR_030161."
     Region          278..325
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in isoform 2). /FTId=VSP_004862."
     Site            388..389
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="cleavage"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Cleavage."
     Site            426..427
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /site_type="cleavage"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Cleavage."
     Region          462
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="I -> N. /FTId=VAR_041050."
     Region          463
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M. /FTId=VAR_041051."
     Region          484..605
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="ANK"
                     /note="ankyrin repeats;  ankyrin repeats mediate
                     protein-protein interactions in very diverse families of
                     proteins. The number of ANK repeats in a protein can range
                     from 2 to over 20 (ankyrins, for example). ANK repeats may
                     occur in combinations with other...; cd00204"
                     /db_xref="CDD:29261"
     Region          485..514
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 1."
     Region          490..614
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Ank_2"
                     /note="Ankyrin repeats (3 copies); pfam12796"
                     /db_xref="CDD:193272"
     Region          518..547
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 2."
     Region          546..672
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="ANK"
                     /note="ankyrin repeats;  ankyrin repeats mediate
                     protein-protein interactions in very diverse families of
                     proteins. The number of ANK repeats in a protein can range
                     from 2 to over 20 (ankyrins, for example). ANK repeats may
                     occur in combinations with other...; cd00204"
                     /db_xref="CDD:29261"
     Region          551..580
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 3."
     Region          562
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> Y. /FTId=VAR_041052."
     Region          584..613
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 4."
     Region          590..680
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Ank_2"
                     /note="Ankyrin repeats (3 copies); pfam12796"
                     /db_xref="CDD:193272"
     Region          617..647
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 5."
     Region          646..771
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="ANK"
                     /note="ankyrin repeats;  ankyrin repeats mediate
                     protein-protein interactions in very diverse families of
                     proteins. The number of ANK repeats in a protein can range
                     from 2 to over 20 (ankyrins, for example). ANK repeats may
                     occur in combinations with other...; cd00204"
                     /db_xref="CDD:29261"
     Region          651..680
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 6."
     Region          656..747
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Ank_2"
                     /note="Ankyrin repeats (3 copies); pfam12796"
                     /db_xref="CDD:193272"
     Region          669
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H. /FTId=VAR_041053."
     Region          684..713
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 7."
     Region          714
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> V (in Ref. 1; BAB56136)."
     Region          717..746
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 8."
     Region          722..812
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Ank_2"
                     /note="Ankyrin repeats (3 copies); pfam12796"
                     /db_xref="CDD:193272"
     Region          749
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> S. /FTId=VAR_041054."
     Region          750..780
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 9."
     Region          782..812
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="ANK"
                     /note="ankyrin repeats;  ankyrin repeats mediate
                     protein-protein interactions in very diverse families of
                     proteins. The number of ANK repeats in a protein can range
                     from 2 to over 20 (ankyrins, for example). ANK repeats may
                     occur in combinations with other...; cl02529"
                     /db_xref="CDD:198706"
     Region          782..811
                     /gene="RIPK4"
                     /gene_synonym="ANKRD3"
                     /gene_synonym="DIK"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="ANK 10."
ORIGIN      
        1 megdggtpwa lallrtfdag eftgwekvgs ggfgqvykvr hvhwktwlai kcspslhvdd
       61 rermelleea kkmemakfry ilpvygicre pvglvmeyme tgslekllas eplpwdlrfr
      121 iihetavgmn flhcmappll hldlkpanil ldahyhvkis dfglakcngl shshdlsmdg
      181 lfgtiaylpp erireksrlf dtkhdvysfa iviwgvltqk kpfadeknil himvkvvkgh
      241 rpelppvcra rpracshlir lmqrcwqgdp rvrptfqgng lngelirqvl aallpvtgrw
      301 rspgegfrle seviirvtcp lsspqeitse tedlcekpdd evketahdld vksppeprse
      361 vvparlkras aptfdndysl sellsqldsg vsqavegpee lsrssseskl pssgsgkrls
      421 gvssvdsafs srgslslsfe repstsdlgt tdvqkkklvd aivsgdtskl mkilqpqdvd
      481 laldsgasll hlaveagqee cakwlllnna npnlsnrrgs tplhmaverr vrgvvellla
      541 rkisvnakde dqwtalhfaa qngdesstrl lleknasvne vdfegrtpmh vacqhgqeni
      601 vrillrrgvd vslqgkdawl plhyaawqgh lpivkllakq pgvsvnaqtl dgrtplhlaa
      661 qrghyrvari lidlcsdvnv csllaqtplh vaaetghtst arlllhrgag keamtsdgyt
      721 alhlaarngh latvkllvee kadvlargpl nqtalhlaaa hghsevveel vsadvidlfd
      781 eqglsalhla aqgrhaqtve tllrhgahin lqslkfqggh gpaatllrrs kt
//

LOCUS       ZSC12_HUMAN              604 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Zinc finger and SCAN domain-containing protein 12;
            AltName: Full=Zinc finger protein 305; AltName: Full=Zinc finger
            protein 96.
ACCESSION   O43309
VERSION     O43309.1  GI:11135560
DBSOURCE    UniProtKB: locus ZSC12_HUMAN, accession O43309;
            class: standard.
            extra accessions:O43724
            created: Dec 1, 2000.
            sequence updated: Jun 1, 1998.
            annotation updated: Sep 21, 2011.
            xrefs: AB007886.1, BAA24856.2, Z98745.1, CAB11428.2, BC041661.1,
            AAH41661.1
            xrefs (non-sequence databases): IPI:IPI00011942, UniGene:Hs.134816,
            ProteinModelPortal:O43309, SMR:O43309, IntAct:O43309,
            STRING:O43309, PhosphoSite:O43309, PRIDE:O43309,
            Ensembl:ENST00000361028, Ensembl:ENSP00000354305,
            Ensembl:ENSG00000158691, Ensembl:ENST00000396827,
            Ensembl:ENSP00000380039, GeneCards:GC06M028152, H-InvDB:HIX0005671,
            HGNC:13172, HPA:HPA006637, MIM:603978, neXtProt:NX_O43309,
            PharmGKB:PA37744, eggNOG:prNOG05646, GeneTree:ENSGT00600000084347,
            HOGENOM:HBG717200, HOVERGEN:HBG018163, InParanoid:O43309,
            OMA:EKCYQCK, OrthoDB:EOG4MW85P, PhylomeDB:O43309, Bgee:O43309,
            CleanEx:HS_ZSCAN12, Genevestigator:O43309,
            GermOnline:ENSG00000158691, GO:0005634, GO:0003677, GO:0003700,
            GO:0008270, GO:0016032, InterPro:IPR008916, InterPro:IPR003309,
            InterPro:IPR007087, InterPro:IPR015880, InterPro:IPR013087,
            Gene3D:G3DSA:3.30.160.60, Pfam:PF02023, Pfam:PF00096,
            SMART:SM00431, SMART:SM00355, SUPFAM:SSF47353, PROSITE:PS50804,
            PROSITE:PS00028, PROSITE:PS50157
KEYWORDS    Complete proteome; DNA-binding; Metal-binding; Nucleus; Reference
            proteome; Repeat; Transcription; Transcription regulation; Zinc;
            Zinc-finger.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 604)
  AUTHORS   Ishikawa,K., Nagase,T., Nakajima,D., Seki,N., Ohira,M.,
            Miyajima,N., Tanaka,A., Kotani,H., Nomura,N. and Ohara,O.
  TITLE     Prediction of the coding sequences of unidentified human genes.
            VIII. 78 new cDNA clones from brain which code for large proteins
            in vitro
  JOURNAL   DNA Res. 4 (5), 307-313 (1997)
   PUBMED   9455477
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Brain
REFERENCE   2  (residues 1 to 604)
  AUTHORS   Mungall,A.J., Palmer,S.A., Sims,S.K., Edwards,C.A., Ashurst,J.L.,
            Wilming,L., Jones,M.C., Horton,R., Hunt,S.E., Scott,C.E.,
            Gilbert,J.G., Clamp,M.E., Bethel,G., Milne,S., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Andrews,T.D., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Barker,D.J.,
            Barlow,K.F., Bates,K., Beare,D.M., Beasley,H., Beasley,O.,
            Bird,C.P., Blakey,S., Bray-Allen,S., Brook,J., Brown,A.J.,
            Brown,J.Y., Burford,D.C., Burrill,W., Burton,J., Carder,C.,
            Carter,N.P., Chapman,J.C., Clark,S.Y., Clark,G., Clee,C.M.,
            Clegg,S., Cobley,V., Collier,R.E., Collins,J.E., Colman,L.K.,
            Corby,N.R., Coville,G.J., Culley,K.M., Dhami,P., Davies,J.,
            Dunn,M., Earthrowl,M.E., Ellington,A.E., Evans,K.A., Faulkner,L.,
            Francis,M.D., Frankish,A., Frankland,J., French,L., Garner,P.,
            Garnett,J., Ghori,M.J., Gilby,L.M., Gillson,C.J., Glithero,R.J.,
            Grafham,D.V., Grant,M., Gribble,S., Griffiths,C., Griffiths,M.,
            Hall,R., Halls,K.S., Hammond,S., Harley,J.L., Hart,E.A.,
            Heath,P.D., Heathcott,R., Holmes,S.J., Howden,P.J., Howe,K.L.,
            Howell,G.R., Huckle,E., Humphray,S.J., Humphries,M.D., Hunt,A.R.,
            Johnson,C.M., Joy,A.A., Kay,M., Keenan,S.J., Kimberley,A.M.,
            King,A., Laird,G.K., Langford,C., Lawlor,S., Leongamornlert,D.A.,
            Leversha,M., Lloyd,C.R., Lloyd,D.M., Loveland,J.E., Lovell,J.,
            Martin,S., Mashreghi-Mohammadi,M., Maslen,G.L., Matthews,L.,
            McCann,O.T., McLaren,S.J., McLay,K., McMurray,A., Moore,M.J.,
            Mullikin,J.C., Niblett,D., Nickerson,T., Novik,K.L., Oliver,K.,
            Overton-Larty,E.K., Parker,A., Patel,R., Pearce,A.V., Peck,A.I.,
            Phillimore,B., Phillips,S., Plumb,R.W., Porter,K.M., Ramsey,Y.,
            Ranby,S.A., Rice,C.M., Ross,M.T., Searle,S.M., Sehra,H.K.,
            Sheridan,E., Skuce,C.D., Smith,S., Smith,M., Spraggon,L.,
            Squares,S.L., Steward,C.A., Sycamore,N., Tamlyn-Hall,G., Tester,J.,
            Theaker,A.J., Thomas,D.W., Thorpe,A., Tracey,A., Tromans,A.,
            Tubby,B., Wall,M., Wallis,J.M., West,A.P., White,S.S.,
            Whitehead,S.L., Whittaker,H., Wild,A., Willey,D.J., Wilmer,T.E.,
            Wood,J.M., Wray,P.W., Wyatt,J.C., Young,L., Younger,R.M.,
            Bentley,D.R., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E.,
            Dunham,I., Rogers,J. and Beck,S.
  TITLE     The DNA sequence and analysis of human chromosome 6
  JOURNAL   Nature 425 (6960), 805-811 (2003)
   PUBMED   14574404
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   3  (residues 1 to 604)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Skin
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
COMMENT     [FUNCTION] May be involved in transcriptional regulation.
            [SUBCELLULAR LOCATION] Nucleus (Potential).
            [SIMILARITY] Belongs to the krueppel C2H2-type zinc-finger protein
            family.
            [SIMILARITY] Contains 11 C2H2-type zinc fingers.
            [SIMILARITY] Contains 1 SCAN box domain.
            [SEQUENCE CAUTION] Sequence=BAA24856.2; Type=Erroneous initiation.
FEATURES             Location/Qualifiers
     source          1..604
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..604
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
     Protein         1..604
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /product="Zinc finger and SCAN domain-containing protein
                     12"
                     /note="Zinc finger protein 305; Zinc finger protein 96"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..604
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc finger and SCAN domain-containing protein 12.
                     /FTId=PRO_0000047403."
     Region          43..126
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="SCAN"
                     /note="SCAN oligomerization domain; cd07936"
                     /db_xref="CDD:153421"
     Region          46..128
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="SCAN box."
     Site            order(49..50,52..54,59..61,63..64,67..68,71..72,74..77,
                     81..82,85..86,89..91,93..94,96..99,118,121..122,124..126)
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /site_type="other"
                     /note="dimerization interface [polypeptide binding]"
                     /db_xref="CDD:153421"
     Region          274..296
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 1."
     Region          <301..459
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="COG5048"
                     /note="FOG: Zn-finger [General function prediction only]"
                     /db_xref="CDD:34653"
     Region          302..324
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 2."
     Region          330..352
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 3."
     Region          358..380
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 4."
     Region          <382..566
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="COG5048"
                     /note="FOG: Zn-finger [General function prediction only]"
                     /db_xref="CDD:34653"
     Region          386..408
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 5."
     Region          414..436
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 6."
     Region          442..463
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 7."
     Region          469..491
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 8."
     Region          497..519
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 9."
     Region          525..547
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 10."
     Region          553..578
                     /gene="ZSCAN12"
                     /gene_synonym="KIAA0426"
                     /gene_synonym="ZNF305"
                     /gene_synonym="ZNF96"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 11; degenerate."
ORIGIN      
        1 mastwaiqah mdqdeplevk ieeekyttrq dwdlrknnth srevfrqyfr qfcyqetsgp
       61 realsrlrel chqwlrpeth tkeqilellv leqfltilpe elqawvqeqh pesgeevvtv
      121 ledlerelde pgeqvsvhtg eqemflqetv rlrkegepsm slqsmkaqpk yespelesqq
      181 eqvldvetgn eygnlkqevs eemephgkts skfendmsks arcgetrepe eiteepsacs
      241 redkqptcde ngvsltensd htehqricpg eesygcddcg kafsqhshli ehqrihtgdr
      301 pykceecgka frgrtvlirh kiihtgekpy kcnecgkafg rwsalnqhqr lhtgekhyhc
      361 ndcgkafsqk aglfhhikih trdkpyqctq cnksfsrrsi ltqhqgvhtg akpyecnecg
      421 kafvynsslv shqeihhkek cyqckecgks fsqsgliqhq rihtgekpyk cdvcekafiq
      481 rtsltehqri htgerpykcd kcgkaftqrs vltehqriht gerpykcdec gnafrgitsl
      541 iqhqrihtge kpyqcdecgk afrqrkktsy keillknhse pqagvnllls slipewqscf
      601 rrdl
//

LOCUS       ZN208_HUMAN             1167 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Zinc finger protein 208; AltName: Full=Zinc finger
            protein 91-like.
ACCESSION   O43345
VERSION     O43345.1  GI:12585543
DBSOURCE    UniProtKB: locus ZN208_HUMAN, accession O43345;
            class: standard.
            created: Jan 24, 2001.
            sequence updated: Jun 1, 1998.
            annotation updated: Sep 21, 2011.
            xrefs: AC003973.1, AAB94784.1
            xrefs (non-sequence databases): IPI:IPI00941719, UniGene:Hs.541334,
            ProteinModelPortal:O43345, SMR:O43345, PhosphoSite:O43345,
            PRIDE:O43345, Ensembl:ENST00000397126, Ensembl:ENSP00000380315,
            Ensembl:ENSG00000160321, UCSC:uc002nqp.1, GeneCards:GC19M021686,
            HGNC:12999, MIM:603977, neXtProt:NX_O43345, eggNOG:prNOG16882,
            GeneTree:ENSGT00600000084165, HOGENOM:HBG717200,
            HOVERGEN:HBG018163, InParanoid:O43345, OMA:NWSSNLM,
            OrthoDB:EOG4VT5WC, PhylomeDB:O43345, Reactome:REACT_71,
            NextBio:30033, ArrayExpress:O43345, Bgee:O43345, CleanEx:HS_ZNF208,
            Genevestigator:O43345, GermOnline:ENSG00000160321, GO:0005634,
            GO:0003677, GO:0008270, GO:0006355, GO:0006351, InterPro:IPR001909,
            InterPro:IPR007087, InterPro:IPR015880, InterPro:IPR013087,
            Gene3D:G3DSA:3.30.160.60, Pfam:PF01352, Pfam:PF00096,
            SMART:SM00349, SMART:SM00355, SUPFAM:SSF109640, PROSITE:PS50805,
            PROSITE:PS00028, PROSITE:PS50157
KEYWORDS    Complete proteome; DNA-binding; Metal-binding; Nucleus;
            Polymorphism; Reference proteome; Repeat; Transcription;
            Transcription regulation; Zinc; Zinc-finger.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 1167)
  AUTHORS   Eichler,E.E., Hoffman,S.M., Adamson,A.A., Gordon,L.A., McCready,P.,
            Lamerdin,J.E. and Mohrenweiser,H.W.
  TITLE     Complex beta-satellite repeat structures and the expansion of the
            zinc finger gene cluster in 19p12
  JOURNAL   Genome Res. 8 (8), 791-808 (1998)
   PUBMED   9724325
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   2  (residues 1 to 1167)
  AUTHORS   Grimwood,J., Gordon,L.A., Olsen,A., Terry,A., Schmutz,J.,
            Lamerdin,J., Hellsten,U., Goodstein,D., Couronne,O.,
            Tran-Gyamfi,M., Aerts,A., Altherr,M., Ashworth,L., Bajorek,E.,
            Black,S., Branscomb,E., Caenepeel,S., Carrano,A., Caoile,C.,
            Chan,Y.M., Christensen,M., Cleland,C.A., Copeland,A., Dalin,E.,
            Dehal,P., Denys,M., Detter,J.C., Escobar,J., Flowers,D.,
            Fotopulos,D., Garcia,C., Georgescu,A.M., Glavina,T., Gomez,M.,
            Gonzales,E., Groza,M., Hammon,N., Hawkins,T., Haydu,L., Ho,I.,
            Huang,W., Israni,S., Jett,J., Kadner,K., Kimball,H., Kobayashi,A.,
            Larionov,V., Leem,S.H., Lopez,F., Lou,Y., Lowry,S., Malfatti,S.,
            Martinez,D., McCready,P., Medina,C., Morgan,J., Nelson,K.,
            Nolan,M., Ovcharenko,I., Pitluck,S., Pollard,M., Popkie,A.P.,
            Predki,P., Quan,G., Ramirez,L., Rash,S., Retterer,J., Rodriguez,A.,
            Rogers,S., Salamov,A., Salazar,A., She,X., Smith,D., Slezak,T.,
            Solovyev,V., Thayer,N., Tice,H., Tsai,M., Ustaszewska,A., Vo,N.,
            Wagner,M., Wheeler,J., Wu,K., Xie,G., Yang,J., Dubchak,I.,
            Furey,T.S., DeJong,P., Dickson,M., Gordon,D., Eichler,E.E.,
            Pennacchio,L.A., Richardson,P., Stubbs,L., Rokhsar,D.S.,
            Myers,R.M., Rubin,E.M. and Lucas,S.M.
  TITLE     The DNA sequence and biology of human chromosome 19
  JOURNAL   Nature 428 (6982), 529-535 (2004)
   PUBMED   15057824
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
COMMENT     [FUNCTION] May be involved in transcriptional regulation.
            [SUBCELLULAR LOCATION] Nucleus (Probable).
            [TISSUE SPECIFICITY] Ubiquitous.
            [SIMILARITY] Belongs to the krueppel C2H2-type zinc-finger protein
            family.
            [SIMILARITY] Contains 34 C2H2-type zinc fingers.
            [SIMILARITY] Contains 1 KRAB domain.
FEATURES             Location/Qualifiers
     source          1..1167
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..1167
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
     Protein         1..1167
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /product="Zinc finger protein 208"
                     /note="Zinc finger protein 91-like"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..1167
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Zinc finger protein 208. /FTId=PRO_0000047454."
     Region          4..43
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="KRAB_A-box"
                     /note="KRAB (Kruppel-associated box) domain -A box;
                     cd07765"
                     /db_xref="CDD:143639"
     Region          7..75
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="KRAB."
     Region          201..223
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 1; degenerate."
     Region          229..251
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 2."
     Region          257..279
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 3."
     Region          282
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in dbSNP:rs2007506). /FTId=VAR_052791."
     Region          285..307
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 4."
     Region          298
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> L (in dbSNP:rs12462668). /FTId=VAR_052792."
     Region          301..725
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="COG5048"
                     /note="FOG: Zn-finger [General function prediction only]"
                     /db_xref="CDD:34653"
     Region          313..335
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 5."
     Region          341..363
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 6."
     Region          369..391
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 7."
     Region          397..419
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 8."
     Region          425..447
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 9."
     Region          453..475
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 10."
     Region          456
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> Q (in dbSNP:rs7255075). /FTId=VAR_052793."
     Region          481..503
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 11."
     Region          509..531
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 12."
     Region          537..559
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 13."
     Region          540
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="K -> E (in dbSNP:rs10425763). /FTId=VAR_059903."
     Region          565..587
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 14."
     Region          593..615
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 15."
     Region          621..643
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 16."
     Region          649..671
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 17."
     Region          677..699
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 18."
     Region          701..1117
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="COG5048"
                     /note="FOG: Zn-finger [General function prediction only]"
                     /db_xref="CDD:34653"
     Region          705..727
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 19."
     Region          733..755
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 20."
     Region          761..783
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 21."
     Region          789..811
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 22."
     Region          817..839
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 23."
     Region          845..867
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 24."
     Region          873..895
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 25."
     Region          901..923
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 26."
     Region          907
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> G (in dbSNP:rs8108957). /FTId=VAR_059904."
     Region          929..951
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 27."
     Region          957..979
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 28."
     Region          985..1007
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 29."
     Region          1013..1035
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 30."
     Region          1041..1063
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 31."
     Region          1069..1091
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 32."
     Region          1097..1119
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 33."
     Region          1125..1147
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C2H2-type 34."
     Region          1165
                     /gene="ZNF208"
                     /gene_synonym="ZNF91L"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> H (in dbSNP:rs2359812). /FTId=VAR_059905."
ORIGIN      
        1 mgsltfrdva iefsleewqc ldtaqqnlyr nvmlenyrnl vflgiaafkp dliifleegk
       61 eswnmkrhem veespvicsh faqdlwpeqg iedsfqkvil rryekcghen lhlkigytnv
      121 deckvhkegy nklnqslttt qskvfqrgky anvfhkcsns nrhkirhtgk khlqckeyvr
      181 sfcmlshlsq hkriytrens ykceeggkaf nwsstltyyk sahtgekpyr ckecgkafsk
      241 fsiltkhkvi htgeksykce ecgkafnqsa iltkhkiiht gekpnkceec gkafskvstl
      301 tthkaihage kpykckecgk afskvstlit hkaihagekp ykckecgkaf skfsiltkhk
      361 vihtgekpyk ceecgkaykw pstlsyhkki htgekpykce ecgkgfsmfs iltkheviht
      421 gekpykceec gkafnwssnl mehkkihtge tpykceecgk gfswsstlsy hkkihtvekp
      481 ykceecgkaf nqsailikhk rihtgekpyk ceecgktfsk vstltthkai hagekpykck
      541 ecgktfikvs tltthkaiha gekpykckec gkafskfsil tkhkvihtge kpykceecgk
      601 afnwssnlme hkrihtgekp ykceecgksf stfsvltkhk vihtgekpyk ceecgkaykw
      661 sstlsyhkki htvekpykce ecgkafnrsa ilikhkriht dekpykceec gktfskvstl
      721 tthkaihage kpykckecgk afskfsiltk hkvihtgekp ykceecgkay kwpstlsyhk
      781 kihtgekpyk ceecgkgfsm fsiltkhevi htgekpykce ecgkafswls vfskhkktha
      841 gekfykceac gkayntfsil tkhkvihtge kpykceecgk afnwssnlme hkkihtgetp
      901 ykceecdkaf swpssltehk athagekpyk ceecgkafsw psrltehkat hageepykce
      961 ecgkafnwss nlmehkriht gekpykceec gksfstfsil tkhkvihtge kpykceecgk
     1021 aykwsstlsy hkkihtvekp ykceecgkgf vmfsilakhk vihtgeklyk ceecgkaykw
     1081 pstlryhkki htgekpykce ecgkafstfs iltkhkviht gekpykceec gkafswlsvf
     1141 skhkkihtgv pnppthkkih ageklyk
//

LOCUS       1A68_HUMAN               365 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, A-68 alpha
            chain; AltName: Full=Aw-68; AltName: Full=HLA class I
            histocompatibility antigen, A-28 alpha chain; AltName: Full=MHC
            class I antigen A*68; Flags: Precursor.
ACCESSION   P01891
VERSION     P01891.4  GI:13124681
DBSOURCE    UniProtKB: locus 1A68_HUMAN, accession P01891;
            class: standard.
            extra
            accessions:O19673,O19695,O19794,O19795,O43907,O77938,O98010,P10315,
            P79505,Q9MYA5,Q9MYC4,Q9TQG7,Q9TQN5,Q9UIN2
            created: Jul 21, 1986.
            sequence updated: Feb 21, 2001.
            annotation updated: Sep 21, 2011.
            xrefs: U03861.1, AAA03602.1, X03070.1, CAB56605.1, X03071.1,
            CAB56606.1, U41057.1, AAB41292.1, AJ315642.1, CAC44382.1,
            AF144013.1, AAF74211.1, AJ245567.1, CAB59722.1, U91628.1,
            AAB50567.1, U91627.1, U89946.1, AAB82079.1, U89947.1, AAB82080.1,
            AJ001274.1, CAA04647.1, AF072770.1, AAC25782.1, AF072769.1,
            AF135545.1, AAD22270.1, AF135544.1, AF108431.1, AAD27539.1,
            AF108430.1, AJ223972.3, CAA11708.1, AF041372.1, AAD02208.1,
            AF041371.1, AF268398.1, AAF73477.1, AF268397.1, HLHU28, HLHUAW,
            I38441, 1HSB_A, 1TMC_A, 2HLA_A
            xrefs (non-sequence databases): IPI:IPI00472882, UniGene:Hs.181244,
            UniGene:Hs.713441, PDBsum:1HSB, PDBsum:1TMC, PDBsum:2HLA,
            ProteinModelPortal:P01891, SMR:P01891, MINT:MINT-274751,
            STRING:P01891, PRIDE:P01891, Ensembl:ENST00000412679,
            Ensembl:ENSP00000399020, Ensembl:ENSG00000235657,
            Ensembl:ENST00000457879, Ensembl:ENSP00000403575,
            GeneCards:GC06P029921, GeneCards:GC06Pk29899, HGNC:4931,
            MIM:142800, neXtProt:NX_P01891, HOVERGEN:HBG016709,
            CleanEx:HS_HLA-A, Genevestigator:P01891,
            GermOnline:ENSG00000204632, GO:0016021, GO:0042612, GO:0002474,
            GO:0006955, GO:0044419, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Glycoprotein; Host-virus interaction; Immunity;
            Membrane; MHC I; Polymorphism; Reference proteome; Signal;
            Transmembrane; Transmembrane helix; Ubl conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 365)
  AUTHORS   Holmes,N., Ennis,P., Wan,A.M., Denney,D.W. and Parham,P.
  TITLE     Multiple genetic mechanisms have contributed to the generation of
            the HLA-A2/A28 family of class I MHC molecules
  JOURNAL   J. Immunol. 139 (3), 936-941 (1987)
   PUBMED   3496393
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*68:02).
REFERENCE   2  (residues 1 to 365)
  AUTHORS   Domena,J.D.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-NOV-1993)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*68:02).
REFERENCE   3  (residues 1 to 365)
  AUTHORS   Ellexson,M., Lau,M., Terasaki,P. and Hildebrand,W.
  TITLE     Molecular characterization of HLA-A*6803
  JOURNAL   Immunogenetics 45 (1), 78-79 (1996)
   PUBMED   8881043
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE A*68:03).
REFERENCE   4  (residues 1 to 365)
  AUTHORS   Cox,S.T., Arguello,J.R., Marsh,S.G., Lau,M., Kwan,P.L.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Sequence of HLA-A*6808
  JOURNAL   Tissue Antigens 53 (6), 597-600 (1999)
   PUBMED   10395114
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE A*68:08).
REFERENCE   5  (residues 1 to 365)
  AUTHORS   Cox,S.T.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUN-2001)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE A*68:011).;
            TISSUE=Blood
REFERENCE   6  (residues 1 to 365)
  AUTHORS   Ramon,D., Scott,I., Cox,S.T., Pesoa,S., Vullo,C., Little,A.M. and
            Madrigal,J.A.
  TITLE     HLA-A*6817, identified in the Kolla Amerindians of North-West
            Argentina possesses a novel nucleotide substitution
  JOURNAL   Tissue Antigens 55 (5), 453-454 (2000)
   PUBMED   10885567
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE A*68:17).
REFERENCE   7  (residues 1 to 365)
  AUTHORS   Bei,M. and Hurley,C.K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-FEB-1997)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*68:06).
REFERENCE   8  (residues 1 to 365)
  AUTHORS   Vargas-Alarcon,G., Martinez-Laso,J., Gomez-Casado,E.,
            Perez-Blas,M., Granados,J., Alegre,R., Alvarez,M., Zuniga,J. and
            Arnaiz-Villena,A.
  TITLE     Description of HLA-A*6803 and A*68N in Mazatecan Indians from
            Mexico
  JOURNAL   Immunogenetics 46 (5), 446-447 (1997)
   PUBMED   9271640
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-206 (ALLELE A*68:03).;
            TISSUE=Blood
REFERENCE   9  (residues 1 to 365)
  AUTHORS   Blasczyk,R.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-AUG-1997)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*68:03).;
            TISSUE=Blood
REFERENCE   10 (residues 1 to 365)
  AUTHORS   Edson,S.M. and Hurley,C.K.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAR-1999)
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELE A*68:02).
REFERENCE   11 (residues 1 to 365)
  AUTHORS   Ellis,J., Steiner,N., Kosman,C., Henson,V., Mitton,W., Koester,R.,
            Ng,J., Hartzman,R.J. and Hurley,C.K.
  TITLE     Seventeen more novel HLA-A locus alleles
  JOURNAL   Tissue Antigens 55 (4), 369-373 (2000)
   PUBMED   10852390
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES A*68:09 AND A*68:10).
REFERENCE   12 (residues 1 to 365)
  AUTHORS   Gomez-Casado,E., Martinez-Laso,J., Gonzalez-Hevilla,M., Longas,J.,
            Rubio,I., Silvera-Redondo,C., Garcia-Gomez,A., Lowy,E. and
            Arnaiz-Villena,A.
  TITLE     A novel HLA-A*6816 allele possible generated by a point mutation in
            a Chilean from Punta Arenas (Magellan Strait)
  JOURNAL   Immunogenetics 51 (4-5), 257-260 (2000)
   PUBMED   10803837
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 3-206 (ALLELE A*68:16).
REFERENCE   13 (residues 1 to 365)
  AUTHORS   Hickman,H.D., Cavett,J.W., Ellexson-Turner,M.E., Sparkman,J.N.,
            Bennett,T.T., Turner,S., Sidebottom,D.A., Trachtenberg,E.A.,
            Confer,D.L. and Hildebrand,W.H.
  TITLE     Non-conservative substitutions distinguish previously
            uncharacterized HLA-A molecules
  JOURNAL   Tissue Antigens 57 (2), 95-102 (2001)
   PUBMED   11260503
  REMARK    NUCLEOTIDE SEQUENCE OF 26-206 (ALLELES A*68:07 AND A*68:17).
REFERENCE   14 (residues 1 to 365)
  AUTHORS   Holmes,N. and Parham,P.
  TITLE     Exon shuffling in vivo can generate novel HLA class I molecules
  JOURNAL   EMBO J. 4 (11), 2849-2854 (1985)
   PUBMED   3877632
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 26-297 (ALLELE A*68:01).
REFERENCE   15 (residues 1 to 365)
  AUTHORS   Lopez de Castro,J.A., Strominger,J.L., Strong,D.M. and Orr,H.T.
  TITLE     Structure of crossreactive human histocompatibility antigens
            HLA-A28 and HLA-A2: possible implications for the generation of HLA
            polymorphism
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 79 (12), 3813-3817 (1982)
   PUBMED   6179086
  REMARK    PARTIAL PROTEIN SEQUENCE OF 25-294 (A*68:01).
REFERENCE   16 (residues 1 to 365)
  AUTHORS   Chen,R., Jiang,X., Sun,D., Han,G., Wang,F., Ye,M., Wang,L. and
            Zou,H.
  TITLE     Glycoproteomics analysis of human liver tissue by combination of
            multiple enzyme digestion and hydrazide chemistry
  JOURNAL   J. Proteome Res. 8 (2), 651-661 (2009)
   PUBMED   19159218
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-110, AND MASS
            SPECTROMETRY.;
            TISSUE=Liver
REFERENCE   17 (residues 1 to 365)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
REFERENCE   18 (residues 1 to 365)
  AUTHORS   Guo,H.C., Jardetzky,T.S., Garrett,T.P., Lane,W.S., Strominger,J.L.
            and Wiley,D.C.
  TITLE     Different length peptides bind to HLA-Aw68 similarly at their ends
            but bulge out in the middle
  JOURNAL   Nature 360 (6402), 364-366 (1992)
   PUBMED   1448153
  REMARK    X-RAY CRYSTALLOGRAPHY (1.9 ANGSTROMS) OF 25-294 (A*68:01).
REFERENCE   19 (residues 1 to 365)
  AUTHORS   Silver,M.L., Guo,H.C., Strominger,J.L. and Wiley,D.C.
  TITLE     Atomic structure of a human MHC molecule presenting an influenza
            virus peptide
  JOURNAL   Nature 360 (6402), 367-369 (1992)
   PUBMED   1448154
  REMARK    X-RAY CRYSTALLOGRAPHY (1.9 ANGSTROMS) OF 25-294 (A*68:01).
REFERENCE   20 (residues 1 to 365)
  AUTHORS   Collins,E.J., Garboczi,D.N., Karpusas,M.N. and Wiley,D.C.
  TITLE     The three-dimensional structure of a class I major
            histocompatibility complex molecule missing the alpha 3 domain of
            the heavy chain
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 92 (4), 1218-1221 (1995)
   PUBMED   7862664
  REMARK    X-RAY CRYSTALLOGRAPHY (2.3 ANGSTROMS) OF 25-199 (A*68:01).
COMMENT     On or before Jul 18, 2007 this sequence version replaced gi:70073,
            gi:70082, gi:2118805, gi:1168211.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of A-68 are known: A*68:01
            (Aw68.1), A*68:02, A*68:03. A*68:04, A*68:05, A*68:06, A*68:07,
            A*68:08, A*68:09, A*68:10, A*68:16 and A*68:17. The sequence shown
            is that of A*68:01.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..365
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
     Protein         1..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /product="HLA class I histocompatibility antigen, A-68
                     alpha chain"
                     /note="Aw-68; HLA class I histocompatibility antigen, A-28
                     alpha chain; MHC class I antigen A*68"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, A-68 alpha
                     chain. /FTId=PRO_0000018830."
     Region          25..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          36
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> M (in allele A*68:02). /FTId=VAR_004389."
     Region          41..43
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          55..61
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          74..76
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          86..87
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="RN -> EE (in allele A*68:10). /FTId=VAR_010362."
     Region          89
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> G (in dbSNP:rs1059459). /FTId=VAR_056304."
     Region          94
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Q -> H (in allele A*68:03, allele A*68:04 and
                     allele A*68:05; dbSNP:rs1059463). /FTId=VAR_010363."
     Region          97
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> I (in allele A*68:04). /FTId=VAR_010364."
     Region          98
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> H (in allele A*68:05). /FTId=VAR_010365."
     Region          101
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in dbSNP:rs1136688). /FTId=VAR_056305."
     Site            110
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          115..206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          121
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="M -> R (in allele A*68:02). /FTId=VAR_004390."
     Bond            125..188
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          129
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> P (in allele A*68:02; dbSNP:rs1136700).
                     /FTId=VAR_004391."
     Region          133..142
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          133
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="F -> L (in dbSNP:rs1059488). /FTId=VAR_056306."
     Region          138
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> E (in allele A*68:06; requires 2 nucleotide
                     substitutions). /FTId=VAR_010366."
     Region          138
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> H (in allele A*68:02). /FTId=VAR_004392."
     Region          140
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> H (in allele A*68:06 and allele A*68:07).
                     /FTId=VAR_010367."
     Region          140
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> V (in allele A*68:17). /FTId=VAR_010368."
     Region          140
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> Y (in allele A*68:02). /FTId=VAR_004393."
     Region          145..150
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          175
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> L (in allele A*68:16). /FTId=VAR_010369."
     Region          176..185
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> L (in allele A*68:08). /FTId=VAR_010370."
     Region          180
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> Q (in allele A*68:09; requires 2 nucleotide
                     substitutions). /FTId=VAR_010371."
     Region          187..198
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          200..203
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          206
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> A (in Ref. 12; AAF74211)."
     Region          207..299
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..235
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          231
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> G (in Ref. 15; AA sequence)."
     Site            order(233..235,263,288)
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          246..248
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          252..254
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          278..280
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          290..292
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          309..332
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          333..365
                     /gene="HLA-A"
                     /gene_synonym="HLAA"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mavmaprtlv lllsgalalt qtwagshsmr yfytsvsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasqrme prapwieqeg peywdrntrn vkaqsqtdrv dlgtlrgyyn qseagshtiq
      121 mmygcdvgsd grflrgyrqd aydgkdyial kedlrswtaa dmaaqttkhk weaahvaeqw
      181 raylegtcve wlrrylengk etlqrtdapk thmthhavsd heatlrcwal sfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdgtfqkwva vvvpsgqeqr ytchvqhegl pkpltlrwep
      301 ssqptipivg iiaglvlfga vitgavvaav mwrrkssdrk ggsysqaass dsaqgsdvsl
      361 tackv
//

LOCUS       ERR2_HUMAN               500 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Steroid hormone receptor ERR2; AltName: Full=ERR
            beta-2; AltName: Full=Estrogen receptor-like 2; AltName:
            Full=Estrogen-related receptor beta; Short=ERR-beta; AltName:
            Full=Nuclear receptor subfamily 3 group B member 2.
ACCESSION   O95718
VERSION     O95718.1  GI:13626133
DBSOURCE    UniProtKB: locus ERR2_HUMAN, accession O95718;
            class: standard.
            extra accessions:Q9HCB4
            created: Feb 21, 2001.
            sequence updated: May 1, 1999.
            annotation updated: Sep 21, 2011.
            xrefs: AF094517.1, AAC99409.1, AC008050.6, AAG17472.1, AC016543.6,
            1LO1_A
            xrefs (non-sequence databases): IPI:IPI00032812, UniGene:Hs.435845,
            PDBsum:1LO1, ProteinModelPortal:O95718, SMR:O95718, STRING:O95718,
            PhosphoSite:O95718, PRIDE:O95718, Ensembl:ENST00000261532,
            Ensembl:ENSP00000261532, Ensembl:ENSG00000119715, UCSC:uc001xso.1,
            GeneCards:GC14P057006, HGNC:3473, MIM:602167, MIM:608565,
            neXtProt:NX_O95718, Orphanet:90636, HOVERGEN:HBG108344,
            OMA:CASGLME, PhylomeDB:O95718, Reactome:REACT_71, NextBio:8507,
            ArrayExpress:O95718, Bgee:O95718, CleanEx:HS_ESRRB,
            Genevestigator:O95718, GermOnline:ENSG00000119715, GO:0005654,
            GO:0000980, GO:0003700, GO:0003707, GO:0003713, GO:0008134,
            GO:0008270, GO:0045944, GO:0034339, InterPro:IPR008946,
            InterPro:IPR000536, InterPro:IPR024178, InterPro:IPR001723,
            InterPro:IPR001628, InterPro:IPR013088, Gene3D:G3DSA:1.10.565.10,
            Gene3D:G3DSA:3.30.50.10, Pfam:PF00104, Pfam:PF00105,
            PIRSF:PIRSF002527, PRINTS:PR00398, PRINTS:PR00047, SMART:SM00430,
            SMART:SM00399, SUPFAM:SSF48508, PROSITE:PS00031, PROSITE:PS51030
KEYWORDS    3D-structure; Complete proteome; Deafness; Disease mutation;
            DNA-binding; Metal-binding; Non-syndromic deafness; Nucleus;
            Phosphoprotein; Receptor; Reference proteome; Transcription;
            Transcription regulation; Zinc; Zinc-finger.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 500)
  AUTHORS   Chen,F., Zhang,Q., McDonald,T., Davidoff,M.J., Bailey,W., Bai,C.,
            Liu,Q. and Caskey,C.T.
  TITLE     Identification of two hERR2-related novel nuclear receptors
            utilizing bioinformatics and inverse PCR
  JOURNAL   Gene 228 (1-2), 101-109 (1999)
   PUBMED   10072763
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Testis
REFERENCE   2  (residues 1 to 500)
  AUTHORS   Heilig,R., Eckenberg,R., Petit,J.L., Fonknechten,N., Da Silva,C.,
            Cattolico,L., Levy,M., Barbe,V., de Berardinis,V., Ureta-Vidal,A.,
            Pelletier,E., Vico,V., Anthouard,V., Rowen,L., Madan,A., Qin,S.,
            Sun,H., Du,H., Pepin,K., Artiguenave,F., Robert,C., Cruaud,C.,
            Bruls,T., Jaillon,O., Friedlander,L., Samson,G., Brottier,P.,
            Cure,S., Segurens,B., Aniere,F., Samain,S., Crespeau,H., Abbasi,N.,
            Aiach,N., Boscus,D., Dickhoff,R., Dors,M., Dubois,I., Friedman,C.,
            Gouyvenoux,M., James,R., Madan,A., Mairey-Estrada,B., Mangenot,S.,
            Martins,N., Menard,M., Oztas,S., Ratcliffe,A., Shaffer,T.,
            Trask,B., Vacherie,B., Bellemere,C., Belser,C., Besnard-Gonnet,M.,
            Bartol-Mavel,D., Boutard,M., Briez-Silla,S., Combette,S.,
            Dufosse-Laurent,V., Ferron,C., Lechaplais,C., Louesse,C.,
            Muselet,D., Magdelenat,G., Pateau,E., Petit,E.,
            Sirvain-Trukniewicz,P., Trybou,A., Vega-Czarny,N., Bataille,E.,
            Bluet,E., Bordelais,I., Dubois,M., Dumont,C., Guerin,T.,
            Haffray,S., Hammadi,R., Muanga,J., Pellouin,V., Robert,D.,
            Wunderle,E., Gauguet,G., Roy,A., Sainte-Marthe,L., Verdier,J.,
            Verdier-Discala,C., Hillier,L., Fulton,L., McPherson,J.,
            Matsuda,F., Wilson,R., Scarpelli,C., Gyapay,G., Wincker,P.,
            Saurin,W., Quetier,F., Waterston,R., Hood,L. and Weissenbach,J.
  TITLE     The DNA sequence and analysis of human chromosome 14
  JOURNAL   Nature 421 (6923), 601-607 (2003)
   PUBMED   12508121
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   3  (residues 1 to 500)
  AUTHORS   Gauci,S., Helbig,A.O., Slijper,M., Krijgsveld,J., Heck,A.J. and
            Mohammed,S.
  TITLE     Lys-N and trypsin cover complementary parts of the phosphoproteome
            in a refined SCX-based approach
  JOURNAL   Anal. Chem. 81 (11), 4493-4501 (2009)
   PUBMED   19413330
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT THR-395, AND MASS
            SPECTROMETRY.;
            TISSUE=Embryonic kidney
REFERENCE   4  (residues 1 to 500)
  AUTHORS   Gearhart,M.D., Holmbeck,S.M., Evans,R.M., Dyson,H.J. and
            Wright,P.E.
  TITLE     Monomeric complex of human orphan estrogen related receptor-2 with
            DNA: a pseudo-dimer interface mediates extended half-site
            recognition
  JOURNAL   J. Mol. Biol. 327 (4), 819-832 (2003)
   PUBMED   12654265
  REMARK    STRUCTURE BY NMR OF 97-194, SUBUNIT, DNA-BINDING, AND MUTAGENESIS
            OF TYR-185.
REFERENCE   5  (residues 1 to 500)
  AUTHORS   Collin,R.W., Kalay,E., Tariq,M., Peters,T., van der Zwaag,B.,
            Venselaar,H., Oostrik,J., Lee,K., Ahmed,Z.M., Caylan,R., Li,Y.,
            Spierenburg,H.A., Eyupoglu,E., Heister,A., Riazuddin,S., Bahat,E.,
            Ansar,M., Arslan,S., Wollnik,B., Brunner,H.G., Cremers,C.W.,
            Karaguzel,A., Ahmad,W., Cremers,F.P., Vriend,G., Friedman,T.B.,
            Riazuddin,S., Leal,S.M. and Kremer,H.
  TITLE     Mutations of ESRRB encoding estrogen-related receptor beta cause
            autosomal-recessive nonsyndromic hearing impairment DFNB35
  JOURNAL   Am. J. Hum. Genet. 82 (1), 125-138 (2008)
   PUBMED   18179891
  REMARK    VARIANTS DFNB35 VAL-110; PRO-320; LEU-342; PRO-347 AND MET-389, AND
            VARIANT SER-386.
COMMENT     [FUNCTION] Nuclear receptor that binds DNA as monomer.
            [SUBUNIT] Monomer.
            [SUBCELLULAR LOCATION] Nucleus (Potential).
            [DISEASE] Defects in ESRRB are the cause of deafness autosomal
            recessive type 35 (DFNB35) [MIM:608565]. DFNB35 is a form of
            sensorineural hearing loss. Sensorineural deafness results from
            damage to the neural receptors of the inner ear, the nerve pathways
            to the brain, or the area of the brain that receives sound
            information.
            [SIMILARITY] Belongs to the nuclear hormone receptor family. NR3
            subfamily.
            [SIMILARITY] Contains 1 nuclear receptor DNA-binding domain.
FEATURES             Location/Qualifiers
     source          1..500
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..500
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
     Protein         1..500
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /product="Steroid hormone receptor ERR2"
                     /note="ERR beta-2; Estrogen receptor-like 2;
                     Estrogen-related receptor beta; Nuclear receptor subfamily
                     3 group B member 2; ERR-beta"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..500
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Steroid hormone receptor ERR2.
                     /FTId=PRO_0000053662."
     Region          98..193
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="NR_DBD_ERR"
                     /note="DNA-binding domain of estrogen related receptors
                     (ERR) is composed of two C4-type zinc fingers; cd07170"
                     /db_xref="CDD:143544"
     Site            100..186
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="DNA binding"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Nuclear receptor."
     Site            order(101,113..116,121..122,124..126,128..129,132,
                     152..153,156,159,173..174,177..184)
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="DNA binding"
                     /note="DNA binding site [nucleotide binding]"
                     /db_xref="CDD:143544"
     Site            order(103,106,120,123,139,145,155,158)
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="other"
                     /note="zinc binding site [ion binding]"
                     /db_xref="CDD:143544"
     Region          103..123
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="NR C4-type."
     Region          104..107
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          110
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> V (in DFNB35). /FTId=VAR_043503."
     Region          111..119
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          121..132
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          139..163
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Zinc finger region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="NR C4-type."
     Region          149..154
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          156..166
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          170..172
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            185
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="mutagenized"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y->A: 6-fold decrease in DNA-binding affinity."
     Site            185
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="other"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Important for stabilizing DNA-binding."
     Region          212..431
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="NR_LBD_ERR"
                     /note="The ligand binding domain of estrogen
                     receptor-related nuclear receptors; cd06946"
                     /db_xref="CDD:132744"
     Site            order(240,243,247,250,288,301,305,315..317,410,413,415)
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="other"
                     /note="ligand binding site [chemical binding]"
                     /db_xref="CDD:132744"
     Site            order(255,269,272..273,276..277,423..424,427..428)
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="other"
                     /note="coactivator recognition site [polypeptide binding]"
                     /db_xref="CDD:132744"
     Region          320
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> P (in DFNB35). /FTId=VAR_043504."
     Region          342
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> L (in DFNB35). /FTId=VAR_043505."
     Region          347
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> P (in DFNB35). /FTId=VAR_043506."
     Site            351
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="other"
                     /note="dimer interface [polypeptide binding]"
                     /db_xref="CDD:132744"
     Region          386
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> S. /FTId=VAR_043507."
     Region          389
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> M (in DFNB35; uncertain pathological
                     significance). /FTId=VAR_043508."
     Site            395
                     /gene="ESRRB"
                     /gene_synonym="ERRB2"
                     /gene_synonym="ESRL2"
                     /gene_synonym="NR3B2"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphothreonine."
ORIGIN      
        1 mssddrhlgs scgsfiktep sspssgidal shhspsgssd asggfglalg thangldspp
       61 mfagaglggt pcrksyedca sgimedsaik ceymlnaipk rlclvcgdia sgyhygvasc
      121 eackaffkrt iqgnieyscp atneceitkr rrkscqacrf mkclkvgmlk egvrldrvrg
      181 grqkykrrld sesspylslq isppakkplt kivsyllvae pdklyamppp gmpegdikal
      241 ttlcdladre lvviigwakh ipgfsslslg dqmsllqsaw meililgivy rslpyddklv
      301 yaedyimdee hsrlagllel yrailqlvrr ykklkvekee fvtlkalala nsdsmyiedl
      361 eavqklqdll healqdyels qrheepwrtg kllltlpllr qtaakavqhf ysvklqgkvp
      421 mhklflemle akawaradsl qewrpleqvp splhratkrq hvhfltplpp ppsvawvgta
      481 qagyhlevfl pqragwpraa
//

LOCUS       SMG64_HUMAN               66 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Putative smooth muscle cell-expressed and macrophage
            conditioned medium-induced protein 64; Short=Smag-64.
ACCESSION   Q9NRT5
VERSION     Q9NRT5.1  GI:14916713
DBSOURCE    UniProtKB: locus SMG64_HUMAN, accession Q9NRT5;
            class: standard.
            created: Jul 11, 2001.
            sequence updated: Oct 1, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AF170702.1, AAF89665.1
            xrefs (non-sequence databases): IPI:IPI00016844, UniGene:Hs.654548,
            MINT:MINT-1439254, PRIDE:Q9NRT5, neXtProt:NX_Q9NRT5,
            Genevestigator:Q9NRT5, GermOnline:ENSG00000144810, GO:0007525
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 66)
  AUTHORS   de Vries,C.J., van Achterberg,T.A., Horrevoets,A.J., ten Cate,J.W.
            and Pannekoek,H.
  TITLE     Differential display identification of 40 genes with altered
            expression in activated human smooth muscle cells. Local expression
            in atherosclerotic lesions of smags, smooth muscle
            activation-specific genes
  JOURNAL   J. Biol. Chem. 275 (31), 23939-23947 (2000)
   PUBMED   10823842
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Umbilical artery
COMMENT     [CAUTION] Product of a dubious CDS prediction. Seems to be enocded
            in the intron of COL8A1.
FEATURES             Location/Qualifiers
     source          1..66
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     Protein         1..66
                     /product="Putative smooth muscle cell-expressed and
                     macrophage conditioned medium-induced protein 64"
                     /note="Smag-64"
                     /UniProtKB_evidence="Uncertain"
     Region          1..66
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Putative smooth muscle cell-expressed and
                     macrophage conditioned medium-induced protein 64.
                     /FTId=PRO_0000071971."
ORIGIN      
        1 mstfqsihfi dmislvspts lqgnegdqyg stlrskahps lplvavsgwn tfkqgnklps
       61 sllltl
//

LOCUS       NEUR3_HUMAN              428 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Sialidase-3; AltName: Full=Ganglioside sialidase;
            AltName: Full=Membrane sialidase; AltName:
            Full=N-acetyl-alpha-neuraminidase 3.
ACCESSION   Q9UQ49
VERSION     Q9UQ49.1  GI:17369720
DBSOURCE    UniProtKB: locus NEUR3_HUMAN, accession Q9UQ49;
            class: standard.
            extra accessions:Q9NQE1
            created: Nov 16, 2001.
            sequence updated: May 1, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AB008185.2, BAA82611.1, Y18563.1, CAB96131.1, AP001992.4
            xrefs (non-sequence databases): IPI:IPI00220736, UniGene:Hs.191074,
            ProteinModelPortal:Q9UQ49, SMR:Q9UQ49, STRING:Q9UQ49, CAZy:GH33,
            PhosphoSite:Q9UQ49, PRIDE:Q9UQ49, Ensembl:ENST00000294064,
            Ensembl:ENSP00000294064, Ensembl:ENSG00000162139, UCSC:uc001ovw.1,
            GeneCards:GC11P070997, H-InvDB:HIX0009941, HGNC:7760, MIM:604617,
            neXtProt:NX_Q9UQ49, eggNOG:prNOG11670,
            GeneTree:ENSGT00390000011171, HOVERGEN:HBG052608,
            InParanoid:Q9UQ49, OrthoDB:EOG4FR0RV, BRENDA:3.2.1.18,
            ArrayExpress:Q9UQ49, Bgee:Q9UQ49, CleanEx:HS_NEU3,
            Genevestigator:Q9UQ49, GermOnline:ENSG00000162139, GO:0005887,
            GO:0004308, GO:0005975, GO:0006689, InterPro:IPR011040,
            Gene3D:G3DSA:2.120.10.10, SUPFAM:SSF50939
KEYWORDS    Complete proteome; Glycosidase; Hydrolase; Membrane;
            Phosphoprotein; Polymorphism; Reference proteome; Repeat.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 428)
  AUTHORS   Wada,T., Yoshikawa,Y., Tokuyama,S., Kuwabara,M., Akita,H. and
            Miyagi,T.
  TITLE     Cloning, expression, and chromosomal mapping of a human ganglioside
            sialidase
  JOURNAL   Biochem. Biophys. Res. Commun. 261 (1), 21-27 (1999)
   PUBMED   10405317
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Brain
REFERENCE   2  (residues 1 to 428)
  AUTHORS   Monti,E., Bassi,M.T., Papini,N., Riboni,M., Manzoni,M.,
            Venerando,B., Croci,G., Preti,A., Ballabio,A., Tettamanti,G. and
            Borsani,G.
  TITLE     Identification and expression of NEU3, a novel human sialidase
            associated to the plasma membrane
  JOURNAL   Biochem. J. 349 (PT 1), 343-351 (2000)
   PUBMED   10861246
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].;
            TISSUE=Skeletal muscle
REFERENCE   3  (residues 1 to 428)
  AUTHORS   Taylor,T.D., Noguchi,H., Totoki,Y., Toyoda,A., Kuroki,Y., Dewar,K.,
            Lloyd,C., Itoh,T., Takeda,T., Kim,D.W., She,X., Barlow,K.F.,
            Bloom,T., Bruford,E., Chang,J.L., Cuomo,C.A., Eichler,E.,
            FitzGerald,M.G., Jaffe,D.B., LaButti,K., Nicol,R., Park,H.S.,
            Seaman,C., Sougnez,C., Yang,X., Zimmer,A.R., Zody,M.C.,
            Birren,B.W., Nusbaum,C., Fujiyama,A., Hattori,M., Rogers,J.,
            Lander,E.S. and Sakaki,Y.
  TITLE     Human chromosome 11 DNA sequence and analysis including novel gene
            identification
  JOURNAL   Nature 440 (7083), 497-500 (2006)
   PUBMED   16554811
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   4  (residues 1 to 428)
  AUTHORS   Daub,H., Olsen,J.V., Bairlein,M., Gnad,F., Oppermann,F.S.,
            Korner,R., Greff,Z., Keri,G., Stemmann,O. and Mann,M.
  TITLE     Kinase-selective enrichment enables quantitative phosphoproteomics
            of the kinome across the cell cycle
  JOURNAL   Mol. Cell 31 (3), 438-448 (2008)
   PUBMED   18691976
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-417, AND MASS
            SPECTROMETRY.;
            TISSUE=Cervix carcinoma
COMMENT     [FUNCTION] Plays a role in modulating the ganglioside content of
            the lipid bilayer at the level of membrane-bound sialyl
            glycoconjugates.
            [CATALYTIC ACTIVITY] Hydrolysis of alpha-(2->3)-, alpha-(2->6)-,
            alpha-(2->8)- glycosidic linkages of terminal sialic acid residues
            in oligosaccharides, glycoproteins, glycolipids, colominic acid and
            synthetic substrates.
            [BIOPHYSICOCHEMICAL PROPERTIES] pH dependence: Optimum pH is 3.8.
            [SUBCELLULAR LOCATION] Membrane; Peripheral membrane protein.
            [TISSUE SPECIFICITY] Highly expressed in skeletal muscle, testis,
            adrenal gland and thymus, followed by pancreas, liver, heart and
            thymus. Weakly expressed in kidney, placenta, brain and lung.
            [SIMILARITY] Belongs to the glycosyl hydrolase 33 family.
            [SIMILARITY] Contains 3 BNR repeats.
            [SEQUENCE CAUTION] Sequence=CAB96131.1; Type=Erroneous initiation;
            Note=Translation N-terminally shortened.
FEATURES             Location/Qualifiers
     source          1..428
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..428
                     /gene="NEU3"
     Protein         1..428
                     /gene="NEU3"
                     /product="Sialidase-3"
                     /EC_number="3.2.1.18"
                     /note="Ganglioside sialidase; Membrane sialidase;
                     N-acetyl-alpha-neuraminidase 3"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..428
                     /gene="NEU3"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sialidase-3. /FTId=PRO_0000208903."
     Region          11..372
                     /gene="NEU3"
                     /region_name="Sialidase"
                     /note="Sialidases or neuraminidases function to bind and
                     hydrolyze terminal sialic acid residues from various
                     glycoconjugates as well as playing roles in pathogenesis,
                     bacterial nutrition and cellular interactions. They have a
                     six-bladed, beta-propeller fold...; cd00260"
                     /db_xref="CDD:29333"
     Region          15
                     /gene="NEU3"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> Q (in dbSNP:rs7115499). /FTId=VAR_055839."
     Region          24..27
                     /gene="NEU3"
                     /region_name="Short sequence motif of biological interest"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="FRIP motif."
     Site            order(25,50,225,245,340,370)
                     /gene="NEU3"
                     /site_type="active"
                     /note="catalytic site [active]"
                     /db_xref="CDD:29333"
     Site            25
                     /gene="NEU3"
                     /site_type="binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Substrate (By similarity)."
     Site            50
                     /gene="NEU3"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Proton acceptor (By similarity)."
     Region          129..140
                     /gene="NEU3"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="BNR 1."
     Region          203..214
                     /gene="NEU3"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="BNR 2."
     Site            order(205..207,210..212)
                     /gene="NEU3"
                     /site_type="other"
                     /note="Asp-box motif"
                     /db_xref="CDD:29333"
     Site            245
                     /gene="NEU3"
                     /site_type="binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Substrate (Potential)."
     Region          254..265
                     /gene="NEU3"
                     /region_name="Repetitive region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="BNR 3."
     Site            340
                     /gene="NEU3"
                     /site_type="binding"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Substrate (By similarity)."
     Site            370
                     /gene="NEU3"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Nucleophile (By similarity)."
     Site            387
                     /gene="NEU3"
                     /site_type="active"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Potential."
     Site            417
                     /gene="NEU3"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
ORIGIN      
        1 meevttcsfn splfrqeddr gityripall yippthtfla faekrstrrd edalhlvlrr
       61 glrigqlvqw gplkplmeat lpghrtmnpc pvweqksgcv flfficvrgh vterqqivsg
      121 rnaarlcfiy sqdagcswse vrdlteevig selkhwatfa vgpghgiqlq sgrlvipayt
      181 yyipswffcf qlpcktrphs lmiysddlgv twhhgrlirp mvtvecevae vtgraghpvl
      241 ycsartpnrc raealstdhg egfqrlalsr qlcepphgcq gsvvsfrple iphrcqdsss
      301 kdaptiqqss pgsslrleee agtpseswll yshptsrkqr vdlgiylnqt pleaacwsrp
      361 wilhcgpcgy sdlaaleeeg lfgclfecgt kqeceqiafr lfthreilsh lqgdctspgr
      421 npsqfksn
//

LOCUS       AKA7G_HUMAN              326 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=A-kinase anchor protein 7 isoform gamma; Short=AKAP-7
            isoform gamma; AltName: Full=A-kinase anchor protein 18 kDa;
            Short=AKAP 18; AltName: Full=Protein kinase A-anchoring protein 7
            isoform gamma.
ACCESSION   Q9P0M2
VERSION     Q9P0M2.1  GI:25089623
DBSOURCE    UniProtKB: locus AKA7G_HUMAN, accession Q9P0M2;
            class: standard.
            extra accessions:Q9HCZ8
            created: Nov 15, 2002.
            sequence updated: Oct 1, 2000.
            annotation updated: Sep 21, 2011.
            xrefs: AF152929.1, AAF28106.1, AL137063.11, CAI19003.1,
            AL136110.17, AL137222.17, CAI19788.1, CAI21509.1
            xrefs (non-sequence databases): IPI:IPI00942176, UniGene:Hs.486483,
            ProteinModelPortal:Q9P0M2, SMR:Q9P0M2, IntAct:Q9P0M2,
            STRING:Q9P0M2, PRIDE:Q9P0M2, Ensembl:ENST00000368123,
            Ensembl:ENSP00000357105, Ensembl:ENSG00000118507,
            Ensembl:ENST00000431975, Ensembl:ENSP00000405252, KEGG:hsa:9465,
            UCSC:uc003qck.1, GeneCards:GC06P129047, H-InvDB:HIX0032781,
            HGNC:377, HPA:HPA027172, HPA:HPA028327, MIM:604693,
            neXtProt:NX_Q9P0M2, GeneTree:ENSGT00390000012756,
            HOVERGEN:HBG050475, InParanoid:Q9P0M2, OrthoDB:EOG4PVP01,
            PhylomeDB:Q9P0M2, NextBio:35464, ArrayExpress:Q9P0M2, Bgee:Q9P0M2,
            CleanEx:HS_AKAP7, Genevestigator:Q9P0M2,
            GermOnline:ENSG00000118507, GO:0005829, GO:0003824, GO:0016070,
            InterPro:IPR019510, InterPro:IPR019511, InterPro:IPR009097,
            Pfam:PF10469, Pfam:PF10470, SUPFAM:SSF55144
KEYWORDS    Alternative splicing; Complete proteome; Cytoplasm; Polymorphism;
            Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 326)
  AUTHORS   Trotter,K.W., Fraser,I.D., Scott,G.K., Stutts,M.J., Scott,J.D. and
            Milgram,S.L.
  TITLE     Alternative splicing regulates the subcellular localization of
            A-kinase anchoring protein 18 isoforms
  JOURNAL   J. Cell Biol. 147 (7), 1481-1492 (1999)
   PUBMED   10613906
  REMARK    NUCLEOTIDE SEQUENCE [MRNA], FUNCTION, SUBCELLULAR LOCATION, AND
            TISSUE SPECIFICITY.;
            TISSUE=Lung
REFERENCE   2  (residues 1 to 326)
  AUTHORS   Mungall,A.J., Palmer,S.A., Sims,S.K., Edwards,C.A., Ashurst,J.L.,
            Wilming,L., Jones,M.C., Horton,R., Hunt,S.E., Scott,C.E.,
            Gilbert,J.G., Clamp,M.E., Bethel,G., Milne,S., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Andrews,T.D., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Barker,D.J.,
            Barlow,K.F., Bates,K., Beare,D.M., Beasley,H., Beasley,O.,
            Bird,C.P., Blakey,S., Bray-Allen,S., Brook,J., Brown,A.J.,
            Brown,J.Y., Burford,D.C., Burrill,W., Burton,J., Carder,C.,
            Carter,N.P., Chapman,J.C., Clark,S.Y., Clark,G., Clee,C.M.,
            Clegg,S., Cobley,V., Collier,R.E., Collins,J.E., Colman,L.K.,
            Corby,N.R., Coville,G.J., Culley,K.M., Dhami,P., Davies,J.,
            Dunn,M., Earthrowl,M.E., Ellington,A.E., Evans,K.A., Faulkner,L.,
            Francis,M.D., Frankish,A., Frankland,J., French,L., Garner,P.,
            Garnett,J., Ghori,M.J., Gilby,L.M., Gillson,C.J., Glithero,R.J.,
            Grafham,D.V., Grant,M., Gribble,S., Griffiths,C., Griffiths,M.,
            Hall,R., Halls,K.S., Hammond,S., Harley,J.L., Hart,E.A.,
            Heath,P.D., Heathcott,R., Holmes,S.J., Howden,P.J., Howe,K.L.,
            Howell,G.R., Huckle,E., Humphray,S.J., Humphries,M.D., Hunt,A.R.,
            Johnson,C.M., Joy,A.A., Kay,M., Keenan,S.J., Kimberley,A.M.,
            King,A., Laird,G.K., Langford,C., Lawlor,S., Leongamornlert,D.A.,
            Leversha,M., Lloyd,C.R., Lloyd,D.M., Loveland,J.E., Lovell,J.,
            Martin,S., Mashreghi-Mohammadi,M., Maslen,G.L., Matthews,L.,
            McCann,O.T., McLaren,S.J., McLay,K., McMurray,A., Moore,M.J.,
            Mullikin,J.C., Niblett,D., Nickerson,T., Novik,K.L., Oliver,K.,
            Overton-Larty,E.K., Parker,A., Patel,R., Pearce,A.V., Peck,A.I.,
            Phillimore,B., Phillips,S., Plumb,R.W., Porter,K.M., Ramsey,Y.,
            Ranby,S.A., Rice,C.M., Ross,M.T., Searle,S.M., Sehra,H.K.,
            Sheridan,E., Skuce,C.D., Smith,S., Smith,M., Spraggon,L.,
            Squares,S.L., Steward,C.A., Sycamore,N., Tamlyn-Hall,G., Tester,J.,
            Theaker,A.J., Thomas,D.W., Thorpe,A., Tracey,A., Tromans,A.,
            Tubby,B., Wall,M., Wallis,J.M., West,A.P., White,S.S.,
            Whitehead,S.L., Whittaker,H., Wild,A., Willey,D.J., Wilmer,T.E.,
            Wood,J.M., Wray,P.W., Wyatt,J.C., Young,L., Younger,R.M.,
            Bentley,D.R., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E.,
            Dunham,I., Rogers,J. and Beck,S.
  TITLE     The DNA sequence and analysis of human chromosome 6
  JOURNAL   Nature 425 (6960), 805-811 (2003)
   PUBMED   14574404
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
COMMENT     [FUNCTION] Probably targets cAMP-dependent protein kinase (PKA) to
            the cellular membrane or cytoskeletal structures.
            [SUBUNIT] Binds cAMP-dependent protein kinase (PKA).
            [SUBCELLULAR LOCATION] Cytoplasm.
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=3; Comment=Additional isoforms seem to exist; Name=Gamma;
            IsoId=Q9P0M2-1; Sequence=Displayed; Name=Alpha; IsoId=O43687-2;
            Sequence=External; Name=Beta; IsoId=O43687-1; Sequence=External.
            [TISSUE SPECIFICITY] Expressed in brain, heart, lung, pancreas and
            placenta.
FEATURES             Location/Qualifiers
     source          1..326
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..326
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
     Protein         1..326
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /product="A-kinase anchor protein 7 isoform gamma"
                     /note="AKAP-7 isoform gamma; A-kinase anchor protein 18
                     kDa; Protein kinase A-anchoring protein 7 isoform gamma;
                     AKAP 18"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..326
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A-kinase anchor protein 7 isoform gamma.
                     /FTId=PRO_0000064523."
     Region          4
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in dbSNP:rs7771473). /FTId=VAR_024246."
     Region          16..261
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="AKAP7_NLS"
                     /note="Protein kinase A anchor protein nuclear
                     localisation signal; pfam10469"
                     /db_xref="CDD:118989"
     Region          193
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> N (in dbSNP:rs1190788). /FTId=VAR_024247."
     Region          266..326
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="AKAP7_RIRII_bdg"
                     /note="PKA-RI-RII subunit binding domain of A-kinase
                     anchor protein; pfam10470"
                     /db_xref="CDD:151037"
     Region          273..286
                     /gene="AKAP7"
                     /gene_synonym="AKAP18"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="RII-binding."
ORIGIN      
        1 mseefeantm dslvdmpfat vdiqddcgit depqinlkrs qenewvksdq vkkrkkkrkd
       61 yqpnyflsip itnkeiikgi kilqnaiiqq derlakamvs dgsfhitllv mqllnedevn
      121 igidallelk pfieellqgk hltlpfqgig tfgnqvgfvk laegdhvnsl leiaetanrt
      181 fqekgilvge srsfkphltf mklskspwlr kngvkkidpd lyekfishrf geeilyridl
      241 csmlkkkqsn gyyhcessiv igeknggepd daelvrlskr lvenavlkav qqyleetqnk
      301 nkpgegssvk teaadqngnd nennrk
//

LOCUS       CU081_HUMAN               89 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Putative uncharacterized protein C21orf81.
ACCESSION   Q8NFU9
VERSION     Q8NFU9.1  GI:25089995
DBSOURCE    UniProtKB: locus CU081_HUMAN, accession Q8NFU9;
            class: standard.
            created: Nov 15, 2002.
            sequence updated: Oct 1, 2002.
            annotation updated: Sep 21, 2011.
            xrefs: AF426257.1, AAM53513.1
            xrefs (non-sequence databases): IPI:IPI00183401, UniGene:Hs.364456,
            ProteinModelPortal:Q8NFU9, SMR:Q8NFU9, IntAct:Q8NFU9, PRIDE:Q8NFU9,
            GeneCards:GC21M000712, HGNC:16413, neXtProt:NX_Q8NFU9,
            PhylomeDB:Q8NFU9, CleanEx:HS_C21orf81, Genevestigator:Q8NFU9,
            GermOnline:ENSG00000171562
KEYWORDS    Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 89)
  AUTHORS   Reymond,A., Camargo,A.A., Deutsch,S., Stevenson,B.J.,
            Parmigiani,R.B., Ucla,C., Bettoni,F., Rossier,C., Lyle,R.,
            Guipponi,M., de Souza,S., Iseli,C., Jongeneel,C.V., Bucher,P.,
            Simpson,A.J. and Antonarakis,S.E.
  TITLE     Nineteen additional unpredicted transcripts from human chromosome
            21
  JOURNAL   Genomics 79 (6), 824-832 (2002)
   PUBMED   12036297
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
COMMENT     [TISSUE SPECIFICITY] Widely expressed; not found in kidney, nor in
            liver.
            [CAUTION] Product of a dubious CDS prediction.
FEATURES             Location/Qualifiers
     source          1..89
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..89
                     /gene="C21orf81"
     Protein         1..89
                     /gene="C21orf81"
                     /product="Putative uncharacterized protein C21orf81"
                     /UniProtKB_evidence="Uncertain"
     Region          1..89
                     /gene="C21orf81"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Putative uncharacterized protein C21orf81.
                     /FTId=PRO_0000079533."
ORIGIN      
        1 mklfgfrshr gqtvlgtidh lytgsgyrir yselqkihka avkgdaaeme rclarrsgdl
       61 daldkqhssv sprkcqslyv dlpmekete
//

LOCUS       LEU1_HUMAN                78 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Leukemia-associated protein 1; AltName: Full=Deleted
            in lymphocytic leukemia 1; AltName: Full=HBV X-transactivated gene
            6 protein; AltName: Full=HBV XAg-transactivated protein 6.
ACCESSION   O43261
VERSION     O43261.2  GI:28381371
DBSOURCE    UniProtKB: locus LEU1_HUMAN, accession O43261;
            class: standard.
            extra accessions:Q547G6,Q8TE10,Q96QY5
            created: Dec 1, 2000.
            sequence updated: Feb 12, 2003.
            annotation updated: Sep 21, 2011.
            xrefs: Y15227.1, CAA75515.1, Y15381.1, CAA75600.1, AF490255.1,
            AAO85463.1, AL137060.13, CAC43393.1, CH471075.1, EAX08858.1,
            BC020692.1, AF328925.1, AAL95698.1
            xrefs (non-sequence databases): IPI:IPI00180736,
            ProteinModelPortal:O43261, IntAct:O43261, MINT:MINT-1370081,
            STRING:O43261, Ensembl:ENST00000378180, Ensembl:ENSP00000367422,
            Ensembl:ENSG00000176124, GeneCards:GC13P031451, H-InvDB:HIX0011324,
            H-InvDB:HIX0171888, HGNC:13747, HPA:CAB017848, MIM:605765,
            neXtProt:NX_O43261, eggNOG:maNOG23964, HOVERGEN:HBG036908,
            InParanoid:O43261, OMA:PERNEEQ, OrthoDB:EOG41VK4M,
            PhylomeDB:O43261, ArrayExpress:O43261, Bgee:O43261,
            CleanEx:HS_DLEU1, Genevestigator:O43261,
            GermOnline:ENSG00000176124, GO:0005515
KEYWORDS    Complete proteome; Reference proteome; Tumor suppressor.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 78)
  AUTHORS   Liu,Y., Corcoran,M., Rasool,O., Ivanova,G., Ibbotson,R.,
            Grander,D., Iyengar,A., Baranova,A., Kashuba,V., Merup,M., Wu,X.,
            Gardiner,A., Mullenbach,R., Poltaraus,A., Hultstrom,A.L.,
            Juliusson,G., Chapman,R., Tiller,M., Cotter,F., Gahrton,G.,
            Yankovsky,N., Zabarovsky,E., Einhorn,S. and Oscier,D.
  TITLE     Cloning of two candidate tumor suppressor genes within a 10 kb
            region on chromosome 13q14, frequently deleted in chronic
            lymphocytic leukemia
  JOURNAL   Oncogene 15 (20), 2463-2473 (1997)
   PUBMED   9395242
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA / MRNA].
REFERENCE   2  (residues 1 to 78)
  AUTHORS   Liu,Y., Cheng,J., Lu,Y., Wang,G., Li,K., Chen,J. and Li,L.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-MAR-2002)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA].
REFERENCE   3  (residues 1 to 78)
  AUTHORS   Dunham,A., Matthews,L.H., Burton,J., Ashurst,J.L., Howe,K.L.,
            Ashcroft,K.J., Beare,D.M., Burford,D.C., Hunt,S.E.,
            Griffiths-Jones,S., Jones,M.C., Keenan,S.J., Oliver,K., Scott,C.E.,
            Ainscough,R., Almeida,J.P., Ambrose,K.D., Andrews,D.T.,
            Ashwell,R.I., Babbage,A.K., Bagguley,C.L., Bailey,J., Bannerjee,R.,
            Barlow,K.F., Bates,K., Beasley,H., Bird,C.P., Bray-Allen,S.,
            Brown,A.J., Brown,J.Y., Burrill,W., Carder,C., Carter,N.P.,
            Chapman,J.C., Clamp,M.E., Clark,S.Y., Clarke,G., Clee,C.M.,
            Clegg,S.C., Cobley,V., Collins,J.E., Corby,N., Coville,G.J.,
            Deloukas,P., Dhami,P., Dunham,I., Dunn,M., Earthrowl,M.E.,
            Ellington,A.G., Faulkner,L., Frankish,A.G., Frankland,J.,
            French,L., Garner,P., Garnett,J., Gilbert,J.G., Gilson,C.J.,
            Ghori,J., Grafham,D.V., Gribble,S.M., Griffiths,C., Hall,R.E.,
            Hammond,S., Harley,J.L., Hart,E.A., Heath,P.D., Howden,P.J.,
            Huckle,E.J., Hunt,P.J., Hunt,A.R., Johnson,C., Johnson,D., Kay,M.,
            Kimberley,A.M., King,A., Laird,G.K., Langford,C.J., Lawlor,S.,
            Leongamornlert,D.A., Lloyd,D.M., Lloyd,C., Loveland,J.E.,
            Lovell,J., Martin,S., Mashreghi-Mohammadi,M., McLaren,S.J.,
            McMurray,A., Milne,S., Moore,M.J., Nickerson,T., Palmer,S.A.,
            Pearce,A.V., Peck,A.I., Pelan,S., Phillimore,B., Porter,K.M.,
            Rice,C.M., Searle,S., Sehra,H.K., Shownkeen,R., Skuce,C.D.,
            Smith,M., Steward,C.A., Sycamore,N., Tester,J., Thomas,D.W.,
            Tracey,A., Tromans,A., Tubby,B., Wall,M., Wallis,J.M., West,A.P.,
            Whitehead,S.L., Willey,D.L., Wilming,L., Wray,P.W., Wright,M.W.,
            Young,L., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E., Beck,S.,
            Bentley,D.R., Rogers,J. and Ross,M.T.
  TITLE     The DNA sequence and analysis of human chromosome 13
  JOURNAL   Nature 428 (6982), 522-528 (2004)
   PUBMED   15057823
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   4  (residues 1 to 78)
  AUTHORS   Mural,R.J., Istrail,S., Sutton,G.G., Florea,L., Halpern,A.L.,
            Mobarry,C.M., Lippert,R., Walenz,B., Shatkay,H., Dew,I.,
            Miller,J.R., Flanigan,M.J., Edwards,N.J., Bolanos,R., Fasulo,D.,
            Halldorsson,B.V., Hannenhalli,S., Turner,R., Yooseph,S., Lu,F.,
            Nusskern,D.R., Shue,B.C., Zheng,X.H., Zhong,F., Delcher,A.L.,
            Huson,D.H., Kravitz,S.A., Mouchard,L., Reinert,K., Remington,K.A.,
            Clark,A.G., Waterman,M.S., Eichler,E.E., Adams,M.D.,
            Hunkapiller,M.W., Myers,E.W. and Venter,J.C.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-2005)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   5  (residues 1 to 78)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Placenta
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   6  (residues 1 to 78)
  AUTHORS   Kapanadze,B., Makeeva,N., Corcoran,M., Jareborg,N., Hammarsund,M.,
            Baranova,A., Zabarovsky,E., Vorontsova,O., Merup,M., Gahrton,G.,
            Jansson,M., Yankovsky,N., Einhorn,S., Oscier,D., Grander,D. and
            Sangfelt,O.
  TITLE     Comparative sequence analysis of a region on human chromosome
            13q14, frequently deleted in B-cell chronic lymphocytic leukemia,
            and its homologous region on mouse chromosome 14
  JOURNAL   Genomics 70 (3), 327-334 (2000)
   PUBMED   11161783
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 1-40.
COMMENT     On or before Mar 3, 2010 this sequence version replaced
            gi:74727200, gi:8928174.
            [FUNCTION] May act as a tumor suppressor.
            [INTERACTION] Q92993:KAT5; NbExp=2; IntAct=EBI-710057, EBI-399080.
            [SEQUENCE CAUTION] Sequence=CAA75515.1; Type=Frameshift;
            Positions=73.
FEATURES             Location/Qualifiers
     source          1..78
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..78
                     /gene="DLEU1"
                     /gene_synonym="LEU1"
                     /gene_synonym="XTP6"
     Protein         1..78
                     /gene="DLEU1"
                     /gene_synonym="LEU1"
                     /gene_synonym="XTP6"
                     /product="Leukemia-associated protein 1"
                     /note="Deleted in lymphocytic leukemia 1; HBV
                     X-transactivated gene 6 protein; HBV XAg-transactivated
                     protein 6"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..78
                     /gene="DLEU1"
                     /gene_synonym="LEU1"
                     /gene_synonym="XTP6"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Leukemia-associated protein 1.
                     /FTId=PRO_0000084409."
ORIGIN      
        1 mrpciwihvh lkppcrlvel lpfssalqgl shlslgttlp vilperneeq nlqelshnad
       61 kyqmgdccke eiddsify
//

LOCUS       SEM4B_HUMAN              832 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Semaphorin-4B; Flags: Precursor.
ACCESSION   Q9NPR2
VERSION     Q9NPR2.3  GI:29840873
DBSOURCE    UniProtKB: locus SEM4B_HUMAN, accession Q9NPR2;
            class: standard.
            extra accessions:Q6UXE3,Q8WVP9,Q96FK5,Q9C0B8,Q9H691,Q9NPM8,Q9NPN0
            created: Apr 27, 2001.
            sequence updated: Apr 11, 2003.
            annotation updated: Sep 21, 2011.
            xrefs: AY445887.1, AAR15707.1, AB051532.1, BAB21836.1, AY358392.1,
            AAQ88758.1, AC091167.19, AL390080.1, CAB98204.1, AL390081.1,
            CAB98205.1, AL390082.1, CAB98206.1, AK026133.1, BAB15372.1,
            BC010701.1, AAH10701.2, BC017658.1, AAH17658.1
            xrefs (non-sequence databases): IPI:IPI00419724, IPI:IPI00513964,
            UniGene:Hs.474935, ProteinModelPortal:Q9NPR2, SMR:Q9NPR2,
            STRING:Q9NPR2, PhosphoSite:Q9NPR2, PRIDE:Q9NPR2,
            Ensembl:ENST00000332496, Ensembl:ENSP00000332204,
            Ensembl:ENSG00000185033, Ensembl:ENST00000411539,
            Ensembl:ENSP00000394720, UCSC:uc002boy.1, GeneCards:GC15P066843,
            H-InvDB:HIX0012577, HGNC:10730, HPA:HPA013372, neXtProt:NX_Q9NPR2,
            GeneTree:ENSGT00560000076864, HOVERGEN:HBG061165,
            InParanoid:Q9NPR2, OrthoDB:EOG4CNQQF, PhylomeDB:Q9NPR2,
            ArrayExpress:Q9NPR2, Bgee:Q9NPR2, CleanEx:HS_SEMA4B,
            Genevestigator:Q9NPR2, GermOnline:ENSG00000185033, GO:0016021,
            GO:0004872, GO:0030154, GO:0007399, InterPro:IPR003659,
            InterPro:IPR016201, InterPro:IPR002165, InterPro:IPR001627,
            InterPro:IPR015943, Gene3D:G3DSA:2.130.10.10, Pfam:PF01437,
            Pfam:PF01403, SMART:SM00423, SMART:SM00630, SUPFAM:SSF103575,
            SUPFAM:SSF101912, PROSITE:PS51004
KEYWORDS    Alternative splicing; Complete proteome; Developmental protein;
            Differentiation; Direct protein sequencing; Disulfide bond;
            Glycoprotein; Immunoglobulin domain; Membrane; Neurogenesis;
            Phosphoprotein; Polymorphism; Reference proteome; Signal;
            Transmembrane; Transmembrane helix.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 832)
  AUTHORS   White,J.R., Levinson,N., Lee,S.R., Myers,K.A., Harris,R.A.,
            Balkwill,F., Beard,G.L. and Naylor,S.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-OCT-2003)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ISOFORM 1), AND VARIANT ALA-792.
REFERENCE   2  (residues 1 to 832)
  AUTHORS   Nagase,T., Kikuno,R., Hattori,A., Kondo,Y., Okumura,K. and Ohara,O.
  TITLE     Prediction of the coding sequences of unidentified human genes.
            XIX. The complete sequences of 100 new cDNA clones from brain which
            code for large proteins in vitro
  JOURNAL   DNA Res. 7 (6), 347-355 (2000)
   PUBMED   11214970
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] (ISOFORM 1).;
            TISSUE=Brain
REFERENCE   3  (residues 1 to 832)
  AUTHORS   Clark,H.F., Gurney,A.L., Abaya,E., Baker,K., Baldwin,D., Brush,J.,
            Chen,J., Chow,B., Chui,C., Crowley,C., Currell,B., Deuel,B.,
            Dowd,P., Eaton,D., Foster,J., Grimaldi,C., Gu,Q., Hass,P.E.,
            Heldens,S., Huang,A., Kim,H.S., Klimowski,L., Jin,Y., Johnson,S.,
            Lee,J., Lewis,L., Liao,D., Mark,M., Robbie,E., Sanchez,C.,
            Schoenfeld,J., Seshagiri,S., Simmons,L., Singh,J., Smith,V.,
            Stinson,J., Vagts,A., Vandlen,R., Watanabe,C., Wieand,D., Woods,K.,
            Xie,M.H., Yansura,D., Yi,S., Yu,G., Yuan,J., Zhang,M., Zhang,Z.,
            Goddard,A., Wood,W.I., Godowski,P. and Gray,A.
  TITLE     The secreted protein discovery initiative (SPDI), a large-scale
            effort to identify novel human secreted and transmembrane proteins:
            a bioinformatics assessment
  JOURNAL   Genome Res. 13 (10), 2265-2270 (2003)
   PUBMED   12975309
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA], AND VARIANT ALA-792.
            Erratum:[Genome Res. 2003 Dec;13(12):2759]
REFERENCE   4  (residues 1 to 832)
  AUTHORS   Zody,M.C., Garber,M., Sharpe,T., Young,S.K., Rowen,L., O'Neill,K.,
            Whittaker,C.A., Kamal,M., Chang,J.L., Cuomo,C.A., Dewar,K.,
            FitzGerald,M.G., Kodira,C.D., Madan,A., Qin,S., Yang,X., Abbasi,N.,
            Abouelleil,A., Arachchi,H.M., Baradarani,L., Birditt,B., Bloom,S.,
            Bloom,T., Borowsky,M.L., Burke,J., Butler,J., Cook,A.,
            DeArellano,K., DeCaprio,D., Dorris,L. III, Dors,M., Eichler,E.E.,
            Engels,R., Fahey,J., Fleetwood,P., Friedman,C., Gearin,G.,
            Hall,J.L., Hensley,G., Johnson,E., Jones,C., Kamat,A., Kaur,A.,
            Locke,D.P., Madan,A., Munson,G., Jaffe,D.B., Lui,A., Macdonald,P.,
            Mauceli,E., Naylor,J.W., Nesbitt,R., Nicol,R., O'Leary,S.B.,
            Ratcliffe,A., Rounsley,S., She,X., Sneddon,K.M., Stewart,S.,
            Sougnez,C., Stone,S.M., Topham,K., Vincent,D., Wang,S.,
            Zimmer,A.R., Birren,B.W., Hood,L., Lander,E.S. and Nusbaum,C.
  TITLE     Analysis of the DNA sequence and duplication history of human
            chromosome 15
  JOURNAL   Nature 440 (7084), 671-675 (2006)
   PUBMED   16572171
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   5  (residues 1 to 832)
  AUTHORS   Zhang,Z. and Henzel,W.J.
  TITLE     Signal peptide prediction based on analysis of experimentally
            verified cleavage sites
  JOURNAL   Protein Sci. 13 (10), 2819-2824 (2004)
   PUBMED   15340161
  REMARK    PROTEIN SEQUENCE OF 39-53.
REFERENCE   6  (residues 1 to 832)
  CONSRTM   The European IMAGE consortium
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUL-2000)
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] OF 160-832 (ISOFORM 1), AND
            VARIANT ALA-792.
REFERENCE   7  (residues 1 to 832)
  AUTHORS   Ota,T., Suzuki,Y., Nishikawa,T., Otsuki,T., Sugiyama,T., Irie,R.,
            Wakamatsu,A., Hayashi,K., Sato,H., Nagai,K., Kimura,K., Makita,H.,
            Sekine,M., Obayashi,M., Nishi,T., Shibahara,T., Tanaka,T.,
            Ishii,S., Yamamoto,J., Saito,K., Kawai,Y., Isono,Y., Nakamura,Y.,
            Nagahari,K., Murakami,K., Yasuda,T., Iwayanagi,T., Wagatsuma,M.,
            Shiratori,A., Sudo,H., Hosoiri,T., Kaku,Y., Kodaira,H., Kondo,H.,
            Sugawara,M., Takahashi,M., Kanda,K., Yokoi,T., Furuya,T.,
            Kikkawa,E., Omura,Y., Abe,K., Kamihara,K., Katsuta,N., Sato,K.,
            Tanikawa,M., Yamazaki,M., Ninomiya,K., Ishibashi,T., Yamashita,H.,
            Murakawa,K., Fujimori,K., Tanai,H., Kimata,M., Watanabe,M.,
            Hiraoka,S., Chiba,Y., Ishida,S., Ono,Y., Takiguchi,S., Watanabe,S.,
            Yosida,M., Hotuta,T., Kusano,J., Kanehori,K., Takahashi-Fujii,A.,
            Hara,H., Tanase,T.O., Nomura,Y., Togiya,S., Komai,F., Hara,R.,
            Takeuchi,K., Arita,M., Imose,N., Musashino,K., Yuuki,H., Oshima,A.,
            Sasaki,N., Aotsuka,S., Yoshikawa,Y., Matsunawa,H., Ichihara,T.,
            Shiohata,N., Sano,S., Moriya,S., Momiyama,H., Satoh,N., Takami,S.,
            Terashima,Y., Suzuki,O., Nakagawa,S., Senoh,A., Mizoguchi,H.,
            Goto,Y., Shimizu,F., Wakebe,H., Hishigaki,H., Watanabe,T.,
            Sugiyama,A., Takemoto,M., Kawakami,B., Yamazaki,M., Watanabe,K.,
            Kumagai,A., Itakura,S., Fukuzumi,Y., Fujimori,Y., Komiyama,M.,
            Tashiro,H., Tanigami,A., Fujiwara,T., Ono,T., Yamada,K., Fujii,Y.,
            Ozaki,K., Hirao,M., Ohmori,Y., Kawabata,A., Hikiji,T., Kobatake,N.,
            Inagaki,H., Ikema,Y., Okamoto,S., Okitani,R., Kawakami,T.,
            Noguchi,S., Itoh,T., Shigeta,K., Senba,T., Matsumura,K.,
            Nakajima,Y., Mizuno,T., Morinaga,M., Sasaki,M., Togashi,T.,
            Oyama,M., Hata,H., Watanabe,M., Komatsu,T., Mizushima-Sugano,J.,
            Satoh,T., Shirai,Y., Takahashi,Y., Nakagawa,K., Okumura,K.,
            Nagase,T., Nomura,N., Kikuchi,H., Masuho,Y., Yamashita,R.,
            Nakai,K., Yada,T., Nakamura,Y., Ohara,O., Isogai,T. and Sugano,S.
  TITLE     Complete sequencing and characterization of 21,243 full-length
            human cDNAs
  JOURNAL   Nat. Genet. 36 (1), 40-45 (2004)
   PUBMED   14702039
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] OF 279-832 (ISOFORM 2).
REFERENCE   8  (residues 1 to 832)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] OF 303-832 (ISOFORM 1), AND
            VARIANT ALA-792.;
            TISSUE=Colon, and Pancreas
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
REFERENCE   9  (residues 1 to 832)
  AUTHORS   Liu,T., Qian,W.J., Gritsenko,M.A., Camp,D.G. II, Monroe,M.E.,
            Moore,R.J. and Smith,R.D.
  TITLE     Human plasma N-glycoproteome analysis by immunoaffinity
            subtraction, hydrazide chemistry, and mass spectrometry
  JOURNAL   J. Proteome Res. 4 (6), 2070-2080 (2005)
   PUBMED   16335952
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-64 AND ASN-405, AND
            MASS SPECTROMETRY.;
            TISSUE=Plasma
REFERENCE   10 (residues 1 to 832)
  AUTHORS   Olsen,J.V., Blagoev,B., Gnad,F., Macek,B., Kumar,C., Mortensen,P.
            and Mann,M.
  TITLE     Global, in vivo, and site-specific phosphorylation dynamics in
            signaling networks
  JOURNAL   Cell 127 (3), 635-648 (2006)
   PUBMED   17081983
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-813 AND SER-825, AND
            MASS SPECTROMETRY.;
            TISSUE=Cervix carcinoma
REFERENCE   11 (residues 1 to 832)
  AUTHORS   Dephoure,N., Zhou,C., Villen,J., Beausoleil,S.A., Bakalarski,C.E.,
            Elledge,S.J. and Gygi,S.P.
  TITLE     A quantitative atlas of mitotic phosphorylation
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 105 (31), 10762-10767 (2008)
   PUBMED   18669648
  REMARK    PHOSPHORYLATION [LARGE SCALE ANALYSIS] AT SER-825, AND MASS
            SPECTROMETRY.;
            TISSUE=Cervix carcinoma
COMMENT     On Apr 15, 2003 this sequence version replaced gi:13633936.
            [FUNCTION] Inhibits axonal extension by providing local signals to
            specify territories inaccessible for growing axons (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=2; Name=1; IsoId=Q9NPR2-1; Sequence=Displayed; Name=2;
            IsoId=Q9NPR2-2; Sequence=VSP_012460; Note=No experimental
            confirmation available.
            [SIMILARITY] Belongs to the semaphorin family.
            [SIMILARITY] Contains 1 Ig-like C2-type (immunoglobulin-like)
            domain.
            [SIMILARITY] Contains 1 PSI domain.
            [SIMILARITY] Contains 1 Sema domain.
            [SEQUENCE CAUTION] Sequence=AAQ88758.1; Type=Erroneous initiation;
            Note=Translation N-terminally shortened; Sequence=AAR15707.1;
            Type=Erroneous initiation; Note=Translation N-terminally shortened;
            Sequence=BAB15372.1; Type=Erroneous initiation; Note=Translation
            N-terminally extended; Sequence=BAB21836.1; Type=Erroneous
            initiation; Note=Translation N-terminally shortened.
FEATURES             Location/Qualifiers
     source          1..832
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..832
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
     Protein         1..832
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /product="Semaphorin-4B"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..38
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          39..832
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Semaphorin-4B. /FTId=PRO_0000032324."
     Region          39..712
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          42..518
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Sema."
     Site            64
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          65..494
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Sema"
                     /note="Sema domain; cl08322"
                     /db_xref="CDD:198920"
     Site            91
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            115..126
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            144..153
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          160
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> P (in Ref. 6; CAB98205)."
     Site            160
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Bond            281..394
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Bond            305..354
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            405
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          520..574
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="PSI."
     Region          520..>545
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="PSI"
                     /note="Plexin repeat; cl02601"
                     /db_xref="CDD:198740"
     Site            520
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          565
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> K (in Ref. 8; AAH10701)."
     Region          589..672
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Ig_Sema4B_like"
                     /note="Immunoglobulin (Ig)-like domain of the class IV
                     semaphorin Sema4B; cd05872"
                     /db_xref="CDD:143280"
     Region          599..658
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C2-type."
     Site            order(601,640)
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="other"
                     /note="dimer interface [polypeptide binding]"
                     /db_xref="CDD:143280"
     Bond            606..651
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            625
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (Potential)."
     Region          709..832
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="YWKEFLVMCTLFVLAVLLPVLFLLYRHRNSMKVFLKQGECASVHPKTCPVV
                     LPPETRPLNGLGPPSTPLDHRGYQSLSDSPPGSRVFTESEKRPLSIQDSFVEVSPVCP
                     RPRVRLGSEIRDSVV -> WARTQLLDLSSLYQAVATREDSASSGEIS (in
                     isoform 2). /FTId=VSP_012460."
     Region          713..733
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          734..832
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          753..776
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Compositionally biased region"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Pro-rich."
     Region          792
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> A. /FTId=VAR_010758."
     Site            813
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
     Site            825
                     /gene="SEMA4B"
                     /locus_tag="UNQ749/PRO1480"
                     /gene_synonym="KIAA1745"
                     /gene_synonym="SEMAC"
                     /site_type="modified"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Phosphoserine."
ORIGIN      
        1 mglrswlaap wgalpprppl llllllllll qpppptwals prislplgse erpflrfeae
       61 hisnytalll srdgrtlyvg arealfalss nlsflpggey qellwgadae kkqqcsfkgk
      121 dpqrdcqnyi killplsgsh lftcgtaafs pmctyinmen ftlardekgn vlledgkgrc
      181 pfdpnfksta lvvdgelytg tvssfqgndp aisrsqslrp tktesslnwl qdpafvasay
      241 ipeslgslqg dddkiyfffs etgqefeffe ntivsriari ckgdeggerv lqqrwtsflk
      301 aqllcsrpdd gfpfnvlqdv ftlspspqdw rdtlfygvft sqwhrgtteg savcvftmkd
      361 vqrvfsglyk evnretqqwy tvthpvptpr pgacitnsar erkinsslql pdrvlnflkd
      421 hflmdgqvrs rmlllqpqar yqrvavhrvp glhhtydvlf lgtgdgrlhk avsvgprvhi
      481 ieelqifssg qpvqnllldt hrgllyaash sgvvqvpman cslyrscgdc llardpycaw
      541 sgssckhvsl yqpqlatrpw iqdiegasak dlcsassvvs psfvptgekp ceqvqfqpnt
      601 vntlacplls nlatrlwlrn gapvnasasc hvlptgdlll vgtqqlgefq cwsleegfqq
      661 lvasycpevv edgvadqtde ggsvpviist srvsapaggk aswgadrsyw keflvmctlf
      721 vlavllpvlf llyrhrnsmk vflkqgecas vhpktcpvvl ppetrplngl gppstpldhr
      781 gyqslsdspp gsrvftesek rplsiqdsfv evspvcprpr vrlgseirds vv
//

LOCUS       CN048_HUMAN              140 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=Uncharacterized protein C14orf48.
ACCESSION   Q8NCU1
VERSION     Q8NCU1.1  GI:30172877
DBSOURCE    UniProtKB: locus CN048_HUMAN, accession Q8NCU1;
            class: standard.
            extra accessions:Q8N7S1
            created: Apr 23, 2003.
            sequence updated: Oct 1, 2002.
            annotation updated: Sep 21, 2011.
            xrefs: BC021728.2, AK097741.1, BAC05156.1
            xrefs (non-sequence databases): IPI:IPI00168455, IPI:IPI00242370,
            UniGene:Hs.143845, ProteinModelPortal:Q8NCU1, IntAct:Q8NCU1,
            PRIDE:Q8NCU1, UCSC:uc001ycg.1, GeneCards:GC14P074643, HGNC:19860,
            neXtProt:NX_Q8NCU1, eggNOG:prNOG21924, InParanoid:Q8NCU1,
            OMA:ESLEESH, PhylomeDB:Q8NCU1, NextBio:92792, ArrayExpress:Q8NCU1,
            CleanEx:HS_C14orf48, Genevestigator:Q8NCU1,
            GermOnline:ENSG00000175699
KEYWORDS    Alternative splicing; Complete proteome; Reference proteome.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 140)
  AUTHORS   Ota,T., Suzuki,Y., Nishikawa,T., Otsuki,T., Sugiyama,T., Irie,R.,
            Wakamatsu,A., Hayashi,K., Sato,H., Nagai,K., Kimura,K., Makita,H.,
            Sekine,M., Obayashi,M., Nishi,T., Shibahara,T., Tanaka,T.,
            Ishii,S., Yamamoto,J., Saito,K., Kawai,Y., Isono,Y., Nakamura,Y.,
            Nagahari,K., Murakami,K., Yasuda,T., Iwayanagi,T., Wagatsuma,M.,
            Shiratori,A., Sudo,H., Hosoiri,T., Kaku,Y., Kodaira,H., Kondo,H.,
            Sugawara,M., Takahashi,M., Kanda,K., Yokoi,T., Furuya,T.,
            Kikkawa,E., Omura,Y., Abe,K., Kamihara,K., Katsuta,N., Sato,K.,
            Tanikawa,M., Yamazaki,M., Ninomiya,K., Ishibashi,T., Yamashita,H.,
            Murakawa,K., Fujimori,K., Tanai,H., Kimata,M., Watanabe,M.,
            Hiraoka,S., Chiba,Y., Ishida,S., Ono,Y., Takiguchi,S., Watanabe,S.,
            Yosida,M., Hotuta,T., Kusano,J., Kanehori,K., Takahashi-Fujii,A.,
            Hara,H., Tanase,T.O., Nomura,Y., Togiya,S., Komai,F., Hara,R.,
            Takeuchi,K., Arita,M., Imose,N., Musashino,K., Yuuki,H., Oshima,A.,
            Sasaki,N., Aotsuka,S., Yoshikawa,Y., Matsunawa,H., Ichihara,T.,
            Shiohata,N., Sano,S., Moriya,S., Momiyama,H., Satoh,N., Takami,S.,
            Terashima,Y., Suzuki,O., Nakagawa,S., Senoh,A., Mizoguchi,H.,
            Goto,Y., Shimizu,F., Wakebe,H., Hishigaki,H., Watanabe,T.,
            Sugiyama,A., Takemoto,M., Kawakami,B., Yamazaki,M., Watanabe,K.,
            Kumagai,A., Itakura,S., Fukuzumi,Y., Fujimori,Y., Komiyama,M.,
            Tashiro,H., Tanigami,A., Fujiwara,T., Ono,T., Yamada,K., Fujii,Y.,
            Ozaki,K., Hirao,M., Ohmori,Y., Kawabata,A., Hikiji,T., Kobatake,N.,
            Inagaki,H., Ikema,Y., Okamoto,S., Okitani,R., Kawakami,T.,
            Noguchi,S., Itoh,T., Shigeta,K., Senba,T., Matsumura,K.,
            Nakajima,Y., Mizuno,T., Morinaga,M., Sasaki,M., Togashi,T.,
            Oyama,M., Hata,H., Watanabe,M., Komatsu,T., Mizushima-Sugano,J.,
            Satoh,T., Shirai,Y., Takahashi,Y., Nakagawa,K., Okumura,K.,
            Nagase,T., Nomura,N., Kikuchi,H., Masuho,Y., Yamashita,R.,
            Nakai,K., Yada,T., Nakamura,Y., Ohara,O., Isogai,T. and Sugano,S.
  TITLE     Complete sequencing and characterization of 21,243 full-length
            human cDNAs
  JOURNAL   Nat. Genet. 36 (1), 40-45 (2004)
   PUBMED   14702039
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] (ISOFORM 2).;
            TISSUE=Testis
REFERENCE   2  (residues 1 to 140)
  AUTHORS   Gerhard,D.S., Wagner,L., Feingold,E.A., Shenmen,C.M., Grouse,L.H.,
            Schuler,G., Klein,S.L., Old,S., Rasooly,R., Good,P., Guyer,M.,
            Peck,A.M., Derge,J.G., Lipman,D., Collins,F.S., Jang,W., Sherry,S.,
            Feolo,M., Misquitta,L., Lee,E., Rotmistrovsky,K., Greenhut,S.F.,
            Schaefer,C.F., Buetow,K., Bonner,T.I., Haussler,D., Kent,J.,
            Kiekhaus,M., Furey,T., Brent,M., Prange,C., Schreiber,K.,
            Shapiro,N., Bhat,N.K., Hopkins,R.F., Hsie,F., Driscoll,T.,
            Soares,M.B., Casavant,T.L., Scheetz,T.E., Brown-stein,M.J.,
            Usdin,T.B., Toshiyuki,S., Carninci,P., Piao,Y., Dudekula,D.B.,
            Ko,M.S., Kawakami,K., Suzuki,Y., Sugano,S., Gruber,C.E.,
            Smith,M.R., Simmons,B., Moore,T., Waterman,R., Johnson,S.L.,
            Ruan,Y., Wei,C.L., Mathavan,S., Gunaratne,P.H., Wu,J., Garcia,A.M.,
            Hulyk,S.W., Fuh,E., Yuan,Y., Sneed,A., Kowis,C., Hodgson,A.,
            Muzny,D.M., McPherson,J., Gibbs,R.A., Fahey,J., Helton,E.,
            Ketteman,M., Madan,A., Rodrigues,S., Sanchez,A., Whiting,M.,
            Madari,A., Young,A.C., Wetherby,K.D., Granite,S.J., Kwong,P.N.,
            Brinkley,C.P., Pearson,R.L., Bouffard,G.G., Blakesly,R.W.,
            Green,E.D., Dickson,M.C., Rodriguez,A.C., Grimwood,J., Schmutz,J.,
            Myers,R.M., Butterfield,Y.S., Griffith,M., Griffith,O.L.,
            Krzywinski,M.I., Liao,N., Morin,R., Palmquist,D., Petrescu,A.S.,
            Skalska,U., Smailus,D.E., Stott,J.M., Schnerch,A., Schein,J.E.,
            Jones,S.J., Holt,R.A., Baross,A., Marra,M.A., Clifton,S.,
            Makowski,K.A., Bosak,S. and Malek,J.
  CONSRTM   MGC Project Team
  TITLE     The status, quality, and expansion of the NIH full-length cDNA
            project: the Mammalian Gene Collection (MGC)
  JOURNAL   Genome Res. 14 (10B), 2121-2127 (2004)
   PUBMED   15489334
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA] (ISOFORM 1).;
            TISSUE=Testis
            Erratum:[Genome Res. 2006 Jun;16(6):804. Morrin, Ryan [corrected to
            Morin, Ryan]]
COMMENT     [ALTERNATIVE PRODUCTS] Event=Alternative splicing; Named
            isoforms=2; Name=1; IsoId=Q8NCU1-1; Sequence=Displayed; Name=2;
            IsoId=Q8NCU1-2; Sequence=VSP_007204, VSP_007205; Note=No
            experimental confirmation available.
            [SEQUENCE CAUTION] Sequence=BAC05156.1; Type=Erroneous initiation.
FEATURES             Location/Qualifiers
     source          1..140
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..140
                     /gene="C14orf48"
     Protein         1..140
                     /gene="C14orf48"
                     /product="Uncharacterized protein C14orf48"
                     /UniProtKB_evidence="Evidence at transcript level"
     Region          1..140
                     /gene="C14orf48"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Uncharacterized protein C14orf48.
                     /FTId=PRO_0000089892."
     Region          118..124
                     /gene="C14orf48"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="IASRSGC -> MLLSHNK (in isoform 2).
                     /FTId=VSP_007204."
     Region          125..140
                     /gene="C14orf48"
                     /region_name="Splicing variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Missing (in isoform 2). /FTId=VSP_007205."
ORIGIN      
        1 mdtgqradps npgdkegdlq glwqelyqlq akqkklkrev ekhklfedyl ikvlekipeg
       61 ctgweepeev lveatvkhyg klftasqdtq krleafcqmi qavhrslesl eedhralias
      121 rsgcvscrrs atasrssggs
//

LOCUS       1B27_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-27 alpha
            chain; AltName: Full=MHC class I antigen B*27; Flags: Precursor.
ACCESSION   P03989
VERSION     P03989.2  GI:34305677
DBSOURCE    UniProtKB: locus 1B27_HUMAN, accession P03989;
            class: standard.
            extra
            accessions:O19692,P10317,P10318,P19373,P30467,Q08136,Q29693,Q29846,
            Q29961
            created: Oct 23, 1986.
            sequence updated: Aug 13, 1987.
            annotation updated: Sep 21, 2011.
            xrefs: X03945.1, CAA27578.1, X03664.1, CAA27301.1, X03667.1,
            L38504.1, AAA69724.1, M54883.1, AAA59616.1, X03665.1, CAA27302.1,
            X03666.1, M12967.1, AAA36221.1, U27608.1, AAC50444.1, U35734.1,
            AAC50447.1, M14013.1, AAA59643.1, X73578.1, CAA51980.1, M62852.1,
            AAA59647.1, L19923.1, AAA59658.1, Z33453.1, CAA83876.1, I37515,
            I56116, HLHUB2, 1HSA_A, 1HSA_D, 1JGD_A, 1JGE_A, 1K5N_A, 1OF2_A,
            1OGT_A, 1ROG_A, 1ROH_A, 1ROI_A, 1ROJ_A, 1ROK_A, 1ROL_A, 1UXS_A,
            1UXW_A, 1W0V_A, 1W0W_A, 2A83_A, 2BSR_A, 2BSS_A, 2BST_A, 3B3I_A,
            3B6S_A, 3BP4_A, 3BP7_A, 3CZF_A, 3D18_A, 3DTX_A, 3HCV_A, 3LV3_A
            xrefs (non-sequence databases): IPI:IPI00471986, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1HSA, PDBsum:1JGD,
            PDBsum:1JGE, PDBsum:1K5N, PDBsum:1OF2, PDBsum:1OGT, PDBsum:1ROG,
            PDBsum:1ROH, PDBsum:1ROI, PDBsum:1ROJ, PDBsum:1ROK, PDBsum:1ROL,
            PDBsum:1UXS, PDBsum:1UXW, PDBsum:1W0V, PDBsum:1W0W, PDBsum:2A83,
            PDBsum:2BSR, PDBsum:2BSS, PDBsum:2BST, PDBsum:3B3I, PDBsum:3B6S,
            PDBsum:3BP4, PDBsum:3BP7, PDBsum:3CZF, PDBsum:3D18, PDBsum:3DTX,
            PDBsum:3HCV, PDBsum:3LV3, ProteinModelPortal:P03989, SMR:P03989,
            DIP:DIP-6188N, MINT:MINT-247525, STRING:P03989, PRIDE:P03989,
            Ensembl:ENST00000435618, Ensembl:ENSP00000405178,
            Ensembl:ENSG00000224608, GeneCards:GC06M031112,
            GeneCards:GC06Ml31364, HGNC:4932, MIM:106300, MIM:142830,
            neXtProt:NX_P03989, Orphanet:240841, Orphanet:240845, Orphanet:825,
            Orphanet:117, Orphanet:240857, Orphanet:240871, Orphanet:240899,
            Orphanet:240901, Orphanet:241001, Orphanet:241005, Orphanet:241035,
            Orphanet:241037, Orphanet:241039, Orphanet:241041,
            HOVERGEN:HBG016709, InParanoid:P03989, Reactome:REACT_6900,
            CleanEx:HS_HLA-B, Genevestigator:P03989, GO:0016021, GO:0005624,
            GO:0042612, GO:0002474, GO:0060333, GO:0044419, GO:0050776,
            GO:0060337, InterPro:IPR007110, InterPro:IPR013783,
            InterPro:IPR003006, InterPro:IPR003597, InterPro:IPR011161,
            InterPro:IPR011162, InterPro:IPR001039, InterPro:IPR010579,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.30.500.10, Pfam:PF07654,
            Pfam:PF00129, Pfam:PF06623, PRINTS:PR01638, SMART:SM00407,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Direct protein sequencing;
            Disulfide bond; Glycoprotein; Host-virus interaction; Immunity;
            Membrane; MHC I; Polymorphism; Reference proteome; Signal;
            Transmembrane; Transmembrane helix; Ubl conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Weiss,E.H., Kuon,W., Dorner,C., Lang,M. and Riethmuller,G.
  TITLE     Organization, sequence and expression of the HLA-B27 gene: a
            molecular approach to analyze HLA and disease associations
  JOURNAL   Immunobiology 170 (5), 367-380 (1985)
   PUBMED   3912316
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*27:01).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Szots,H., Riethmuller,G., Weiss,E. and Meo,T.
  TITLE     Complete sequence of HLA-B27 cDNA identified through the
            characterization of structural markers unique to the HLA-A, -B, and
            -C allelic series
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 83 (5), 1428-1432 (1986)
   PUBMED   3485286
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 25-361 (ALLELE B*27:01).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Ezquerra,A., Bragado,R., Vega,M.A., Strominger,J.L., Woody,J. and
            Lopez de Castro,J.A.
  TITLE     Primary structure of papain-solubilized human histocompatibility
            antigen HLA-B27
  JOURNAL   Biochemistry 24 (7), 1733-1741 (1985)
   PUBMED   2408663
  REMARK    PROTEIN SEQUENCE OF 25-295 (B*27:01).
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Seemann,G.H., Rein,R.S., Brown,C.S. and Ploegh,H.L.
  TITLE     Gene conversion-like mechanisms may generate polymorphism in human
            class I genes
  JOURNAL   EMBO J. 5 (3), 547-552 (1986)
   PUBMED   3011411
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELES B*27:01 AND B*27:02).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Moses,J.H., Marsh,S.G., Arnett,K.L., Adams,E.J., Bodmer,J.G. and
            Parham,P.
  TITLE     On the nucleotide sequences of B*2702 and B*2705
  JOURNAL   Tissue Antigens 46 (1), 50-53 (1995)
   PUBMED   7482496
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*27:02).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Vega,M.A., Ezquerra,A., Rojo,S., Aparicio,P., Bragado,R. and Lopez
            de Castro,J.A.
  TITLE     Structural analysis of an HLA-B27 functional variant:
            identification of residues that contribute to the specificity of
            recognition by cytolytic T lymphocytes
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 82 (21), 7394-7398 (1985)
   PUBMED   2414775
  REMARK    PROTEIN SEQUENCE OF 86-107 AND 171-181 (B*27:02).
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Choo,S.Y., St John,T., Orr,H.T. and Hansen,J.A.
  TITLE     Molecular analysis of the variant alloantigen HLA-B27d (HLA-B*2703)
            identifies a unique single amino acid substitution
  JOURNAL   Hum. Immunol. 21 (3), 209-219 (1988)
   PUBMED   3286582
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE B*27:03).
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Rudwaleit,M., Bowness,P. and Wordsworth,P.
  TITLE     The nucleotide sequence of HLA-B*2704 reveals a new amino acid
            substitution in exon 4 which is also present in HLA-B*2706
  JOURNAL   Immunogenetics 43 (3), 160-162 (1996)
   PUBMED   8550101
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES B*27:04 AND B*27:06).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Coppin,H.L. and McDevitt,H.O.
  TITLE     Absence of polymorphism between HLA-B27 genomic exon sequences
            isolated from normal donors and ankylosing spondylitis patients
  JOURNAL   J. Immunol. 137 (7), 2168-2172 (1986)
   PUBMED   3489755
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 25-298 (ALLELE B*27:05).
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Vilches,C., de Pablo,R. and Kreisler,M.
  TITLE     Nucleotide sequence of HLA-B*2706
  JOURNAL   Immunogenetics 39 (3), 219 (1994)
   PUBMED   8276469
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*27:06).
            Erratum:[Immunogenetics 1996;43(1-2):114]
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Choo,S.Y., Fan,L.A. and Hansen,J.A.
  TITLE     A novel HLA-B27 allele maps B27 allospecificity to the region
            around position 70 in the alpha 1 domain
  JOURNAL   J. Immunol. 147 (1), 174-180 (1991)
   PUBMED   1711072
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*27:07).
REFERENCE   12 (residues 1 to 362)
  AUTHORS   Hildebrand,W.H., Domena,J.D., Shen,S.Y., Marsh,S.G., Bunce,M.,
            Guttridge,M.G., Darke,C. and Parham,P.
  TITLE     The HLA-B7Qui antigen is encoded by a new subtype of HLA-B27
            (B*2708)
  JOURNAL   Tissue Antigens 44 (1), 47-51 (1994)
   PUBMED   7974468
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*27:08).
REFERENCE   13 (residues 1 to 362)
  AUTHORS   Del Porto,P., D'Amato,M., Fiorillo,M.T., Tuosto,L., Piccolella,E.
            and Sorrentino,R.
  TITLE     Identification of a novel HLA-B27 subtype by restriction analysis
            of a cytotoxic gamma delta T cell clone
  JOURNAL   J. Immunol. 153 (7), 3093-3100 (1994)
   PUBMED   8089488
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*27:09).;
            TISSUE=Blood
REFERENCE   14 (residues 1 to 362)
  AUTHORS   Chen,R., Jiang,X., Sun,D., Han,G., Wang,F., Ye,M., Wang,L. and
            Zou,H.
  TITLE     Glycoproteomics analysis of human liver tissue by combination of
            multiple enzyme digestion and hydrazide chemistry
  JOURNAL   J. Proteome Res. 8 (2), 651-661 (2009)
   PUBMED   19159218
  REMARK    GLYCOSYLATION [LARGE SCALE ANALYSIS] AT ASN-110, AND MASS
            SPECTROMETRY.;
            TISSUE=Liver
REFERENCE   15 (residues 1 to 362)
  AUTHORS   Madden,D.R., Gorga,J.C., Strominger,J.L. and Wiley,D.C.
  TITLE     The three-dimensional structure of HLA-B27 at 2.1 A resolution
            suggests a general mechanism for tight peptide binding to MHC
  JOURNAL   Cell 70 (6), 1035-1048 (1992)
   PUBMED   1525820
  REMARK    X-RAY CRYSTALLOGRAPHY (2.1 ANGSTROMS) OF 25-300.
REFERENCE   16 (residues 1 to 362)
  AUTHORS   Madden,D.R., Gorga,J.C., Strominger,J.L. and Wiley,D.C.
  TITLE     The structure of HLA-B27 reveals nonamer self-peptides bound in an
            extended conformation
  JOURNAL   Nature 353 (6342), 321-325 (1991)
   PUBMED   1922337
  REMARK    X-RAY CRYSTALLOGRAPHY (1.9 ANGSTROMS) OF 25-300.
REFERENCE   17 (residues 1 to 362)
  AUTHORS   Hulsmeyer,M., Hillig,R.C., Volz,A., Ruhl,M., Schroder,W.,
            Saenger,W., Ziegler,A. and Uchanska-Ziegler,B.
  TITLE     HLA-B27 subtypes differentially associated with disease exhibit
            subtle structural alterations
  JOURNAL   J. Biol. Chem. 277 (49), 47844-47853 (2002)
   PUBMED   12244049
  REMARK    X-RAY CRYSTALLOGRAPHY (2.1 ANGSTROMS) OF 25-300.
REFERENCE   18 (residues 1 to 362)
  AUTHORS   Rognan,D., Scapozza,L., Folkers,G. and Daser,A.
  TITLE     Rational design of nonnatural peptides as high-affinity ligands for
            the HLA-B*2705 human leukocyte antigen
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 92 (3), 753-757 (1995)
   PUBMED   7846047
  REMARK    3D-STRUCTURE MODELING OF 115-206.
REFERENCE   19 (residues 1 to 362)
  AUTHORS   Varnavidou-Nicolaidou,A., Karpasitou,K., Georgiou,D., Stylianou,G.,
            Kokkofitou,A., Michalis,C., Constantina,C., Gregoriadou,C. and
            Kyriakides,G.
  TITLE     HLA-B27 in the Greek Cypriot population: distribution of subtypes
            in patients with ankylosing spondylitis and other HLA-B27-related
            diseases. The possible protective role of B*2707
  JOURNAL   Hum. Immunol. 65 (12), 1451-1454 (2004)
   PUBMED   15603872
  REMARK    DISEASE, AND POSSIBLE PROTECTIVE ROLE OF ALLELE B*27:07.
COMMENT     On or before Apr 26, 2005 this sequence version replaced
            gi:2118844, gi:2118796, gi:1070579, gi:122166, gi:122167,
            gi:122177, gi:231389, gi:1168213, gi:122164.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-27 are known:
            B*27:01=B*27:05, B*27:02 (B27.2; B-27k; B27e), B*27:03 (B27d),
            B*27:04, B*27:06, B*27:07, B*27:08 (B7Qui) and B*27:09 (B27-ci).
            The sequence shown is that of B*27:01.
            [DISEASE] Defects in HLA-B are a cause of susceptibility to
            spondyloarthropathy type 1 (SPDA1) [MIM:106300]. It is a chronic
            rheumatic disease with multifactorial inheritance. It includes a
            spectrum of related disorders comprising ankylosing spondylitis, a
            subset of psoriatic arthritis, reactive arthritis (e.g.,Reiter
            syndrome), arthritis associated with inflammatory bowel disease and
            undifferentiated spondyloarthropathy. These disorders may occur
            simultaneously or sequentially in the same patient, probably
            representing various phenotypic expressions of the same disease.
            Ankylosing spondylitis is the form of rheumatoid arthritis
            affecting the spine and is considered the prototype of seronegative
            spondyloarthropathies. It produces pain and stiffness as a result
            of inflammation of the sacroiliac, intervertebral, and
            costovertebral joints. Note=In the Greek Cypriot population, a
            restricted number of HLA-B27 subtypes are associated with
            ankylosing spondylitis and other B27-related diseases and an
            elevated frequency of the B*2702 allele in ankylosing spondylitis
            patients is identified. The allele B*2707 seems to have a
            protective role in this population because it was found only in the
            healthy controls.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-27
                     alpha chain"
                     /note="MHC class I antigen B*27"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-27 alpha
                     chain. /FTId=PRO_0000018839."
     Region          25..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          41..43
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          65
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1050529). /FTId=VAR_056341."
     Region          74..76
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          83
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Y -> H (in allele B*27:03). /FTId=VAR_016379."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> N (in allele B*27:02). /FTId=VAR_016380."
     Region          101
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> S (in allele B*27:04, allele B*27:06 and
                     allele B*27:08; requires 2 nucleotide substitutions).
                     /FTId=VAR_016381."
     Region          104..105
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TL -> IA (in allele B*27:02). /FTId=VAR_016382."
     Region          104
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="T -> N (in allele B*27:08). /FTId=VAR_016383."
     Region          106..107
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="LR -> RG (in allele B*27:08). /FTId=VAR_016384."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N-linked (GlcNAc...)."
     Region          113..115
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="N -> S (in allele B*27:07). /FTId=VAR_016385."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          137..138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="YH -> HN (in allele B*27:07). /FTId=VAR_016386."
     Region          138
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> D (in allele B*27:06). /FTId=VAR_016387."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> H (in allele B*27:09). /FTId=VAR_016388."
     Region          140
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="D -> Y (in allele B*27:06 and allele B*27:07).
                     /FTId=VAR_016389."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          155
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> R (in allele B*27:07). /FTId=VAR_016390."
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> E (in allele B*27:04 and allele B*27:06).
                     /FTId=VAR_016391."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          199..204
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Hydrogen bonded turn"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> V (in Ref. 2)."
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..219
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          222..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> G (in allele B*27:04 and allele B*27:06).
                     /FTId=VAR_016392."
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          266
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Conflict"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Q -> E (in Ref. 3; AA sequence)."
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..308
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          306
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="V -> I (in dbSNP:rs1131500). /FTId=VAR_056342."
     Region          309..332
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          329
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> T (in dbSNP:rs1051488). /FTId=VAR_056343."
     Region          333..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> S (in dbSNP:rs2308655). /FTId=VAR_061402."
     Region          349
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="C -> Y (in dbSNP:rs2308655). /FTId=VAR_061403."
ORIGIN      
        1 mrvtaprtll lllwgavalt etwagshsmr yfhtsvsrpg rgeprfitvg yvddtlfvrf
       61 dsdaaspree prapwieqeg peywdretqi ckakaqtdre dlrtllryyn qseagshtlq
      121 nmygcdvgpd grllrgyhqd aydgkdyial nedlsswtaa dtaaqitqrk weaarvaeql
      181 raylegecve wlrrylengk etlqradppk thvthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstvpivg ivaglavlav vvigavvaav mcrrkssggk ggsysqaacs dsaqgsdvsl
      361 ta
//

LOCUS       1B15_HUMAN               362 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class I histocompatibility antigen, B-15 alpha
            chain; AltName: Full=MHC class I antigen B*15; Flags: Precursor.
ACCESSION   P30464
VERSION     P30464.2  GI:34305703
DBSOURCE    UniProtKB: locus 1B15_HUMAN, accession P30464;
            class: standard.
            extra
            accessions:B0V0B8,P30465,P30513,Q29633,Q29636,Q29829,Q29953,Q29982,
            Q95343,Q95344,Q9BD06
            created: Apr 1, 1993.
            sequence updated: Aug 22, 2003.
            annotation updated: Sep 21, 2011.
            xrefs: M75138.1, AAA59630.1, U03859.1, AAA03601.1, U03027.1,
            AAA18902.1, L11604.1, AAA56836.1, D50292.1, BAA08823.1, D50293.1,
            BAA08824.1, D50294.1, BAA08825.1, X61709.1, CAA43878.1, M84382.1,
            AAA59632.1, U70528.1, AAB16918.1, AJ295140.2, CAC17462.1,
            AJ308399.1, CAC33441.1, CR759828.5, CAQ10738.1, M28203.1,
            AAA53258.1, M83193.1, AAA58628.1, G01230, I38421, I62042, S16789,
            S24433, S77966, 1XR8_A, 1XR9_A, 3C9N_A
            xrefs (non-sequence databases): IPI:IPI00646083, UniGene:Hs.654404,
            UniGene:Hs.703277, UniGene:Hs.77961, PDBsum:1XR8, PDBsum:1XR9,
            PDBsum:3C9N, ProteinModelPortal:P30464, SMR:P30464, STRING:P30464,
            PRIDE:P30464, Ensembl:ENST00000450871, Ensembl:ENSP00000388208,
            Ensembl:ENSG00000232126, GeneCards:GC06M031112,
            GeneCards:GC06Mm31398, HGNC:4932, MIM:142830, MIM:608579,
            neXtProt:NX_P30464, HOVERGEN:HBG016709, InParanoid:P30464,
            OrthoDB:EOG4F4SBG, Reactome:REACT_6900, Bgee:P30464,
            CleanEx:HS_HLA-B, Genevestigator:P30464, GO:0016021, GO:0042612,
            GO:0002474, GO:0060333, GO:0044419, GO:0050776, GO:0060337,
            InterPro:IPR007110, InterPro:IPR013783, InterPro:IPR003006,
            InterPro:IPR003597, InterPro:IPR011161, InterPro:IPR011162,
            InterPro:IPR001039, InterPro:IPR010579, Gene3D:G3DSA:2.60.40.10,
            Gene3D:G3DSA:3.30.500.10, Pfam:PF07654, Pfam:PF00129, Pfam:PF06623,
            PRINTS:PR01638, SMART:SM00407, SUPFAM:SSF54452, PROSITE:PS50835,
            PROSITE:PS00290
KEYWORDS    3D-structure; Complete proteome; Disulfide bond; Glycoprotein;
            Host-virus interaction; Immunity; Membrane; MHC I; Polymorphism;
            Reference proteome; Signal; Transmembrane; Transmembrane helix; Ubl
            conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 362)
  AUTHORS   Little,A.M. and Parham,P.
  TITLE     The HLA-Bw75 subtype of B15: molecular characterization and
            comparison with crossreacting antigens
  JOURNAL   Tissue Antigens 38 (4), 186-190 (1991)
   PUBMED   1801311
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE B*15:02).
REFERENCE   2  (residues 1 to 362)
  AUTHORS   Hildebrand,W.H., Domena,J.D., Shen,S.Y., Lau,M., Terasaki,P.I.,
            Bunce,M., Marsh,S.G., Guttridge,M.G., Bias,W.B. and Parham,P.
  TITLE     HLA-B15: a widespread and diverse family of HLA-B alleles
  JOURNAL   Tissue Antigens 43 (4), 209-218 (1994)
   PUBMED   7521976
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES B*15:01; B*15:11 AND B*15:19).
REFERENCE   3  (residues 1 to 362)
  AUTHORS   Lin,L., Tokunaga,K., Tanaka,H., Nakajima,F., Imanishi,T.,
            Kashiwase,K., Bannai,M., Mizuno,S., Akaza,T., Tadokoro,K.,
            Shibata,Y. and Juji,T.
  TITLE     Further molecular diversity in the HLA-B15 group
  JOURNAL   Tissue Antigens 47 (4), 265-274 (1996)
   PUBMED   8773315
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELES B*15:01; B*15:02 AND B*15:11).;
            TISSUE=Blood
REFERENCE   4  (residues 1 to 362)
  AUTHORS   Madrigal,J.A., Belich,M.P., Hildebrand,W.H., Benjamin,R.J.,
            Little,A.-M., Zemmour,J., Ennis,P.D., Ward,F.E., Petzl-Erler,M.L.,
            Martell,R.W., du Toit,E.D. and Parham,P.
  TITLE     Distinctive HLA-A,B antigens of black populations formed by
            interallelic conversion
  JOURNAL   J. Immunol. 149 (10), 3411-3415 (1992)
   PUBMED   1431115
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*15:03).
REFERENCE   5  (residues 1 to 362)
  AUTHORS   Watkins,D.I., McAdam,S.N., Liu,X., Stang,C.R., Milford,E.L.,
            Levine,C.G., Garber,T.L., Dogon,A.L., Lord,C.I., Ghim,S.H.,
            Troup,G.M., Hughes,A.L. and Letvin,N.L.
  TITLE     New recombinant HLA-B alleles in a tribe of South American
            Amerindians indicate rapid evolution of MHC class I loci
  JOURNAL   Nature 357 (6376), 329-333 (1992)
   PUBMED   1589035
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*15:04).
REFERENCE   6  (residues 1 to 362)
  AUTHORS   Ramos,M., Barber,D.F., Layrisse,Z. and de Castro,J.A.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-OCT-1996)
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*15:04).;
            TISSUE=Blood
REFERENCE   7  (residues 1 to 362)
  AUTHORS   Cox,S.T., McWhinnie,A.J., Robinson,J., Marsh,S.G., Parham,P.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Cloning and sequencing full-length HLA-B and -C genes
  JOURNAL   Tissue Antigens 61 (1), 20-48 (2003)
   PUBMED   12622774
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*15:01).;
            TISSUE=Blood
REFERENCE   8  (residues 1 to 362)
  AUTHORS   Cox,S.T., Prokupek,B., Baker,F., Holman,R., Leung,V.T., Wong,A.S.,
            Madrigal,J.A. and Little,A.M.
  TITLE     Identification of HLA-B*1566
  JOURNAL   Tissue Antigens 59 (5), 424-425 (2002)
   PUBMED   12144628
  REMARK    NUCLEOTIDE SEQUENCE (ALLELE B*15:66).
REFERENCE   9  (residues 1 to 362)
  AUTHORS   Mungall,A.J., Palmer,S.A., Sims,S.K., Edwards,C.A., Ashurst,J.L.,
            Wilming,L., Jones,M.C., Horton,R., Hunt,S.E., Scott,C.E.,
            Gilbert,J.G., Clamp,M.E., Bethel,G., Milne,S., Ainscough,R.,
            Almeida,J.P., Ambrose,K.D., Andrews,T.D., Ashwell,R.I.,
            Babbage,A.K., Bagguley,C.L., Bailey,J., Banerjee,R., Barker,D.J.,
            Barlow,K.F., Bates,K., Beare,D.M., Beasley,H., Beasley,O.,
            Bird,C.P., Blakey,S., Bray-Allen,S., Brook,J., Brown,A.J.,
            Brown,J.Y., Burford,D.C., Burrill,W., Burton,J., Carder,C.,
            Carter,N.P., Chapman,J.C., Clark,S.Y., Clark,G., Clee,C.M.,
            Clegg,S., Cobley,V., Collier,R.E., Collins,J.E., Colman,L.K.,
            Corby,N.R., Coville,G.J., Culley,K.M., Dhami,P., Davies,J.,
            Dunn,M., Earthrowl,M.E., Ellington,A.E., Evans,K.A., Faulkner,L.,
            Francis,M.D., Frankish,A., Frankland,J., French,L., Garner,P.,
            Garnett,J., Ghori,M.J., Gilby,L.M., Gillson,C.J., Glithero,R.J.,
            Grafham,D.V., Grant,M., Gribble,S., Griffiths,C., Griffiths,M.,
            Hall,R., Halls,K.S., Hammond,S., Harley,J.L., Hart,E.A.,
            Heath,P.D., Heathcott,R., Holmes,S.J., Howden,P.J., Howe,K.L.,
            Howell,G.R., Huckle,E., Humphray,S.J., Humphries,M.D., Hunt,A.R.,
            Johnson,C.M., Joy,A.A., Kay,M., Keenan,S.J., Kimberley,A.M.,
            King,A., Laird,G.K., Langford,C., Lawlor,S., Leongamornlert,D.A.,
            Leversha,M., Lloyd,C.R., Lloyd,D.M., Loveland,J.E., Lovell,J.,
            Martin,S., Mashreghi-Mohammadi,M., Maslen,G.L., Matthews,L.,
            McCann,O.T., McLaren,S.J., McLay,K., McMurray,A., Moore,M.J.,
            Mullikin,J.C., Niblett,D., Nickerson,T., Novik,K.L., Oliver,K.,
            Overton-Larty,E.K., Parker,A., Patel,R., Pearce,A.V., Peck,A.I.,
            Phillimore,B., Phillips,S., Plumb,R.W., Porter,K.M., Ramsey,Y.,
            Ranby,S.A., Rice,C.M., Ross,M.T., Searle,S.M., Sehra,H.K.,
            Sheridan,E., Skuce,C.D., Smith,S., Smith,M., Spraggon,L.,
            Squares,S.L., Steward,C.A., Sycamore,N., Tamlyn-Hall,G., Tester,J.,
            Theaker,A.J., Thomas,D.W., Thorpe,A., Tracey,A., Tromans,A.,
            Tubby,B., Wall,M., Wallis,J.M., West,A.P., White,S.S.,
            Whitehead,S.L., Whittaker,H., Wild,A., Willey,D.J., Wilmer,T.E.,
            Wood,J.M., Wray,P.W., Wyatt,J.C., Young,L., Younger,R.M.,
            Bentley,D.R., Coulson,A., Durbin,R., Hubbard,T., Sulston,J.E.,
            Dunham,I., Rogers,J. and Beck,S.
  TITLE     The DNA sequence and analysis of human chromosome 6
  JOURNAL   Nature 425 (6960), 805-811 (2003)
   PUBMED   14574404
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE GENOMIC DNA].
REFERENCE   10 (residues 1 to 362)
  AUTHORS   Pohla,H., Kuon,W., Tabaczewski,P., Doerner,C. and Weiss,E.H.
  TITLE     Allelic variation in HLA-B and HLA-C sequences and the evolution of
            the HLA-B alleles
  JOURNAL   Immunogenetics 29 (5), 297-307 (1989)
   PUBMED   2714852
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 5-362 (ALLELE B*15:01).
REFERENCE   11 (residues 1 to 362)
  AUTHORS   Choo,S.Y., Fan,L.A. and Hansen,J.A.
  TITLE     Allelic variations clustered in the antigen binding sites of
            HLA-Bw62 molecules
  JOURNAL   Immunogenetics 37 (2), 108-113 (1993)
   PUBMED   8423049
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 25-362 (ALLELE B*15:01).
REFERENCE   12 (residues 1 to 362)
  AUTHORS   Chung,W.H., Hung,S.I., Hong,H.S., Hsih,M.S., Yang,L.C., Ho,H.C.,
            Wu,J.Y. and Chen,Y.T.
  TITLE     Medical genetics: a marker for Stevens-Johnson syndrome
  JOURNAL   Nature 428 (6982), 486 (2004)
   PUBMED   15057820
  REMARK    ASSOCIATION OF ALLELE B*15:02 WITH STEVENS-JOHNSON SYNDROME.
COMMENT     On or before Jul 18, 2007 this sequence version replaced gi:105641,
            gi:7439171, gi:2135191, gi:2118831, gi:105637, gi:7439168,
            gi:231386, gi:1345598, gi:231385.
            [FUNCTION] Involved in the presentation of foreign antigens to the
            immune system.
            [SUBUNIT] Heterodimer of an alpha chain and a beta chain
            (beta-2-microglobulin). Interacts with human herpesvirus 8 MIR1
            protein (By similarity).
            [SUBCELLULAR LOCATION] Membrane; Single-pass type I membrane
            protein.
            [PTM] Polyubiquitinated in a post ER compartment by interaction
            with human herpesvirus 8 MIR1 protein. This targets the protein for
            rapid degradation via the ubiquitin system (By similarity).
            [POLYMORPHISM] The following alleles of B-15 are known: B*15:01
            (Bw-62; B-62), B*15:02 (Bw-75, B-75), B*15:03 (Bw-72; B-72; B-70)
            B*15:04, B*15:11, B*15:19 and B*15:66. Allele B*15:02 is associated
            with susceptibility to Stevens-Johnson syndrome. The sequence shown
            is that of B*15:01.
            [DISEASE] Defects in HLA-B are a cause of susceptibility to
            Stevens-Johnson syndrome (STJOS) [MIM:608579]. A limited form of
            toxic epidermal necrolysis characterized by destruction and
            detachment of the skin epithelium and mucous membranes involving
            less than 10% of the body surface area. It ranges from mild skin
            and mucous membrane lesions to a severe, sometimes fatal systemic
            disorder. Ocular symptoms include ulcerative conjunctivitis,
            keratitis, iritis, uveitis and sometimes blindness. It can be
            caused by a severe adverse reaction to particular types of
            medication, although Mycoplasma infections may induce some cases.
            [SIMILARITY] Belongs to the MHC class I family.
            [SIMILARITY] Contains 1 Ig-like C1-type (immunoglobulin-like)
            domain.
FEATURES             Location/Qualifiers
     source          1..362
                     /organism="Homo sapiens"
                     /db_xref="taxon:9606"
     gene            1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
     Protein         1..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /product="HLA class I histocompatibility antigen, B-15
                     alpha chain"
                     /note="MHC class I antigen B*15"
                     /UniProtKB_evidence="Evidence at protein level"
     Region          1..24
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Signal"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          25..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Mature chain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="HLA class I histocompatibility antigen, B-15 alpha
                     chain. /FTId=PRO_0000018837."
     Region          25..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Extracellular (Potential)."
     Region          25..114
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-1."
     Region          26..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="MHC_I"
                     /note="Class I Histocompatibility antigen, domains alpha 1
                     and 2; pfam00129"
                     /db_xref="CDD:189407"
     Region          27..36
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          45..52
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          48
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="A -> S (in allele B*15:03). /FTId=VAR_016365."
     Region          55..61
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          64..66
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          69..70
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="MA -> EE (in allele B*15:03). /FTId=VAR_016366."
     Region          74..77
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          81..108
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          87
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="E -> N (in allele B*15:02 and allele B*15:11;
                     requires 2 nucleotide substitutions). /FTId=VAR_016367."
     Region          91
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> C (in allele B*15:66). /FTId=VAR_016368."
     Region          91
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="S -> Y (in allele B*15:11). /FTId=VAR_016369."
     Site            110
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="glycosylation"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="N-linked (GlcNAc...) (By similarity)."
     Region          115..206
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-2."
     Region          118..127
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          118..119
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="TL -> II (in allele B*15:02). /FTId=VAR_016370."
     Region          119
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="L -> W (in allele B*15:04). /FTId=VAR_016371."
     Region          121
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="R -> T (in allele B*15:04). /FTId=VAR_016372."
     Bond            125..188
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Region          133..142
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          137
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="H -> Y (in allele B*15:02). /FTId=VAR_016373."
     Region          145..150
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          157..161
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          162..173
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          176..185
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          180
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="W -> L (in allele B*15:02 and allele B*15:03).
                     /FTId=VAR_016374."
     Region          187..198
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          190..191
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="EW -> DG (in allele B*15:19). /FTId=VAR_016375."
     Region          200..203
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          207..299
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="IgC_MHC_I_alpha3"
                     /note="Class I major histocompatibility complex (MHC)
                     alpha chain immunoglobulin domain; cd07698"
                     /db_xref="CDD:143322"
     Region          207..298
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Alpha-3."
     Region          209..295
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Domain"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Ig-like C1-type."
     Region          210..219
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          222..235
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Site            order(226,228,255..256,258..260,266,268)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="heterodimer interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Bond            227..283
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /bond_type="disulfide"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="By similarity."
     Site            order(233..235,263,288)
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /site_type="other"
                     /note="MHC binding domain interface [polypeptide binding]"
                     /db_xref="CDD:143322"
     Region          238..243
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          249..251
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          261..263
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          265..274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          274
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Variant"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="P -> L (in allele B*15:19). /FTId=VAR_016376."
     Region          278..280
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Helical region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          281..286
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          294..296
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Beta-strand region"
                     /experiment="experimental evidence, no additional details
                     recorded"
     Region          299..309
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Region of interest in the sequence"
                     /experiment="experimental evidence, no additional details
                     recorded"
                     /note="Connecting peptide."
     Region          310..333
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Transmembrane region"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Helical; (Potential)."
     Region          334..362
                     /gene="HLA-B"
                     /gene_synonym="HLAB"
                     /region_name="Topological domain"
                     /inference="non-experimental evidence, no additional
                     details recorded"
                     /note="Cytoplasmic (Potential)."
ORIGIN      
        1 mrvtaprtvl lllsgalalt etwagshsmr yfytamsrpg rgeprfiavg yvddtqfvrf
       61 dsdaasprma prapwieqeg peywdretqi sktntqtyre slrnlrgyyn qseagshtlq
      121 rmygcdvgpd grllrghdqs aydgkdyial nedlsswtaa dtaaqitqrk weaareaeqw
      181 rayleglcve wlrrylengk etlqradppk thvthhpisd heatlrcwal gfypaeitlt
      241 wqrdgedqtq dtelvetrpa gdrtfqkwaa vvvpsgeeqr ytchvqhegl pkpltlrwep
      301 ssqstipivg ivaglavlav vvigavvatv mcrrkssggk ggsysqaass dsaqgsdvsl
      361 ta
//

LOCUS       2B11_HUMAN               266 aa            linear   PRI 21-SEP-2011
DEFINITION  RecName: Full=HLA class II histocompatibility antigen, DRB1-1 beta
            chain; AltName: Full=MHC class II antigen DRB1*1; Short=DR-1;
            Short=DR1; Flags: Precursor.
ACCESSION   P04229
VERSION     P04229.2  GI:34395916
DBSOURCE    UniProtKB: locus 2B11_HUMAN, accession P04229;
            class: standard.
            extra
            accessions:A4F5N0,A8K098,O62869,P13758,Q06662,Q30116,Q30117,Q5Y7E9,
            Q7M2H4,Q95461,Q9BCL7,Q9GIK5,Q9MXZ0,Q9MXZ5,Q9TQ91
            created: Mar 20, 1987.
            sequence updated: Aug 29, 2003.
            annotation updated: Sep 21, 2011.
            xrefs: X03069.1, CAA26873.1, M11161.1, AAA59781.1, M33600.1,
            AAA59782.1, AY663400.1, AAU87993.1, AM419948.1, CAL99240.1,
            AK289463.1, BAF82152.1, X64547.1, CAA45845.1, X99896.1, CAA68171.1,
            AF089723.1, AAD51131.1, AJ276206.1, CAC27123.1, AB015184.1,
            BAA28761.1, AJ303118.1, CAC19693.1, Z50871.1, M21008.1, AAA59780.1,
            AF029288.1, AAF65497.1, AF029293.1, AAF65502.1, A19197, HLHU1B,
            I56072, PH0147, 1AQD_B, 1AQD_E, 1AQD_H, 1AQD_K, 1DLH_B, 1DLH_E,
            1FYT_B, 1HXY_B, 1JWM_B, 1JWS_B, 1JWU_B, 1KG0_B, 1KLG_B, 1KLU_B,
            1LO5_B, 1PYW_B, 1R5I_B, 1R5I_F, 1SEB_B, 1SEB_F, 1SJE_B, 1SJH_B,
            1T5W_B, 1T5W_E, 1T5X_B, 2FSE_B, 2FSE_D, 2G9H_B, 2IAM_B, 2IAN_B,
            2IAN_G, 2IAN_L, 2IAN_Q, 2ICW_B, 2ICW_E, 2IPK_B, 2OJE_B, 2OJE_F,
            2XN9_E, 3L6F_B, 3PDO_B, 3PGC_B, 3PGC_E, 3PGD_B, 3PGD_E
            xrefs (non-sequence databases): IPI:IPI00738107, UniGene:Hs.534322,
            UniGene:Hs.696211, PDBsum:1AQD, PDBsum:1DLH, PDBsum:1FYT,
            PDBsum:1HXY, PDBsum:1JWM, PDBsum:1JWS, PDBsum:1JWU, PDBsum:1KG0,
            PDBsum:1KLG, PDBsum:1KLU, PDBsum:1LO5, PDBsum:1PYW, PDBsum:1R5I,
            PDBsum:1SEB, PDBsum:1SJE, PDBsum:1SJH, PDBsum:1T5W, PDBsum:1T5X,
            PDBsum:2FSE, PDBsum:2G9H, PDBsum:2IAM, PDBsum:2IAN, PDBsum:2ICW,
            PDBsum:2IPK, PDBsum:2OJE, PDBsum:2XN9, PDBsum:3L6F, PDBsum:3PDO,
            PDBsum:3PGC, PDBsum:3PGD, ProteinModelPortal:P04229, SMR:P04229,
            DIP:DIP-6143N, IntAct:P04229, MINT:MINT-203282, STRING:P04229,
            PhosphoSite:P04229, PRIDE:P04229, Ensembl:ENST00000360004,
            Ensembl:ENSP00000353099, Ensembl:ENSG00000196126,
            GeneCards:GC06M032546, HGNC:4948, HPA:CAB015400, HPA:CAB034021,
            MIM:142857, MIM:181000, neXtProt:NX_P04229, Orphanet:797,
            HOVERGEN:HBG012730, InParanoid:P04229, OrthoDB:EOG461454,
            Pathway_Interaction_DB:il12_stat4pathway,
            Pathway_Interaction_DB:il12_2pathway,
            Pathway_Interaction_DB:tcrpathway, Reactome:REACT_6900,
            DrugBank:DB05259, Bgee:P04229, CleanEx:HS_HLA-DRB1,
            Genevestigator:P04229, GermOnline:ENSG00000196126, GO:0005789,
            GO:0005794, GO:0016021, GO:0031902, GO:0005765, GO:0042613,
            GO:0002504, GO:0060333, GO:0031295, GO:0050852, InterPro:IPR007110,
            InterPro:IPR013783, InterPro:IPR003006, InterPro:IPR003597,
            InterPro:IPR011162, InterPro:IPR014745, InterPro:IPR000353,
            Gene3D:G3DSA:2.60.40.10, Gene3D:G3DSA:3.10.320.10, Pfam:PF07654,
            Pfam:PF00969, ProDom:PD000328, SMART:SM00407, SMART:SM00921,
            SUPFAM:SSF54452, PROSITE:PS50835, PROSITE:PS00290
KEYWORDS    3D-structure; Cell membrane; Complete proteome; Direct protein
            sequencing; Disulfide bond; Endoplasmic reticulum; Endosome;
            Glycoprotein; Golgi apparatus; Immunity; Isopeptide bond; Lysosome;
            Membrane; MHC II; Polymorphism; Reference proteome; Signal;
            Transmembrane; Transmembrane helix; Ubl conjugation.
SOURCE      Homo sapiens (human)
  ORGANISM  Homo sapiens
            Eukaryota; Metazoa; Chordata; Craniata; Vertebrata; Euteleostomi;
            Mammalia; Eutheria; Euarchontoglires; Primates; Haplorrhini;
            Catarrhini; Hominidae; Homo.
REFERENCE   1  (residues 1 to 266)
  AUTHORS   Tonnelle,C., DeMars,R. and Long,E.O.
  TITLE     DO beta: a new beta chain gene in HLA-D with a distinct regulation
            of expression
  JOURNAL   EMBO J. 4 (11), 2839-2847 (1985)
   PUBMED   2998758
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE DRB1*01:01).
REFERENCE   2  (residues 1 to 266)
  AUTHORS   Bell,J.I., Estess,P., St John,T., Saiki,R., Watling,D.L.,
            Erlich,H.A. and McDevitt,H.O.
  TITLE     DNA sequence and characterization of human class II major
            histocompatibility complex beta chains from the DR1 haplotype
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 82 (10), 3405-3409 (1985)
   PUBMED   3858829
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE DRB1*01:01).
REFERENCE   3  (residues 1 to 266)
  AUTHORS   Coppin,H.L., Avoustin,P., Fabron,J., Huchenq,A., Garnier,J.M.,
            Thomsen,M. and De Preval,C.
  TITLE     Evolution of the HLA-DR1 gene family. Structural and functional
            analysis of the new allele 'DR-BON'
  JOURNAL   J. Immunol. 144 (3), 984-989 (1990)
   PUBMED   1688595
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] (ALLELE DRB1*01:03).
REFERENCE   4  (residues 1 to 266)
  AUTHORS   Raymond,C.K., Kas,A., Paddock,M., Qiu,R., Zhou,Y., Subramanian,S.,
            Chang,J., Palmieri,A., Haugen,E., Kaul,R. and Olson,M.V.
  TITLE     Ancient haplotypes of the HLA Class II region
  JOURNAL   Genome Res. 15 (9), 1250-1257 (2005)
   PUBMED   16140993
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA].
REFERENCE   5  (residues 1 to 266)
  AUTHORS   von Salome,J., Gyllensten,U. and Bergstrom,T.F.
  TITLE     Full-length sequence analysis of the HLA-DRB1 locus suggests a
            recent origin of alleles
  JOURNAL   Immunogenetics 59 (4), 261-271 (2007)
   PUBMED   17345114
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] (ALLELE DRB1*01:01), AND VARIANT
            ARG-262.
REFERENCE   6  (residues 1 to 266)
  AUTHORS   Ota,T., Suzuki,Y., Nishikawa,T., Otsuki,T., Sugiyama,T., Irie,R.,
            Wakamatsu,A., Hayashi,K., Sato,H., Nagai,K., Kimura,K., Makita,H.,
            Sekine,M., Obayashi,M., Nishi,T., Shibahara,T., Tanaka,T.,
            Ishii,S., Yamamoto,J., Saito,K., Kawai,Y., Isono,Y., Nakamura,Y.,
            Nagahari,K., Murakami,K., Yasuda,T., Iwayanagi,T., Wagatsuma,M.,
            Shiratori,A., Sudo,H., Hosoiri,T., Kaku,Y., Kodaira,H., Kondo,H.,
            Sugawara,M., Takahashi,M., Kanda,K., Yokoi,T., Furuya,T.,
            Kikkawa,E., Omura,Y., Abe,K., Kamihara,K., Katsuta,N., Sato,K.,
            Tanikawa,M., Yamazaki,M., Ninomiya,K., Ishibashi,T., Yamashita,H.,
            Murakawa,K., Fujimori,K., Tanai,H., Kimata,M., Watanabe,M.,
            Hiraoka,S., Chiba,Y., Ishida,S., Ono,Y., Takiguchi,S., Watanabe,S.,
            Yosida,M., Hotuta,T., Kusano,J., Kanehori,K., Takahashi-Fujii,A.,
            Hara,H., Tanase,T.O., Nomura,Y., Togiya,S., Komai,F., Hara,R.,
            Takeuchi,K., Arita,M., Imose,N., Musashino,K., Yuuki,H., Oshima,A.,
            Sasaki,N., Aotsuka,S., Yoshikawa,Y., Matsunawa,H., Ichihara,T.,
            Shiohata,N., Sano,S., Moriya,S., Momiyama,H., Satoh,N., Takami,S.,
            Terashima,Y., Suzuki,O., Nakagawa,S., Senoh,A., Mizoguchi,H.,
            Goto,Y., Shimizu,F., Wakebe,H., Hishigaki,H., Watanabe,T.,
            Sugiyama,A., Takemoto,M., Kawakami,B., Yamazaki,M., Watanabe,K.,
            Kumagai,A., Itakura,S., Fukuzumi,Y., Fujimori,Y., Komiyama,M.,
            Tashiro,H., Tanigami,A., Fujiwara,T., Ono,T., Yamada,K., Fujii,Y.,
            Ozaki,K., Hirao,M., Ohmori,Y., Kawabata,A., Hikiji,T., Kobatake,N.,
            Inagaki,H., Ikema,Y., Okamoto,S., Okitani,R., Kawakami,T.,
            Noguchi,S., Itoh,T., Shigeta,K., Senba,T., Matsumura,K.,
            Nakajima,Y., Mizuno,T., Morinaga,M., Sasaki,M., Togashi,T.,
            Oyama,M., Hata,H., Watanabe,M., Komatsu,T., Mizushima-Sugano,J.,
            Satoh,T., Shirai,Y., Takahashi,Y., Nakagawa,K., Okumura,K.,
            Nagase,T., Nomura,N., Kikuchi,H., Masuho,Y., Yamashita,R.,
            Nakai,K., Yada,T., Nakamura,Y., Ohara,O., Isogai,T. and Sugano,S.
  TITLE     Complete sequencing and characterization of 21,243 full-length
            human cDNAs
  JOURNAL   Nat. Genet. 36 (1), 40-45 (2004)
   PUBMED   14702039
  REMARK    NUCLEOTIDE SEQUENCE [LARGE SCALE MRNA].;
            TISSUE=Cerebellum
REFERENCE   7  (residues 1 to 266)
  AUTHORS   Louis,P., Eliaou,J.F., Kerlan-Candon,S., Pinet,V., Vincent,R. and
            Clot,J.
  TITLE     Polymorphism in the regulatory region of HLA-DRB genes correlating
            with haplotype evolution
  JOURNAL   Immunogenetics 38 (1), 21-26 (1993)
   PUBMED   8462990
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 1-29.;
            TISSUE=B-cell
REFERENCE   8  (residues 1 to 266)
  AUTHORS   Middleton,D., Versluis,L.F. and Tilanus,M.G.J.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-AUG-1996)
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 30-266 (ALLELE DRB1*01:04).
REFERENCE   9  (residues 1 to 266)
  AUTHORS   Walker,L.E., Hewick,R., Hunkapiller,M.W., Hood,L.E., Dreyer,W.J.
            and Reisfeld,R.A.
  TITLE     N-terminal amino acid sequences of the alpha and beta chains of
            HLA-DR1 and HLA-DR2 antigens
  JOURNAL   Biochemistry 22 (1), 185-188 (1983)
   PUBMED   6600932
  REMARK    PROTEIN SEQUENCE OF 30-64.;
            TISSUE=B-cell
REFERENCE   10 (residues 1 to 266)
  AUTHORS   Palou,E., Mongay,L., Arias,M.T., Isart,F., Suarez,B., Masso,M.,
            Fabregat,V., Martorell,J. and Gaya,A.
  TITLE     Identification of a novel DRB1-allele (DRB1*0106) by sequence-based
            typing
  JOURNAL   Tissue Antigens 53 (3), 308-310 (1999)
   PUBMED   10203026
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 35-123 (ALLELE DRB1*01:06).
REFERENCE   11 (residues 1 to 266)
  AUTHORS   Voorter,C.E., Hepkema,B.G., Lems,S.P. and van den Berg-Loonen,E.M.
  TITLE     Identification of three new DRB1 alleles, DRB1*0107, *0425 and
            *13012 and confirmation of DRB4*01033
  JOURNAL   Tissue Antigens 61 (5), 398-402 (2003)
   PUBMED   12753659
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 35-123 (ALLELE DRB1*01:07).
REFERENCE   12 (residues 1 to 266)
  AUTHORS   Kashiwase,K., Akaza,T. and Juji,T.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-JUN-1998)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 35-123 (ALLELE DRB1*01:05).
REFERENCE   13 (residues 1 to 266)
  AUTHORS   Dormoy,A., Froelich,N., Leisenbach,R. and Tongio,M.M.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-DEC-2000)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 35-123 (ALLELE DRB1*01:07).
REFERENCE   14 (residues 1 to 266)
  AUTHORS   Hashemi,S., Couture,C., Cole,R. and Buyse,I.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-AUG-1995)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 35-122 (ALLELE DRB1*01:02).;
            TISSUE=Blood
REFERENCE   15 (residues 1 to 266)
  AUTHORS   Hurley,C.K., Ziff,B.L., Silver,J., Gregersen,P.K., Hartzman,R. and
            Johnson,A.H.
  TITLE     Polymorphism of the HLA-DR1 haplotype in American blacks.
            Identification of a DR1 beta-chain determinant recognized in the
            mixed lymphocyte reaction
  JOURNAL   J. Immunol. 140 (11), 4019-4023 (1988)
   PUBMED   2453563
  REMARK    NUCLEOTIDE SEQUENCE [MRNA] OF 37-266 (ALLELE DRB1*01:02).
REFERENCE   16 (residues 1 to 266)
  AUTHORS   Arnaiz-Villena,A.
  TITLE     Direct Submission
  JOURNAL   Submitted (??-OCT-1997)
  REMARK    NUCLEOTIDE SEQUENCE [GENOMIC DNA] OF 43-115 (ALLELES DRB1*01:01 AND
            DRB1*01:02).;
            TISSUE=Blood
REFERENCE   17 (residues 1 to 266)
  AUTHORS   Rossman,M.D., Thompson,B., Frederick,M., Maliarik,M.,
            Iannuzzi,M.C., Rybicki,B.A., Pandey,J.P., Newman,L.S., Magira,E.,
            Beznik-Cizman,B. and Monos,D.
  TITLE     HLA-DRB1*1101: a significant risk factor for sarcoidosis in blacks
            and whites
  JOURNAL   Am. J. Hum. Genet. 73 (4), 720-735 (2003)
   PUBMED   14508706
  REMARK    DISEASE.
REFERENCE   18 (residues 1 to 266)
  AUTHORS   Cresswell,P.
  TITLE     Invariant chain structure and MHC class II function
  JOURNAL   Cell 84 (4), 505-507 (1996)
   PUBMED   8598037
  REMARK    REVIEW.
REFERENCE   19 (residues 1 to 266)
  AUTHORS   Villadangos,J.A.
  TITLE     Presentation of antigens by MHC class II molecules: getting the
            most out of them
  JOURNAL   Mol. Immunol. 38 (5), 329-346 (2001)
   PUBMED   11684289
  REMARK    REVIEW.
REFERENCE   20 (residues 1 to 266)
  AUTHORS   Menendez-Benito,V. and Neefjes,J.
  TITLE     Autophagy in MHC class II presentation: sampling from within
  JOURNAL   Immunity 26 (1), 1-3 (2007)
   PUBMED   17241953
  REMARK    REVIEW.
REFERENCE   21 (residues 1 to 266)
  AUTHORS   Rocha,N. and Neefjes,J.
  TITLE     MHC class II molecules on the move for successful antigen
            presentation
  JOURNAL   EMBO J. 27 (1), 1-5 (2008)
   PUBMED   18046453
  REMARK    REVIEW.
REFERENCE   22 (residues 1 to 266)
  AUTHORS   De Gassart,A., Camosseto,V., Thibodeau,J., Ceppi,M., Catalan,N.,
            Pierre,P. and Gatti,E.
  TITLE     MHC class II stabilization at the surface of human dendritic cells
            is the result of maturation-dependent MARCH I down-regulation
  JOURNAL   Proc. Natl. Acad. Sci. U.S.A. 105 (9), 3491-3496 (2008)
   PUBMED   18305173
  REMARK    UBIQUITINATION BY MARCH1, AND SUBCELLULAR LOCATION.
REFERENCE   23 (residues 1 to 266)
  AUTHORS   Berger,A.C. and Roche,P.A.
  TITLE     MHC class II transport at a glance
  JOURNAL   J. Cell. Sci. 122 (PT 1), 1-4 (2009)
   PUBMED   19092054
  REMARK    REVIEW.
REFERENCE   24 (residues 1 to 266)
  AUTHORS   Beswick,E.J. and Reyes,V.E.
  TITLE     CD74 in antigen presentation, inflammation, and cancers of the
            gastrointestinal tract
  JOURNAL   World J. Gastroenterol. 15 (23), 2855-2861 (2009)
   PUBMED   19533806
  REMARK    REVIEW.
REFERENCE   25 (residues 1 to 266)
  AUTHORS   Burkard,T.R., Planyavsky,M., Kaupe,I., Breitwieser,F.P.,
            Burckstummer,T., Bennett,K.L., Superti-Furga,G. and Colinge,J.
  TITLE     Initial characterization of the human central proteome
  JOURNAL   BMC Syst Biol 5, 17 (2011)
   PUBMED   21269460
  REMARK    IDENTIFICATION BY MASS SPECTROMETRY [LARGE SCALE ANALYSIS].
            Publication Status: Online-Only
REFERENCE   26 (residues 1 to 266)
  AUTHORS   Brown,J.H., Jardetzky,T.S., Gorga,J.C., Stern,L.J., Urban,R.G.,
            Strominger,J.L. and Wiley,D.C.
  TITLE     Three-dimensional structure of the human class II
            histocompatibility antigen HLA-DR1
  JOURNAL   Nature 364 (6432), 33-39 (1993)
   PUBMED   8316295
  REMARK    X-RAY CRYSTALLOGRAPHY (2.8 ANGSTROMS) OF 32-219.
REFERENCE   27 (residues 1 to 266)
  AUTHORS   Stern,L.J., Brown,J.H., Jardetzky,T.S., Gorga,J.C., Urban,R.G.,
            Strominger,J.L. and Wiley,D.C.
  TITLE     Crystal structure of the human class II MHC protein HLA-DR1
            complexed with an influenza virus peptide
  JOURNAL   Nature 368 (6468), 215-221 (1994)
   PUBMED   8145819
  REMARK    X-RAY CRYSTALLOGRAPHY (2.8 ANGSTROMS) OF 32-219.
REFERENCE   28 (residues 1 to 266)
  AUTHORS   Jardetzky,T.S., Brown,J.H., Gorga,J.C., Stern,L.J., Urban,R.G.,
            Chi,Y.I., Stauffacher,C., Strominger,J.L. and Wiley,D.C.
  TITLE     Three-dimensional structure of a human class II histocompatibility
            molecule complexed with superantigen
  JOURNAL   Nature 368 (6473), 711-718 (1994)
   PUBMED   8152483
  REMARK    X-RAY CRYSTALLOGRAPHY (2.7 ANGSTROMS) OF COMPLEX WITH SEB.
COMMENT     On or before Jan 29, 2008 this sequence version replaced
            gi:74757237, gi:74713078, gi:1070584, gi:2118876, gi:87712,
            gi:122250, gi:122249.
            [FUNCTION] Binds peptides derived from antigens that access the
            endocytic route of antigen presenting cells (APC) and presents them
            on the cell surface for recognition by the CD4 T-cells. The peptide
            binding cleft accomodates peptides of 10-30 residues. The peptides
            presented by MHC class II molecules are generated mostly by
            degradation of proteins that access the endocytic route; where they
            are processed by lysosomal proteases and other hydrolases.
            Exogenous antigens that have been endocytosed by the APC are thus
            readily available for presentation via MHC II molecules; and for
            this reason this antigen presentation pathway is usually referred
            to as exogenous. As membrane proteins on their way to degradation
            in lysosomes as part of their normal turn-over are also contained
            in the endosomal/lysosomal compartments; exogenous antigens must
            compete with those derived from endogenous components. Autophagy is
            also a source of endogenous peptides; autophagosomes constitutively
            fuse with MHC class II loading compartments. In addition to APCs;
            other cells of the gastrointestinal tract; such as epithelial
            cells; express MHC class II molecules and CD74 and act as APCs;
            which is an unusual trait of the GI tract. To produce a MHC class
            II molecule that presents an antigen; three MHC class II molecules
            (heterodimers of an alpha and a beta chain) associate with a CD74
            trimer in the ER to form an heterononamer. Soon after the entry of
            this complex into the endosomal/lysosomal system where antigen
            processing occurs; CD74 undergoes a sequential degradation by
            various proteases; including CTSS and CTSL; leaving a small
            fragment termed CLIP (class-II-associated invariant chain peptide).
            The removal of CLIP is facilitated by HLA-DM via direct binding to
            the alpha-beta-CLIP complex so that CLIP is released. HLA-DM
            stabilizes MHC class II molecules until primary high affinity
            antigenic peptides are bound. The MHC II molecule bound to a
            peptide is then transported to the cell membrane surface. In B
        